"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var UploadSketch_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UploadSketch = void 0;
const inversify_1 = require("inversify");
const event_1 = require("@theia/core/lib/common/event");
const protocol_1 = require("../../common/protocol");
const arduino_menus_1 = require("../menu/arduino-menus");
const arduino_toolbar_1 = require("../toolbar/arduino-toolbar");
const boards_data_store_1 = require("../boards/boards-data-store");
const serial_connection_manager_1 = require("../serial/serial-connection-manager");
const boards_service_provider_1 = require("../boards/boards-service-provider");
const contribution_1 = require("./contribution");
const user_fields_dialog_1 = require("../dialogs/user-fields/user-fields-dialog");
const common_1 = require("@theia/core/lib/common");
let UploadSketch = UploadSketch_1 = class UploadSketch extends contribution_1.SketchContribution {
    constructor() {
        super(...arguments);
        this.cachedUserFields = new Map();
        this.onDidChangeEmitter = new event_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
        this.uploadInProgress = false;
        this.boardRequiresUserFields = false;
        this.menuActionsDisposables = new common_1.DisposableCollection();
    }
    init() {
        this.boardsServiceClientImpl.onBoardsConfigChanged(async () => {
            const userFields = await this.boardsServiceClientImpl.selectedBoardUserFields();
            this.boardRequiresUserFields = userFields.length > 0;
            this.registerMenus(this.menuRegistry);
        });
    }
    selectedFqbnAddress() {
        var _a, _b, _c, _d;
        const { boardsConfig } = this.boardsServiceClientImpl;
        const fqbn = (_a = boardsConfig.selectedBoard) === null || _a === void 0 ? void 0 : _a.fqbn;
        if (!fqbn) {
            return '';
        }
        const address = ((_c = (_b = boardsConfig.selectedBoard) === null || _b === void 0 ? void 0 : _b.port) === null || _c === void 0 ? void 0 : _c.address) || ((_d = boardsConfig.selectedPort) === null || _d === void 0 ? void 0 : _d.address);
        if (!address) {
            return '';
        }
        return fqbn + '|' + address;
    }
    registerCommands(registry) {
        registry.registerCommand(UploadSketch_1.Commands.UPLOAD_SKETCH, {
            execute: async () => {
                const key = this.selectedFqbnAddress();
                if (!key) {
                    return;
                }
                if (this.boardRequiresUserFields && !this.cachedUserFields.has(key)) {
                    // Deep clone the array of board fields to avoid editing the cached ones
                    this.userFieldsDialog.value = (await this.boardsServiceClientImpl.selectedBoardUserFields()).map((f) => (Object.assign({}, f)));
                    const result = await this.userFieldsDialog.open();
                    if (!result) {
                        return;
                    }
                    this.cachedUserFields.set(key, result);
                }
                this.uploadSketch();
            },
            isEnabled: () => !this.uploadInProgress,
        });
        registry.registerCommand(UploadSketch_1.Commands.UPLOAD_WITH_CONFIGURATION, {
            execute: async () => {
                const key = this.selectedFqbnAddress();
                if (!key) {
                    return;
                }
                const cached = this.cachedUserFields.get(key);
                // Deep clone the array of board fields to avoid editing the cached ones
                this.userFieldsDialog.value = (cached !== null && cached !== void 0 ? cached : (await this.boardsServiceClientImpl.selectedBoardUserFields())).map((f) => (Object.assign({}, f)));
                const result = await this.userFieldsDialog.open();
                if (!result) {
                    return;
                }
                this.cachedUserFields.set(key, result);
                this.uploadSketch();
            },
            isEnabled: () => !this.uploadInProgress && this.boardRequiresUserFields,
        });
        registry.registerCommand(UploadSketch_1.Commands.UPLOAD_SKETCH_USING_PROGRAMMER, {
            execute: () => this.uploadSketch(true),
            isEnabled: () => !this.uploadInProgress,
        });
        registry.registerCommand(UploadSketch_1.Commands.UPLOAD_SKETCH_TOOLBAR, {
            isVisible: (widget) => arduino_toolbar_1.ArduinoToolbar.is(widget) && widget.side === 'left',
            isEnabled: () => !this.uploadInProgress,
            isToggled: () => this.uploadInProgress,
            execute: () => registry.executeCommand(UploadSketch_1.Commands.UPLOAD_SKETCH.id),
        });
    }
    registerMenus(registry) {
        this.menuActionsDisposables.dispose();
        this.menuActionsDisposables.push(registry.registerMenuAction(arduino_menus_1.ArduinoMenus.SKETCH__MAIN_GROUP, {
            commandId: UploadSketch_1.Commands.UPLOAD_SKETCH.id,
            label: common_1.nls.localize('arduino/sketch/upload', 'Upload'),
            order: '1',
        }));
        if (this.boardRequiresUserFields) {
            this.menuActionsDisposables.push(registry.registerMenuAction(arduino_menus_1.ArduinoMenus.SKETCH__MAIN_GROUP, {
                commandId: UploadSketch_1.Commands.UPLOAD_WITH_CONFIGURATION.id,
                label: UploadSketch_1.Commands.UPLOAD_WITH_CONFIGURATION.label,
                order: '2',
            }));
        }
        else {
            this.menuActionsDisposables.push(registry.registerMenuNode(arduino_menus_1.ArduinoMenus.SKETCH__MAIN_GROUP, new arduino_menus_1.PlaceholderMenuNode(arduino_menus_1.ArduinoMenus.SKETCH__MAIN_GROUP, 
            // commandId: UploadSketch.Commands.UPLOAD_WITH_CONFIGURATION.id,
            UploadSketch_1.Commands.UPLOAD_WITH_CONFIGURATION.label, { order: '2' })));
        }
        this.menuActionsDisposables.push(registry.registerMenuAction(arduino_menus_1.ArduinoMenus.SKETCH__MAIN_GROUP, {
            commandId: UploadSketch_1.Commands.UPLOAD_SKETCH_USING_PROGRAMMER.id,
            label: common_1.nls.localize('arduino/sketch/uploadUsingProgrammer', 'Upload Using Programmer'),
            order: '3',
        }));
    }
    registerKeybindings(registry) {
        registry.registerKeybinding({
            command: UploadSketch_1.Commands.UPLOAD_SKETCH.id,
            keybinding: 'CtrlCmd+U',
        });
        registry.registerKeybinding({
            command: UploadSketch_1.Commands.UPLOAD_SKETCH_USING_PROGRAMMER.id,
            keybinding: 'CtrlCmd+Shift+U',
        });
    }
    registerToolbarItems(registry) {
        registry.registerItem({
            id: UploadSketch_1.Commands.UPLOAD_SKETCH_TOOLBAR.id,
            command: UploadSketch_1.Commands.UPLOAD_SKETCH_TOOLBAR.id,
            tooltip: common_1.nls.localize('arduino/sketch/upload', 'Upload'),
            priority: 1,
            onDidChange: this.onDidChange,
        });
    }
    async uploadSketch(usingProgrammer = false) {
        var _a, _b, _c;
        // even with buttons disabled, better to double check if an upload is already in progress
        if (this.uploadInProgress) {
            return;
        }
        // toggle the toolbar button and menu item state.
        // uploadInProgress will be set to false whether the upload fails or not
        this.uploadInProgress = true;
        this.onDidChangeEmitter.fire();
        const sketch = await this.sketchServiceClient.currentSketch();
        if (!sketch) {
            return;
        }
        try {
            const { boardsConfig } = this.boardsServiceClientImpl;
            const [fqbn, { selectedProgrammer }, verify, verbose, sourceOverride] = await Promise.all([
                this.boardsDataStore.appendConfigToFqbn((_a = boardsConfig.selectedBoard) === null || _a === void 0 ? void 0 : _a.fqbn),
                this.boardsDataStore.getData((_b = boardsConfig.selectedBoard) === null || _b === void 0 ? void 0 : _b.fqbn),
                this.preferences.get('arduino.upload.verify'),
                this.preferences.get('arduino.upload.verbose'),
                this.sourceOverride(),
            ]);
            let options = undefined;
            const sketchUri = sketch.uri;
            const optimizeForDebug = this.editorMode.compileForDebug;
            const { selectedPort } = boardsConfig;
            const port = selectedPort;
            const userFields = (_c = this.cachedUserFields.get(this.selectedFqbnAddress())) !== null && _c !== void 0 ? _c : [];
            if (userFields.length === 0 && this.boardRequiresUserFields) {
                this.messageService.error(common_1.nls.localize('arduino/sketch/userFieldsNotFoundError', "Can't find user fields for connected board"));
                return;
            }
            if (usingProgrammer) {
                const programmer = selectedProgrammer;
                options = {
                    sketchUri,
                    fqbn,
                    optimizeForDebug,
                    programmer,
                    port,
                    verbose,
                    verify,
                    sourceOverride,
                    userFields,
                };
            }
            else {
                options = {
                    sketchUri,
                    fqbn,
                    optimizeForDebug,
                    port,
                    verbose,
                    verify,
                    sourceOverride,
                    userFields,
                };
            }
            this.outputChannelManager.getChannel('Arduino').clear();
            if (usingProgrammer) {
                await this.coreService.uploadUsingProgrammer(options);
            }
            else {
                await this.coreService.upload(options);
            }
            this.messageService.info(common_1.nls.localize('arduino/sketch/doneUploading', 'Done uploading.'), { timeout: 3000 });
        }
        catch (e) {
            let errorMessage = '';
            if (typeof e === 'string') {
                errorMessage = e;
            }
            else {
                errorMessage = e.toString();
            }
            this.messageService.error(errorMessage);
        }
        finally {
            this.uploadInProgress = false;
            this.onDidChangeEmitter.fire();
            setTimeout(() => this.serialConnection.reconnectAfterUpload(), 5000);
        }
    }
};
__decorate([
    inversify_1.inject(protocol_1.CoreService),
    __metadata("design:type", Object)
], UploadSketch.prototype, "coreService", void 0);
__decorate([
    inversify_1.inject(serial_connection_manager_1.SerialConnectionManager),
    __metadata("design:type", serial_connection_manager_1.SerialConnectionManager)
], UploadSketch.prototype, "serialConnection", void 0);
__decorate([
    inversify_1.inject(contribution_1.MenuModelRegistry),
    __metadata("design:type", contribution_1.MenuModelRegistry)
], UploadSketch.prototype, "menuRegistry", void 0);
__decorate([
    inversify_1.inject(boards_data_store_1.BoardsDataStore),
    __metadata("design:type", boards_data_store_1.BoardsDataStore)
], UploadSketch.prototype, "boardsDataStore", void 0);
__decorate([
    inversify_1.inject(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], UploadSketch.prototype, "boardsServiceClientImpl", void 0);
__decorate([
    inversify_1.inject(user_fields_dialog_1.UserFieldsDialog),
    __metadata("design:type", user_fields_dialog_1.UserFieldsDialog)
], UploadSketch.prototype, "userFieldsDialog", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], UploadSketch.prototype, "init", null);
UploadSketch = UploadSketch_1 = __decorate([
    inversify_1.injectable()
], UploadSketch);
exports.UploadSketch = UploadSketch;
(function (UploadSketch) {
    let Commands;
    (function (Commands) {
        Commands.UPLOAD_SKETCH = {
            id: 'arduino-upload-sketch',
        };
        Commands.UPLOAD_WITH_CONFIGURATION = {
            id: 'arduino-upload-with-configuration-sketch',
            label: common_1.nls.localize('arduino/sketch/configureAndUpload', 'Configure And Upload'),
            category: 'Arduino',
        };
        Commands.UPLOAD_SKETCH_USING_PROGRAMMER = {
            id: 'arduino-upload-sketch-using-programmer',
        };
        Commands.UPLOAD_SKETCH_TOOLBAR = {
            id: 'arduino-upload-sketch--toolbar',
        };
    })(Commands = UploadSketch.Commands || (UploadSketch.Commands = {}));
})(UploadSketch = exports.UploadSketch || (exports.UploadSketch = {}));
exports.UploadSketch = UploadSketch;
//# sourceMappingURL=upload-sketch.js.map