"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var UploadFirmware_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UploadFirmware = void 0;
const inversify_1 = require("inversify");
const contribution_1 = require("./contribution");
const arduino_menus_1 = require("../menu/arduino-menus");
const firmware_uploader_dialog_1 = require("../dialogs/firmware-uploader/firmware-uploader-dialog");
const common_1 = require("@theia/core/lib/common");
let UploadFirmware = UploadFirmware_1 = class UploadFirmware extends contribution_1.Contribution {
    constructor() {
        super(...arguments);
        this.dialogOpened = false;
    }
    registerCommands(registry) {
        registry.registerCommand(UploadFirmware_1.Commands.OPEN, {
            execute: async () => {
                try {
                    this.dialogOpened = true;
                    await this.dialog.open();
                }
                finally {
                    this.dialogOpened = false;
                }
            },
            isEnabled: () => !this.dialogOpened,
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.TOOLS__FIRMWARE_UPLOADER_GROUP, {
            commandId: UploadFirmware_1.Commands.OPEN.id,
            label: UploadFirmware_1.Commands.OPEN.label,
            order: '0',
        });
    }
};
__decorate([
    inversify_1.inject(firmware_uploader_dialog_1.UploadFirmwareDialog),
    __metadata("design:type", firmware_uploader_dialog_1.UploadFirmwareDialog)
], UploadFirmware.prototype, "dialog", void 0);
UploadFirmware = UploadFirmware_1 = __decorate([
    inversify_1.injectable()
], UploadFirmware);
exports.UploadFirmware = UploadFirmware;
(function (UploadFirmware) {
    let Commands;
    (function (Commands) {
        Commands.OPEN = {
            id: 'arduino-upload-firmware-open',
            label: common_1.nls.localize('arduino/firmware/updater', 'WiFi101 / WiFiNINA Firmware Updater'),
            category: 'Arduino',
        };
    })(Commands = UploadFirmware.Commands || (UploadFirmware.Commands = {}));
})(UploadFirmware = exports.UploadFirmware || (exports.UploadFirmware = {}));
exports.UploadFirmware = UploadFirmware;
//# sourceMappingURL=upload-firmware.js.map