"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var UploadCertificate_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UploadCertificate = void 0;
const inversify_1 = require("inversify");
const contribution_1 = require("./contribution");
const arduino_menus_1 = require("../menu/arduino-menus");
const certificate_uploader_dialog_1 = require("../dialogs/certificate-uploader/certificate-uploader-dialog");
const context_menu_renderer_1 = require("@theia/core/lib/browser/context-menu-renderer");
const preference_service_1 = require("@theia/core/lib/browser/preferences/preference-service");
const arduino_preferences_1 = require("../arduino-preferences");
const utils_1 = require("../dialogs/certificate-uploader/utils");
const arduino_firmware_uploader_1 = require("../../common/protocol/arduino-firmware-uploader");
const common_1 = require("@theia/core/lib/common");
let UploadCertificate = UploadCertificate_1 = class UploadCertificate extends contribution_1.Contribution {
    constructor() {
        super(...arguments);
        this.dialogOpened = false;
    }
    registerCommands(registry) {
        registry.registerCommand(UploadCertificate_1.Commands.OPEN, {
            execute: async () => {
                try {
                    this.dialogOpened = true;
                    await this.dialog.open();
                }
                finally {
                    this.dialogOpened = false;
                }
            },
            isEnabled: () => !this.dialogOpened,
        });
        registry.registerCommand(UploadCertificate_1.Commands.REMOVE_CERT, {
            execute: async (certToRemove) => {
                const certs = this.arduinoPreferences.get('arduino.board.certificates');
                this.preferenceService.set('arduino.board.certificates', utils_1.certificateList(certs)
                    .filter((c) => c !== certToRemove)
                    .join(','), preference_service_1.PreferenceScope.User);
            },
            isEnabled: (certToRemove) => certToRemove !== utils_1.arduinoCert,
        });
        registry.registerCommand(UploadCertificate_1.Commands.UPLOAD_CERT, {
            execute: async ({ fqbn, address, urls }) => {
                return this.arduinoFirmwareUploader.uploadCertificates(`-b ${fqbn} -a ${address} ${urls
                    .map((url) => `-u ${url}`)
                    .join(' ')}`);
            },
            isEnabled: () => true,
        });
        registry.registerCommand(UploadCertificate_1.Commands.OPEN_CERT_CONTEXT, {
            execute: async (args) => {
                this.contextMenuRenderer.render({
                    menuPath: arduino_menus_1.ArduinoMenus.ROOT_CERTIFICATES__CONTEXT,
                    anchor: {
                        x: args.x,
                        y: args.y,
                    },
                    args: [args.cert],
                });
            },
            isEnabled: () => true,
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.TOOLS__FIRMWARE_UPLOADER_GROUP, {
            commandId: UploadCertificate_1.Commands.OPEN.id,
            label: UploadCertificate_1.Commands.OPEN.label,
            order: '1',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.ROOT_CERTIFICATES__CONTEXT, {
            commandId: UploadCertificate_1.Commands.REMOVE_CERT.id,
            label: UploadCertificate_1.Commands.REMOVE_CERT.label,
            order: '1',
        });
    }
};
__decorate([
    inversify_1.inject(certificate_uploader_dialog_1.UploadCertificateDialog),
    __metadata("design:type", certificate_uploader_dialog_1.UploadCertificateDialog)
], UploadCertificate.prototype, "dialog", void 0);
__decorate([
    inversify_1.inject(context_menu_renderer_1.ContextMenuRenderer),
    __metadata("design:type", context_menu_renderer_1.ContextMenuRenderer)
], UploadCertificate.prototype, "contextMenuRenderer", void 0);
__decorate([
    inversify_1.inject(preference_service_1.PreferenceService),
    __metadata("design:type", Object)
], UploadCertificate.prototype, "preferenceService", void 0);
__decorate([
    inversify_1.inject(arduino_preferences_1.ArduinoPreferences),
    __metadata("design:type", Object)
], UploadCertificate.prototype, "arduinoPreferences", void 0);
__decorate([
    inversify_1.inject(arduino_firmware_uploader_1.ArduinoFirmwareUploader),
    __metadata("design:type", Object)
], UploadCertificate.prototype, "arduinoFirmwareUploader", void 0);
UploadCertificate = UploadCertificate_1 = __decorate([
    inversify_1.injectable()
], UploadCertificate);
exports.UploadCertificate = UploadCertificate;
(function (UploadCertificate) {
    let Commands;
    (function (Commands) {
        Commands.OPEN = {
            id: 'arduino-upload-certificate-open',
            label: common_1.nls.localize('arduino/certificate/uploadRootCertificates', 'Upload SSL Root Certificates'),
            category: 'Arduino',
        };
        Commands.OPEN_CERT_CONTEXT = {
            id: 'arduino-certificate-open-context',
            label: common_1.nls.localize('arduino/certificate/openContext', 'Open context'),
            category: 'Arduino',
        };
        Commands.REMOVE_CERT = {
            id: 'arduino-certificate-remove',
            label: common_1.nls.localize('arduino/certificate/remove', 'Remove'),
            category: 'Arduino',
        };
        Commands.UPLOAD_CERT = {
            id: 'arduino-certificate-upload',
            label: common_1.nls.localize('arduino/certificate/upload', 'Upload'),
            category: 'Arduino',
        };
    })(Commands = UploadCertificate.Commands || (UploadCertificate.Commands = {}));
})(UploadCertificate = exports.UploadCertificate || (exports.UploadCertificate = {}));
exports.UploadCertificate = UploadCertificate;
//# sourceMappingURL=upload-certificate.js.map