"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var SketchControl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SketchControl = void 0;
const inversify_1 = require("inversify");
const common_frontend_contribution_1 = require("@theia/core/lib/browser/common-frontend-contribution");
const application_shell_1 = require("@theia/core/lib/browser/shell/application-shell");
const browser_1 = require("@theia/workspace/lib/browser");
const context_menu_renderer_1 = require("@theia/core/lib/browser/context-menu-renderer");
const disposable_1 = require("@theia/core/lib/common/disposable");
const contribution_1 = require("./contribution");
const arduino_menus_1 = require("../menu/arduino-menus");
const editor_manager_1 = require("@theia/editor/lib/browser/editor-manager");
const sketches_service_client_impl_1 = require("../../common/protocol/sketches-service-client-impl");
const local_cache_fs_provider_1 = require("../local-cache/local-cache-fs-provider");
const common_1 = require("@theia/core/lib/common");
let SketchControl = SketchControl_1 = class SketchControl extends contribution_1.SketchContribution {
    constructor() {
        super(...arguments);
        this.toDisposeBeforeCreateNewContextMenu = new disposable_1.DisposableCollection();
    }
    registerCommands(registry) {
        registry.registerCommand(SketchControl_1.Commands.OPEN_SKETCH_CONTROL__TOOLBAR, {
            isVisible: (widget) => this.shell.getWidgets('main').indexOf(widget) !== -1,
            execute: async () => {
                var _a, _b;
                this.toDisposeBeforeCreateNewContextMenu.dispose();
                const sketch = await this.sketchServiceClient.currentSketch();
                if (!sketch) {
                    return;
                }
                const target = document.getElementById(SketchControl_1.Commands.OPEN_SKETCH_CONTROL__TOOLBAR.id);
                if (!(target instanceof HTMLElement)) {
                    return;
                }
                const { parentElement } = target;
                if (!parentElement) {
                    return;
                }
                const { mainFileUri, rootFolderFileUris } = await this.sketchService.loadSketch(sketch.uri);
                const uris = [mainFileUri, ...rootFolderFileUris];
                const currentSketch = await this.sketchesServiceClient.currentSketch();
                const parentsketchUri = (_b = (_a = this.editorManager.currentEditor) === null || _a === void 0 ? void 0 : _a.getResourceUri()) === null || _b === void 0 ? void 0 : _b.toString();
                const parentsketch = await this.sketchService.getSketchFolder(parentsketchUri || '');
                // if the current file is in the current opened sketch, show extra menus
                if (currentSketch &&
                    parentsketch &&
                    parentsketch.uri === currentSketch.uri &&
                    this.allowRename(parentsketch.uri)) {
                    this.menuRegistry.registerMenuAction(arduino_menus_1.ArduinoMenus.SKETCH_CONTROL__CONTEXT__MAIN_GROUP, {
                        commandId: browser_1.WorkspaceCommands.FILE_RENAME.id,
                        label: common_1.nls.localize('vscode/fileActions/rename', 'Rename'),
                        order: '1',
                    });
                    this.toDisposeBeforeCreateNewContextMenu.push(disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuAction(browser_1.WorkspaceCommands.FILE_RENAME)));
                }
                else {
                    const renamePlaceholder = new arduino_menus_1.PlaceholderMenuNode(arduino_menus_1.ArduinoMenus.SKETCH_CONTROL__CONTEXT__MAIN_GROUP, common_1.nls.localize('vscode/fileActions/rename', 'Rename'));
                    this.menuRegistry.registerMenuNode(arduino_menus_1.ArduinoMenus.SKETCH_CONTROL__CONTEXT__MAIN_GROUP, renamePlaceholder);
                    this.toDisposeBeforeCreateNewContextMenu.push(disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuNode(renamePlaceholder.id)));
                }
                if (currentSketch &&
                    parentsketch &&
                    parentsketch.uri === currentSketch.uri &&
                    this.allowDelete(parentsketch.uri)) {
                    this.menuRegistry.registerMenuAction(arduino_menus_1.ArduinoMenus.SKETCH_CONTROL__CONTEXT__MAIN_GROUP, {
                        commandId: browser_1.WorkspaceCommands.FILE_DELETE.id,
                        label: common_1.nls.localize('vscode/fileActions/delete', 'Delete'),
                        order: '2',
                    });
                    this.toDisposeBeforeCreateNewContextMenu.push(disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuAction(browser_1.WorkspaceCommands.FILE_DELETE)));
                }
                else {
                    const deletePlaceholder = new arduino_menus_1.PlaceholderMenuNode(arduino_menus_1.ArduinoMenus.SKETCH_CONTROL__CONTEXT__MAIN_GROUP, common_1.nls.localize('vscode/fileActions/delete', 'Delete'));
                    this.menuRegistry.registerMenuNode(arduino_menus_1.ArduinoMenus.SKETCH_CONTROL__CONTEXT__MAIN_GROUP, deletePlaceholder);
                    this.toDisposeBeforeCreateNewContextMenu.push(disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuNode(deletePlaceholder.id)));
                }
                for (let i = 0; i < uris.length; i++) {
                    const uri = new contribution_1.URI(uris[i]);
                    // focus on the opened sketch
                    const command = {
                        id: `arduino-focus-file--${uri.toString()}`,
                    };
                    const handler = {
                        execute: () => contribution_1.open(this.openerService, uri),
                    };
                    this.toDisposeBeforeCreateNewContextMenu.push(registry.registerCommand(command, handler));
                    this.menuRegistry.registerMenuAction(arduino_menus_1.ArduinoMenus.SKETCH_CONTROL__CONTEXT__RESOURCES_GROUP, {
                        commandId: command.id,
                        label: this.labelProvider.getName(uri),
                        order: `${i}`,
                    });
                    this.toDisposeBeforeCreateNewContextMenu.push(disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuAction(command)));
                }
                const options = {
                    menuPath: arduino_menus_1.ArduinoMenus.SKETCH_CONTROL__CONTEXT,
                    anchor: {
                        x: parentElement.getBoundingClientRect().left,
                        y: parentElement.getBoundingClientRect().top +
                            parentElement.offsetHeight,
                    },
                };
                this.contextMenuRenderer.render(options);
            },
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.SKETCH_CONTROL__CONTEXT__MAIN_GROUP, {
            commandId: browser_1.WorkspaceCommands.NEW_FILE.id,
            label: common_1.nls.localize('vscode/menubar/mNewTab', 'New Tab'),
            order: '0',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.SKETCH_CONTROL__CONTEXT__NAVIGATION_GROUP, {
            commandId: common_frontend_contribution_1.CommonCommands.PREVIOUS_TAB.id,
            label: common_1.nls.localize('vscode/menubar/mShowPreviousTab', 'Previous Tab'),
            order: '0',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.SKETCH_CONTROL__CONTEXT__NAVIGATION_GROUP, {
            commandId: common_frontend_contribution_1.CommonCommands.NEXT_TAB.id,
            label: common_1.nls.localize('vscode/menubar/mShowNextTab', 'Next Tab'),
            order: '0',
        });
    }
    registerKeybindings(registry) {
        registry.registerKeybinding({
            command: browser_1.WorkspaceCommands.NEW_FILE.id,
            keybinding: 'CtrlCmd+Shift+N',
        });
        registry.registerKeybinding({
            command: common_frontend_contribution_1.CommonCommands.PREVIOUS_TAB.id,
            keybinding: 'CtrlCmd+Alt+Left',
        });
        registry.registerKeybinding({
            command: common_frontend_contribution_1.CommonCommands.NEXT_TAB.id,
            keybinding: 'CtrlCmd+Alt+Right',
        });
    }
    registerToolbarItems(registry) {
        registry.registerItem({
            id: SketchControl_1.Commands.OPEN_SKETCH_CONTROL__TOOLBAR.id,
            command: SketchControl_1.Commands.OPEN_SKETCH_CONTROL__TOOLBAR.id,
        });
    }
    isCloudSketch(uri) {
        try {
            const cloudCacheLocation = this.localCacheFsProvider.from(new contribution_1.URI(uri));
            if (cloudCacheLocation) {
                return true;
            }
            return false;
        }
        catch (_a) {
            return false;
        }
    }
    allowRename(uri) {
        return !this.isCloudSketch(uri);
    }
    allowDelete(uri) {
        return !this.isCloudSketch(uri);
    }
};
__decorate([
    inversify_1.inject(application_shell_1.ApplicationShell),
    __metadata("design:type", application_shell_1.ApplicationShell)
], SketchControl.prototype, "shell", void 0);
__decorate([
    inversify_1.inject(contribution_1.MenuModelRegistry),
    __metadata("design:type", contribution_1.MenuModelRegistry)
], SketchControl.prototype, "menuRegistry", void 0);
__decorate([
    inversify_1.inject(context_menu_renderer_1.ContextMenuRenderer),
    __metadata("design:type", context_menu_renderer_1.ContextMenuRenderer)
], SketchControl.prototype, "contextMenuRenderer", void 0);
__decorate([
    inversify_1.inject(editor_manager_1.EditorManager),
    __metadata("design:type", editor_manager_1.EditorManager)
], SketchControl.prototype, "editorManager", void 0);
__decorate([
    inversify_1.inject(sketches_service_client_impl_1.SketchesServiceClientImpl),
    __metadata("design:type", sketches_service_client_impl_1.SketchesServiceClientImpl)
], SketchControl.prototype, "sketchesServiceClient", void 0);
__decorate([
    inversify_1.inject(local_cache_fs_provider_1.LocalCacheFsProvider),
    __metadata("design:type", local_cache_fs_provider_1.LocalCacheFsProvider)
], SketchControl.prototype, "localCacheFsProvider", void 0);
SketchControl = SketchControl_1 = __decorate([
    inversify_1.injectable()
], SketchControl);
exports.SketchControl = SketchControl;
(function (SketchControl) {
    let Commands;
    (function (Commands) {
        Commands.OPEN_SKETCH_CONTROL__TOOLBAR = {
            id: 'arduino-open-sketch-control--toolbar',
            iconClass: 'fa fa-caret-down',
        };
    })(Commands = SketchControl.Commands || (SketchControl.Commands = {}));
})(SketchControl = exports.SketchControl || (exports.SketchControl = {}));
exports.SketchControl = SketchControl;
//# sourceMappingURL=sketch-control.js.map