"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var SaveSketch_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SaveSketch = void 0;
const inversify_1 = require("inversify");
const common_frontend_contribution_1 = require("@theia/core/lib/browser/common-frontend-contribution");
const arduino_menus_1 = require("../menu/arduino-menus");
const arduino_toolbar_1 = require("../toolbar/arduino-toolbar");
const save_as_sketch_1 = require("./save-as-sketch");
const contribution_1 = require("./contribution");
const common_1 = require("@theia/core/lib/common");
let SaveSketch = SaveSketch_1 = class SaveSketch extends contribution_1.SketchContribution {
    registerCommands(registry) {
        registry.registerCommand(SaveSketch_1.Commands.SAVE_SKETCH, {
            execute: () => this.saveSketch(),
        });
        registry.registerCommand(SaveSketch_1.Commands.SAVE_SKETCH__TOOLBAR, {
            isVisible: (widget) => arduino_toolbar_1.ArduinoToolbar.is(widget) && widget.side === 'left',
            execute: () => registry.executeCommand(SaveSketch_1.Commands.SAVE_SKETCH.id),
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.FILE__SKETCH_GROUP, {
            commandId: SaveSketch_1.Commands.SAVE_SKETCH.id,
            label: common_1.nls.localize('vscode/fileCommands/save', 'Save'),
            order: '6',
        });
    }
    registerKeybindings(registry) {
        registry.registerKeybinding({
            command: SaveSketch_1.Commands.SAVE_SKETCH.id,
            keybinding: 'CtrlCmd+S',
        });
    }
    registerToolbarItems(registry) {
        registry.registerItem({
            id: SaveSketch_1.Commands.SAVE_SKETCH__TOOLBAR.id,
            command: SaveSketch_1.Commands.SAVE_SKETCH__TOOLBAR.id,
            tooltip: common_1.nls.localize('vscode/fileCommands/save', 'Save'),
            priority: 5,
        });
    }
    async saveSketch() {
        const sketch = await this.sketchServiceClient.currentSketch();
        if (!sketch) {
            return;
        }
        const isTemp = await this.sketchService.isTemp(sketch);
        if (isTemp) {
            return this.commandService.executeCommand(save_as_sketch_1.SaveAsSketch.Commands.SAVE_AS_SKETCH.id, {
                execOnlyIfTemp: false,
                openAfterMove: true,
                wipeOriginal: true,
            });
        }
        return this.commandService.executeCommand(common_frontend_contribution_1.CommonCommands.SAVE_ALL.id);
    }
};
SaveSketch = SaveSketch_1 = __decorate([
    inversify_1.injectable()
], SaveSketch);
exports.SaveSketch = SaveSketch;
(function (SaveSketch) {
    let Commands;
    (function (Commands) {
        Commands.SAVE_SKETCH = {
            id: 'arduino-save-sketch',
        };
        Commands.SAVE_SKETCH__TOOLBAR = {
            id: 'arduino-save-sketch--toolbar',
        };
    })(Commands = SaveSketch.Commands || (SaveSketch.Commands = {}));
})(SaveSketch = exports.SaveSketch || (exports.SaveSketch = {}));
exports.SaveSketch = SaveSketch;
//# sourceMappingURL=save-sketch.js.map