"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var SaveAsSketch_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SaveAsSketch = void 0;
const inversify_1 = require("inversify");
const remote = require("@theia/core/electron-shared/@electron/remote");
const dateFormat = require("dateformat");
const arduino_menus_1 = require("../menu/arduino-menus");
const contribution_1 = require("./contribution");
const common_1 = require("@theia/core/lib/common");
let SaveAsSketch = SaveAsSketch_1 = class SaveAsSketch extends contribution_1.SketchContribution {
    registerCommands(registry) {
        registry.registerCommand(SaveAsSketch_1.Commands.SAVE_AS_SKETCH, {
            execute: (args) => this.saveAs(args),
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.FILE__SKETCH_GROUP, {
            commandId: SaveAsSketch_1.Commands.SAVE_AS_SKETCH.id,
            label: common_1.nls.localize('vscode/fileCommands/saveAs', 'Save As...'),
            order: '7',
        });
    }
    registerKeybindings(registry) {
        registry.registerKeybinding({
            command: SaveAsSketch_1.Commands.SAVE_AS_SKETCH.id,
            keybinding: 'CtrlCmd+Shift+S',
        });
    }
    /**
     * Resolves `true` if the sketch was successfully saved as something.
     */
    async saveAs({ execOnlyIfTemp, openAfterMove, wipeOriginal, } = SaveAsSketch_1.Options.DEFAULT) {
        const sketch = await this.sketchServiceClient.currentSketch();
        if (!sketch) {
            return false;
        }
        const isTemp = await this.sketchService.isTemp(sketch);
        if (!isTemp && !!execOnlyIfTemp) {
            return false;
        }
        // If target does not exist, propose a `directories.user`/${sketch.name} path
        // If target exists, propose `directories.user`/${sketch.name}_copy_${yyyymmddHHMMss}
        const sketchDirUri = new contribution_1.URI((await this.configService.getConfiguration()).sketchDirUri);
        const exists = await this.fileService.exists(sketchDirUri.resolve(sketch.name));
        const defaultUri = exists
            ? sketchDirUri.resolve(sketchDirUri
                .resolve(`${sketch.name}_copy_${dateFormat(new Date(), 'yyyymmddHHMMss')}`)
                .toString())
            : sketchDirUri.resolve(sketch.name);
        const defaultPath = await this.fileService.fsPath(defaultUri);
        const { filePath, canceled } = await remote.dialog.showSaveDialog({
            title: common_1.nls.localize('arduino/sketch/saveFolderAs', 'Save sketch folder as...'),
            defaultPath,
        });
        if (!filePath || canceled) {
            return false;
        }
        const destinationUri = await this.fileSystemExt.getUri(filePath);
        if (!destinationUri) {
            return false;
        }
        const workspaceUri = await this.sketchService.copy(sketch, {
            destinationUri,
        });
        if (workspaceUri && openAfterMove) {
            if (wipeOriginal || (openAfterMove && execOnlyIfTemp)) {
                try {
                    await this.fileService.delete(new contribution_1.URI(sketch.uri), {
                        recursive: true,
                    });
                }
                catch (_a) {
                    /* NOOP: from time to time, it's not possible to wipe the old resource from the temp dir on Windows */
                }
            }
            this.workspaceService.open(new contribution_1.URI(workspaceUri), {
                preserveWindow: true,
            });
        }
        return !!workspaceUri;
    }
};
SaveAsSketch = SaveAsSketch_1 = __decorate([
    inversify_1.injectable()
], SaveAsSketch);
exports.SaveAsSketch = SaveAsSketch;
(function (SaveAsSketch) {
    let Commands;
    (function (Commands) {
        Commands.SAVE_AS_SKETCH = {
            id: 'arduino-save-as-sketch',
        };
    })(Commands = SaveAsSketch.Commands || (SaveAsSketch.Commands = {}));
    let Options;
    (function (Options) {
        Options.DEFAULT = {
            execOnlyIfTemp: false,
            openAfterMove: true,
            wipeOriginal: false,
        };
    })(Options = SaveAsSketch.Options || (SaveAsSketch.Options = {}));
})(SaveAsSketch = exports.SaveAsSketch || (exports.SaveAsSketch = {}));
exports.SaveAsSketch = SaveAsSketch;
//# sourceMappingURL=save-as-sketch.js.map