"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var OpenSketchExternal_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenSketchExternal = void 0;
const inversify_1 = require("inversify");
const remote = require("@theia/core/electron-shared/@electron/remote");
const uri_1 = require("@theia/core/lib/common/uri");
const arduino_menus_1 = require("../menu/arduino-menus");
const contribution_1 = require("./contribution");
const common_1 = require("@theia/core/lib/common");
let OpenSketchExternal = OpenSketchExternal_1 = class OpenSketchExternal extends contribution_1.SketchContribution {
    registerCommands(registry) {
        registry.registerCommand(OpenSketchExternal_1.Commands.OPEN_EXTERNAL, {
            execute: () => this.openExternal(),
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.SKETCH__UTILS_GROUP, {
            commandId: OpenSketchExternal_1.Commands.OPEN_EXTERNAL.id,
            label: common_1.nls.localize('arduino/sketch/showFolder', 'Show Sketch Folder'),
            order: '0',
        });
    }
    registerKeybindings(registry) {
        registry.registerKeybinding({
            command: OpenSketchExternal_1.Commands.OPEN_EXTERNAL.id,
            keybinding: 'CtrlCmd+Alt+K',
        });
    }
    async openExternal() {
        const uri = await this.sketchServiceClient.currentSketchFile();
        if (uri) {
            const exists = await this.fileService.exists(new uri_1.default(uri));
            if (exists) {
                const fsPath = await this.fileService.fsPath(new uri_1.default(uri));
                if (fsPath) {
                    remote.shell.showItemInFolder(fsPath);
                }
            }
        }
    }
};
OpenSketchExternal = OpenSketchExternal_1 = __decorate([
    inversify_1.injectable()
], OpenSketchExternal);
exports.OpenSketchExternal = OpenSketchExternal;
(function (OpenSketchExternal) {
    let Commands;
    (function (Commands) {
        Commands.OPEN_EXTERNAL = {
            id: 'arduino-open-sketch-external',
        };
    })(Commands = OpenSketchExternal.Commands || (OpenSketchExternal.Commands = {}));
})(OpenSketchExternal = exports.OpenSketchExternal || (exports.OpenSketchExternal = {}));
exports.OpenSketchExternal = OpenSketchExternal;
//# sourceMappingURL=open-sketch-external.js.map