"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenRecentSketch = void 0;
const inversify_1 = require("inversify");
const workspace_protocol_1 = require("@theia/workspace/lib/common/workspace-protocol");
const disposable_1 = require("@theia/core/lib/common/disposable");
const contribution_1 = require("./contribution");
const arduino_menus_1 = require("../menu/arduino-menus");
const main_menu_manager_1 = require("../../common/main-menu-manager");
const open_sketch_1 = require("./open-sketch");
const notification_center_1 = require("../notification-center");
const common_1 = require("@theia/core/lib/common");
let OpenRecentSketch = class OpenRecentSketch extends contribution_1.SketchContribution {
    constructor() {
        super(...arguments);
        this.toDisposeBeforeRegister = new Map();
    }
    onStart() {
        const refreshMenu = (sketches) => {
            this.register(sketches);
            this.mainMenuManager.update();
        };
        this.notificationCenter.onRecentSketchesChanged(({ sketches }) => refreshMenu(sketches));
        this.sketchService.recentlyOpenedSketches().then(refreshMenu);
    }
    registerMenus(registry) {
        registry.registerSubmenu(arduino_menus_1.ArduinoMenus.FILE__OPEN_RECENT_SUBMENU, common_1.nls.localize('arduino/sketch/openRecent', 'Open Recent'), { order: '2' });
    }
    register(sketches) {
        const order = 0;
        for (const sketch of sketches) {
            const { uri } = sketch;
            const toDispose = this.toDisposeBeforeRegister.get(uri);
            if (toDispose) {
                toDispose.dispose();
            }
            const command = { id: `arduino-open-recent--${uri}` };
            const handler = {
                execute: () => this.commandRegistry.executeCommand(open_sketch_1.OpenSketch.Commands.OPEN_SKETCH.id, sketch),
            };
            this.commandRegistry.registerCommand(command, handler);
            this.menuRegistry.registerMenuAction(arduino_menus_1.ArduinoMenus.FILE__OPEN_RECENT_SUBMENU, {
                commandId: command.id,
                label: sketch.name,
                order: String(order),
            });
            this.toDisposeBeforeRegister.set(sketch.uri, new disposable_1.DisposableCollection(disposable_1.Disposable.create(() => this.commandRegistry.unregisterCommand(command)), disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuAction(command))));
        }
    }
};
__decorate([
    inversify_1.inject(contribution_1.CommandRegistry),
    __metadata("design:type", contribution_1.CommandRegistry)
], OpenRecentSketch.prototype, "commandRegistry", void 0);
__decorate([
    inversify_1.inject(contribution_1.MenuModelRegistry),
    __metadata("design:type", contribution_1.MenuModelRegistry)
], OpenRecentSketch.prototype, "menuRegistry", void 0);
__decorate([
    inversify_1.inject(main_menu_manager_1.MainMenuManager),
    __metadata("design:type", Object)
], OpenRecentSketch.prototype, "mainMenuManager", void 0);
__decorate([
    inversify_1.inject(workspace_protocol_1.WorkspaceServer),
    __metadata("design:type", Object)
], OpenRecentSketch.prototype, "workspaceServer", void 0);
__decorate([
    inversify_1.inject(notification_center_1.NotificationCenter),
    __metadata("design:type", notification_center_1.NotificationCenter)
], OpenRecentSketch.prototype, "notificationCenter", void 0);
OpenRecentSketch = __decorate([
    inversify_1.injectable()
], OpenRecentSketch);
exports.OpenRecentSketch = OpenRecentSketch;
//# sourceMappingURL=open-recent-sketch.js.map