"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var IncludeLibrary_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IncludeLibrary = void 0;
const PQueue = require("p-queue");
const inversify_1 = require("inversify");
const uri_1 = require("@theia/core/lib/common/uri");
const monaco_editor_1 = require("@theia/monaco/lib/browser/monaco-editor");
const browser_1 = require("@theia/editor/lib/browser");
const menu_1 = require("@theia/core/lib/common/menu");
const disposable_1 = require("@theia/core/lib/common/disposable");
const arduino_menus_1 = require("../menu/arduino-menus");
const protocol_1 = require("../../common/protocol");
const main_menu_manager_1 = require("../../common/main-menu-manager");
const library_list_widget_1 = require("../library/library-list-widget");
const boards_service_provider_1 = require("../boards/boards-service-provider");
const contribution_1 = require("./contribution");
const notification_center_1 = require("../notification-center");
const common_1 = require("@theia/core/lib/common");
let IncludeLibrary = IncludeLibrary_1 = class IncludeLibrary extends contribution_1.SketchContribution {
    constructor() {
        super(...arguments);
        this.queue = new PQueue({ autoStart: true, concurrency: 1 });
        this.toDispose = new disposable_1.DisposableCollection();
    }
    onStart() {
        this.updateMenuActions();
        this.boardsServiceClient.onBoardsConfigChanged(() => this.updateMenuActions());
        this.notificationCenter.onLibraryInstalled(() => this.updateMenuActions());
        this.notificationCenter.onLibraryUninstalled(() => this.updateMenuActions());
    }
    registerMenus(registry) {
        // `Include Library` submenu
        const includeLibMenuPath = [
            ...arduino_menus_1.ArduinoMenus.SKETCH__UTILS_GROUP,
            '0_include',
        ];
        registry.registerSubmenu(includeLibMenuPath, common_1.nls.localize('arduino/library/include', 'Include Library'), {
            order: '1',
        });
        // `Manage Libraries...` group.
        registry.registerMenuAction([...includeLibMenuPath, '0_manage'], {
            commandId: `${library_list_widget_1.LibraryListWidget.WIDGET_ID}:toggle`,
            label: common_1.nls.localize('arduino/library/manageLibraries', 'Manage Libraries...'),
        });
    }
    registerCommands(registry) {
        registry.registerCommand(IncludeLibrary_1.Commands.INCLUDE_LIBRARY, {
            execute: async (arg) => {
                if (protocol_1.LibraryPackage.is(arg)) {
                    this.includeLibrary(arg);
                }
            },
        });
    }
    async updateMenuActions() {
        return this.queue.add(async () => {
            var _a;
            this.toDispose.dispose();
            this.mainMenuManager.update();
            const libraries = [];
            const fqbn = (_a = this.boardsServiceClient.boardsConfig.selectedBoard) === null || _a === void 0 ? void 0 : _a.fqbn;
            // Show all libraries, when no board is selected.
            // Otherwise, show libraries only for the selected board.
            libraries.push(...(await this.libraryService.list({ fqbn })));
            const includeLibMenuPath = [
                ...arduino_menus_1.ArduinoMenus.SKETCH__UTILS_GROUP,
                '0_include',
            ];
            // `Add .ZIP Library...`
            // TODO: implement it
            // `Arduino libraries`
            const packageMenuPath = [...includeLibMenuPath, '2_arduino'];
            const userMenuPath = [...includeLibMenuPath, '3_contributed'];
            const { user, rest } = protocol_1.LibraryPackage.groupByLocation(libraries);
            if (rest.length) {
                rest.unshift(common_1.nls.localize('arduino/library/arduinoLibraries', 'Arduino libraries'));
            }
            if (user.length) {
                user.unshift(common_1.nls.localize('arduino/library/contributedLibraries', 'Contributed libraries'));
            }
            for (const library of user) {
                this.toDispose.push(this.registerLibrary(library, userMenuPath));
            }
            for (const library of rest) {
                this.toDispose.push(this.registerLibrary(library, packageMenuPath));
            }
            this.mainMenuManager.update();
        });
    }
    registerLibrary(libraryOrPlaceholder, menuPath) {
        if (typeof libraryOrPlaceholder === 'string') {
            const placeholder = new arduino_menus_1.PlaceholderMenuNode(menuPath, libraryOrPlaceholder);
            this.menuRegistry.registerMenuNode(menuPath, placeholder);
            return disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuNode(placeholder.id));
        }
        const commandId = `arduino-include-library--${libraryOrPlaceholder.name}:${libraryOrPlaceholder.author}`;
        const command = { id: commandId };
        const handler = {
            execute: () => this.commandRegistry.executeCommand(IncludeLibrary_1.Commands.INCLUDE_LIBRARY.id, libraryOrPlaceholder),
        };
        const menuAction = { commandId, label: libraryOrPlaceholder.name };
        this.menuRegistry.registerMenuAction(menuPath, menuAction);
        return new disposable_1.DisposableCollection(this.commandRegistry.registerCommand(command, handler), disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuAction(menuAction)));
    }
    async includeLibrary(library) {
        var _a;
        const sketch = await this.sketchServiceClient.currentSketch();
        if (!sketch) {
            return;
        }
        // If the current editor is one of the additional files from the sketch, we use that.
        // Otherwise, we pick the editor of the main sketch file.
        let codeEditor;
        const editor = (_a = this.editorManager.currentEditor) === null || _a === void 0 ? void 0 : _a.editor;
        if (editor instanceof monaco_editor_1.MonacoEditor) {
            if (sketch.additionalFileUris.some((uri) => uri === editor.uri.toString())) {
                codeEditor = editor.getControl();
            }
        }
        if (!codeEditor) {
            const widget = await this.editorManager.open(new uri_1.default(sketch.mainFileUri));
            if (widget.editor instanceof monaco_editor_1.MonacoEditor) {
                codeEditor = widget.editor.getControl();
            }
        }
        if (!codeEditor) {
            return;
        }
        const textModel = codeEditor.getModel();
        if (!textModel) {
            return;
        }
        const cursorState = codeEditor.getSelections() || [];
        const eol = textModel.getEOL();
        const includes = library.includes.slice();
        includes.push(''); // For the trailing new line.
        const text = includes
            .map((include) => (include ? `#include <${include}>` : eol))
            .join(eol);
        textModel.pushStackElement(); // Start a fresh operation.
        textModel.pushEditOperations(cursorState, [
            {
                range: new monaco.Range(1, 1, 1, 1),
                text,
                forceMoveMarkers: true,
            },
        ], () => cursorState);
        textModel.pushStackElement(); // Make it undoable.
    }
};
__decorate([
    inversify_1.inject(contribution_1.CommandRegistry),
    __metadata("design:type", contribution_1.CommandRegistry)
], IncludeLibrary.prototype, "commandRegistry", void 0);
__decorate([
    inversify_1.inject(menu_1.MenuModelRegistry),
    __metadata("design:type", menu_1.MenuModelRegistry)
], IncludeLibrary.prototype, "menuRegistry", void 0);
__decorate([
    inversify_1.inject(main_menu_manager_1.MainMenuManager),
    __metadata("design:type", Object)
], IncludeLibrary.prototype, "mainMenuManager", void 0);
__decorate([
    inversify_1.inject(browser_1.EditorManager),
    __metadata("design:type", browser_1.EditorManager)
], IncludeLibrary.prototype, "editorManager", void 0);
__decorate([
    inversify_1.inject(notification_center_1.NotificationCenter),
    __metadata("design:type", notification_center_1.NotificationCenter)
], IncludeLibrary.prototype, "notificationCenter", void 0);
__decorate([
    inversify_1.inject(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], IncludeLibrary.prototype, "boardsServiceClient", void 0);
__decorate([
    inversify_1.inject(protocol_1.LibraryService),
    __metadata("design:type", Object)
], IncludeLibrary.prototype, "libraryService", void 0);
IncludeLibrary = IncludeLibrary_1 = __decorate([
    inversify_1.injectable()
], IncludeLibrary);
exports.IncludeLibrary = IncludeLibrary;
(function (IncludeLibrary) {
    let Commands;
    (function (Commands) {
        Commands.INCLUDE_LIBRARY = {
            id: 'arduino-include-library',
        };
    })(Commands = IncludeLibrary.Commands || (IncludeLibrary.Commands = {}));
})(IncludeLibrary = exports.IncludeLibrary || (exports.IncludeLibrary = {}));
exports.IncludeLibrary = IncludeLibrary;
//# sourceMappingURL=include-library.js.map