"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var Help_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Help = void 0;
const inversify_1 = require("inversify");
const monaco_editor_1 = require("@theia/monaco/lib/browser/monaco-editor");
const editor_manager_1 = require("@theia/editor/lib/browser/editor-manager");
const window_service_1 = require("@theia/core/lib/browser/window/window-service");
const arduino_menus_1 = require("../menu/arduino-menus");
const quick_input_service_1 = require("@theia/core/lib/browser/quick-input/quick-input-service");
const contribution_1 = require("./contribution");
const common_1 = require("@theia/core/lib/common");
const ide_updater_commands_1 = require("../ide-updater/ide-updater-commands");
const electron_menu_contribution_1 = require("@theia/core/lib/electron-browser/menu/electron-menu-contribution");
let Help = Help_1 = class Help extends contribution_1.Contribution {
    registerCommands(registry) {
        const open = (url) => this.windowService.openNewWindow(url, { external: true });
        const createOpenHandler = (url) => ({
            execute: () => open(url),
        });
        registry.registerCommand(Help_1.Commands.GETTING_STARTED, createOpenHandler('https://www.arduino.cc/en/Guide'));
        registry.registerCommand(Help_1.Commands.ENVIRONMENT, createOpenHandler('https://www.arduino.cc/en/Guide/Environment'));
        registry.registerCommand(Help_1.Commands.TROUBLESHOOTING, createOpenHandler('https://support.arduino.cc/hc/en-us'));
        registry.registerCommand(Help_1.Commands.REFERENCE, createOpenHandler('https://www.arduino.cc/reference/en/'));
        registry.registerCommand(Help_1.Commands.FIND_IN_REFERENCE, {
            execute: async () => {
                let searchFor = undefined;
                const { currentEditor } = this.editorManager;
                if (currentEditor && currentEditor.editor instanceof monaco_editor_1.MonacoEditor) {
                    const codeEditor = currentEditor.editor.getControl();
                    const selection = codeEditor.getSelection();
                    const model = codeEditor.getModel();
                    if (model && selection && !monaco.Range.isEmpty(selection)) {
                        searchFor = model.getValueInRange(selection);
                    }
                }
                if (!searchFor) {
                    searchFor = await this.quickInputService.input({
                        prompt: common_1.nls.localize('arduino/help/search', 'Search on Arduino.cc'),
                        placeHolder: common_1.nls.localize('arduino/help/keyword', 'Type a keyword'),
                    });
                }
                if (searchFor) {
                    return open(`https://www.arduino.cc/search?q=${encodeURIComponent(searchFor)}&tab=reference`);
                }
            },
        });
        registry.registerCommand(Help_1.Commands.FAQ, createOpenHandler('https://support.arduino.cc/hc/en-us'));
        registry.registerCommand(Help_1.Commands.VISIT_ARDUINO, createOpenHandler('https://www.arduino.cc/'));
        registry.registerCommand(Help_1.Commands.PRIVACY_POLICY, createOpenHandler('https://www.arduino.cc/en/privacy-policy'));
    }
    registerMenus(registry) {
        registry.unregisterMenuAction({
            commandId: electron_menu_contribution_1.ElectronCommands.TOGGLE_DEVELOPER_TOOLS.id,
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.HELP__MAIN_GROUP, {
            commandId: Help_1.Commands.GETTING_STARTED.id,
            order: '0',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.HELP__MAIN_GROUP, {
            commandId: Help_1.Commands.ENVIRONMENT.id,
            order: '1',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.HELP__MAIN_GROUP, {
            commandId: Help_1.Commands.TROUBLESHOOTING.id,
            order: '2',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.HELP__MAIN_GROUP, {
            commandId: Help_1.Commands.REFERENCE.id,
            order: '3',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.HELP__FIND_GROUP, {
            commandId: Help_1.Commands.FIND_IN_REFERENCE.id,
            order: '4',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.HELP__FIND_GROUP, {
            commandId: Help_1.Commands.FAQ.id,
            order: '5',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.HELP__FIND_GROUP, {
            commandId: Help_1.Commands.VISIT_ARDUINO.id,
            order: '6',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.HELP__FIND_GROUP, {
            commandId: Help_1.Commands.PRIVACY_POLICY.id,
            order: '7',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.HELP__FIND_GROUP, {
            commandId: ide_updater_commands_1.IDEUpdaterCommands.CHECK_FOR_UPDATES.id,
            order: '8',
        });
    }
    registerKeybindings(registry) {
        registry.registerKeybinding({
            command: Help_1.Commands.FIND_IN_REFERENCE.id,
            keybinding: 'CtrlCmd+Shift+F',
        });
    }
};
__decorate([
    inversify_1.inject(editor_manager_1.EditorManager),
    __metadata("design:type", editor_manager_1.EditorManager)
], Help.prototype, "editorManager", void 0);
__decorate([
    inversify_1.inject(window_service_1.WindowService),
    __metadata("design:type", Object)
], Help.prototype, "windowService", void 0);
__decorate([
    inversify_1.inject(quick_input_service_1.QuickInputService),
    __metadata("design:type", Object)
], Help.prototype, "quickInputService", void 0);
Help = Help_1 = __decorate([
    inversify_1.injectable()
], Help);
exports.Help = Help;
(function (Help) {
    let Commands;
    (function (Commands) {
        Commands.GETTING_STARTED = {
            id: 'arduino-getting-started',
            label: common_1.nls.localize('arduino/help/gettingStarted', 'Getting Started'),
            category: 'Arduino',
        };
        Commands.ENVIRONMENT = {
            id: 'arduino-environment',
            label: common_1.nls.localize('arduino/help/environment', 'Environment'),
            category: 'Arduino',
        };
        Commands.TROUBLESHOOTING = {
            id: 'arduino-troubleshooting',
            label: common_1.nls.localize('arduino/help/troubleshooting', 'Troubleshooting'),
            category: 'Arduino',
        };
        Commands.REFERENCE = {
            id: 'arduino-reference',
            label: common_1.nls.localize('arduino/help/reference', 'Reference'),
            category: 'Arduino',
        };
        Commands.FIND_IN_REFERENCE = {
            id: 'arduino-find-in-reference',
            label: common_1.nls.localize('arduino/help/findInReference', 'Find in Reference'),
            category: 'Arduino',
        };
        Commands.FAQ = {
            id: 'arduino-faq',
            label: common_1.nls.localize('arduino/help/faq', 'Frequently Asked Questions'),
            category: 'Arduino',
        };
        Commands.VISIT_ARDUINO = {
            id: 'arduino-visit-arduino',
            label: common_1.nls.localize('arduino/help/visit', 'Visit Arduino.cc'),
            category: 'Arduino',
        };
        Commands.PRIVACY_POLICY = {
            id: 'arduino-privacy-policy',
            label: common_1.nls.localize('arduino/help/privacyPolicy', 'Privacy Policy'),
            category: 'Arduino',
        };
    })(Commands = Help.Commands || (Help.Commands = {}));
})(Help = exports.Help || (exports.Help = {}));
exports.Help = Help;
//# sourceMappingURL=help.js.map