"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LibraryExamples = exports.BuiltInExamples = exports.Examples = void 0;
const PQueue = require("p-queue");
const inversify_1 = require("inversify");
const menu_1 = require("@theia/core/lib/common/menu");
const disposable_1 = require("@theia/core/lib/common/disposable");
const open_sketch_1 = require("./open-sketch");
const arduino_menus_1 = require("../menu/arduino-menus");
const main_menu_manager_1 = require("../../common/main-menu-manager");
const boards_service_provider_1 = require("../boards/boards-service-provider");
const examples_service_1 = require("../../common/protocol/examples-service");
const contribution_1 = require("./contribution");
const notification_center_1 = require("../notification-center");
const protocol_1 = require("../../common/protocol");
const common_1 = require("@theia/core/lib/common");
let Examples = class Examples extends contribution_1.SketchContribution {
    constructor() {
        super(...arguments);
        this.toDispose = new disposable_1.DisposableCollection();
    }
    init() {
        this.boardsServiceClient.onBoardsConfigChanged(({ selectedBoard }) => this.handleBoardChanged(selectedBoard));
    }
    handleBoardChanged(board) {
        // NOOP
    }
    registerMenus(registry) {
        try {
            // This is a hack the ensures the desired menu ordering! We cannot use https://github.com/eclipse-theia/theia/pull/8377 due to ATL-222.
            const index = arduino_menus_1.ArduinoMenus.FILE__EXAMPLES_SUBMENU.length - 1;
            const menuId = arduino_menus_1.ArduinoMenus.FILE__EXAMPLES_SUBMENU[index];
            const groupPath = index === 0 ? [] : arduino_menus_1.ArduinoMenus.FILE__EXAMPLES_SUBMENU.slice(0, index);
            const parent = registry.findGroup(groupPath);
            const examples = new menu_1.CompositeMenuNode(menuId, '', { order: '4' });
            parent.addNode(examples);
        }
        catch (e) {
            console.error(e);
            console.warn('Could not patch menu ordering.');
        }
        // Registering the same submenu multiple times has no side-effect.
        // TODO: unregister submenu? https://github.com/eclipse-theia/theia/issues/7300
        registry.registerSubmenu(arduino_menus_1.ArduinoMenus.FILE__EXAMPLES_SUBMENU, common_1.nls.localize('arduino/examples/menu', 'Examples'), {
            order: '4',
        });
    }
    registerRecursively(sketchContainerOrPlaceholder, menuPath, pushToDispose = new disposable_1.DisposableCollection(), subMenuOptions) {
        if (typeof sketchContainerOrPlaceholder === 'string') {
            const placeholder = new arduino_menus_1.PlaceholderMenuNode(menuPath, sketchContainerOrPlaceholder);
            this.menuRegistry.registerMenuNode(menuPath, placeholder);
            pushToDispose.push(disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuNode(placeholder.id)));
        }
        else {
            const sketches = [];
            const children = [];
            let submenuPath = menuPath;
            if (protocol_1.SketchContainer.is(sketchContainerOrPlaceholder)) {
                const { label } = sketchContainerOrPlaceholder;
                submenuPath = [...menuPath, label];
                this.menuRegistry.registerSubmenu(submenuPath, label, subMenuOptions);
                sketches.push(...sketchContainerOrPlaceholder.sketches);
                children.push(...sketchContainerOrPlaceholder.children);
            }
            else {
                for (const sketchOrContainer of sketchContainerOrPlaceholder) {
                    if (protocol_1.SketchContainer.is(sketchOrContainer)) {
                        children.push(sketchOrContainer);
                    }
                    else {
                        sketches.push(sketchOrContainer);
                    }
                }
            }
            children.forEach((child) => this.registerRecursively(child, submenuPath, pushToDispose));
            for (const sketch of sketches) {
                const { uri } = sketch;
                const commandId = `arduino-open-example-${submenuPath.join(':')}--${uri}`;
                const command = { id: commandId };
                const handler = this.createHandler(uri);
                pushToDispose.push(this.commandRegistry.registerCommand(command, handler));
                this.menuRegistry.registerMenuAction(submenuPath, {
                    commandId,
                    label: sketch.name,
                    order: sketch.name.toLocaleLowerCase(),
                });
                pushToDispose.push(disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuAction(command)));
            }
        }
    }
    createHandler(uri) {
        return {
            execute: async () => {
                const sketch = await this.sketchService.cloneExample(uri);
                return this.commandService.executeCommand(open_sketch_1.OpenSketch.Commands.OPEN_SKETCH.id, sketch);
            },
        };
    }
};
__decorate([
    inversify_1.inject(contribution_1.CommandRegistry),
    __metadata("design:type", contribution_1.CommandRegistry)
], Examples.prototype, "commandRegistry", void 0);
__decorate([
    inversify_1.inject(contribution_1.MenuModelRegistry),
    __metadata("design:type", contribution_1.MenuModelRegistry)
], Examples.prototype, "menuRegistry", void 0);
__decorate([
    inversify_1.inject(main_menu_manager_1.MainMenuManager),
    __metadata("design:type", Object)
], Examples.prototype, "menuManager", void 0);
__decorate([
    inversify_1.inject(examples_service_1.ExamplesService),
    __metadata("design:type", Object)
], Examples.prototype, "examplesService", void 0);
__decorate([
    inversify_1.inject(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], Examples.prototype, "boardsServiceClient", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], Examples.prototype, "init", null);
Examples = __decorate([
    inversify_1.injectable()
], Examples);
exports.Examples = Examples;
let BuiltInExamples = class BuiltInExamples extends Examples {
    onStart() {
        this.register(); // no `await`
    }
    async register() {
        let sketchContainers;
        try {
            sketchContainers = await this.examplesService.builtIns();
        }
        catch (e) {
            console.error('Could not initialize built-in examples.', e);
            this.messageService.error(common_1.nls.localize('arduino/examples/couldNotInitializeExamples', 'Could not initialize built-in examples.'));
            return;
        }
        this.toDispose.dispose();
        for (const container of [
            common_1.nls.localize('arduino/examples/builtInExamples', 'Built-in examples'),
            ...sketchContainers,
        ]) {
            this.registerRecursively(container, arduino_menus_1.ArduinoMenus.EXAMPLES__BUILT_IN_GROUP, this.toDispose);
        }
        this.menuManager.update();
    }
};
BuiltInExamples = __decorate([
    inversify_1.injectable()
], BuiltInExamples);
exports.BuiltInExamples = BuiltInExamples;
let LibraryExamples = class LibraryExamples extends Examples {
    constructor() {
        super(...arguments);
        this.queue = new PQueue({ autoStart: true, concurrency: 1 });
    }
    onStart() {
        this.register(); // no `await`
        this.notificationCenter.onLibraryInstalled(() => this.register());
        this.notificationCenter.onLibraryUninstalled(() => this.register());
    }
    handleBoardChanged(board) {
        this.register(board);
    }
    async register(board = this.boardsServiceClient.boardsConfig
        .selectedBoard) {
        return this.queue.add(async () => {
            this.toDispose.dispose();
            const fqbn = board === null || board === void 0 ? void 0 : board.fqbn;
            const name = board === null || board === void 0 ? void 0 : board.name;
            // Shows all examples when no board is selected, or the platform of the currently selected board is not installed.
            const { user, current, any } = await this.examplesService.installed({
                fqbn,
            });
            if (user.length) {
                user.unshift(common_1.nls.localize('arduino/examples/customLibrary', 'Examples from Custom Libraries'));
            }
            if (name && fqbn && current.length) {
                current.unshift(common_1.nls.localize('arduino/examples/for', 'Examples for {0}', name));
            }
            if (any.length) {
                any.unshift(common_1.nls.localize('arduino/examples/forAny', 'Examples for any board'));
            }
            for (const container of user) {
                this.registerRecursively(container, arduino_menus_1.ArduinoMenus.EXAMPLES__USER_LIBS_GROUP, this.toDispose);
            }
            for (const container of current) {
                this.registerRecursively(container, arduino_menus_1.ArduinoMenus.EXAMPLES__CURRENT_BOARD_GROUP, this.toDispose);
            }
            for (const container of any) {
                this.registerRecursively(container, arduino_menus_1.ArduinoMenus.EXAMPLES__ANY_BOARD_GROUP, this.toDispose);
            }
            this.menuManager.update();
        });
    }
};
__decorate([
    inversify_1.inject(notification_center_1.NotificationCenter),
    __metadata("design:type", notification_center_1.NotificationCenter)
], LibraryExamples.prototype, "notificationCenter", void 0);
LibraryExamples = __decorate([
    inversify_1.injectable()
], LibraryExamples);
exports.LibraryExamples = LibraryExamples;
//# sourceMappingURL=examples.js.map