"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SketchContribution = exports.Contribution = exports.open = exports.Sketch = exports.URI = exports.TabBarToolbarRegistry = exports.KeybindingRegistry = exports.MenuModelRegistry = exports.CommandRegistry = exports.Command = void 0;
const inversify_1 = require("inversify");
const uri_1 = require("@theia/core/lib/common/uri");
exports.URI = uri_1.default;
const logger_1 = require("@theia/core/lib/common/logger");
const saveable_1 = require("@theia/core/lib/browser/saveable");
const file_service_1 = require("@theia/filesystem/lib/browser/file-service");
const label_provider_1 = require("@theia/core/lib/browser/label-provider");
const editor_manager_1 = require("@theia/editor/lib/browser/editor-manager");
const message_service_1 = require("@theia/core/lib/common/message-service");
const workspace_service_1 = require("@theia/workspace/lib/browser/workspace-service");
const opener_service_1 = require("@theia/core/lib/browser/opener-service");
Object.defineProperty(exports, "open", { enumerable: true, get: function () { return opener_service_1.open; } });
const output_channel_1 = require("@theia/output/lib/browser/output-channel");
const menu_1 = require("@theia/core/lib/common/menu");
Object.defineProperty(exports, "MenuModelRegistry", { enumerable: true, get: function () { return menu_1.MenuModelRegistry; } });
const keybinding_1 = require("@theia/core/lib/browser/keybinding");
Object.defineProperty(exports, "KeybindingRegistry", { enumerable: true, get: function () { return keybinding_1.KeybindingRegistry; } });
const tab_bar_toolbar_1 = require("@theia/core/lib/browser/shell/tab-bar-toolbar");
Object.defineProperty(exports, "TabBarToolbarRegistry", { enumerable: true, get: function () { return tab_bar_toolbar_1.TabBarToolbarRegistry; } });
const frontend_application_1 = require("@theia/core/lib/browser/frontend-application");
const command_1 = require("@theia/core/lib/common/command");
Object.defineProperty(exports, "Command", { enumerable: true, get: function () { return command_1.Command; } });
Object.defineProperty(exports, "CommandRegistry", { enumerable: true, get: function () { return command_1.CommandRegistry; } });
const editor_mode_1 = require("../editor-mode");
const settings_1 = require("../dialogs/settings/settings");
const sketches_service_client_impl_1 = require("../../common/protocol/sketches-service-client-impl");
const protocol_1 = require("../../common/protocol");
Object.defineProperty(exports, "Sketch", { enumerable: true, get: function () { return protocol_1.Sketch; } });
const arduino_preferences_1 = require("../arduino-preferences");
let Contribution = class Contribution {
    onStart(app) { }
    registerCommands(registry) { }
    registerMenus(registry) { }
    registerKeybindings(registry) { }
    registerToolbarItems(registry) { }
};
__decorate([
    inversify_1.inject(logger_1.ILogger),
    __metadata("design:type", Object)
], Contribution.prototype, "logger", void 0);
__decorate([
    inversify_1.inject(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], Contribution.prototype, "messageService", void 0);
__decorate([
    inversify_1.inject(command_1.CommandService),
    __metadata("design:type", Object)
], Contribution.prototype, "commandService", void 0);
__decorate([
    inversify_1.inject(workspace_service_1.WorkspaceService),
    __metadata("design:type", workspace_service_1.WorkspaceService)
], Contribution.prototype, "workspaceService", void 0);
__decorate([
    inversify_1.inject(editor_mode_1.EditorMode),
    __metadata("design:type", editor_mode_1.EditorMode)
], Contribution.prototype, "editorMode", void 0);
__decorate([
    inversify_1.inject(label_provider_1.LabelProvider),
    __metadata("design:type", label_provider_1.LabelProvider)
], Contribution.prototype, "labelProvider", void 0);
__decorate([
    inversify_1.inject(settings_1.SettingsService),
    __metadata("design:type", settings_1.SettingsService)
], Contribution.prototype, "settingsService", void 0);
Contribution = __decorate([
    inversify_1.injectable()
], Contribution);
exports.Contribution = Contribution;
let SketchContribution = class SketchContribution extends Contribution {
    async sourceOverride() {
        const override = {};
        const sketch = await this.sketchServiceClient.currentSketch();
        if (sketch) {
            for (const editor of this.editorManager.all) {
                const uri = editor.editor.uri;
                if (saveable_1.Saveable.isDirty(editor) && protocol_1.Sketch.isInSketch(uri, sketch)) {
                    override[uri.toString()] = editor.editor.document.getText();
                }
            }
        }
        return override;
    }
};
__decorate([
    inversify_1.inject(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], SketchContribution.prototype, "fileService", void 0);
__decorate([
    inversify_1.inject(protocol_1.FileSystemExt),
    __metadata("design:type", Object)
], SketchContribution.prototype, "fileSystemExt", void 0);
__decorate([
    inversify_1.inject(protocol_1.ConfigService),
    __metadata("design:type", Object)
], SketchContribution.prototype, "configService", void 0);
__decorate([
    inversify_1.inject(protocol_1.SketchesService),
    __metadata("design:type", Object)
], SketchContribution.prototype, "sketchService", void 0);
__decorate([
    inversify_1.inject(opener_service_1.OpenerService),
    __metadata("design:type", Object)
], SketchContribution.prototype, "openerService", void 0);
__decorate([
    inversify_1.inject(sketches_service_client_impl_1.SketchesServiceClientImpl),
    __metadata("design:type", sketches_service_client_impl_1.SketchesServiceClientImpl)
], SketchContribution.prototype, "sketchServiceClient", void 0);
__decorate([
    inversify_1.inject(arduino_preferences_1.ArduinoPreferences),
    __metadata("design:type", Object)
], SketchContribution.prototype, "preferences", void 0);
__decorate([
    inversify_1.inject(editor_manager_1.EditorManager),
    __metadata("design:type", editor_manager_1.EditorManager)
], SketchContribution.prototype, "editorManager", void 0);
__decorate([
    inversify_1.inject(output_channel_1.OutputChannelManager),
    __metadata("design:type", output_channel_1.OutputChannelManager)
], SketchContribution.prototype, "outputChannelManager", void 0);
SketchContribution = __decorate([
    inversify_1.injectable()
], SketchContribution);
exports.SketchContribution = SketchContribution;
(function (Contribution) {
    function configure(bind, serviceIdentifier) {
        bind(serviceIdentifier).toSelf().inSingletonScope();
        bind(command_1.CommandContribution).toService(serviceIdentifier);
        bind(menu_1.MenuContribution).toService(serviceIdentifier);
        bind(keybinding_1.KeybindingContribution).toService(serviceIdentifier);
        bind(tab_bar_toolbar_1.TabBarToolbarContribution).toService(serviceIdentifier);
        bind(frontend_application_1.FrontendApplicationContribution).toService(serviceIdentifier);
    }
    Contribution.configure = configure;
})(Contribution = exports.Contribution || (exports.Contribution = {}));
exports.Contribution = Contribution;
//# sourceMappingURL=contribution.js.map