"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var Close_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Close = void 0;
const inversify_1 = require("inversify");
const algorithm_1 = require("@phosphor/algorithm");
const remote = require("@theia/core/electron-shared/@electron/remote");
const monaco_editor_1 = require("@theia/monaco/lib/browser/monaco-editor");
const editor_manager_1 = require("@theia/editor/lib/browser/editor-manager");
const arduino_menus_1 = require("../menu/arduino-menus");
const save_as_sketch_1 = require("./save-as-sketch");
const contribution_1 = require("./contribution");
const common_1 = require("@theia/core/lib/common");
/**
 * Closes the `current` closeable editor, or any closeable current widget from the main area, or the current sketch window.
 */
let Close = Close_1 = class Close extends contribution_1.SketchContribution {
    onStart(app) {
        this.shell = app.shell;
    }
    registerCommands(registry) {
        registry.registerCommand(Close_1.Commands.CLOSE, {
            execute: async () => {
                // Close current editor if closeable.
                const { currentEditor } = this.editorManager;
                if (currentEditor && currentEditor.title.closable) {
                    currentEditor.close();
                    return;
                }
                // Close current widget from the main area if possible.
                const { currentWidget } = this.shell;
                if (currentWidget) {
                    const currentWidgetInMain = algorithm_1.toArray(this.shell.mainPanel.widgets()).find((widget) => widget === currentWidget);
                    if (currentWidgetInMain && currentWidgetInMain.title.closable) {
                        return currentWidgetInMain.close();
                    }
                }
                // Close the sketch (window).
                const sketch = await this.sketchServiceClient.currentSketch();
                if (!sketch) {
                    return;
                }
                const isTemp = await this.sketchService.isTemp(sketch);
                const uri = await this.sketchServiceClient.currentSketchFile();
                if (!uri) {
                    return;
                }
                if (isTemp && (await this.wasTouched(uri))) {
                    const { response } = await remote.dialog.showMessageBox({
                        type: 'question',
                        buttons: [
                            common_1.nls.localize('vscode/abstractTaskService/saveBeforeRun.dontSave', "Don't Save"),
                            common_1.nls.localize('vscode/issueMainService/cancel', 'Cancel'),
                            common_1.nls.localize('vscode/abstractTaskService/saveBeforeRun.save', 'Save'),
                        ],
                        message: common_1.nls.localize('arduino/common/saveChangesToSketch', 'Do you want to save changes to this sketch before closing?'),
                        detail: common_1.nls.localize('arduino/common/loseChanges', "If you don't save, your changes will be lost."),
                    });
                    if (response === 1) {
                        // Cancel
                        return;
                    }
                    if (response === 2) {
                        // Save
                        const saved = await this.commandService.executeCommand(save_as_sketch_1.SaveAsSketch.Commands.SAVE_AS_SKETCH.id, { openAfterMove: false, execOnlyIfTemp: true });
                        if (!saved) {
                            // If it was not saved, do bail the close.
                            return;
                        }
                    }
                }
                window.close();
            },
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.FILE__SKETCH_GROUP, {
            commandId: Close_1.Commands.CLOSE.id,
            label: common_1.nls.localize('vscode/editor.contribution/close', 'Close'),
            order: '5',
        });
    }
    registerKeybindings(registry) {
        registry.registerKeybinding({
            command: Close_1.Commands.CLOSE.id,
            keybinding: 'CtrlCmd+W',
        });
    }
    /**
     * If the file was ever touched/modified. We get this based on the `version` of the monaco model.
     */
    async wasTouched(uri) {
        var _a;
        const editorWidget = await this.editorManager.getByUri(new contribution_1.URI(uri));
        if (editorWidget) {
            const { editor } = editorWidget;
            if (editor instanceof monaco_editor_1.MonacoEditor) {
                const versionId = (_a = editor.getControl().getModel()) === null || _a === void 0 ? void 0 : _a.getVersionId();
                if (Number.isInteger(versionId) && versionId > 1) {
                    return true;
                }
            }
        }
        return false;
    }
};
__decorate([
    inversify_1.inject(editor_manager_1.EditorManager),
    __metadata("design:type", editor_manager_1.EditorManager)
], Close.prototype, "editorManager", void 0);
Close = Close_1 = __decorate([
    inversify_1.injectable()
], Close);
exports.Close = Close;
(function (Close) {
    let Commands;
    (function (Commands) {
        Commands.CLOSE = {
            id: 'arduino-close',
        };
    })(Commands = Close.Commands || (Close.Commands = {}));
})(Close = exports.Close || (exports.Close = {}));
exports.Close = Close;
//# sourceMappingURL=close.js.map