"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var BurnBootloader_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BurnBootloader = void 0;
const inversify_1 = require("inversify");
const output_channel_1 = require("@theia/output/lib/browser/output-channel");
const protocol_1 = require("../../common/protocol");
const arduino_menus_1 = require("../menu/arduino-menus");
const boards_data_store_1 = require("../boards/boards-data-store");
const serial_connection_manager_1 = require("../serial/serial-connection-manager");
const boards_service_provider_1 = require("../boards/boards-service-provider");
const contribution_1 = require("./contribution");
const common_1 = require("@theia/core/lib/common");
let BurnBootloader = BurnBootloader_1 = class BurnBootloader extends contribution_1.SketchContribution {
    registerCommands(registry) {
        registry.registerCommand(BurnBootloader_1.Commands.BURN_BOOTLOADER, {
            execute: () => this.burnBootloader(),
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.TOOLS__BOARD_SETTINGS_GROUP, {
            commandId: BurnBootloader_1.Commands.BURN_BOOTLOADER.id,
            label: common_1.nls.localize('arduino/bootloader/burnBootloader', 'Burn Bootloader'),
            order: 'z99',
        });
    }
    async burnBootloader() {
        var _a, _b;
        try {
            const { boardsConfig } = this.boardsServiceClientImpl;
            const port = boardsConfig.selectedPort;
            const [fqbn, { selectedProgrammer: programmer }, verify, verbose] = await Promise.all([
                this.boardsDataStore.appendConfigToFqbn((_a = boardsConfig.selectedBoard) === null || _a === void 0 ? void 0 : _a.fqbn),
                this.boardsDataStore.getData((_b = boardsConfig.selectedBoard) === null || _b === void 0 ? void 0 : _b.fqbn),
                this.preferences.get('arduino.upload.verify'),
                this.preferences.get('arduino.upload.verbose'),
            ]);
            this.outputChannelManager.getChannel('Arduino').clear();
            await this.coreService.burnBootloader({
                fqbn,
                programmer,
                port,
                verify,
                verbose,
            });
            this.messageService.info(common_1.nls.localize('arduino/bootloader/doneBurningBootloader', 'Done burning bootloader.'), {
                timeout: 3000,
            });
        }
        catch (e) {
            let errorMessage = "";
            if (typeof e === "string") {
                errorMessage = e;
            }
            else {
                errorMessage = e.toString();
            }
            this.messageService.error(errorMessage);
        }
        finally {
            await this.serialConnection.reconnectAfterUpload();
        }
    }
};
__decorate([
    inversify_1.inject(protocol_1.CoreService),
    __metadata("design:type", Object)
], BurnBootloader.prototype, "coreService", void 0);
__decorate([
    inversify_1.inject(serial_connection_manager_1.SerialConnectionManager),
    __metadata("design:type", serial_connection_manager_1.SerialConnectionManager)
], BurnBootloader.prototype, "serialConnection", void 0);
__decorate([
    inversify_1.inject(boards_data_store_1.BoardsDataStore),
    __metadata("design:type", boards_data_store_1.BoardsDataStore)
], BurnBootloader.prototype, "boardsDataStore", void 0);
__decorate([
    inversify_1.inject(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], BurnBootloader.prototype, "boardsServiceClientImpl", void 0);
__decorate([
    inversify_1.inject(output_channel_1.OutputChannelManager),
    __metadata("design:type", output_channel_1.OutputChannelManager)
], BurnBootloader.prototype, "outputChannelManager", void 0);
BurnBootloader = BurnBootloader_1 = __decorate([
    inversify_1.injectable()
], BurnBootloader);
exports.BurnBootloader = BurnBootloader;
(function (BurnBootloader) {
    let Commands;
    (function (Commands) {
        Commands.BURN_BOOTLOADER = {
            id: 'arduino-burn-bootloader',
        };
    })(Commands = BurnBootloader.Commands || (BurnBootloader.Commands = {}));
})(BurnBootloader = exports.BurnBootloader || (exports.BurnBootloader = {}));
exports.BurnBootloader = BurnBootloader;
//# sourceMappingURL=burn-bootloader.js.map