"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var BoardSelection_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BoardSelection = void 0;
const inversify_1 = require("inversify");
const remote = require("@theia/core/electron-shared/@electron/remote");
const menu_1 = require("@theia/core/lib/common/menu");
const disposable_1 = require("@theia/core/lib/common/disposable");
const utils_1 = require("../../common/utils");
const main_menu_manager_1 = require("../../common/main-menu-manager");
const boards_list_widget_1 = require("../boards/boards-list-widget");
const notification_center_1 = require("../notification-center");
const boards_service_provider_1 = require("../boards/boards-service-provider");
const arduino_menus_1 = require("../menu/arduino-menus");
const protocol_1 = require("../../common/protocol");
const contribution_1 = require("./contribution");
const common_1 = require("@theia/core/lib/common");
let BoardSelection = BoardSelection_1 = class BoardSelection extends contribution_1.SketchContribution {
    constructor() {
        super(...arguments);
        this.toDisposeBeforeMenuRebuild = new disposable_1.DisposableCollection();
    }
    registerCommands(registry) {
        registry.registerCommand(BoardSelection_1.Commands.GET_BOARD_INFO, {
            execute: async () => {
                const { selectedBoard, selectedPort } = this.boardsServiceProvider.boardsConfig;
                if (!selectedBoard) {
                    this.messageService.info(common_1.nls.localize('arduino/board/selectBoardForInfo', 'Please select a board to obtain board info.'));
                    return;
                }
                if (!selectedBoard.fqbn) {
                    this.messageService.info(common_1.nls.localize('arduino/board/platformMissing', "The platform for the selected '{0}' board is not installed.", selectedBoard.name));
                    return;
                }
                if (!selectedPort) {
                    this.messageService.info(common_1.nls.localize('arduino/board/selectPortForInfo', 'Please select a port to obtain board info.'));
                    return;
                }
                const boardDetails = await this.boardsService.getBoardDetails({
                    fqbn: selectedBoard.fqbn,
                });
                if (boardDetails) {
                    const { VID, PID } = boardDetails;
                    const detail = `BN: ${selectedBoard.name}
VID: ${VID}
PID: ${PID}`;
                    await remote.dialog.showMessageBox(remote.getCurrentWindow(), {
                        message: common_1.nls.localize('arduino/board/boardInfo', 'Board Info'),
                        title: common_1.nls.localize('arduino/board/boardInfo', 'Board Info'),
                        type: 'info',
                        detail,
                        buttons: [common_1.nls.localize('vscode/issueMainService/ok', 'OK')],
                    });
                }
            },
        });
    }
    onStart() {
        this.updateMenus();
        this.notificationCenter.onPlatformInstalled(this.updateMenus.bind(this));
        this.notificationCenter.onPlatformUninstalled(this.updateMenus.bind(this));
        this.boardsServiceProvider.onBoardsConfigChanged(this.updateMenus.bind(this));
        this.boardsServiceProvider.onAvailableBoardsChanged(this.updateMenus.bind(this));
        this.boardsServiceProvider.onAvailablePortsChanged(this.updateMenus.bind(this));
    }
    async updateMenus() {
        const [installedBoards, availablePorts, config] = await Promise.all([
            this.installedBoards(),
            this.boardsService.getState(),
            this.boardsServiceProvider.boardsConfig,
        ]);
        this.rebuildMenus(installedBoards, availablePorts, config);
    }
    rebuildMenus(installedBoards, availablePorts, config) {
        var _a, _b;
        this.toDisposeBeforeMenuRebuild.dispose();
        // Boards submenu
        const boardsSubmenuPath = [
            ...arduino_menus_1.ArduinoMenus.TOOLS__BOARD_SELECTION_GROUP,
            '1_boards',
        ];
        const boardsSubmenuLabel = (_a = config.selectedBoard) === null || _a === void 0 ? void 0 : _a.name;
        // Note: The submenu order starts from `100` because `Auto Format`, `Serial Monitor`, etc starts from `0` index.
        // The board specific items, and the rest, have order with `z`. We needed something between `0` and `z` with natural-order.
        this.menuModelRegistry.registerSubmenu(boardsSubmenuPath, common_1.nls.localize('arduino/board/board', 'Board{0}', !!boardsSubmenuLabel ? `: "${boardsSubmenuLabel}"` : ''), { order: '100' });
        this.toDisposeBeforeMenuRebuild.push(disposable_1.Disposable.create(() => arduino_menus_1.unregisterSubmenu(boardsSubmenuPath, this.menuModelRegistry)));
        // Ports submenu
        const portsSubmenuPath = [
            ...arduino_menus_1.ArduinoMenus.TOOLS__BOARD_SELECTION_GROUP,
            '2_ports',
        ];
        const portsSubmenuLabel = (_b = config.selectedPort) === null || _b === void 0 ? void 0 : _b.address;
        this.menuModelRegistry.registerSubmenu(portsSubmenuPath, common_1.nls.localize('arduino/board/port', 'Port{0}', portsSubmenuLabel ? `: "${portsSubmenuLabel}"` : ''), { order: '101' });
        this.toDisposeBeforeMenuRebuild.push(disposable_1.Disposable.create(() => arduino_menus_1.unregisterSubmenu(portsSubmenuPath, this.menuModelRegistry)));
        const getBoardInfo = {
            commandId: BoardSelection_1.Commands.GET_BOARD_INFO.id,
            label: common_1.nls.localize('arduino/board/getBoardInfo', 'Get Board Info'),
            order: '103',
        };
        this.menuModelRegistry.registerMenuAction(arduino_menus_1.ArduinoMenus.TOOLS__BOARD_SELECTION_GROUP, getBoardInfo);
        this.toDisposeBeforeMenuRebuild.push(disposable_1.Disposable.create(() => this.menuModelRegistry.unregisterMenuAction(getBoardInfo)));
        const boardsManagerGroup = [...boardsSubmenuPath, '0_manager'];
        const boardsPackagesGroup = [...boardsSubmenuPath, '1_packages'];
        this.menuModelRegistry.registerMenuAction(boardsManagerGroup, {
            commandId: `${boards_list_widget_1.BoardsListWidget.WIDGET_ID}:toggle`,
            label: `${boards_list_widget_1.BoardsListWidget.WIDGET_LABEL}...`,
        });
        // Installed boards
        for (const board of installedBoards) {
            const { packageId, packageName, fqbn, name, manuallyInstalled } = board;
            const packageLabel = packageName +
                `${manuallyInstalled
                    ? common_1.nls.localize('arduino/board/inSketchbook', ' (in Sketchbook)')
                    : ''}`;
            // Platform submenu
            const platformMenuPath = [...boardsPackagesGroup, packageId];
            // Note: Registering the same submenu twice is a noop. No need to group the boards per platform.
            this.menuModelRegistry.registerSubmenu(platformMenuPath, packageLabel, {
                order: packageName.toLowerCase(),
            });
            const id = `arduino-select-board--${fqbn}`;
            const command = { id };
            const handler = {
                execute: () => {
                    var _a, _b;
                    if (fqbn !== ((_a = this.boardsServiceProvider.boardsConfig.selectedBoard) === null || _a === void 0 ? void 0 : _a.fqbn)) {
                        this.boardsServiceProvider.boardsConfig = {
                            selectedBoard: {
                                name,
                                fqbn,
                                port: (_b = this.boardsServiceProvider.boardsConfig.selectedBoard) === null || _b === void 0 ? void 0 : _b.port,
                            },
                            selectedPort: this.boardsServiceProvider.boardsConfig.selectedPort,
                        };
                    }
                },
                isToggled: () => { var _a; return fqbn === ((_a = this.boardsServiceProvider.boardsConfig.selectedBoard) === null || _a === void 0 ? void 0 : _a.fqbn); },
            };
            // Board menu
            const menuAction = { commandId: id, label: name };
            this.commandRegistry.registerCommand(command, handler);
            this.toDisposeBeforeMenuRebuild.push(disposable_1.Disposable.create(() => this.commandRegistry.unregisterCommand(command)));
            this.menuModelRegistry.registerMenuAction(platformMenuPath, menuAction);
            // Note: we do not dispose the menu actions individually. Calling `unregisterSubmenu` on the parent will wipe the children menu nodes recursively.
        }
        // Installed ports
        const registerPorts = (protocol, protocolOrder, ports) => {
            const portIDs = Object.keys(ports);
            if (!portIDs.length) {
                return;
            }
            // Register placeholder for protocol
            const menuPath = [
                ...portsSubmenuPath,
                `${protocolOrder.toString()}_${protocol}`,
            ];
            const placeholder = new arduino_menus_1.PlaceholderMenuNode(menuPath, `${utils_1.firstToUpperCase(protocol)} ports`, { order: protocolOrder.toString() });
            this.menuModelRegistry.registerMenuNode(menuPath, placeholder);
            this.toDisposeBeforeMenuRebuild.push(disposable_1.Disposable.create(() => this.menuModelRegistry.unregisterMenuNode(placeholder.id)));
            // First we show addresses with recognized boards connected,
            // then all the rest.
            const sortedIDs = Object.keys(ports).sort((left, right) => {
                const [, leftBoards] = ports[left];
                const [, rightBoards] = ports[right];
                return rightBoards.length - leftBoards.length;
            });
            for (let i = 0; i < sortedIDs.length; i++) {
                const portID = sortedIDs[i];
                const [port, boards] = ports[portID];
                let label = `${port.address}`;
                if (boards.length) {
                    const boardsList = boards.map((board) => board.name).join(', ');
                    label = `${label} (${boardsList})`;
                }
                const id = `arduino-select-port--${portID}`;
                const command = { id };
                const handler = {
                    execute: () => {
                        if (!protocol_1.Port.sameAs(port, this.boardsServiceProvider.boardsConfig.selectedPort)) {
                            this.boardsServiceProvider.boardsConfig = {
                                selectedBoard: this.boardsServiceProvider.boardsConfig.selectedBoard,
                                selectedPort: port,
                            };
                        }
                    },
                    isToggled: () => protocol_1.Port.sameAs(port, this.boardsServiceProvider.boardsConfig.selectedPort),
                };
                const menuAction = {
                    commandId: id,
                    label,
                    order: `${protocolOrder + i + 1}`,
                };
                this.commandRegistry.registerCommand(command, handler);
                this.toDisposeBeforeMenuRebuild.push(disposable_1.Disposable.create(() => this.commandRegistry.unregisterCommand(command)));
                this.menuModelRegistry.registerMenuAction(menuPath, menuAction);
            }
        };
        const grouped = protocol_1.AvailablePorts.byProtocol(availablePorts);
        let protocolOrder = 100;
        // We first show serial and network ports, then all the rest
        ['serial', 'network'].forEach((protocol) => {
            const ports = grouped.get(protocol);
            if (ports) {
                registerPorts(protocol, protocolOrder, ports);
                grouped.delete(protocol);
                protocolOrder = protocolOrder + 100;
            }
        });
        grouped.forEach((ports, protocol) => {
            registerPorts(protocol, protocolOrder, ports);
            protocolOrder = protocolOrder + 100;
        });
        this.mainMenuManager.update();
    }
    async installedBoards() {
        const allBoards = await this.boardsService.searchBoards({});
        return allBoards.filter(protocol_1.InstalledBoardWithPackage.is);
    }
};
__decorate([
    inversify_1.inject(contribution_1.CommandRegistry),
    __metadata("design:type", contribution_1.CommandRegistry)
], BoardSelection.prototype, "commandRegistry", void 0);
__decorate([
    inversify_1.inject(main_menu_manager_1.MainMenuManager),
    __metadata("design:type", Object)
], BoardSelection.prototype, "mainMenuManager", void 0);
__decorate([
    inversify_1.inject(menu_1.MenuModelRegistry),
    __metadata("design:type", menu_1.MenuModelRegistry)
], BoardSelection.prototype, "menuModelRegistry", void 0);
__decorate([
    inversify_1.inject(notification_center_1.NotificationCenter),
    __metadata("design:type", notification_center_1.NotificationCenter)
], BoardSelection.prototype, "notificationCenter", void 0);
__decorate([
    inversify_1.inject(protocol_1.BoardsService),
    __metadata("design:type", Object)
], BoardSelection.prototype, "boardsService", void 0);
__decorate([
    inversify_1.inject(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], BoardSelection.prototype, "boardsServiceProvider", void 0);
BoardSelection = BoardSelection_1 = __decorate([
    inversify_1.injectable()
], BoardSelection);
exports.BoardSelection = BoardSelection;
(function (BoardSelection) {
    let Commands;
    (function (Commands) {
        Commands.GET_BOARD_INFO = { id: 'arduino-get-board-info' };
    })(Commands = BoardSelection.Commands || (BoardSelection.Commands = {}));
})(BoardSelection = exports.BoardSelection || (exports.BoardSelection = {}));
exports.BoardSelection = BoardSelection;
//# sourceMappingURL=board-selection.js.map