"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var ArchiveSketch_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArchiveSketch = void 0;
const inversify_1 = require("inversify");
const remote = require("@theia/core/electron-shared/@electron/remote");
const dateFormat = require("dateformat");
const uri_1 = require("@theia/core/lib/common/uri");
const arduino_menus_1 = require("../menu/arduino-menus");
const contribution_1 = require("./contribution");
const common_1 = require("@theia/core/lib/common");
let ArchiveSketch = ArchiveSketch_1 = class ArchiveSketch extends contribution_1.SketchContribution {
    registerCommands(registry) {
        registry.registerCommand(ArchiveSketch_1.Commands.ARCHIVE_SKETCH, {
            execute: () => this.archiveSketch(),
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.TOOLS__MAIN_GROUP, {
            commandId: ArchiveSketch_1.Commands.ARCHIVE_SKETCH.id,
            label: common_1.nls.localize('arduino/sketch/archiveSketch', 'Archive Sketch'),
            order: '1',
        });
    }
    async archiveSketch() {
        const [sketch, config] = await Promise.all([
            this.sketchServiceClient.currentSketch(),
            this.configService.getConfiguration(),
        ]);
        if (!sketch) {
            return;
        }
        const archiveBasename = `${sketch.name}-${dateFormat(new Date(), 'yymmdd')}a.zip`;
        const defaultPath = await this.fileService.fsPath(new uri_1.default(config.sketchDirUri).resolve(archiveBasename));
        const { filePath, canceled } = await remote.dialog.showSaveDialog({
            title: common_1.nls.localize('arduino/sketch/saveSketchAs', 'Save sketch folder as...'),
            defaultPath,
        });
        if (!filePath || canceled) {
            return;
        }
        const destinationUri = await this.fileSystemExt.getUri(filePath);
        if (!destinationUri) {
            return;
        }
        await this.sketchService.archive(sketch, destinationUri.toString());
        this.messageService.info(common_1.nls.localize('arduino/sketch/createdArchive', "Created archive '{0}'.", archiveBasename), {
            timeout: 2000,
        });
    }
};
ArchiveSketch = ArchiveSketch_1 = __decorate([
    inversify_1.injectable()
], ArchiveSketch);
exports.ArchiveSketch = ArchiveSketch;
(function (ArchiveSketch) {
    let Commands;
    (function (Commands) {
        Commands.ARCHIVE_SKETCH = {
            id: 'arduino-archive-sketch',
        };
    })(Commands = ArchiveSketch.Commands || (ArchiveSketch.Commands = {}));
})(ArchiveSketch = exports.ArchiveSketch || (exports.ArchiveSketch = {}));
exports.ArchiveSketch = ArchiveSketch;
//# sourceMappingURL=archive-sketch.js.map