"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var AddZipLibrary_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddZipLibrary = void 0;
const inversify_1 = require("inversify");
const remote = require("@theia/core/electron-shared/@electron/remote");
const uri_1 = require("@theia/core/lib/common/uri");
const dialogs_1 = require("@theia/core/lib/browser/dialogs");
const env_variables_1 = require("@theia/core/lib/common/env-variables");
const arduino_menus_1 = require("../menu/arduino-menus");
const protocol_1 = require("../../common/protocol");
const contribution_1 = require("./contribution");
const common_1 = require("@theia/core/lib/common");
let AddZipLibrary = AddZipLibrary_1 = class AddZipLibrary extends contribution_1.SketchContribution {
    registerCommands(registry) {
        registry.registerCommand(AddZipLibrary_1.Commands.ADD_ZIP_LIBRARY, {
            execute: () => this.addZipLibrary(),
        });
    }
    registerMenus(registry) {
        const includeLibMenuPath = [
            ...arduino_menus_1.ArduinoMenus.SKETCH__UTILS_GROUP,
            '0_include',
        ];
        // TODO: do we need it? calling `registerSubmenu` multiple times is noop, so it does not hurt.
        registry.registerSubmenu(includeLibMenuPath, 'Include Library', {
            order: '1',
        });
        registry.registerMenuAction([...includeLibMenuPath, '1_install'], {
            commandId: AddZipLibrary_1.Commands.ADD_ZIP_LIBRARY.id,
            label: common_1.nls.localize('arduino/library/addZip', 'Add .ZIP Library...'),
            order: '1',
        });
    }
    async addZipLibrary() {
        const homeUri = await this.envVariableServer.getHomeDirUri();
        const defaultPath = await this.fileService.fsPath(new uri_1.default(homeUri));
        const { canceled, filePaths } = await remote.dialog.showOpenDialog({
            title: common_1.nls.localize('arduino/selectZip', "Select a zip file containing the library you'd like to add"),
            defaultPath,
            properties: ['openFile'],
            filters: [
                {
                    name: common_1.nls.localize('arduino/library/zipLibrary', 'Library'),
                    extensions: ['zip'],
                },
            ],
        });
        if (!canceled && filePaths.length) {
            const zipUri = await this.fileSystemExt.getUri(filePaths[0]);
            try {
                await this.doInstall(zipUri);
            }
            catch (error) {
                if (error instanceof AlreadyInstalledError) {
                    const result = await new dialogs_1.ConfirmDialog({
                        msg: error.message,
                        title: common_1.nls.localize('arduino/library/overwriteExistingLibrary', 'Do you want to overwrite the existing library?'),
                        ok: common_1.nls.localize('vscode/extensionsUtils/yes', 'Yes'),
                        cancel: common_1.nls.localize('vscode/extensionsUtils/no', 'No'),
                    }).open();
                    if (result) {
                        await this.doInstall(zipUri, true);
                    }
                }
            }
        }
    }
    async doInstall(zipUri, overwrite) {
        try {
            await protocol_1.Installable.doWithProgress({
                messageService: this.messageService,
                progressText: common_1.nls.localize('arduino/common/processing', 'Processing') +
                    ` ${new uri_1.default(zipUri).path.base}`,
                responseService: this.responseService,
                run: () => this.libraryService.installZip({ zipUri, overwrite }),
            });
            this.messageService.info(common_1.nls.localize('arduino/library/successfullyInstalledZipLibrary', 'Successfully installed library from {0} archive', new uri_1.default(zipUri).path.base), { timeout: 3000 });
        }
        catch (error) {
            if (error instanceof Error) {
                const match = error.message.match(/library (.*?) already installed/);
                if (match && match.length >= 2) {
                    const name = match[1].trim();
                    if (name) {
                        throw new AlreadyInstalledError(common_1.nls.localize('arduino/library/namedLibraryAlreadyExists', 'A library folder named {0} already exists. Do you want to overwrite it?', name), name);
                    }
                    else {
                        throw new AlreadyInstalledError(common_1.nls.localize('arduino/library/libraryAlreadyExists', 'A library already exists. Do you want to overwrite it?'));
                    }
                }
            }
            this.messageService.error(error.toString());
            throw error;
        }
    }
};
__decorate([
    inversify_1.inject(env_variables_1.EnvVariablesServer),
    __metadata("design:type", Object)
], AddZipLibrary.prototype, "envVariableServer", void 0);
__decorate([
    inversify_1.inject(protocol_1.ResponseServiceArduino),
    __metadata("design:type", Object)
], AddZipLibrary.prototype, "responseService", void 0);
__decorate([
    inversify_1.inject(protocol_1.LibraryService),
    __metadata("design:type", Object)
], AddZipLibrary.prototype, "libraryService", void 0);
AddZipLibrary = AddZipLibrary_1 = __decorate([
    inversify_1.injectable()
], AddZipLibrary);
exports.AddZipLibrary = AddZipLibrary;
class AlreadyInstalledError extends Error {
    constructor(message, libraryName) {
        super(message);
        this.libraryName = libraryName;
        Object.setPrototypeOf(this, AlreadyInstalledError.prototype);
    }
}
(function (AddZipLibrary) {
    let Commands;
    (function (Commands) {
        Commands.ADD_ZIP_LIBRARY = {
            id: 'arduino-add-zip-library',
        };
    })(Commands = AddZipLibrary.Commands || (AddZipLibrary.Commands = {}));
})(AddZipLibrary = exports.AddZipLibrary || (exports.AddZipLibrary = {}));
exports.AddZipLibrary = AddZipLibrary;
//# sourceMappingURL=add-zip-library.js.map