"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var About_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.About = void 0;
const inversify_1 = require("inversify");
const moment = require("moment");
const remote = require("@theia/core/electron-shared/@electron/remote");
const os_1 = require("@theia/core/lib/common/os");
const clipboard_service_1 = require("@theia/core/lib/browser/clipboard-service");
const frontend_application_config_provider_1 = require("@theia/core/lib/browser/frontend-application-config-provider");
const contribution_1 = require("./contribution");
const arduino_menus_1 = require("../menu/arduino-menus");
const protocol_1 = require("../../common/protocol");
const common_1 = require("@theia/core/lib/common");
let About = About_1 = class About extends contribution_1.Contribution {
    registerCommands(registry) {
        registry.registerCommand(About_1.Commands.ABOUT_APP, {
            execute: () => this.showAbout(),
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.HELP__ABOUT_GROUP, {
            commandId: About_1.Commands.ABOUT_APP.id,
            label: common_1.nls.localize('arduino/about/label', 'About {0}', this.applicationName),
            order: '0',
        });
    }
    async showAbout() {
        const { version, commit, status: cliStatus, } = await this.configService.getVersion();
        const buildDate = this.buildDate;
        const detail = (showAll) => common_1.nls.localize('arduino/about/detail', 'Version: {0}\nDate: {1}{2}\nCLI Version: {3}{4} [{5}]\n\n{6}', remote.app.getVersion(), buildDate ? buildDate : common_1.nls.localize('', 'dev build'), buildDate && showAll ? ` (${this.ago(buildDate)})` : '', version, cliStatus ? ` ${cliStatus}` : '', commit, common_1.nls.localize('arduino/about/copyright', 'Copyright © {0} Arduino SA', new Date().getFullYear().toString()));
        const ok = common_1.nls.localize('vscode/issueMainService/ok', 'OK');
        const copy = common_1.nls.localize('vscode/textInputActions/copy', 'Copy');
        const buttons = !os_1.isWindows && !os_1.isOSX ? [copy, ok] : [ok, copy];
        const { response } = await remote.dialog.showMessageBox(remote.getCurrentWindow(), {
            message: `${this.applicationName}`,
            title: `${this.applicationName}`,
            type: 'info',
            detail: detail(true),
            buttons,
            noLink: true,
            defaultId: buttons.indexOf(ok),
            cancelId: buttons.indexOf(ok),
        });
        if (buttons[response] === copy) {
            await this.clipboardService.writeText(detail(false).trim());
        }
    }
    get applicationName() {
        return frontend_application_config_provider_1.FrontendApplicationConfigProvider.get().applicationName;
    }
    get buildDate() {
        return frontend_application_config_provider_1.FrontendApplicationConfigProvider.get().buildDate;
    }
    ago(isoTime) {
        const now = moment(Date.now());
        const other = moment(isoTime);
        let result = now.diff(other, 'minute');
        if (result < 60) {
            return result === 1
                ? common_1.nls.localize('vscode/date/date.fromNow.minutes.singular.ago', '{0} minute ago', result.toString())
                : common_1.nls.localize('vscode/date/date.fromNow.minutes.plural.ago', '{0} minutes ago', result.toString());
        }
        result = now.diff(other, 'hour');
        if (result < 25) {
            return result === 1
                ? common_1.nls.localize('vscode/date/date.fromNow.hours.singular.ago', '{0} hour ago', result.toString())
                : common_1.nls.localize('vscode/date/date.fromNow.hours.plural.ago', '{0} hours ago', result.toString());
        }
        result = now.diff(other, 'day');
        if (result < 8) {
            return result === 1
                ? common_1.nls.localize('vscode/date/date.fromNow.days.singular.ago', '{0} day ago', result.toString())
                : common_1.nls.localize('vscode/date/date.fromNow.days.plural.ago', '{0} days ago', result.toString());
        }
        result = now.diff(other, 'week');
        if (result < 5) {
            return result === 1
                ? common_1.nls.localize('vscode/date/date.fromNow.weeks.singular.ago', '{0} week ago', result.toString())
                : common_1.nls.localize('vscode/date/date.fromNow.weeks.plural.ago', '{0} weeks ago', result.toString());
        }
        result = now.diff(other, 'month');
        if (result < 13) {
            return result === 1
                ? common_1.nls.localize('vscode/date/date.fromNow.months.singular.ago', '{0} month ago', result.toString())
                : common_1.nls.localize('vscode/date/date.fromNow.months.plural.ago', '{0} months ago', result.toString());
        }
        result = now.diff(other, 'year');
        return result === 1
            ? common_1.nls.localize('vscode/date/date.fromNow.years.singular.ago', '{0} year ago', result.toString())
            : common_1.nls.localize('vscode/date/date.fromNow.years.plural.ago', '{0} years ago', result.toString());
    }
};
__decorate([
    inversify_1.inject(clipboard_service_1.ClipboardService),
    __metadata("design:type", Object)
], About.prototype, "clipboardService", void 0);
__decorate([
    inversify_1.inject(protocol_1.ConfigService),
    __metadata("design:type", Object)
], About.prototype, "configService", void 0);
About = About_1 = __decorate([
    inversify_1.injectable()
], About);
exports.About = About;
(function (About) {
    let Commands;
    (function (Commands) {
        Commands.ABOUT_APP = {
            id: 'arduino-about',
        };
    })(Commands = About.Commands || (About.Commands = {}));
})(About = exports.About || (exports.About = {}));
exports.About = About;
//# sourceMappingURL=about.js.map