"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
function ProgressBar({ percent = 0, showPercentage = false, }) {
    const roundedPercent = Math.round(percent);
    return (React.createElement("div", { className: "progress-bar" },
        React.createElement("div", { className: "progress-bar--outer" },
            React.createElement("div", { className: "progress-bar--inner", style: { width: `${roundedPercent}%` } })),
        showPercentage && (React.createElement("div", { className: "progress-bar--percentage" },
            React.createElement("div", { className: "progress-bar--percentage-text" },
                roundedPercent,
                "%")))));
}
exports.default = ProgressBar;
//# sourceMappingURL=ProgressBar.js.map