"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var BoardsDataStore_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BoardsDataStore = void 0;
const inversify_1 = require("inversify");
const logger_1 = require("@theia/core/lib/common/logger");
const objects_1 = require("@theia/core/lib/common/objects");
const event_1 = require("@theia/core/lib/common/event");
const browser_1 = require("@theia/core/lib/browser");
const utils_1 = require("../../common/utils");
const protocol_1 = require("../../common/protocol");
const notification_center_1 = require("../notification-center");
let BoardsDataStore = BoardsDataStore_1 = class BoardsDataStore {
    constructor() {
        this.onChangedEmitter = new event_1.Emitter();
    }
    onStart() {
        this.notificationCenter.onPlatformInstalled(async ({ item }) => {
            let shouldFireChanged = false;
            for (const fqbn of item.boards
                .map(({ fqbn }) => fqbn)
                .filter(utils_1.notEmpty)
                .filter((fqbn) => !!fqbn)) {
                const key = this.getStorageKey(fqbn);
                let data = await this.storageService.getData(key);
                if (!data || !data.length) {
                    const details = await this.getBoardDetailsSafe(fqbn);
                    if (details) {
                        data = details.configOptions;
                        if (data.length) {
                            await this.storageService.setData(key, data);
                            shouldFireChanged = true;
                        }
                    }
                }
            }
            if (shouldFireChanged) {
                this.fireChanged();
            }
        });
    }
    get onChanged() {
        return this.onChangedEmitter.event;
    }
    async appendConfigToFqbn(fqbn) {
        if (!fqbn) {
            return undefined;
        }
        const { configOptions } = await this.getData(fqbn);
        return protocol_1.ConfigOption.decorate(fqbn, configOptions);
    }
    async getData(fqbn) {
        if (!fqbn) {
            return BoardsDataStore_1.Data.EMPTY;
        }
        const key = this.getStorageKey(fqbn);
        let data = await this.storageService.getData(key, undefined);
        if (BoardsDataStore_1.Data.is(data)) {
            return data;
        }
        const boardDetails = await this.getBoardDetailsSafe(fqbn);
        if (!boardDetails) {
            return BoardsDataStore_1.Data.EMPTY;
        }
        data = {
            configOptions: boardDetails.configOptions,
            programmers: boardDetails.programmers,
        };
        await this.storageService.setData(key, data);
        return data;
    }
    async selectProgrammer({ fqbn, selectedProgrammer, }) {
        const data = objects_1.deepClone(await this.getData(fqbn));
        const { programmers } = data;
        if (!programmers.find((p) => protocol_1.Programmer.equals(selectedProgrammer, p))) {
            return false;
        }
        await this.setData({
            fqbn,
            data: Object.assign(Object.assign({}, data), { selectedProgrammer }),
        });
        this.fireChanged();
        return true;
    }
    async selectConfigOption({ fqbn, option, selectedValue, }) {
        const data = objects_1.deepClone(await this.getData(fqbn));
        const { configOptions } = data;
        const configOption = configOptions.find((c) => c.option === option);
        if (!configOption) {
            return false;
        }
        let updated = false;
        for (const value of configOption.values) {
            if (value.value === selectedValue) {
                value.selected = true;
                updated = true;
            }
            else {
                value.selected = false;
            }
        }
        if (!updated) {
            return false;
        }
        await this.setData({ fqbn, data });
        this.fireChanged();
        return true;
    }
    async setData({ fqbn, data, }) {
        const key = this.getStorageKey(fqbn);
        return this.storageService.setData(key, data);
    }
    getStorageKey(fqbn) {
        return `.arduinoIDE-configOptions-${fqbn}`;
    }
    async getBoardDetailsSafe(fqbn) {
        try {
            const details = this.boardsService.getBoardDetails({ fqbn });
            return details;
        }
        catch (err) {
            if (err instanceof Error &&
                err.message.includes('loading board data') &&
                err.message.includes('is not installed')) {
                this.logger.warn(`The boards package is not installed for board with FQBN: ${fqbn}`);
            }
            else {
                this.logger.error(`An unexpected error occurred while retrieving the board details for ${fqbn}.`, err);
            }
            return undefined;
        }
    }
    fireChanged() {
        this.onChangedEmitter.fire();
    }
};
__decorate([
    inversify_1.inject(logger_1.ILogger),
    inversify_1.named('store'),
    __metadata("design:type", Object)
], BoardsDataStore.prototype, "logger", void 0);
__decorate([
    inversify_1.inject(protocol_1.BoardsService),
    __metadata("design:type", Object)
], BoardsDataStore.prototype, "boardsService", void 0);
__decorate([
    inversify_1.inject(notification_center_1.NotificationCenter),
    __metadata("design:type", notification_center_1.NotificationCenter)
], BoardsDataStore.prototype, "notificationCenter", void 0);
__decorate([
    inversify_1.inject(browser_1.LocalStorageService),
    __metadata("design:type", browser_1.LocalStorageService)
], BoardsDataStore.prototype, "storageService", void 0);
BoardsDataStore = BoardsDataStore_1 = __decorate([
    inversify_1.injectable()
], BoardsDataStore);
exports.BoardsDataStore = BoardsDataStore;
(function (BoardsDataStore) {
    let Data;
    (function (Data) {
        Data.EMPTY = {
            configOptions: [],
            programmers: [],
        };
        function is(arg) {
            return (!!arg &&
                'configOptions' in arg &&
                Array.isArray(arg['configOptions']) &&
                'programmers' in arg &&
                Array.isArray(arg['programmers']));
        }
        Data.is = is;
    })(Data = BoardsDataStore.Data || (BoardsDataStore.Data = {}));
})(BoardsDataStore = exports.BoardsDataStore || (exports.BoardsDataStore = {}));
exports.BoardsDataStore = BoardsDataStore;
//# sourceMappingURL=boards-data-store.js.map