"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BoardsDataMenuUpdater = void 0;
const PQueue = require("p-queue");
const inversify_1 = require("inversify");
const command_1 = require("@theia/core/lib/common/command");
const menu_1 = require("@theia/core/lib/common/menu");
const disposable_1 = require("@theia/core/lib/common/disposable");
const boards_service_provider_1 = require("./boards-service-provider");
const protocol_1 = require("../../common/protocol");
const boards_data_store_1 = require("./boards-data-store");
const main_menu_manager_1 = require("../../common/main-menu-manager");
const arduino_menus_1 = require("../menu/arduino-menus");
const common_1 = require("@theia/core/lib/common");
let BoardsDataMenuUpdater = class BoardsDataMenuUpdater {
    constructor() {
        this.queue = new PQueue({ autoStart: true, concurrency: 1 });
        this.toDisposeOnBoardChange = new disposable_1.DisposableCollection();
    }
    async onStart() {
        this.updateMenuActions(this.boardsServiceClient.boardsConfig.selectedBoard);
        this.boardsDataStore.onChanged(() => this.updateMenuActions(this.boardsServiceClient.boardsConfig.selectedBoard));
        this.boardsServiceClient.onBoardsConfigChanged(({ selectedBoard }) => this.updateMenuActions(selectedBoard));
    }
    async updateMenuActions(selectedBoard) {
        return this.queue.add(async () => {
            this.toDisposeOnBoardChange.dispose();
            this.mainMenuManager.update();
            if (selectedBoard) {
                const { fqbn } = selectedBoard;
                if (fqbn) {
                    const { configOptions, programmers, selectedProgrammer } = await this.boardsDataStore.getData(fqbn);
                    if (configOptions.length) {
                        const boardsConfigMenuPath = [
                            ...arduino_menus_1.ArduinoMenus.TOOLS__BOARD_SETTINGS_GROUP,
                            'z01_boardsConfig',
                        ]; // `z_` is for ordering.
                        for (const { label, option, values } of configOptions.sort(protocol_1.ConfigOption.LABEL_COMPARATOR)) {
                            const menuPath = [...boardsConfigMenuPath, `${option}`];
                            const commands = new Map();
                            for (const value of values) {
                                const id = `${fqbn}-${option}--${value.value}`;
                                const command = { id };
                                const selectedValue = value.value;
                                const handler = {
                                    execute: () => this.boardsDataStore.selectConfigOption({
                                        fqbn,
                                        option,
                                        selectedValue,
                                    }),
                                    isToggled: () => value.selected,
                                };
                                commands.set(id, Object.assign(this.commandRegistry.registerCommand(command, handler), { label: value.label }));
                            }
                            this.menuRegistry.registerSubmenu(menuPath, label);
                            this.toDisposeOnBoardChange.pushAll([
                                ...commands.values(),
                                disposable_1.Disposable.create(() => arduino_menus_1.unregisterSubmenu(menuPath, this.menuRegistry)),
                                ...Array.from(commands.keys()).map((commandId, i) => {
                                    const { label } = commands.get(commandId);
                                    this.menuRegistry.registerMenuAction(menuPath, {
                                        commandId,
                                        order: `${i}`,
                                        label,
                                    });
                                    return disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuAction(commandId));
                                }),
                            ]);
                        }
                    }
                    if (programmers.length) {
                        const programmersMenuPath = [
                            ...arduino_menus_1.ArduinoMenus.TOOLS__BOARD_SETTINGS_GROUP,
                            'z02_programmers',
                        ];
                        const programmerNls = common_1.nls.localize('arduino/board/programmer', 'Programmer');
                        const label = selectedProgrammer
                            ? `${programmerNls}: "${selectedProgrammer.name}"`
                            : programmerNls;
                        this.menuRegistry.registerSubmenu(programmersMenuPath, label);
                        this.toDisposeOnBoardChange.push(disposable_1.Disposable.create(() => arduino_menus_1.unregisterSubmenu(programmersMenuPath, this.menuRegistry)));
                        for (const programmer of programmers) {
                            const { id, name } = programmer;
                            const command = { id: `${fqbn}-programmer--${id}` };
                            const handler = {
                                execute: () => this.boardsDataStore.selectProgrammer({
                                    fqbn,
                                    selectedProgrammer: programmer,
                                }),
                                isToggled: () => protocol_1.Programmer.equals(programmer, selectedProgrammer),
                            };
                            this.menuRegistry.registerMenuAction(programmersMenuPath, {
                                commandId: command.id,
                                label: name,
                            });
                            this.commandRegistry.registerCommand(command, handler);
                            this.toDisposeOnBoardChange.pushAll([
                                disposable_1.Disposable.create(() => this.commandRegistry.unregisterCommand(command)),
                                disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuAction(command.id)),
                            ]);
                        }
                    }
                    this.mainMenuManager.update();
                }
            }
        });
    }
};
__decorate([
    inversify_1.inject(command_1.CommandRegistry),
    __metadata("design:type", command_1.CommandRegistry)
], BoardsDataMenuUpdater.prototype, "commandRegistry", void 0);
__decorate([
    inversify_1.inject(menu_1.MenuModelRegistry),
    __metadata("design:type", menu_1.MenuModelRegistry)
], BoardsDataMenuUpdater.prototype, "menuRegistry", void 0);
__decorate([
    inversify_1.inject(main_menu_manager_1.MainMenuManager),
    __metadata("design:type", Object)
], BoardsDataMenuUpdater.prototype, "mainMenuManager", void 0);
__decorate([
    inversify_1.inject(boards_data_store_1.BoardsDataStore),
    __metadata("design:type", boards_data_store_1.BoardsDataStore)
], BoardsDataMenuUpdater.prototype, "boardsDataStore", void 0);
__decorate([
    inversify_1.inject(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], BoardsDataMenuUpdater.prototype, "boardsServiceClient", void 0);
BoardsDataMenuUpdater = __decorate([
    inversify_1.injectable()
], BoardsDataMenuUpdater);
exports.BoardsDataMenuUpdater = BoardsDataMenuUpdater;
//# sourceMappingURL=boards-data-menu-updater.js.map