"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BoardsConfigDialog = exports.BoardsConfigDialogProps = void 0;
const inversify_1 = require("inversify");
const browser_1 = require("@theia/core/lib/browser");
const dialogs_1 = require("../theia/dialogs/dialogs");
const boards_service_1 = require("../../common/protocol/boards-service");
const boards_service_provider_1 = require("./boards-service-provider");
const boards_config_dialog_widget_1 = require("./boards-config-dialog-widget");
const common_1 = require("@theia/core/lib/common");
let BoardsConfigDialogProps = class BoardsConfigDialogProps extends browser_1.DialogProps {
};
BoardsConfigDialogProps = __decorate([
    inversify_1.injectable()
], BoardsConfigDialogProps);
exports.BoardsConfigDialogProps = BoardsConfigDialogProps;
let BoardsConfigDialog = class BoardsConfigDialog extends dialogs_1.AbstractDialog {
    constructor(props) {
        super(props);
        this.props = props;
        this.config = {};
        this.contentNode.classList.add('select-board-dialog');
        this.contentNode.appendChild(this.createDescription());
        this.appendCloseButton(common_1.nls.localize('vscode/issueMainService/cancel', 'Cancel'));
        this.appendAcceptButton(common_1.nls.localize('vscode/issueMainService/ok', 'OK'));
    }
    init() {
        this.toDispose.push(this.boardsServiceClient.onBoardsConfigChanged((config) => {
            this.config = config;
            this.update();
        }));
    }
    /**
     * Pass in an empty string if you want to reset the search term. Using `undefined` has no effect.
     */
    async open(query = undefined) {
        if (typeof query === 'string') {
            this.widget.search(query);
        }
        return super.open();
    }
    createDescription() {
        const head = document.createElement('div');
        head.classList.add('head');
        const title = document.createElement('div');
        title.textContent = common_1.nls.localize('arduino/board/configDialogTitle', 'Select Other Board & Port');
        title.classList.add('title');
        head.appendChild(title);
        const text = document.createElement('div');
        text.classList.add('text');
        head.appendChild(text);
        for (const paragraph of [
            common_1.nls.localize('arduino/board/configDialog1', 'Select both a Board and a Port if you want to upload a sketch.'),
            common_1.nls.localize('arduino/board/configDialog2', 'If you only select a Board you will be able to compile, but not to upload your sketch.'),
        ]) {
            const p = document.createElement('div');
            p.textContent = paragraph;
            text.appendChild(p);
        }
        return head;
    }
    onAfterAttach(msg) {
        if (this.widget.isAttached) {
            browser_1.Widget.detach(this.widget);
        }
        browser_1.Widget.attach(this.widget, this.contentNode);
        this.toDisposeOnDetach.push(this.widget.onBoardConfigChanged((config) => {
            this.config = config;
            this.update();
        }));
        super.onAfterAttach(msg);
        this.update();
    }
    onUpdateRequest(msg) {
        super.onUpdateRequest(msg);
        this.widget.update();
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        this.widget.activate();
    }
    handleEnter(event) {
        if (event.target instanceof HTMLTextAreaElement) {
            return false;
        }
    }
    isValid(value) {
        if (!value.selectedBoard) {
            if (value.selectedPort) {
                return common_1.nls.localize('arduino/board/pleasePickBoard', 'Please pick a board connected to the port you have selected.');
            }
            return false;
        }
        return '';
    }
    get value() {
        return this.config;
    }
};
__decorate([
    inversify_1.inject(boards_config_dialog_widget_1.BoardsConfigDialogWidget),
    __metadata("design:type", boards_config_dialog_widget_1.BoardsConfigDialogWidget)
], BoardsConfigDialog.prototype, "widget", void 0);
__decorate([
    inversify_1.inject(boards_service_1.BoardsService),
    __metadata("design:type", Object)
], BoardsConfigDialog.prototype, "boardService", void 0);
__decorate([
    inversify_1.inject(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], BoardsConfigDialog.prototype, "boardsServiceClient", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], BoardsConfigDialog.prototype, "init", null);
BoardsConfigDialog = __decorate([
    inversify_1.injectable(),
    __param(0, inversify_1.inject(BoardsConfigDialogProps)),
    __metadata("design:paramtypes", [BoardsConfigDialogProps])
], BoardsConfigDialog);
exports.BoardsConfigDialog = BoardsConfigDialog;
//# sourceMappingURL=boards-config-dialog.js.map