"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BoardsConfigDialogWidget = void 0;
const React = require("react");
const inversify_1 = require("inversify");
const event_1 = require("@theia/core/lib/common/event");
const browser_1 = require("@theia/core/lib/browser");
const boards_service_1 = require("../../common/protocol/boards-service");
const boards_config_1 = require("./boards-config");
const boards_service_provider_1 = require("./boards-service-provider");
const notification_center_1 = require("../notification-center");
let BoardsConfigDialogWidget = class BoardsConfigDialogWidget extends browser_1.ReactWidget {
    constructor() {
        super();
        this.onFilterTextDidChangeEmitter = new event_1.Emitter();
        this.onBoardConfigChangedEmitter = new event_1.Emitter();
        this.onBoardConfigChanged = this.onBoardConfigChangedEmitter.event;
        this.fireConfigChanged = (config) => {
            this.onBoardConfigChangedEmitter.fire(config);
        };
        this.setFocusNode = (element) => {
            this.focusNode = element;
        };
        this.id = 'select-board-dialog';
        this.toDispose.pushAll([
            this.onBoardConfigChangedEmitter,
            this.onFilterTextDidChangeEmitter,
        ]);
    }
    search(query) {
        this.onFilterTextDidChangeEmitter.fire(query);
    }
    render() {
        return (React.createElement("div", { className: "selectBoardContainer" },
            React.createElement(boards_config_1.BoardsConfig, { boardsServiceProvider: this.boardsServiceClient, notificationCenter: this.notificationCenter, onConfigChange: this.fireConfigChanged, onFocusNodeSet: this.setFocusNode, onFilteredTextDidChangeEvent: this.onFilterTextDidChangeEmitter.event })));
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        if (this.focusNode instanceof HTMLInputElement) {
            this.focusNode.select();
        }
        (this.focusNode || this.node).focus();
    }
};
__decorate([
    inversify_1.inject(boards_service_1.BoardsService),
    __metadata("design:type", Object)
], BoardsConfigDialogWidget.prototype, "boardsService", void 0);
__decorate([
    inversify_1.inject(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], BoardsConfigDialogWidget.prototype, "boardsServiceClient", void 0);
__decorate([
    inversify_1.inject(notification_center_1.NotificationCenter),
    __metadata("design:type", notification_center_1.NotificationCenter)
], BoardsConfigDialogWidget.prototype, "notificationCenter", void 0);
BoardsConfigDialogWidget = __decorate([
    inversify_1.injectable(),
    __metadata("design:paramtypes", [])
], BoardsConfigDialogWidget);
exports.BoardsConfigDialogWidget = BoardsConfigDialogWidget;
//# sourceMappingURL=boards-config-dialog-widget.js.map