"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BoardsAutoInstaller = void 0;
const inversify_1 = require("inversify");
const message_service_1 = require("@theia/core/lib/common/message-service");
const boards_service_1 = require("../../common/protocol/boards-service");
const boards_service_provider_1 = require("./boards-service-provider");
const protocol_1 = require("../../common/protocol");
const boards_widget_frontend_contribution_1 = require("./boards-widget-frontend-contribution");
const common_1 = require("@theia/core/lib/common");
/**
 * Listens on `BoardsConfig.Config` changes, if a board is selected which does not
 * have the corresponding core installed, it proposes the user to install the core.
 */
let BoardsAutoInstaller = class BoardsAutoInstaller {
    constructor() {
        // Workaround for https://github.com/eclipse-theia/theia/issues/9349
        this.notifications = [];
    }
    onStart() {
        this.boardsServiceClient.onBoardsConfigChanged(this.ensureCoreExists.bind(this));
        this.ensureCoreExists(this.boardsServiceClient.boardsConfig);
    }
    ensureCoreExists(config) {
        const { selectedBoard, selectedPort } = config;
        if (selectedBoard &&
            selectedPort &&
            !this.notifications.find((board) => boards_service_1.Board.sameAs(board, selectedBoard))) {
            this.notifications.push(selectedBoard);
            this.boardsService.search({}).then((packages) => {
                // filter packagesForBoard selecting matches from the cli (installed packages)
                // and matches based on the board name
                // NOTE: this ensures the Deprecated & new packages are all in the array
                // so that we can check if any of the valid packages is already installed
                const packagesForBoard = packages.filter((pkg) => boards_service_1.BoardsPackage.contains(selectedBoard, pkg) ||
                    pkg.boards.some((board) => board.name === selectedBoard.name));
                // check if one of the packages for the board is already installed. if so, no hint
                if (packagesForBoard.some(({ installedVersion }) => !!installedVersion)) {
                    return;
                }
                // filter the installable (not installed) packages,
                // CLI returns the packages already sorted with the deprecated ones at the end of the list
                // in order to ensure the new ones are preferred
                const candidates = packagesForBoard.filter(({ installable, installedVersion }) => installable && !installedVersion);
                const candidate = candidates[0];
                if (candidate) {
                    const version = candidate.availableVersions[0]
                        ? `[v ${candidate.availableVersions[0]}]`
                        : '';
                    const yes = common_1.nls.localize('vscode/extensionsUtils/yes', 'Yes');
                    const manualInstall = common_1.nls.localize('arduino/board/installManually', 'Install Manually');
                    // tslint:disable-next-line:max-line-length
                    this.messageService
                        .info(common_1.nls.localize('arduino/board/installNow', 'The "{0} {1}" core has to be installed for the currently selected "{2}" board. Do you want to install it now?', candidate.name, version, selectedBoard.name), manualInstall, yes)
                        .then(async (answer) => {
                        const index = this.notifications.findIndex((board) => boards_service_1.Board.sameAs(board, selectedBoard));
                        if (index !== -1) {
                            this.notifications.splice(index, 1);
                        }
                        if (answer === yes) {
                            await protocol_1.Installable.installWithProgress({
                                installable: this.boardsService,
                                item: candidate,
                                messageService: this.messageService,
                                responseService: this.responseService,
                                version: candidate.availableVersions[0],
                            });
                            return;
                        }
                        if (answer === manualInstall) {
                            this.boardsManagerFrontendContribution
                                .openView({ reveal: true })
                                .then((widget) => widget.refresh(candidate.name.toLocaleLowerCase()));
                        }
                    });
                }
            });
        }
    }
};
__decorate([
    inversify_1.inject(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], BoardsAutoInstaller.prototype, "messageService", void 0);
__decorate([
    inversify_1.inject(boards_service_1.BoardsService),
    __metadata("design:type", Object)
], BoardsAutoInstaller.prototype, "boardsService", void 0);
__decorate([
    inversify_1.inject(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], BoardsAutoInstaller.prototype, "boardsServiceClient", void 0);
__decorate([
    inversify_1.inject(protocol_1.ResponseServiceArduino),
    __metadata("design:type", Object)
], BoardsAutoInstaller.prototype, "responseService", void 0);
__decorate([
    inversify_1.inject(boards_widget_frontend_contribution_1.BoardsListWidgetFrontendContribution),
    __metadata("design:type", boards_widget_frontend_contribution_1.BoardsListWidgetFrontendContribution)
], BoardsAutoInstaller.prototype, "boardsManagerFrontendContribution", void 0);
BoardsAutoInstaller = __decorate([
    inversify_1.injectable()
], BoardsAutoInstaller);
exports.BoardsAutoInstaller = BoardsAutoInstaller;
//# sourceMappingURL=boards-auto-installer.js.map