"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArduinoWorkspaceRootResolver = void 0;
const vscode_uri_1 = require("@theia/core/shared/vscode-uri");
const os_1 = require("@theia/core/lib/common/os");
const objects_1 = require("@theia/core/lib/common/objects");
class ArduinoWorkspaceRootResolver {
    constructor(options) {
        this.options = options;
    }
    async resolve(options) {
        const { hash, recentWorkspaces, recentSketches } = options;
        for (const uri of [
            this.hashToUri(hash),
            ...recentWorkspaces,
            ...recentSketches,
        ].filter(objects_1.notEmpty)) {
            const valid = await this.isValid(uri);
            if (valid) {
                return { uri };
            }
        }
        return undefined;
    }
    isValid(uri) {
        return this.options.isValid(uri);
    }
    // Note: here, the `hash` was defined as new `URI(yourValidFsPath).path` so we have to map it to a valid FS path first.
    // This is important for Windows only and a NOOP on POSIX.
    // Note: we set the `new URI(myValidUri).path.toString()` as the `hash`. See:
    // - https://github.com/eclipse-theia/theia/blob/8196e9dcf9c8de8ea0910efeb5334a974f426966/packages/workspace/src/browser/workspace-service.ts#L143 and
    // - https://github.com/eclipse-theia/theia/blob/8196e9dcf9c8de8ea0910efeb5334a974f426966/packages/workspace/src/browser/workspace-service.ts#L423
    hashToUri(hash) {
        if (hash && hash.length > 1 && hash.startsWith('#')) {
            const path = decodeURI(hash.slice(1)).replace(/\\/g, '/'); // Trim the leading `#`, decode the URI and replace Windows separators
            return vscode_uri_1.URI.file(path.slice(os_1.isWindows && hash.startsWith('/') ? 1 : 0)).toString();
        }
        return undefined;
    }
}
exports.ArduinoWorkspaceRootResolver = ArduinoWorkspaceRootResolver;
//# sourceMappingURL=arduino-workspace-resolver.js.map