"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArduinoFrontendContribution = exports.SKIP_IDE_VERSION = void 0;
const inversify_1 = require("inversify");
const React = require("react");
const remote = require("@theia/core/electron-shared/@electron/remote");
const protocol_1 = require("../common/protocol");
const async_mutex_1 = require("async-mutex");
const core_1 = require("@theia/core");
const browser_1 = require("@theia/core/lib/browser");
const common_1 = require("@theia/core/lib/common");
const common_frontend_contribution_1 = require("@theia/core/lib/browser/common-frontend-contribution");
const command_1 = require("@theia/core/lib/common/command");
const message_service_1 = require("@theia/core/lib/common/message-service");
const uri_1 = require("@theia/core/lib/common/uri");
const browser_2 = require("@theia/editor/lib/browser");
const problem_contribution_1 = require("@theia/markers/lib/browser/problem/problem-contribution");
const monaco_menu_1 = require("@theia/monaco/lib/browser/monaco-menu");
const navigator_contribution_1 = require("@theia/navigator/lib/browser/navigator-contribution");
const outline_view_contribution_1 = require("@theia/outline-view/lib/browser/outline-view-contribution");
const output_contribution_1 = require("@theia/output/lib/browser/output-contribution");
const scm_contribution_1 = require("@theia/scm/lib/browser/scm-contribution");
const search_in_workspace_frontend_contribution_1 = require("@theia/search-in-workspace/lib/browser/search-in-workspace-frontend-contribution");
const terminal_frontend_contribution_1 = require("@theia/terminal/lib/browser/terminal-frontend-contribution");
const hosted_plugin_1 = require("@theia/plugin-ext/lib/hosted/browser/hosted-plugin");
const file_service_1 = require("@theia/filesystem/lib/browser/file-service");
const config_service_1 = require("../common/protocol/config-service");
const arduino_commands_1 = require("./arduino-commands");
const boards_config_dialog_1 = require("./boards/boards-config-dialog");
const boards_service_provider_1 = require("./boards/boards-service-provider");
const boards_toolbar_item_1 = require("./boards/boards-toolbar-item");
const editor_mode_1 = require("./editor-mode");
const arduino_menus_1 = require("./menu/arduino-menus");
const monitor_view_contribution_1 = require("./serial/monitor/monitor-view-contribution");
const arduino_toolbar_1 = require("./toolbar/arduino-toolbar");
const arduino_preferences_1 = require("./arduino-preferences");
const sketches_service_client_impl_1 = require("../common/protocol/sketches-service-client-impl");
const save_as_sketch_1 = require("./contributions/save-as-sketch");
const sketchbook_widget_contribution_1 = require("./widgets/sketchbook/sketchbook-widget-contribution");
const ide_updater_dialog_1 = require("./dialogs/ide-updater/ide-updater-dialog");
const ide_updater_1 = require("../common/protocol/ide-updater");
const INIT_LIBS_AND_PACKAGES = 'initializedLibsAndPackages';
exports.SKIP_IDE_VERSION = 'skipIDEVersion';
let ArduinoFrontendContribution = class ArduinoFrontendContribution {
    constructor() {
        this.toDisposeOnStop = new core_1.DisposableCollection();
        this.languageServerStartMutex = new async_mutex_1.Mutex();
    }
    async init() {
        const isFirstStartup = !(await this.localStorageService.getData(INIT_LIBS_AND_PACKAGES));
        if (isFirstStartup) {
            await this.localStorageService.setData(INIT_LIBS_AND_PACKAGES, true);
            const avrPackage = await this.boardsService.getBoardPackage({
                id: 'arduino:avr',
            });
            const builtInLibrary = (await this.libraryService.search({
                query: 'Arduino_BuiltIn',
            }))[0];
            !!avrPackage && (await this.boardsService.install({ item: avrPackage }));
            !!builtInLibrary &&
                (await this.libraryService.install({
                    item: builtInLibrary,
                    installDependencies: true,
                }));
        }
        if (!window.navigator.onLine) {
            // tslint:disable-next-line:max-line-length
            this.messageService.warn(common_1.nls.localize('arduino/common/offlineIndicator', 'You appear to be offline. Without an Internet connection, the Arduino CLI might not be able to download the required resources and could cause malfunction. Please connect to the Internet and restart the application.'));
        }
        const updateStatusBar = ({ selectedBoard, selectedPort, }) => {
            this.statusBar.setElement('arduino-selected-board', {
                alignment: browser_1.StatusBarAlignment.RIGHT,
                text: selectedBoard
                    ? `$(microchip) ${selectedBoard.name}`
                    : `$(close) ${common_1.nls.localize('arduino/common/noBoardSelected', 'No board selected')}`,
                className: 'arduino-selected-board',
            });
            if (selectedBoard) {
                this.statusBar.setElement('arduino-selected-port', {
                    alignment: browser_1.StatusBarAlignment.RIGHT,
                    text: selectedPort
                        ? common_1.nls.localize('arduino/common/selectedOn', 'on {0}', selectedPort.address)
                        : common_1.nls.localize('arduino/common/notConnected', '[not connected]'),
                    className: 'arduino-selected-port',
                });
            }
        };
        this.boardsServiceClientImpl.onBoardsConfigChanged(updateStatusBar);
        updateStatusBar(this.boardsServiceClientImpl.boardsConfig);
        this.appStateService.reachedState('ready').then(async () => {
            const sketch = await this.sketchServiceClient.currentSketch();
            if (sketch && !(await this.sketchService.isTemp(sketch))) {
                this.toDisposeOnStop.push(this.fileService.watch(new uri_1.default(sketch.uri)));
                this.toDisposeOnStop.push(this.fileService.onDidFilesChange(async (event) => {
                    for (const { type, resource } of event.changes) {
                        if (type === 1 /* ADDED */ &&
                            resource.parent.toString() === sketch.uri) {
                            const reloadedSketch = await this.sketchService.loadSketch(sketch.uri);
                            if (protocol_1.Sketch.isInSketch(resource, reloadedSketch)) {
                                this.ensureOpened(resource.toString(), true, {
                                    mode: 'open',
                                });
                            }
                        }
                    }
                }));
            }
        });
    }
    async onStart(app) {
        // Initialize all `pro-mode` widgets. This is a NOOP if in normal mode.
        for (const viewContribution of [
            this.fileNavigatorContributions,
            this.outputContribution,
            this.outlineContribution,
            this.problemContribution,
            this.scmContribution,
            this.siwContribution,
            this.sketchbookWidgetContribution,
        ]) {
            if (viewContribution.initializeLayout) {
                viewContribution.initializeLayout(app);
            }
        }
        this.updater
            .init(this.arduinoPreferences.get('arduino.ide.updateChannel'), this.arduinoPreferences.get('arduino.ide.updateBaseUrl'))
            .then(() => this.updater.checkForUpdates(true))
            .then(async (updateInfo) => {
            if (!updateInfo)
                return;
            const versionToSkip = await this.localStorageService.getData(exports.SKIP_IDE_VERSION);
            if (versionToSkip === updateInfo.version)
                return;
            this.updaterDialog.open(updateInfo);
        })
            .catch((e) => {
            this.messageService.error(common_1.nls.localize('arduino/ide-updater/errorCheckingForUpdates', 'Error while checking for Arduino IDE updates.\n{0}', e.message));
        });
        const start = async ({ selectedBoard }) => {
            if (selectedBoard) {
                const { name, fqbn } = selectedBoard;
                if (fqbn) {
                    this.startLanguageServer(fqbn, name);
                }
            }
        };
        this.boardsServiceClientImpl.onBoardsConfigChanged(start);
        this.arduinoPreferences.onPreferenceChanged((event) => {
            if (event.newValue !== event.oldValue) {
                switch (event.preferenceName) {
                    case 'arduino.language.log':
                        start(this.boardsServiceClientImpl.boardsConfig);
                        break;
                    case 'arduino.window.zoomLevel':
                        if (typeof event.newValue === 'number') {
                            const webContents = remote.getCurrentWebContents();
                            webContents.setZoomLevel(event.newValue || 0);
                        }
                        break;
                    case 'arduino.ide.updateChannel':
                    case 'arduino.ide.updateBaseUrl':
                        this.updater.init(this.arduinoPreferences.get('arduino.ide.updateChannel'), this.arduinoPreferences.get('arduino.ide.updateBaseUrl'));
                        break;
                }
            }
        });
        this.arduinoPreferences.ready.then(() => {
            const webContents = remote.getCurrentWebContents();
            const zoomLevel = this.arduinoPreferences.get('arduino.window.zoomLevel');
            webContents.setZoomLevel(zoomLevel);
        });
        app.shell.leftPanelHandler.removeBottomMenu('settings-menu');
    }
    onStop() {
        this.toDisposeOnStop.dispose();
    }
    async startLanguageServer(fqbn, name) {
        const release = await this.languageServerStartMutex.acquire();
        try {
            await this.hostedPluginSupport.didStart;
            const details = await this.boardsService.getBoardDetails({ fqbn });
            if (!details) {
                // Core is not installed for the selected board.
                console.info(`Could not start language server for ${fqbn}. The core is not installed for the board.`);
                if (this.languageServerFqbn) {
                    try {
                        await this.commandRegistry.executeCommand('arduino.languageserver.stop');
                        console.info(`Stopped language server process for ${this.languageServerFqbn}.`);
                        this.languageServerFqbn = undefined;
                    }
                    catch (e) {
                        console.error(`Failed to start language server process for ${this.languageServerFqbn}`, e);
                        throw e;
                    }
                }
                return;
            }
            if (fqbn === this.languageServerFqbn) {
                // NOOP
                return;
            }
            this.logger.info(`Starting language server: ${fqbn}`);
            const log = this.arduinoPreferences.get('arduino.language.log');
            let currentSketchPath = undefined;
            if (log) {
                const currentSketch = await this.sketchServiceClient.currentSketch();
                if (currentSketch) {
                    currentSketchPath = await this.fileService.fsPath(new uri_1.default(currentSketch.uri));
                }
            }
            const { clangdUri, lsUri } = await this.executableService.list();
            const [clangdPath, lsPath] = await Promise.all([
                this.fileService.fsPath(new uri_1.default(clangdUri)),
                this.fileService.fsPath(new uri_1.default(lsUri)),
            ]);
            const config = await this.configService.getConfiguration();
            this.languageServerFqbn = await Promise.race([
                new Promise((_, reject) => setTimeout(() => reject(new Error(`Timeout after ${20000} ms.`)), 20000)),
                this.commandRegistry.executeCommand('arduino.languageserver.start', {
                    lsPath,
                    cliDaemonAddr: `localhost:${config.daemon.port}`,
                    clangdPath,
                    log: currentSketchPath ? currentSketchPath : log,
                    cliDaemonInstance: '1',
                    board: {
                        fqbn,
                        name: name ? `"${name}"` : undefined,
                    },
                }),
            ]);
        }
        catch (e) {
            console.log(`Failed to start language server for ${fqbn}`, e);
            this.languageServerFqbn = undefined;
        }
        finally {
            release();
        }
    }
    registerToolbarItems(registry) {
        registry.registerItem({
            id: boards_toolbar_item_1.BoardsToolBarItem.TOOLBAR_ID,
            render: () => (React.createElement(boards_toolbar_item_1.BoardsToolBarItem, { key: "boardsToolbarItem", commands: this.commandRegistry, boardsServiceClient: this.boardsServiceClientImpl })),
            isVisible: (widget) => arduino_toolbar_1.ArduinoToolbar.is(widget) && widget.side === 'left',
            priority: 7,
        });
        registry.registerItem({
            id: 'toggle-serial-monitor',
            command: monitor_view_contribution_1.MonitorViewContribution.TOGGLE_SERIAL_MONITOR_TOOLBAR,
            tooltip: common_1.nls.localize('arduino/common/serialMonitor', 'Serial Monitor'),
        });
    }
    registerCommands(registry) {
        registry.registerCommand(arduino_commands_1.ArduinoCommands.TOGGLE_COMPILE_FOR_DEBUG, {
            execute: () => this.editorMode.toggleCompileForDebug(),
            isToggled: () => this.editorMode.compileForDebug,
        });
        registry.registerCommand(arduino_commands_1.ArduinoCommands.OPEN_SKETCH_FILES, {
            execute: async (uri) => {
                this.openSketchFiles(uri);
            },
        });
        registry.registerCommand(arduino_commands_1.ArduinoCommands.OPEN_BOARDS_DIALOG, {
            execute: async (query) => {
                const boardsConfig = await this.boardsConfigDialog.open(query);
                if (boardsConfig) {
                    this.boardsServiceClientImpl.boardsConfig = boardsConfig;
                }
            },
        });
    }
    registerMenus(registry) {
        const menuId = (menuPath) => {
            const index = menuPath.length - 1;
            const menuId = menuPath[index];
            return menuId;
        };
        registry.getMenu(core_1.MAIN_MENU_BAR).removeNode(menuId(monaco_menu_1.MonacoMenus.SELECTION));
        registry.getMenu(core_1.MAIN_MENU_BAR).removeNode(menuId(browser_2.EditorMainMenu.GO));
        registry.getMenu(core_1.MAIN_MENU_BAR).removeNode(menuId(terminal_frontend_contribution_1.TerminalMenus.TERMINAL));
        registry.getMenu(core_1.MAIN_MENU_BAR).removeNode(menuId(common_frontend_contribution_1.CommonMenus.VIEW));
        registry.registerSubmenu(arduino_menus_1.ArduinoMenus.SKETCH, common_1.nls.localize('arduino/menu/sketch', 'Sketch'));
        registry.registerSubmenu(arduino_menus_1.ArduinoMenus.TOOLS, common_1.nls.localize('arduino/menu/tools', 'Tools'));
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.SKETCH__MAIN_GROUP, {
            commandId: arduino_commands_1.ArduinoCommands.TOGGLE_COMPILE_FOR_DEBUG.id,
            label: common_1.nls.localize('arduino/debug/optimizeForDebugging', 'Optimize for Debugging'),
            order: '5',
        });
    }
    async openSketchFiles(uri) {
        try {
            const sketch = await this.sketchService.loadSketch(uri.toString());
            const { mainFileUri, rootFolderFileUris } = sketch;
            for (const uri of [mainFileUri, ...rootFolderFileUris]) {
                await this.ensureOpened(uri);
            }
            if (mainFileUri.endsWith('.pde')) {
                const message = common_1.nls.localize('arduino/common/oldFormat', "The '{0}' still uses the old `.pde` format. Do you want to switch to the new `.ino` extension?", sketch.name);
                const yes = common_1.nls.localize('vscode/extensionsUtils/yes', 'Yes');
                this.messageService
                    .info(message, common_1.nls.localize('arduino/common/later', 'Later'), yes)
                    .then(async (answer) => {
                    if (answer === yes) {
                        this.commandRegistry.executeCommand(save_as_sketch_1.SaveAsSketch.Commands.SAVE_AS_SKETCH.id, {
                            execOnlyIfTemp: false,
                            openAfterMove: true,
                            wipeOriginal: false,
                        });
                    }
                });
            }
        }
        catch (e) {
            console.error(e);
            const message = e instanceof Error ? e.message : JSON.stringify(e);
            this.messageService.error(message);
        }
    }
    async ensureOpened(uri, forceOpen = false, options) {
        const widget = this.editorManager.all.find((widget) => widget.editor.uri.toString() === uri);
        if (!widget || forceOpen) {
            return this.editorManager.open(new uri_1.default(uri), options);
        }
    }
    registerColors(colors) {
        colors.register({
            id: 'arduino.branding.primary',
            defaults: {
                dark: 'statusBar.background',
                light: 'statusBar.background',
            },
            description: 'The primary branding color, such as dialog titles, library, and board manager list labels.',
        }, {
            id: 'arduino.branding.secondary',
            defaults: {
                dark: 'statusBar.background',
                light: 'statusBar.background',
            },
            description: 'Secondary branding color for list selections, dropdowns, and widget borders.',
        }, {
            id: 'arduino.foreground',
            defaults: {
                dark: 'editorWidget.background',
                light: 'editorWidget.background',
                hc: 'editorWidget.background',
            },
            description: 'Color of the Arduino IDE foreground which is used for dialogs, such as the Select Board dialog.',
        }, {
            id: 'arduino.toolbar.background',
            defaults: {
                dark: 'button.background',
                light: 'button.background',
                hc: 'activityBar.inactiveForeground',
            },
            description: 'Background color of the toolbar items. Such as Upload, Verify, etc.',
        }, {
            id: 'arduino.toolbar.hoverBackground',
            defaults: {
                dark: 'button.hoverBackground',
                light: 'button.foreground',
                hc: 'textLink.foreground',
            },
            description: 'Background color of the toolbar items when hovering over them. Such as Upload, Verify, etc.',
        }, {
            id: 'arduino.toolbar.toggleBackground',
            defaults: {
                dark: 'editor.selectionBackground',
                light: 'editor.selectionBackground',
                hc: 'textPreformat.foreground',
            },
            description: 'Toggle color of the toolbar items when they are currently toggled (the command is in progress)',
        }, {
            id: 'arduino.output.foreground',
            defaults: {
                dark: 'editor.foreground',
                light: 'editor.foreground',
                hc: 'editor.foreground',
            },
            description: 'Color of the text in the Output view.',
        }, {
            id: 'arduino.output.background',
            defaults: {
                dark: 'editor.background',
                light: 'editor.background',
                hc: 'editor.background',
            },
            description: 'Background color of the Output view.',
        });
    }
};
__decorate([
    inversify_1.inject(core_1.ILogger),
    __metadata("design:type", Object)
], ArduinoFrontendContribution.prototype, "logger", void 0);
__decorate([
    inversify_1.inject(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], ArduinoFrontendContribution.prototype, "messageService", void 0);
__decorate([
    inversify_1.inject(protocol_1.BoardsService),
    __metadata("design:type", Object)
], ArduinoFrontendContribution.prototype, "boardsService", void 0);
__decorate([
    inversify_1.inject(protocol_1.LibraryService),
    __metadata("design:type", Object)
], ArduinoFrontendContribution.prototype, "libraryService", void 0);
__decorate([
    inversify_1.inject(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], ArduinoFrontendContribution.prototype, "boardsServiceClientImpl", void 0);
__decorate([
    inversify_1.inject(browser_2.EditorManager),
    __metadata("design:type", browser_2.EditorManager)
], ArduinoFrontendContribution.prototype, "editorManager", void 0);
__decorate([
    inversify_1.inject(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], ArduinoFrontendContribution.prototype, "fileService", void 0);
__decorate([
    inversify_1.inject(protocol_1.SketchesService),
    __metadata("design:type", Object)
], ArduinoFrontendContribution.prototype, "sketchService", void 0);
__decorate([
    inversify_1.inject(boards_config_dialog_1.BoardsConfigDialog),
    __metadata("design:type", boards_config_dialog_1.BoardsConfigDialog)
], ArduinoFrontendContribution.prototype, "boardsConfigDialog", void 0);
__decorate([
    inversify_1.inject(command_1.CommandRegistry),
    __metadata("design:type", command_1.CommandRegistry)
], ArduinoFrontendContribution.prototype, "commandRegistry", void 0);
__decorate([
    inversify_1.inject(browser_1.StatusBar),
    __metadata("design:type", Object)
], ArduinoFrontendContribution.prototype, "statusBar", void 0);
__decorate([
    inversify_1.inject(navigator_contribution_1.FileNavigatorContribution),
    __metadata("design:type", navigator_contribution_1.FileNavigatorContribution)
], ArduinoFrontendContribution.prototype, "fileNavigatorContributions", void 0);
__decorate([
    inversify_1.inject(output_contribution_1.OutputContribution),
    __metadata("design:type", output_contribution_1.OutputContribution)
], ArduinoFrontendContribution.prototype, "outputContribution", void 0);
__decorate([
    inversify_1.inject(outline_view_contribution_1.OutlineViewContribution),
    __metadata("design:type", outline_view_contribution_1.OutlineViewContribution)
], ArduinoFrontendContribution.prototype, "outlineContribution", void 0);
__decorate([
    inversify_1.inject(problem_contribution_1.ProblemContribution),
    __metadata("design:type", problem_contribution_1.ProblemContribution)
], ArduinoFrontendContribution.prototype, "problemContribution", void 0);
__decorate([
    inversify_1.inject(scm_contribution_1.ScmContribution),
    __metadata("design:type", scm_contribution_1.ScmContribution)
], ArduinoFrontendContribution.prototype, "scmContribution", void 0);
__decorate([
    inversify_1.inject(search_in_workspace_frontend_contribution_1.SearchInWorkspaceFrontendContribution),
    __metadata("design:type", search_in_workspace_frontend_contribution_1.SearchInWorkspaceFrontendContribution)
], ArduinoFrontendContribution.prototype, "siwContribution", void 0);
__decorate([
    inversify_1.inject(sketchbook_widget_contribution_1.SketchbookWidgetContribution),
    __metadata("design:type", sketchbook_widget_contribution_1.SketchbookWidgetContribution)
], ArduinoFrontendContribution.prototype, "sketchbookWidgetContribution", void 0);
__decorate([
    inversify_1.inject(editor_mode_1.EditorMode),
    __metadata("design:type", editor_mode_1.EditorMode)
], ArduinoFrontendContribution.prototype, "editorMode", void 0);
__decorate([
    inversify_1.inject(config_service_1.ConfigService),
    __metadata("design:type", Object)
], ArduinoFrontendContribution.prototype, "configService", void 0);
__decorate([
    inversify_1.inject(hosted_plugin_1.HostedPluginSupport),
    __metadata("design:type", hosted_plugin_1.HostedPluginSupport)
], ArduinoFrontendContribution.prototype, "hostedPluginSupport", void 0);
__decorate([
    inversify_1.inject(protocol_1.ExecutableService),
    __metadata("design:type", Object)
], ArduinoFrontendContribution.prototype, "executableService", void 0);
__decorate([
    inversify_1.inject(arduino_preferences_1.ArduinoPreferences),
    __metadata("design:type", Object)
], ArduinoFrontendContribution.prototype, "arduinoPreferences", void 0);
__decorate([
    inversify_1.inject(sketches_service_client_impl_1.SketchesServiceClientImpl),
    __metadata("design:type", sketches_service_client_impl_1.SketchesServiceClientImpl)
], ArduinoFrontendContribution.prototype, "sketchServiceClient", void 0);
__decorate([
    inversify_1.inject(browser_1.LocalStorageService),
    __metadata("design:type", browser_1.LocalStorageService)
], ArduinoFrontendContribution.prototype, "localStorageService", void 0);
__decorate([
    inversify_1.inject(ide_updater_1.IDEUpdater),
    __metadata("design:type", Object)
], ArduinoFrontendContribution.prototype, "updater", void 0);
__decorate([
    inversify_1.inject(ide_updater_dialog_1.IDEUpdaterDialog),
    __metadata("design:type", ide_updater_dialog_1.IDEUpdaterDialog)
], ArduinoFrontendContribution.prototype, "updaterDialog", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ArduinoFrontendContribution.prototype, "init", null);
ArduinoFrontendContribution = __decorate([
    inversify_1.injectable()
], ArduinoFrontendContribution);
exports.ArduinoFrontendContribution = ArduinoFrontendContribution;
//# sourceMappingURL=arduino-frontend-contribution.js.map