/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { ILayoutService } from '../../layout/browser/layoutService';
import { IInstantiationService } from '../../instantiation/common/instantiation';
import { IThemeService, Themable } from '../../theme/common/themeService';
import { inputBackground, inputForeground, inputBorder, inputValidationInfoBackground, inputValidationInfoForeground, inputValidationInfoBorder, inputValidationWarningBackground, inputValidationWarningForeground, inputValidationWarningBorder, inputValidationErrorBackground, inputValidationErrorForeground, inputValidationErrorBorder, badgeBackground, badgeForeground, contrastBorder, buttonForeground, buttonBackground, buttonHoverBackground, progressBarBackground, widgetShadow, listFocusForeground, activeContrastBorder, pickerGroupBorder, pickerGroupForeground, quickInputForeground, quickInputBackground, quickInputTitleBackground, quickInputListFocusBackground } from '../../theme/common/colorRegistry';
import { CancellationToken } from '../../../base/common/cancellation';
import { computeStyles } from '../../theme/common/styler';
import { IContextKeyService, RawContextKey } from '../../contextkey/common/contextkey';
import { IAccessibilityService } from '../../accessibility/common/accessibility';
import { QuickInputController } from '../../../base/parts/quickinput/browser/quickInput';
import { WorkbenchList } from '../../list/browser/listService';
import { QuickAccessController } from './quickAccess';
var QuickInputService = /** @class */ (function (_super) {
    __extends(QuickInputService, _super);
    function QuickInputService(instantiationService, contextKeyService, themeService, accessibilityService, layoutService) {
        var _this = _super.call(this, themeService) || this;
        _this.instantiationService = instantiationService;
        _this.contextKeyService = contextKeyService;
        _this.accessibilityService = accessibilityService;
        _this.layoutService = layoutService;
        _this.contexts = new Map();
        return _this;
    }
    Object.defineProperty(QuickInputService.prototype, "backButton", {
        get: function () { return this.controller.backButton; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickInputService.prototype, "onShow", {
        get: function () { return this.controller.onShow; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickInputService.prototype, "onHide", {
        get: function () { return this.controller.onHide; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickInputService.prototype, "controller", {
        get: function () {
            if (!this._controller) {
                this._controller = this._register(this.createController());
            }
            return this._controller;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickInputService.prototype, "quickAccess", {
        get: function () {
            if (!this._quickAccess) {
                this._quickAccess = this._register(this.instantiationService.createInstance(QuickAccessController));
            }
            return this._quickAccess;
        },
        enumerable: false,
        configurable: true
    });
    QuickInputService.prototype.createController = function (host, options) {
        var _this = this;
        var _a, _b;
        if (host === void 0) { host = this.layoutService; }
        var defaultOptions = {
            idPrefix: 'quickInput_',
            container: host.container,
            ignoreFocusOut: function () { return false; },
            isScreenReaderOptimized: function () { return _this.accessibilityService.isScreenReaderOptimized(); },
            backKeybindingLabel: function () { return undefined; },
            setContextKey: function (id) { return _this.setContextKey(id); },
            returnFocus: function () { return host.focus(); },
            createList: function (user, container, delegate, renderers, options) { return _this.instantiationService.createInstance(WorkbenchList, user, container, delegate, renderers, options); },
            styles: this.computeStyles()
        };
        var controller = this._register(new QuickInputController(__assign(__assign({}, defaultOptions), options)));
        controller.layout(host.dimension, (_b = (_a = host.offset) === null || _a === void 0 ? void 0 : _a.top) !== null && _b !== void 0 ? _b : 0);
        // Layout changes
        this._register(host.onDidLayout(function (dimension) { var _a, _b; return controller.layout(dimension, (_b = (_a = host.offset) === null || _a === void 0 ? void 0 : _a.top) !== null && _b !== void 0 ? _b : 0); }));
        // Context keys
        this._register(controller.onShow(function () { return _this.resetContextKeys(); }));
        this._register(controller.onHide(function () { return _this.resetContextKeys(); }));
        return controller;
    };
    QuickInputService.prototype.setContextKey = function (id) {
        var key;
        if (id) {
            key = this.contexts.get(id);
            if (!key) {
                key = new RawContextKey(id, false)
                    .bindTo(this.contextKeyService);
                this.contexts.set(id, key);
            }
        }
        if (key && key.get()) {
            return; // already active context
        }
        this.resetContextKeys();
        if (key) {
            key.set(true);
        }
    };
    QuickInputService.prototype.resetContextKeys = function () {
        this.contexts.forEach(function (context) {
            if (context.get()) {
                context.reset();
            }
        });
    };
    QuickInputService.prototype.pick = function (picks, options, token) {
        if (options === void 0) { options = {}; }
        if (token === void 0) { token = CancellationToken.None; }
        return this.controller.pick(picks, options, token);
    };
    QuickInputService.prototype.input = function (options, token) {
        if (options === void 0) { options = {}; }
        if (token === void 0) { token = CancellationToken.None; }
        return this.controller.input(options, token);
    };
    QuickInputService.prototype.createQuickPick = function () {
        return this.controller.createQuickPick();
    };
    QuickInputService.prototype.createInputBox = function () {
        return this.controller.createInputBox();
    };
    QuickInputService.prototype.focus = function () {
        this.controller.focus();
    };
    QuickInputService.prototype.toggle = function () {
        this.controller.toggle();
    };
    QuickInputService.prototype.navigate = function (next, quickNavigate) {
        this.controller.navigate(next, quickNavigate);
    };
    QuickInputService.prototype.accept = function (keyMods) {
        return this.controller.accept(keyMods);
    };
    QuickInputService.prototype.back = function () {
        return this.controller.back();
    };
    QuickInputService.prototype.cancel = function () {
        return this.controller.cancel();
    };
    QuickInputService.prototype.updateStyles = function () {
        this.controller.applyStyles(this.computeStyles());
    };
    QuickInputService.prototype.computeStyles = function () {
        return {
            widget: __assign({}, computeStyles(this.theme, {
                quickInputBackground: quickInputBackground,
                quickInputForeground: quickInputForeground,
                quickInputTitleBackground: quickInputTitleBackground,
                contrastBorder: contrastBorder,
                widgetShadow: widgetShadow
            })),
            inputBox: computeStyles(this.theme, {
                inputForeground: inputForeground,
                inputBackground: inputBackground,
                inputBorder: inputBorder,
                inputValidationInfoBackground: inputValidationInfoBackground,
                inputValidationInfoForeground: inputValidationInfoForeground,
                inputValidationInfoBorder: inputValidationInfoBorder,
                inputValidationWarningBackground: inputValidationWarningBackground,
                inputValidationWarningForeground: inputValidationWarningForeground,
                inputValidationWarningBorder: inputValidationWarningBorder,
                inputValidationErrorBackground: inputValidationErrorBackground,
                inputValidationErrorForeground: inputValidationErrorForeground,
                inputValidationErrorBorder: inputValidationErrorBorder
            }),
            countBadge: computeStyles(this.theme, {
                badgeBackground: badgeBackground,
                badgeForeground: badgeForeground,
                badgeBorder: contrastBorder
            }),
            button: computeStyles(this.theme, {
                buttonForeground: buttonForeground,
                buttonBackground: buttonBackground,
                buttonHoverBackground: buttonHoverBackground,
                buttonBorder: contrastBorder
            }),
            progressBar: computeStyles(this.theme, {
                progressBarBackground: progressBarBackground
            }),
            list: computeStyles(this.theme, {
                listBackground: quickInputBackground,
                // Look like focused when inactive.
                listInactiveFocusForeground: listFocusForeground,
                listInactiveFocusBackground: quickInputListFocusBackground,
                listFocusOutline: activeContrastBorder,
                listInactiveFocusOutline: activeContrastBorder,
                pickerGroupBorder: pickerGroupBorder,
                pickerGroupForeground: pickerGroupForeground
            })
        };
    };
    QuickInputService = __decorate([
        __param(0, IInstantiationService),
        __param(1, IContextKeyService),
        __param(2, IThemeService),
        __param(3, IAccessibilityService),
        __param(4, ILayoutService)
    ], QuickInputService);
    return QuickInputService;
}(Themable));
export { QuickInputService };
