/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import { PauseableEmitter } from '../../../base/common/event';
import { Iterable } from '../../../base/common/iterator';
import { DisposableStore, MutableDisposable } from '../../../base/common/lifecycle';
import { TernarySearchTree } from '../../../base/common/map';
import { distinct } from '../../../base/common/objects';
import { localize } from '../../../nls';
import { CommandsRegistry } from '../../commands/common/commands';
import { IConfigurationService } from '../../configuration/common/configuration';
import { IContextKeyService, SET_CONTEXT_COMMAND_ID, RawContextKey } from '../common/contextkey';
import { KeybindingResolver } from '../../keybinding/common/keybindingResolver';
var KEYBINDING_CONTEXT_ATTR = 'data-keybinding-context';
var Context = /** @class */ (function () {
    function Context(id, parent) {
        this._id = id;
        this._parent = parent;
        this._value = Object.create(null);
        this._value['_contextId'] = id;
    }
    Context.prototype.setValue = function (key, value) {
        // console.log('SET ' + key + ' = ' + value + ' ON ' + this._id);
        if (this._value[key] !== value) {
            this._value[key] = value;
            return true;
        }
        return false;
    };
    Context.prototype.removeValue = function (key) {
        // console.log('REMOVE ' + key + ' FROM ' + this._id);
        if (key in this._value) {
            delete this._value[key];
            return true;
        }
        return false;
    };
    Context.prototype.getValue = function (key) {
        var ret = this._value[key];
        if (typeof ret === 'undefined' && this._parent) {
            return this._parent.getValue(key);
        }
        return ret;
    };
    Context.prototype.updateParent = function (parent) {
        this._parent = parent;
    };
    Context.prototype.collectAllValues = function () {
        var result = this._parent ? this._parent.collectAllValues() : Object.create(null);
        result = __assign(__assign({}, result), this._value);
        delete result['_contextId'];
        return result;
    };
    return Context;
}());
export { Context };
var NullContext = /** @class */ (function (_super) {
    __extends(NullContext, _super);
    function NullContext() {
        return _super.call(this, -1, null) || this;
    }
    NullContext.prototype.setValue = function (key, value) {
        return false;
    };
    NullContext.prototype.removeValue = function (key) {
        return false;
    };
    NullContext.prototype.getValue = function (key) {
        return undefined;
    };
    NullContext.prototype.collectAllValues = function () {
        return Object.create(null);
    };
    NullContext.INSTANCE = new NullContext();
    return NullContext;
}(Context));
var ConfigAwareContextValuesContainer = /** @class */ (function (_super) {
    __extends(ConfigAwareContextValuesContainer, _super);
    function ConfigAwareContextValuesContainer(id, _configurationService, emitter) {
        var _this = _super.call(this, id, null) || this;
        _this._configurationService = _configurationService;
        _this._values = TernarySearchTree.forConfigKeys();
        _this._listener = _this._configurationService.onDidChangeConfiguration(function (event) {
            var e_1, _a;
            if (event.source === 6 /* DEFAULT */) {
                // new setting, reset everything
                var allKeys = Array.from(Iterable.map(_this._values, function (_a) {
                    var _b = __read(_a, 1), k = _b[0];
                    return k;
                }));
                _this._values.clear();
                emitter.fire(new ArrayContextKeyChangeEvent(allKeys));
            }
            else {
                var changedKeys = [];
                try {
                    for (var _b = __values(event.affectedKeys), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var configKey = _c.value;
                        var contextKey = "config." + configKey;
                        var cachedItems = _this._values.findSuperstr(contextKey);
                        if (cachedItems !== undefined) {
                            changedKeys.push.apply(changedKeys, __spreadArray([], __read(Iterable.map(cachedItems, function (_a) {
                                var _b = __read(_a, 1), key = _b[0];
                                return key;
                            }))));
                            _this._values.deleteSuperstr(contextKey);
                        }
                        if (_this._values.has(contextKey)) {
                            changedKeys.push(contextKey);
                            _this._values.delete(contextKey);
                        }
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
                emitter.fire(new ArrayContextKeyChangeEvent(changedKeys));
            }
        });
        return _this;
    }
    ConfigAwareContextValuesContainer.prototype.dispose = function () {
        this._listener.dispose();
    };
    ConfigAwareContextValuesContainer.prototype.getValue = function (key) {
        if (key.indexOf(ConfigAwareContextValuesContainer._keyPrefix) !== 0) {
            return _super.prototype.getValue.call(this, key);
        }
        if (this._values.has(key)) {
            return this._values.get(key);
        }
        var configKey = key.substr(ConfigAwareContextValuesContainer._keyPrefix.length);
        var configValue = this._configurationService.getValue(configKey);
        var value = undefined;
        switch (typeof configValue) {
            case 'number':
            case 'boolean':
            case 'string':
                value = configValue;
                break;
            default:
                if (Array.isArray(configValue)) {
                    value = JSON.stringify(configValue);
                }
                else {
                    value = configValue;
                }
        }
        this._values.set(key, value);
        return value;
    };
    ConfigAwareContextValuesContainer.prototype.setValue = function (key, value) {
        return _super.prototype.setValue.call(this, key, value);
    };
    ConfigAwareContextValuesContainer.prototype.removeValue = function (key) {
        return _super.prototype.removeValue.call(this, key);
    };
    ConfigAwareContextValuesContainer.prototype.collectAllValues = function () {
        var result = Object.create(null);
        this._values.forEach(function (value, index) { return result[index] = value; });
        return __assign(__assign({}, result), _super.prototype.collectAllValues.call(this));
    };
    ConfigAwareContextValuesContainer._keyPrefix = 'config.';
    return ConfigAwareContextValuesContainer;
}(Context));
var ContextKey = /** @class */ (function () {
    function ContextKey(service, key, defaultValue) {
        this._service = service;
        this._key = key;
        this._defaultValue = defaultValue;
        this.reset();
    }
    ContextKey.prototype.set = function (value) {
        this._service.setContext(this._key, value);
    };
    ContextKey.prototype.reset = function () {
        if (typeof this._defaultValue === 'undefined') {
            this._service.removeContext(this._key);
        }
        else {
            this._service.setContext(this._key, this._defaultValue);
        }
    };
    ContextKey.prototype.get = function () {
        return this._service.getContextKeyValue(this._key);
    };
    return ContextKey;
}());
var SimpleContextKeyChangeEvent = /** @class */ (function () {
    function SimpleContextKeyChangeEvent(key) {
        this.key = key;
    }
    SimpleContextKeyChangeEvent.prototype.affectsSome = function (keys) {
        return keys.has(this.key);
    };
    return SimpleContextKeyChangeEvent;
}());
var ArrayContextKeyChangeEvent = /** @class */ (function () {
    function ArrayContextKeyChangeEvent(keys) {
        this.keys = keys;
    }
    ArrayContextKeyChangeEvent.prototype.affectsSome = function (keys) {
        var e_2, _a;
        try {
            for (var _b = __values(this.keys), _c = _b.next(); !_c.done; _c = _b.next()) {
                var key = _c.value;
                if (keys.has(key)) {
                    return true;
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return false;
    };
    return ArrayContextKeyChangeEvent;
}());
var CompositeContextKeyChangeEvent = /** @class */ (function () {
    function CompositeContextKeyChangeEvent(events) {
        this.events = events;
    }
    CompositeContextKeyChangeEvent.prototype.affectsSome = function (keys) {
        var e_3, _a;
        try {
            for (var _b = __values(this.events), _c = _b.next(); !_c.done; _c = _b.next()) {
                var e = _c.value;
                if (e.affectsSome(keys)) {
                    return true;
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_3) throw e_3.error; }
        }
        return false;
    };
    return CompositeContextKeyChangeEvent;
}());
var AbstractContextKeyService = /** @class */ (function () {
    function AbstractContextKeyService(myContextId) {
        this._onDidChangeContext = new PauseableEmitter({ merge: function (input) { return new CompositeContextKeyChangeEvent(input); } });
        this.onDidChangeContext = this._onDidChangeContext.event;
        this._isDisposed = false;
        this._myContextId = myContextId;
    }
    Object.defineProperty(AbstractContextKeyService.prototype, "contextId", {
        get: function () {
            return this._myContextId;
        },
        enumerable: false,
        configurable: true
    });
    AbstractContextKeyService.prototype.createKey = function (key, defaultValue) {
        if (this._isDisposed) {
            throw new Error("AbstractContextKeyService has been disposed");
        }
        return new ContextKey(this, key, defaultValue);
    };
    AbstractContextKeyService.prototype.bufferChangeEvents = function (callback) {
        this._onDidChangeContext.pause();
        try {
            callback();
        }
        finally {
            this._onDidChangeContext.resume();
        }
    };
    AbstractContextKeyService.prototype.createScoped = function (domNode) {
        if (this._isDisposed) {
            throw new Error("AbstractContextKeyService has been disposed");
        }
        return new ScopedContextKeyService(this, domNode);
    };
    AbstractContextKeyService.prototype.createOverlay = function (overlay) {
        if (overlay === void 0) { overlay = Iterable.empty(); }
        if (this._isDisposed) {
            throw new Error("AbstractContextKeyService has been disposed");
        }
        return new OverlayContextKeyService(this, overlay);
    };
    AbstractContextKeyService.prototype.contextMatchesRules = function (rules) {
        if (this._isDisposed) {
            throw new Error("AbstractContextKeyService has been disposed");
        }
        var context = this.getContextValuesContainer(this._myContextId);
        var result = KeybindingResolver.contextMatchesRules(context, rules);
        // console.group(rules.serialize() + ' -> ' + result);
        // rules.keys().forEach(key => { console.log(key, ctx[key]); });
        // console.groupEnd();
        return result;
    };
    AbstractContextKeyService.prototype.getContextKeyValue = function (key) {
        if (this._isDisposed) {
            return undefined;
        }
        return this.getContextValuesContainer(this._myContextId).getValue(key);
    };
    AbstractContextKeyService.prototype.setContext = function (key, value) {
        if (this._isDisposed) {
            return;
        }
        var myContext = this.getContextValuesContainer(this._myContextId);
        if (!myContext) {
            return;
        }
        if (myContext.setValue(key, value)) {
            this._onDidChangeContext.fire(new SimpleContextKeyChangeEvent(key));
        }
    };
    AbstractContextKeyService.prototype.removeContext = function (key) {
        if (this._isDisposed) {
            return;
        }
        if (this.getContextValuesContainer(this._myContextId).removeValue(key)) {
            this._onDidChangeContext.fire(new SimpleContextKeyChangeEvent(key));
        }
    };
    AbstractContextKeyService.prototype.getContext = function (target) {
        if (this._isDisposed) {
            return NullContext.INSTANCE;
        }
        return this.getContextValuesContainer(findContextAttr(target));
    };
    return AbstractContextKeyService;
}());
export { AbstractContextKeyService };
var ContextKeyService = /** @class */ (function (_super) {
    __extends(ContextKeyService, _super);
    function ContextKeyService(configurationService) {
        var _this = _super.call(this, 0) || this;
        _this._contexts = new Map();
        _this._toDispose = new DisposableStore();
        _this._lastContextId = 0;
        var myContext = new ConfigAwareContextValuesContainer(_this._myContextId, configurationService, _this._onDidChangeContext);
        _this._contexts.set(_this._myContextId, myContext);
        _this._toDispose.add(myContext);
        return _this;
        // Uncomment this to see the contexts continuously logged
        // let lastLoggedValue: string | null = null;
        // setInterval(() => {
        // 	let values = Object.keys(this._contexts).map((key) => this._contexts[key]);
        // 	let logValue = values.map(v => JSON.stringify(v._value, null, '\t')).join('\n');
        // 	if (lastLoggedValue !== logValue) {
        // 		lastLoggedValue = logValue;
        // 		console.log(lastLoggedValue);
        // 	}
        // }, 2000);
    }
    ContextKeyService.prototype.dispose = function () {
        this._onDidChangeContext.dispose();
        this._isDisposed = true;
        this._toDispose.dispose();
    };
    ContextKeyService.prototype.getContextValuesContainer = function (contextId) {
        if (this._isDisposed) {
            return NullContext.INSTANCE;
        }
        return this._contexts.get(contextId) || NullContext.INSTANCE;
    };
    ContextKeyService.prototype.createChildContext = function (parentContextId) {
        if (parentContextId === void 0) { parentContextId = this._myContextId; }
        if (this._isDisposed) {
            throw new Error("ContextKeyService has been disposed");
        }
        var id = (++this._lastContextId);
        this._contexts.set(id, new Context(id, this.getContextValuesContainer(parentContextId)));
        return id;
    };
    ContextKeyService.prototype.disposeContext = function (contextId) {
        if (!this._isDisposed) {
            this._contexts.delete(contextId);
        }
    };
    ContextKeyService.prototype.updateParent = function (_parentContextKeyService) {
        throw new Error('Cannot update parent of root ContextKeyService');
    };
    ContextKeyService = __decorate([
        __param(0, IConfigurationService)
    ], ContextKeyService);
    return ContextKeyService;
}(AbstractContextKeyService));
export { ContextKeyService };
var ScopedContextKeyService = /** @class */ (function (_super) {
    __extends(ScopedContextKeyService, _super);
    function ScopedContextKeyService(parent, domNode) {
        var _this = _super.call(this, parent.createChildContext()) || this;
        _this._parentChangeListener = new MutableDisposable();
        _this._parent = parent;
        _this._updateParentChangeListener();
        _this._domNode = domNode;
        if (_this._domNode.hasAttribute(KEYBINDING_CONTEXT_ATTR)) {
            var extraInfo = '';
            if (_this._domNode.classList) {
                extraInfo = Array.from(_this._domNode.classList.values()).join(', ');
            }
            console.error("Element already has context attribute" + (extraInfo ? ': ' + extraInfo : ''));
        }
        _this._domNode.setAttribute(KEYBINDING_CONTEXT_ATTR, String(_this._myContextId));
        return _this;
    }
    ScopedContextKeyService.prototype._updateParentChangeListener = function () {
        // Forward parent events to this listener. Parent will change.
        this._parentChangeListener.value = this._parent.onDidChangeContext(this._onDidChangeContext.fire, this._onDidChangeContext);
    };
    ScopedContextKeyService.prototype.dispose = function () {
        if (this._isDisposed) {
            return;
        }
        this._onDidChangeContext.dispose();
        this._parent.disposeContext(this._myContextId);
        this._parentChangeListener.dispose();
        this._domNode.removeAttribute(KEYBINDING_CONTEXT_ATTR);
        this._isDisposed = true;
    };
    ScopedContextKeyService.prototype.getContextValuesContainer = function (contextId) {
        if (this._isDisposed) {
            return NullContext.INSTANCE;
        }
        return this._parent.getContextValuesContainer(contextId);
    };
    ScopedContextKeyService.prototype.createChildContext = function (parentContextId) {
        if (parentContextId === void 0) { parentContextId = this._myContextId; }
        if (this._isDisposed) {
            throw new Error("ScopedContextKeyService has been disposed");
        }
        return this._parent.createChildContext(parentContextId);
    };
    ScopedContextKeyService.prototype.disposeContext = function (contextId) {
        if (this._isDisposed) {
            return;
        }
        this._parent.disposeContext(contextId);
    };
    ScopedContextKeyService.prototype.updateParent = function (parentContextKeyService) {
        var thisContainer = this._parent.getContextValuesContainer(this._myContextId);
        var oldAllValues = thisContainer.collectAllValues();
        this._parent = parentContextKeyService;
        this._updateParentChangeListener();
        var newParentContainer = this._parent.getContextValuesContainer(this._parent.contextId);
        thisContainer.updateParent(newParentContainer);
        var newAllValues = thisContainer.collectAllValues();
        var allValuesDiff = __assign(__assign({}, distinct(oldAllValues, newAllValues)), distinct(newAllValues, oldAllValues));
        var changedKeys = Object.keys(allValuesDiff);
        this._onDidChangeContext.fire(new ArrayContextKeyChangeEvent(changedKeys));
    };
    return ScopedContextKeyService;
}(AbstractContextKeyService));
var OverlayContext = /** @class */ (function () {
    function OverlayContext(parent, overlay) {
        this.parent = parent;
        this.overlay = overlay;
    }
    OverlayContext.prototype.getValue = function (key) {
        return this.overlay.has(key) ? this.overlay.get(key) : this.parent.getValue(key);
    };
    return OverlayContext;
}());
var OverlayContextKeyService = /** @class */ (function () {
    function OverlayContextKeyService(parent, overlay) {
        this.parent = parent;
        this.overlay = new Map(overlay);
    }
    Object.defineProperty(OverlayContextKeyService.prototype, "contextId", {
        get: function () {
            return this.parent.contextId;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(OverlayContextKeyService.prototype, "onDidChangeContext", {
        get: function () {
            return this.parent.onDidChangeContext;
        },
        enumerable: false,
        configurable: true
    });
    OverlayContextKeyService.prototype.bufferChangeEvents = function (callback) {
        this.parent.bufferChangeEvents(callback);
    };
    OverlayContextKeyService.prototype.createKey = function () {
        throw new Error('Not supported.');
    };
    OverlayContextKeyService.prototype.getContext = function (target) {
        return new OverlayContext(this.parent.getContext(target), this.overlay);
    };
    OverlayContextKeyService.prototype.getContextValuesContainer = function (contextId) {
        var parentContext = this.parent.getContextValuesContainer(contextId);
        return new OverlayContext(parentContext, this.overlay);
    };
    OverlayContextKeyService.prototype.contextMatchesRules = function (rules) {
        var context = this.getContextValuesContainer(this.contextId);
        var result = KeybindingResolver.contextMatchesRules(context, rules);
        return result;
    };
    OverlayContextKeyService.prototype.getContextKeyValue = function (key) {
        return this.overlay.has(key) ? this.overlay.get(key) : this.parent.getContextKeyValue(key);
    };
    OverlayContextKeyService.prototype.createScoped = function () {
        throw new Error('Not supported.');
    };
    OverlayContextKeyService.prototype.createOverlay = function (overlay) {
        if (overlay === void 0) { overlay = Iterable.empty(); }
        return new OverlayContextKeyService(this, overlay);
    };
    OverlayContextKeyService.prototype.updateParent = function () {
        throw new Error('Not supported.');
    };
    OverlayContextKeyService.prototype.dispose = function () {
        // noop
    };
    return OverlayContextKeyService;
}());
function findContextAttr(domNode) {
    while (domNode) {
        if (domNode.hasAttribute(KEYBINDING_CONTEXT_ATTR)) {
            var attr = domNode.getAttribute(KEYBINDING_CONTEXT_ATTR);
            if (attr) {
                return parseInt(attr, 10);
            }
            return NaN;
        }
        domNode = domNode.parentElement;
    }
    return 0;
}
CommandsRegistry.registerCommand(SET_CONTEXT_COMMAND_ID, function (accessor, contextKey, contextValue) {
    accessor.get(IContextKeyService).createKey(String(contextKey), contextValue);
});
CommandsRegistry.registerCommand({
    id: 'getContextKeyInfo',
    handler: function () {
        return __spreadArray([], __read(RawContextKey.all())).sort(function (a, b) { return a.key.localeCompare(b.key); });
    },
    description: {
        description: localize('getContextKeyInfo', "A command that returns information about context keys"),
        args: []
    }
});
CommandsRegistry.registerCommand('_generateContextKeyInfo', function () {
    var e_4, _a;
    var result = [];
    var seen = new Set();
    try {
        for (var _b = __values(RawContextKey.all()), _c = _b.next(); !_c.done; _c = _b.next()) {
            var info = _c.value;
            if (!seen.has(info.key)) {
                seen.add(info.key);
                result.push(info);
            }
        }
    }
    catch (e_4_1) { e_4 = { error: e_4_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_4) throw e_4.error; }
    }
    result.sort(function (a, b) { return a.key.localeCompare(b.key); });
    console.log(JSON.stringify(result, undefined, 2));
});
