/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import * as arrays from '../../../base/common/arrays';
import { CancellationToken } from '../../../base/common/cancellation';
import { EditorAction, registerEditorAction, registerEditorContribution, registerModelCommand } from '../../browser/editorExtensions';
import { Position } from '../../common/core/position';
import { Range } from '../../common/core/range';
import { Selection } from '../../common/core/selection';
import { EditorContextKeys } from '../../common/editorContextKeys';
import * as modes from '../../common/modes';
import * as nls from '../../../nls';
import { MenuId } from '../../../platform/actions/common/actions';
import { WordSelectionRangeProvider } from './wordSelections';
import { BracketSelectionRangeProvider } from './bracketSelections';
import { CommandsRegistry } from '../../../platform/commands/common/commands';
import { onUnexpectedExternalError } from '../../../base/common/errors';
var SelectionRanges = /** @class */ (function () {
    function SelectionRanges(index, ranges) {
        this.index = index;
        this.ranges = ranges;
    }
    SelectionRanges.prototype.mov = function (fwd) {
        var index = this.index + (fwd ? 1 : -1);
        if (index < 0 || index >= this.ranges.length) {
            return this;
        }
        var res = new SelectionRanges(index, this.ranges);
        if (res.ranges[index].equalsRange(this.ranges[this.index])) {
            // next range equals this range, retry with next-next
            return res.mov(fwd);
        }
        return res;
    };
    return SelectionRanges;
}());
var SmartSelectController = /** @class */ (function () {
    function SmartSelectController(_editor) {
        this._editor = _editor;
        this._ignoreSelection = false;
    }
    SmartSelectController.get = function (editor) {
        return editor.getContribution(SmartSelectController.ID);
    };
    SmartSelectController.prototype.dispose = function () {
        var _a;
        (_a = this._selectionListener) === null || _a === void 0 ? void 0 : _a.dispose();
    };
    SmartSelectController.prototype.run = function (forward) {
        return __awaiter(this, void 0, void 0, function () {
            var selections, model, newSelections;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this._editor.hasModel()) {
                            return [2 /*return*/];
                        }
                        selections = this._editor.getSelections();
                        model = this._editor.getModel();
                        if (!modes.SelectionRangeRegistry.has(model)) {
                            return [2 /*return*/];
                        }
                        if (!!this._state) return [3 /*break*/, 2];
                        return [4 /*yield*/, provideSelectionRanges(model, selections.map(function (s) { return s.getPosition(); }), this._editor.getOption(97 /* smartSelect */), CancellationToken.None).then(function (ranges) {
                                var _a;
                                if (!arrays.isNonEmptyArray(ranges) || ranges.length !== selections.length) {
                                    // invalid result
                                    return;
                                }
                                if (!_this._editor.hasModel() || !arrays.equals(_this._editor.getSelections(), selections, function (a, b) { return a.equalsSelection(b); })) {
                                    // invalid editor state
                                    return;
                                }
                                var _loop_1 = function (i) {
                                    ranges[i] = ranges[i].filter(function (range) {
                                        // filter ranges inside the selection
                                        return range.containsPosition(selections[i].getStartPosition()) && range.containsPosition(selections[i].getEndPosition());
                                    });
                                    // prepend current selection
                                    ranges[i].unshift(selections[i]);
                                };
                                for (var i = 0; i < ranges.length; i++) {
                                    _loop_1(i);
                                }
                                _this._state = ranges.map(function (ranges) { return new SelectionRanges(0, ranges); });
                                // listen to caret move and forget about state
                                (_a = _this._selectionListener) === null || _a === void 0 ? void 0 : _a.dispose();
                                _this._selectionListener = _this._editor.onDidChangeCursorPosition(function () {
                                    var _a;
                                    if (!_this._ignoreSelection) {
                                        (_a = _this._selectionListener) === null || _a === void 0 ? void 0 : _a.dispose();
                                        _this._state = undefined;
                                    }
                                });
                            })];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2:
                        if (!this._state) {
                            // no state
                            return [2 /*return*/];
                        }
                        this._state = this._state.map(function (state) { return state.mov(forward); });
                        newSelections = this._state.map(function (state) { return Selection.fromPositions(state.ranges[state.index].getStartPosition(), state.ranges[state.index].getEndPosition()); });
                        this._ignoreSelection = true;
                        try {
                            this._editor.setSelections(newSelections);
                        }
                        finally {
                            this._ignoreSelection = false;
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    SmartSelectController.ID = 'editor.contrib.smartSelectController';
    return SmartSelectController;
}());
var AbstractSmartSelect = /** @class */ (function (_super) {
    __extends(AbstractSmartSelect, _super);
    function AbstractSmartSelect(forward, opts) {
        var _this = _super.call(this, opts) || this;
        _this._forward = forward;
        return _this;
    }
    AbstractSmartSelect.prototype.run = function (_accessor, editor) {
        return __awaiter(this, void 0, void 0, function () {
            var controller;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        controller = SmartSelectController.get(editor);
                        if (!controller) return [3 /*break*/, 2];
                        return [4 /*yield*/, controller.run(this._forward)];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2: return [2 /*return*/];
                }
            });
        });
    };
    return AbstractSmartSelect;
}(EditorAction));
var GrowSelectionAction = /** @class */ (function (_super) {
    __extends(GrowSelectionAction, _super);
    function GrowSelectionAction() {
        return _super.call(this, true, {
            id: 'editor.action.smartSelect.expand',
            label: nls.localize('smartSelect.expand', "Expand Selection"),
            alias: 'Expand Selection',
            precondition: undefined,
            kbOpts: {
                kbExpr: EditorContextKeys.editorTextFocus,
                primary: 1024 /* Shift */ | 512 /* Alt */ | 17 /* RightArrow */,
                mac: {
                    primary: 2048 /* CtrlCmd */ | 256 /* WinCtrl */ | 1024 /* Shift */ | 17 /* RightArrow */,
                    secondary: [256 /* WinCtrl */ | 1024 /* Shift */ | 17 /* RightArrow */],
                },
                weight: 100 /* EditorContrib */
            },
            menuOpts: {
                menuId: MenuId.MenubarSelectionMenu,
                group: '1_basic',
                title: nls.localize({ key: 'miSmartSelectGrow', comment: ['&& denotes a mnemonic'] }, "&&Expand Selection"),
                order: 2
            }
        }) || this;
    }
    return GrowSelectionAction;
}(AbstractSmartSelect));
// renamed command id
CommandsRegistry.registerCommandAlias('editor.action.smartSelect.grow', 'editor.action.smartSelect.expand');
var ShrinkSelectionAction = /** @class */ (function (_super) {
    __extends(ShrinkSelectionAction, _super);
    function ShrinkSelectionAction() {
        return _super.call(this, false, {
            id: 'editor.action.smartSelect.shrink',
            label: nls.localize('smartSelect.shrink', "Shrink Selection"),
            alias: 'Shrink Selection',
            precondition: undefined,
            kbOpts: {
                kbExpr: EditorContextKeys.editorTextFocus,
                primary: 1024 /* Shift */ | 512 /* Alt */ | 15 /* LeftArrow */,
                mac: {
                    primary: 2048 /* CtrlCmd */ | 256 /* WinCtrl */ | 1024 /* Shift */ | 15 /* LeftArrow */,
                    secondary: [256 /* WinCtrl */ | 1024 /* Shift */ | 15 /* LeftArrow */],
                },
                weight: 100 /* EditorContrib */
            },
            menuOpts: {
                menuId: MenuId.MenubarSelectionMenu,
                group: '1_basic',
                title: nls.localize({ key: 'miSmartSelectShrink', comment: ['&& denotes a mnemonic'] }, "&&Shrink Selection"),
                order: 3
            }
        }) || this;
    }
    return ShrinkSelectionAction;
}(AbstractSmartSelect));
registerEditorContribution(SmartSelectController.ID, SmartSelectController);
registerEditorAction(GrowSelectionAction);
registerEditorAction(ShrinkSelectionAction);
// word selection
modes.SelectionRangeRegistry.register('*', new WordSelectionRangeProvider());
export function provideSelectionRanges(model, positions, options, token) {
    return __awaiter(this, void 0, void 0, function () {
        var providers, work, allRawRanges, providers_1, providers_1_1, provider;
        var e_1, _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    providers = modes.SelectionRangeRegistry.all(model);
                    if (providers.length === 1) {
                        // add word selection and bracket selection when no provider exists
                        providers.unshift(new BracketSelectionRangeProvider());
                    }
                    work = [];
                    allRawRanges = [];
                    try {
                        for (providers_1 = __values(providers), providers_1_1 = providers_1.next(); !providers_1_1.done; providers_1_1 = providers_1.next()) {
                            provider = providers_1_1.value;
                            work.push(Promise.resolve(provider.provideSelectionRanges(model, positions, token)).then(function (allProviderRanges) {
                                var e_2, _a;
                                if (arrays.isNonEmptyArray(allProviderRanges) && allProviderRanges.length === positions.length) {
                                    for (var i = 0; i < positions.length; i++) {
                                        if (!allRawRanges[i]) {
                                            allRawRanges[i] = [];
                                        }
                                        try {
                                            for (var _b = (e_2 = void 0, __values(allProviderRanges[i])), _c = _b.next(); !_c.done; _c = _b.next()) {
                                                var oneProviderRanges = _c.value;
                                                if (Range.isIRange(oneProviderRanges.range) && Range.containsPosition(oneProviderRanges.range, positions[i])) {
                                                    allRawRanges[i].push(Range.lift(oneProviderRanges.range));
                                                }
                                            }
                                        }
                                        catch (e_2_1) { e_2 = { error: e_2_1 }; }
                                        finally {
                                            try {
                                                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                                            }
                                            finally { if (e_2) throw e_2.error; }
                                        }
                                    }
                                }
                            }, onUnexpectedExternalError));
                        }
                    }
                    catch (e_1_1) { e_1 = { error: e_1_1 }; }
                    finally {
                        try {
                            if (providers_1_1 && !providers_1_1.done && (_a = providers_1.return)) _a.call(providers_1);
                        }
                        finally { if (e_1) throw e_1.error; }
                    }
                    return [4 /*yield*/, Promise.all(work)];
                case 1:
                    _b.sent();
                    return [2 /*return*/, allRawRanges.map(function (oneRawRanges) {
                            var e_3, _a;
                            if (oneRawRanges.length === 0) {
                                return [];
                            }
                            // sort all by start/end position
                            oneRawRanges.sort(function (a, b) {
                                if (Position.isBefore(a.getStartPosition(), b.getStartPosition())) {
                                    return 1;
                                }
                                else if (Position.isBefore(b.getStartPosition(), a.getStartPosition())) {
                                    return -1;
                                }
                                else if (Position.isBefore(a.getEndPosition(), b.getEndPosition())) {
                                    return -1;
                                }
                                else if (Position.isBefore(b.getEndPosition(), a.getEndPosition())) {
                                    return 1;
                                }
                                else {
                                    return 0;
                                }
                            });
                            // remove ranges that don't contain the former range or that are equal to the
                            // former range
                            var oneRanges = [];
                            var last;
                            try {
                                for (var oneRawRanges_1 = __values(oneRawRanges), oneRawRanges_1_1 = oneRawRanges_1.next(); !oneRawRanges_1_1.done; oneRawRanges_1_1 = oneRawRanges_1.next()) {
                                    var range = oneRawRanges_1_1.value;
                                    if (!last || (Range.containsRange(range, last) && !Range.equalsRange(range, last))) {
                                        oneRanges.push(range);
                                        last = range;
                                    }
                                }
                            }
                            catch (e_3_1) { e_3 = { error: e_3_1 }; }
                            finally {
                                try {
                                    if (oneRawRanges_1_1 && !oneRawRanges_1_1.done && (_a = oneRawRanges_1.return)) _a.call(oneRawRanges_1);
                                }
                                finally { if (e_3) throw e_3.error; }
                            }
                            if (!options.selectLeadingAndTrailingWhitespace) {
                                return oneRanges;
                            }
                            // add ranges that expand trivia at line starts and ends whenever a range
                            // wraps onto the a new line
                            var oneRangesWithTrivia = [oneRanges[0]];
                            for (var i = 1; i < oneRanges.length; i++) {
                                var prev = oneRanges[i - 1];
                                var cur = oneRanges[i];
                                if (cur.startLineNumber !== prev.startLineNumber || cur.endLineNumber !== prev.endLineNumber) {
                                    // add line/block range without leading/failing whitespace
                                    var rangeNoWhitespace = new Range(prev.startLineNumber, model.getLineFirstNonWhitespaceColumn(prev.startLineNumber), prev.endLineNumber, model.getLineLastNonWhitespaceColumn(prev.endLineNumber));
                                    if (rangeNoWhitespace.containsRange(prev) && !rangeNoWhitespace.equalsRange(prev) && cur.containsRange(rangeNoWhitespace) && !cur.equalsRange(rangeNoWhitespace)) {
                                        oneRangesWithTrivia.push(rangeNoWhitespace);
                                    }
                                    // add line/block range
                                    var rangeFull = new Range(prev.startLineNumber, 1, prev.endLineNumber, model.getLineMaxColumn(prev.endLineNumber));
                                    if (rangeFull.containsRange(prev) && !rangeFull.equalsRange(rangeNoWhitespace) && cur.containsRange(rangeFull) && !cur.equalsRange(rangeFull)) {
                                        oneRangesWithTrivia.push(rangeFull);
                                    }
                                }
                                oneRangesWithTrivia.push(cur);
                            }
                            return oneRangesWithTrivia;
                        })];
            }
        });
    });
}
registerModelCommand('_executeSelectionRangeProvider', function (model) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    var _a = __read(args, 1), positions = _a[0];
    return provideSelectionRanges(model, positions, { selectLeadingAndTrailingWhitespace: true }, CancellationToken.None);
});
