/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { CancellationToken } from '../../../base/common/cancellation';
import { onUnexpectedExternalError } from '../../../base/common/errors';
import { URI } from '../../../base/common/uri';
import { Range } from '../../common/core/range';
import { LinkProviderRegistry } from '../../common/modes';
import { IModelService } from '../../common/services/modelService';
import { CommandsRegistry } from '../../../platform/commands/common/commands';
import { isDisposable, DisposableStore } from '../../../base/common/lifecycle';
import { coalesce } from '../../../base/common/arrays';
import { assertType } from '../../../base/common/types';
var Link = /** @class */ (function () {
    function Link(link, provider) {
        this._link = link;
        this._provider = provider;
    }
    Link.prototype.toJSON = function () {
        return {
            range: this.range,
            url: this.url,
            tooltip: this.tooltip
        };
    };
    Object.defineProperty(Link.prototype, "range", {
        get: function () {
            return this._link.range;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Link.prototype, "url", {
        get: function () {
            return this._link.url;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Link.prototype, "tooltip", {
        get: function () {
            return this._link.tooltip;
        },
        enumerable: false,
        configurable: true
    });
    Link.prototype.resolve = function (token) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                if (this._link.url) {
                    return [2 /*return*/, this._link.url];
                }
                if (typeof this._provider.resolveLink === 'function') {
                    return [2 /*return*/, Promise.resolve(this._provider.resolveLink(this._link, token)).then(function (value) {
                            _this._link = value || _this._link;
                            if (_this._link.url) {
                                // recurse
                                return _this.resolve(token);
                            }
                            return Promise.reject(new Error('missing'));
                        })];
                }
                return [2 /*return*/, Promise.reject(new Error('missing'))];
            });
        });
    };
    return Link;
}());
export { Link };
var LinksList = /** @class */ (function () {
    function LinksList(tuples) {
        var e_1, _a;
        this._disposables = new DisposableStore();
        var links = [];
        var _loop_1 = function (list, provider) {
            // merge all links
            var newLinks = list.links.map(function (link) { return new Link(link, provider); });
            links = LinksList._union(links, newLinks);
            // register disposables
            if (isDisposable(list)) {
                this_1._disposables.add(list);
            }
        };
        var this_1 = this;
        try {
            for (var tuples_1 = __values(tuples), tuples_1_1 = tuples_1.next(); !tuples_1_1.done; tuples_1_1 = tuples_1.next()) {
                var _b = __read(tuples_1_1.value, 2), list = _b[0], provider = _b[1];
                _loop_1(list, provider);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (tuples_1_1 && !tuples_1_1.done && (_a = tuples_1.return)) _a.call(tuples_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        this.links = links;
    }
    LinksList.prototype.dispose = function () {
        this._disposables.dispose();
        this.links.length = 0;
    };
    LinksList._union = function (oldLinks, newLinks) {
        // reunite oldLinks with newLinks and remove duplicates
        var result = [];
        var oldIndex;
        var oldLen;
        var newIndex;
        var newLen;
        for (oldIndex = 0, newIndex = 0, oldLen = oldLinks.length, newLen = newLinks.length; oldIndex < oldLen && newIndex < newLen;) {
            var oldLink = oldLinks[oldIndex];
            var newLink = newLinks[newIndex];
            if (Range.areIntersectingOrTouching(oldLink.range, newLink.range)) {
                // Remove the oldLink
                oldIndex++;
                continue;
            }
            var comparisonResult = Range.compareRangesUsingStarts(oldLink.range, newLink.range);
            if (comparisonResult < 0) {
                // oldLink is before
                result.push(oldLink);
                oldIndex++;
            }
            else {
                // newLink is before
                result.push(newLink);
                newIndex++;
            }
        }
        for (; oldIndex < oldLen; oldIndex++) {
            result.push(oldLinks[oldIndex]);
        }
        for (; newIndex < newLen; newIndex++) {
            result.push(newLinks[newIndex]);
        }
        return result;
    };
    return LinksList;
}());
export { LinksList };
export function getLinks(model, token) {
    var lists = [];
    // ask all providers for links in parallel
    var promises = LinkProviderRegistry.ordered(model).reverse().map(function (provider, i) {
        return Promise.resolve(provider.provideLinks(model, token)).then(function (result) {
            if (result) {
                lists[i] = [result, provider];
            }
        }, onUnexpectedExternalError);
    });
    return Promise.all(promises).then(function () {
        var result = new LinksList(coalesce(lists));
        if (!token.isCancellationRequested) {
            return result;
        }
        result.dispose();
        return new LinksList([]);
    });
}
CommandsRegistry.registerCommand('_executeLinkProvider', function (accessor) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    return __awaiter(void 0, void 0, void 0, function () {
        var _a, uri, resolveCount, model, list, i, result;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    _a = __read(args, 2), uri = _a[0], resolveCount = _a[1];
                    assertType(uri instanceof URI);
                    if (typeof resolveCount !== 'number') {
                        resolveCount = 0;
                    }
                    model = accessor.get(IModelService).getModel(uri);
                    if (!model) {
                        return [2 /*return*/, []];
                    }
                    return [4 /*yield*/, getLinks(model, CancellationToken.None)];
                case 1:
                    list = _b.sent();
                    if (!list) {
                        return [2 /*return*/, []];
                    }
                    i = 0;
                    _b.label = 2;
                case 2:
                    if (!(i < Math.min(resolveCount, list.links.length))) return [3 /*break*/, 5];
                    return [4 /*yield*/, list.links[i].resolve(CancellationToken.None)];
                case 3:
                    _b.sent();
                    _b.label = 4;
                case 4:
                    i++;
                    return [3 /*break*/, 2];
                case 5:
                    result = list.links.slice(0);
                    list.dispose();
                    return [2 /*return*/, result];
            }
        });
    });
});
