/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
import * as nls from '../../../nls';
import { Delayer } from '../../../base/common/async';
import { Disposable } from '../../../base/common/lifecycle';
import * as strings from '../../../base/common/strings';
import { EditorAction, EditorCommand, registerEditorAction, registerEditorCommand, registerEditorContribution, MultiEditorAction, registerMultiEditorAction } from '../../browser/editorExtensions';
import { EditorContextKeys } from '../../common/editorContextKeys';
import { CONTEXT_FIND_INPUT_FOCUSED, CONTEXT_FIND_WIDGET_VISIBLE, FIND_IDS, FindModelBoundToEditorModel, ToggleCaseSensitiveKeybinding, TogglePreserveCaseKeybinding, ToggleRegexKeybinding, ToggleSearchScopeKeybinding, ToggleWholeWordKeybinding, CONTEXT_REPLACE_INPUT_FOCUSED } from './findModel';
import { FindOptionsWidget } from './findOptionsWidget';
import { FindReplaceState } from './findState';
import { FindWidget } from './findWidget';
import { MenuId } from '../../../platform/actions/common/actions';
import { IClipboardService } from '../../../platform/clipboard/common/clipboardService';
import { IContextKeyService, ContextKeyExpr } from '../../../platform/contextkey/common/contextkey';
import { IContextViewService } from '../../../platform/contextview/browser/contextView';
import { IKeybindingService } from '../../../platform/keybinding/common/keybinding';
import { IStorageService } from '../../../platform/storage/common/storage';
import { IThemeService } from '../../../platform/theme/common/themeService';
import { INotificationService } from '../../../platform/notification/common/notification';
import { ICodeEditorService } from '../../browser/services/codeEditorService';
var SEARCH_STRING_MAX_LENGTH = 524288;
export function getSelectionSearchString(editor, seedSearchStringFromSelection) {
    if (seedSearchStringFromSelection === void 0) { seedSearchStringFromSelection = 'single'; }
    if (!editor.hasModel()) {
        return null;
    }
    var selection = editor.getSelection();
    // if selection spans multiple lines, default search string to empty
    if ((seedSearchStringFromSelection === 'single' && selection.startLineNumber === selection.endLineNumber)
        || seedSearchStringFromSelection === 'multiple') {
        if (selection.isEmpty()) {
            var wordAtPosition = editor.getConfiguredWordAtPosition(selection.getStartPosition());
            if (wordAtPosition) {
                return wordAtPosition.word;
            }
        }
        else {
            if (editor.getModel().getValueLengthInRange(selection) < SEARCH_STRING_MAX_LENGTH) {
                return editor.getModel().getValueInRange(selection);
            }
        }
    }
    return null;
}
var CommonFindController = /** @class */ (function (_super) {
    __extends(CommonFindController, _super);
    function CommonFindController(editor, contextKeyService, storageService, clipboardService) {
        var _this = _super.call(this) || this;
        _this._editor = editor;
        _this._findWidgetVisible = CONTEXT_FIND_WIDGET_VISIBLE.bindTo(contextKeyService);
        _this._contextKeyService = contextKeyService;
        _this._storageService = storageService;
        _this._clipboardService = clipboardService;
        _this._updateHistoryDelayer = new Delayer(500);
        _this._state = _this._register(new FindReplaceState());
        _this.loadQueryState();
        _this._register(_this._state.onFindReplaceStateChange(function (e) { return _this._onStateChanged(e); }));
        _this._model = null;
        _this._register(_this._editor.onDidChangeModel(function () {
            var shouldRestartFind = (_this._editor.getModel() && _this._state.isRevealed);
            _this.disposeModel();
            _this._state.change({
                searchScope: null,
                matchCase: _this._storageService.getBoolean('editor.matchCase', 1 /* WORKSPACE */, false),
                wholeWord: _this._storageService.getBoolean('editor.wholeWord', 1 /* WORKSPACE */, false),
                isRegex: _this._storageService.getBoolean('editor.isRegex', 1 /* WORKSPACE */, false),
                preserveCase: _this._storageService.getBoolean('editor.preserveCase', 1 /* WORKSPACE */, false)
            }, false);
            if (shouldRestartFind) {
                _this._start({
                    forceRevealReplace: false,
                    seedSearchStringFromSelection: 'none',
                    seedSearchStringFromGlobalClipboard: false,
                    shouldFocus: 0 /* NoFocusChange */,
                    shouldAnimate: false,
                    updateSearchScope: false,
                    loop: _this._editor.getOption(31 /* find */).loop
                });
            }
        }));
        return _this;
    }
    Object.defineProperty(CommonFindController.prototype, "editor", {
        get: function () {
            return this._editor;
        },
        enumerable: false,
        configurable: true
    });
    CommonFindController.get = function (editor) {
        return editor.getContribution(CommonFindController.ID);
    };
    CommonFindController.prototype.dispose = function () {
        this.disposeModel();
        _super.prototype.dispose.call(this);
    };
    CommonFindController.prototype.disposeModel = function () {
        if (this._model) {
            this._model.dispose();
            this._model = null;
        }
    };
    CommonFindController.prototype._onStateChanged = function (e) {
        this.saveQueryState(e);
        if (e.isRevealed) {
            if (this._state.isRevealed) {
                this._findWidgetVisible.set(true);
            }
            else {
                this._findWidgetVisible.reset();
                this.disposeModel();
            }
        }
        if (e.searchString) {
            this.setGlobalBufferTerm(this._state.searchString);
        }
    };
    CommonFindController.prototype.saveQueryState = function (e) {
        if (e.isRegex) {
            this._storageService.store('editor.isRegex', this._state.actualIsRegex, 1 /* WORKSPACE */, 0 /* USER */);
        }
        if (e.wholeWord) {
            this._storageService.store('editor.wholeWord', this._state.actualWholeWord, 1 /* WORKSPACE */, 0 /* USER */);
        }
        if (e.matchCase) {
            this._storageService.store('editor.matchCase', this._state.actualMatchCase, 1 /* WORKSPACE */, 0 /* USER */);
        }
        if (e.preserveCase) {
            this._storageService.store('editor.preserveCase', this._state.actualPreserveCase, 1 /* WORKSPACE */, 0 /* USER */);
        }
    };
    CommonFindController.prototype.loadQueryState = function () {
        this._state.change({
            matchCase: this._storageService.getBoolean('editor.matchCase', 1 /* WORKSPACE */, this._state.matchCase),
            wholeWord: this._storageService.getBoolean('editor.wholeWord', 1 /* WORKSPACE */, this._state.wholeWord),
            isRegex: this._storageService.getBoolean('editor.isRegex', 1 /* WORKSPACE */, this._state.isRegex),
            preserveCase: this._storageService.getBoolean('editor.preserveCase', 1 /* WORKSPACE */, this._state.preserveCase)
        }, false);
    };
    CommonFindController.prototype.isFindInputFocused = function () {
        return !!CONTEXT_FIND_INPUT_FOCUSED.getValue(this._contextKeyService);
    };
    CommonFindController.prototype.getState = function () {
        return this._state;
    };
    CommonFindController.prototype.closeFindWidget = function () {
        this._state.change({
            isRevealed: false,
            searchScope: null
        }, false);
        this._editor.focus();
    };
    CommonFindController.prototype.toggleCaseSensitive = function () {
        this._state.change({ matchCase: !this._state.matchCase }, false);
        if (!this._state.isRevealed) {
            this.highlightFindOptions();
        }
    };
    CommonFindController.prototype.toggleWholeWords = function () {
        this._state.change({ wholeWord: !this._state.wholeWord }, false);
        if (!this._state.isRevealed) {
            this.highlightFindOptions();
        }
    };
    CommonFindController.prototype.toggleRegex = function () {
        this._state.change({ isRegex: !this._state.isRegex }, false);
        if (!this._state.isRevealed) {
            this.highlightFindOptions();
        }
    };
    CommonFindController.prototype.togglePreserveCase = function () {
        this._state.change({ preserveCase: !this._state.preserveCase }, false);
        if (!this._state.isRevealed) {
            this.highlightFindOptions();
        }
    };
    CommonFindController.prototype.toggleSearchScope = function () {
        var _this = this;
        if (this._state.searchScope) {
            this._state.change({ searchScope: null }, true);
        }
        else {
            if (this._editor.hasModel()) {
                var selections = this._editor.getSelections();
                selections.map(function (selection) {
                    if (selection.endColumn === 1 && selection.endLineNumber > selection.startLineNumber) {
                        selection = selection.setEndPosition(selection.endLineNumber - 1, _this._editor.getModel().getLineMaxColumn(selection.endLineNumber - 1));
                    }
                    if (!selection.isEmpty()) {
                        return selection;
                    }
                    return null;
                }).filter(function (element) { return !!element; });
                if (selections.length) {
                    this._state.change({ searchScope: selections }, true);
                }
            }
        }
    };
    CommonFindController.prototype.setSearchString = function (searchString) {
        if (this._state.isRegex) {
            searchString = strings.escapeRegExpCharacters(searchString);
        }
        this._state.change({ searchString: searchString }, false);
    };
    CommonFindController.prototype.highlightFindOptions = function (ignoreWhenVisible) {
        if (ignoreWhenVisible === void 0) { ignoreWhenVisible = false; }
        // overwritten in subclass
    };
    CommonFindController.prototype._start = function (opts) {
        return __awaiter(this, void 0, void 0, function () {
            var stateChanges, selectionSearchString, selectionSearchString, selectionSearchString, currentSelections;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.disposeModel();
                        if (!this._editor.hasModel()) {
                            // cannot do anything with an editor that doesn't have a model...
                            return [2 /*return*/];
                        }
                        stateChanges = {
                            isRevealed: true
                        };
                        if (opts.seedSearchStringFromSelection === 'single') {
                            selectionSearchString = getSelectionSearchString(this._editor, opts.seedSearchStringFromSelection);
                            if (selectionSearchString) {
                                if (this._state.isRegex) {
                                    stateChanges.searchString = strings.escapeRegExpCharacters(selectionSearchString);
                                }
                                else {
                                    stateChanges.searchString = selectionSearchString;
                                }
                            }
                        }
                        else if (opts.seedSearchStringFromSelection === 'multiple' && !opts.updateSearchScope) {
                            selectionSearchString = getSelectionSearchString(this._editor, opts.seedSearchStringFromSelection);
                            if (selectionSearchString) {
                                stateChanges.searchString = selectionSearchString;
                            }
                        }
                        if (!(!stateChanges.searchString && opts.seedSearchStringFromGlobalClipboard)) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.getGlobalBufferTerm()];
                    case 1:
                        selectionSearchString = _a.sent();
                        if (!this._editor.hasModel()) {
                            // the editor has lost its model in the meantime
                            return [2 /*return*/];
                        }
                        if (selectionSearchString) {
                            stateChanges.searchString = selectionSearchString;
                        }
                        _a.label = 2;
                    case 2:
                        // Overwrite isReplaceRevealed
                        if (opts.forceRevealReplace) {
                            stateChanges.isReplaceRevealed = true;
                        }
                        else if (!this._findWidgetVisible.get()) {
                            stateChanges.isReplaceRevealed = false;
                        }
                        if (opts.updateSearchScope) {
                            currentSelections = this._editor.getSelections();
                            if (currentSelections.some(function (selection) { return !selection.isEmpty(); })) {
                                stateChanges.searchScope = currentSelections;
                            }
                        }
                        stateChanges.loop = opts.loop;
                        this._state.change(stateChanges, false);
                        if (!this._model) {
                            this._model = new FindModelBoundToEditorModel(this._editor, this._state);
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    CommonFindController.prototype.start = function (opts) {
        return this._start(opts);
    };
    CommonFindController.prototype.moveToNextMatch = function () {
        if (this._model) {
            this._model.moveToNextMatch();
            return true;
        }
        return false;
    };
    CommonFindController.prototype.moveToPrevMatch = function () {
        if (this._model) {
            this._model.moveToPrevMatch();
            return true;
        }
        return false;
    };
    CommonFindController.prototype.replace = function () {
        if (this._model) {
            this._model.replace();
            return true;
        }
        return false;
    };
    CommonFindController.prototype.replaceAll = function () {
        if (this._model) {
            this._model.replaceAll();
            return true;
        }
        return false;
    };
    CommonFindController.prototype.selectAllMatches = function () {
        if (this._model) {
            this._model.selectAllMatches();
            this._editor.focus();
            return true;
        }
        return false;
    };
    CommonFindController.prototype.getGlobalBufferTerm = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (this._editor.getOption(31 /* find */).globalFindClipboard
                    && this._editor.hasModel()
                    && !this._editor.getModel().isTooLargeForSyncing()) {
                    return [2 /*return*/, this._clipboardService.readFindText()];
                }
                return [2 /*return*/, ''];
            });
        });
    };
    CommonFindController.prototype.setGlobalBufferTerm = function (text) {
        if (this._editor.getOption(31 /* find */).globalFindClipboard
            && this._editor.hasModel()
            && !this._editor.getModel().isTooLargeForSyncing()) {
            // intentionally not awaited
            this._clipboardService.writeFindText(text);
        }
    };
    CommonFindController.ID = 'editor.contrib.findController';
    CommonFindController = __decorate([
        __param(1, IContextKeyService),
        __param(2, IStorageService),
        __param(3, IClipboardService)
    ], CommonFindController);
    return CommonFindController;
}(Disposable));
export { CommonFindController };
var FindController = /** @class */ (function (_super) {
    __extends(FindController, _super);
    function FindController(editor, _contextViewService, _contextKeyService, _keybindingService, _themeService, _notificationService, _storageService, clipboardService) {
        var _this = _super.call(this, editor, _contextKeyService, _storageService, clipboardService) || this;
        _this._contextViewService = _contextViewService;
        _this._keybindingService = _keybindingService;
        _this._themeService = _themeService;
        _this._notificationService = _notificationService;
        _this._widget = null;
        _this._findOptionsWidget = null;
        return _this;
    }
    FindController.prototype._start = function (opts) {
        return __awaiter(this, void 0, void 0, function () {
            var selection, updateSearchScope, isSelectionMultipleLine;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this._widget) {
                            this._createFindWidget();
                        }
                        selection = this._editor.getSelection();
                        updateSearchScope = false;
                        switch (this._editor.getOption(31 /* find */).autoFindInSelection) {
                            case 'always':
                                updateSearchScope = true;
                                break;
                            case 'never':
                                updateSearchScope = false;
                                break;
                            case 'multiline':
                                isSelectionMultipleLine = !!selection && selection.startLineNumber !== selection.endLineNumber;
                                updateSearchScope = isSelectionMultipleLine;
                                break;
                            default:
                                break;
                        }
                        opts.updateSearchScope = updateSearchScope;
                        return [4 /*yield*/, _super.prototype._start.call(this, opts)];
                    case 1:
                        _a.sent();
                        if (this._widget) {
                            if (opts.shouldFocus === 2 /* FocusReplaceInput */) {
                                this._widget.focusReplaceInput();
                            }
                            else if (opts.shouldFocus === 1 /* FocusFindInput */) {
                                this._widget.focusFindInput();
                            }
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    FindController.prototype.highlightFindOptions = function (ignoreWhenVisible) {
        if (ignoreWhenVisible === void 0) { ignoreWhenVisible = false; }
        if (!this._widget) {
            this._createFindWidget();
        }
        if (this._state.isRevealed && !ignoreWhenVisible) {
            this._widget.highlightFindOptions();
        }
        else {
            this._findOptionsWidget.highlightFindOptions();
        }
    };
    FindController.prototype._createFindWidget = function () {
        this._widget = this._register(new FindWidget(this._editor, this, this._state, this._contextViewService, this._keybindingService, this._contextKeyService, this._themeService, this._storageService, this._notificationService));
        this._findOptionsWidget = this._register(new FindOptionsWidget(this._editor, this._state, this._keybindingService, this._themeService));
    };
    FindController.prototype.saveViewState = function () {
        var _a;
        return (_a = this._widget) === null || _a === void 0 ? void 0 : _a.getViewState();
    };
    FindController.prototype.restoreViewState = function (state) {
        var _a;
        (_a = this._widget) === null || _a === void 0 ? void 0 : _a.setViewState(state);
    };
    FindController = __decorate([
        __param(1, IContextViewService),
        __param(2, IContextKeyService),
        __param(3, IKeybindingService),
        __param(4, IThemeService),
        __param(5, INotificationService),
        __param(6, IStorageService),
        __param(7, IClipboardService)
    ], FindController);
    return FindController;
}(CommonFindController));
export { FindController };
export var StartFindAction = registerMultiEditorAction(new MultiEditorAction({
    id: FIND_IDS.StartFindAction,
    label: nls.localize('startFindAction', "Find"),
    alias: 'Find',
    precondition: ContextKeyExpr.or(EditorContextKeys.focus, ContextKeyExpr.has('editorIsOpen')),
    kbOpts: {
        kbExpr: null,
        primary: 2048 /* CtrlCmd */ | 36 /* KEY_F */,
        weight: 100 /* EditorContrib */
    },
    menuOpts: {
        menuId: MenuId.MenubarEditMenu,
        group: '3_find',
        title: nls.localize({ key: 'miFind', comment: ['&& denotes a mnemonic'] }, "&&Find"),
        order: 1
    }
}));
StartFindAction.addImplementation(0, function (accessor, args) {
    var codeEditorService = accessor.get(ICodeEditorService);
    var editor = codeEditorService.getFocusedCodeEditor() || codeEditorService.getActiveCodeEditor();
    if (!editor) {
        return false;
    }
    var controller = CommonFindController.get(editor);
    if (!controller) {
        return false;
    }
    return controller.start({
        forceRevealReplace: false,
        seedSearchStringFromSelection: editor.getOption(31 /* find */).seedSearchStringFromSelection ? 'single' : 'none',
        seedSearchStringFromGlobalClipboard: editor.getOption(31 /* find */).globalFindClipboard,
        shouldFocus: 1 /* FocusFindInput */,
        shouldAnimate: true,
        updateSearchScope: false,
        loop: editor.getOption(31 /* find */).loop
    });
});
var StartFindWithSelectionAction = /** @class */ (function (_super) {
    __extends(StartFindWithSelectionAction, _super);
    function StartFindWithSelectionAction() {
        return _super.call(this, {
            id: FIND_IDS.StartFindWithSelection,
            label: nls.localize('startFindWithSelectionAction', "Find With Selection"),
            alias: 'Find With Selection',
            precondition: undefined,
            kbOpts: {
                kbExpr: null,
                primary: 0,
                mac: {
                    primary: 2048 /* CtrlCmd */ | 35 /* KEY_E */,
                },
                weight: 100 /* EditorContrib */
            }
        }) || this;
    }
    StartFindWithSelectionAction.prototype.run = function (accessor, editor) {
        return __awaiter(this, void 0, void 0, function () {
            var controller;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        controller = CommonFindController.get(editor);
                        if (!controller) return [3 /*break*/, 2];
                        return [4 /*yield*/, controller.start({
                                forceRevealReplace: false,
                                seedSearchStringFromSelection: 'multiple',
                                seedSearchStringFromGlobalClipboard: false,
                                shouldFocus: 0 /* NoFocusChange */,
                                shouldAnimate: true,
                                updateSearchScope: false,
                                loop: editor.getOption(31 /* find */).loop
                            })];
                    case 1:
                        _a.sent();
                        controller.setGlobalBufferTerm(controller.getState().searchString);
                        _a.label = 2;
                    case 2: return [2 /*return*/];
                }
            });
        });
    };
    return StartFindWithSelectionAction;
}(EditorAction));
export { StartFindWithSelectionAction };
var MatchFindAction = /** @class */ (function (_super) {
    __extends(MatchFindAction, _super);
    function MatchFindAction() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MatchFindAction.prototype.run = function (accessor, editor) {
        return __awaiter(this, void 0, void 0, function () {
            var controller;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        controller = CommonFindController.get(editor);
                        if (!(controller && !this._run(controller))) return [3 /*break*/, 2];
                        return [4 /*yield*/, controller.start({
                                forceRevealReplace: false,
                                seedSearchStringFromSelection: (controller.getState().searchString.length === 0) && editor.getOption(31 /* find */).seedSearchStringFromSelection ? 'single' : 'none',
                                seedSearchStringFromGlobalClipboard: true,
                                shouldFocus: 0 /* NoFocusChange */,
                                shouldAnimate: true,
                                updateSearchScope: false,
                                loop: editor.getOption(31 /* find */).loop
                            })];
                    case 1:
                        _a.sent();
                        this._run(controller);
                        _a.label = 2;
                    case 2: return [2 /*return*/];
                }
            });
        });
    };
    return MatchFindAction;
}(EditorAction));
export { MatchFindAction };
var NextMatchFindAction = /** @class */ (function (_super) {
    __extends(NextMatchFindAction, _super);
    function NextMatchFindAction() {
        return _super.call(this, {
            id: FIND_IDS.NextMatchFindAction,
            label: nls.localize('findNextMatchAction', "Find Next"),
            alias: 'Find Next',
            precondition: undefined,
            kbOpts: {
                kbExpr: EditorContextKeys.focus,
                primary: 61 /* F3 */,
                mac: { primary: 2048 /* CtrlCmd */ | 37 /* KEY_G */, secondary: [61 /* F3 */] },
                weight: 100 /* EditorContrib */
            }
        }) || this;
    }
    NextMatchFindAction.prototype._run = function (controller) {
        var result = controller.moveToNextMatch();
        if (result) {
            controller.editor.pushUndoStop();
            return true;
        }
        return false;
    };
    return NextMatchFindAction;
}(MatchFindAction));
export { NextMatchFindAction };
var NextMatchFindAction2 = /** @class */ (function (_super) {
    __extends(NextMatchFindAction2, _super);
    function NextMatchFindAction2() {
        return _super.call(this, {
            id: FIND_IDS.NextMatchFindAction,
            label: nls.localize('findNextMatchAction', "Find Next"),
            alias: 'Find Next',
            precondition: undefined,
            kbOpts: {
                kbExpr: ContextKeyExpr.and(EditorContextKeys.focus, CONTEXT_FIND_INPUT_FOCUSED),
                primary: 3 /* Enter */,
                weight: 100 /* EditorContrib */
            }
        }) || this;
    }
    NextMatchFindAction2.prototype._run = function (controller) {
        var result = controller.moveToNextMatch();
        if (result) {
            controller.editor.pushUndoStop();
            return true;
        }
        return false;
    };
    return NextMatchFindAction2;
}(MatchFindAction));
export { NextMatchFindAction2 };
var PreviousMatchFindAction = /** @class */ (function (_super) {
    __extends(PreviousMatchFindAction, _super);
    function PreviousMatchFindAction() {
        return _super.call(this, {
            id: FIND_IDS.PreviousMatchFindAction,
            label: nls.localize('findPreviousMatchAction', "Find Previous"),
            alias: 'Find Previous',
            precondition: undefined,
            kbOpts: {
                kbExpr: EditorContextKeys.focus,
                primary: 1024 /* Shift */ | 61 /* F3 */,
                mac: { primary: 2048 /* CtrlCmd */ | 1024 /* Shift */ | 37 /* KEY_G */, secondary: [1024 /* Shift */ | 61 /* F3 */] },
                weight: 100 /* EditorContrib */
            }
        }) || this;
    }
    PreviousMatchFindAction.prototype._run = function (controller) {
        return controller.moveToPrevMatch();
    };
    return PreviousMatchFindAction;
}(MatchFindAction));
export { PreviousMatchFindAction };
var PreviousMatchFindAction2 = /** @class */ (function (_super) {
    __extends(PreviousMatchFindAction2, _super);
    function PreviousMatchFindAction2() {
        return _super.call(this, {
            id: FIND_IDS.PreviousMatchFindAction,
            label: nls.localize('findPreviousMatchAction', "Find Previous"),
            alias: 'Find Previous',
            precondition: undefined,
            kbOpts: {
                kbExpr: ContextKeyExpr.and(EditorContextKeys.focus, CONTEXT_FIND_INPUT_FOCUSED),
                primary: 1024 /* Shift */ | 3 /* Enter */,
                weight: 100 /* EditorContrib */
            }
        }) || this;
    }
    PreviousMatchFindAction2.prototype._run = function (controller) {
        return controller.moveToPrevMatch();
    };
    return PreviousMatchFindAction2;
}(MatchFindAction));
export { PreviousMatchFindAction2 };
var SelectionMatchFindAction = /** @class */ (function (_super) {
    __extends(SelectionMatchFindAction, _super);
    function SelectionMatchFindAction() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SelectionMatchFindAction.prototype.run = function (accessor, editor) {
        return __awaiter(this, void 0, void 0, function () {
            var controller, selectionSearchString;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        controller = CommonFindController.get(editor);
                        if (!controller) {
                            return [2 /*return*/];
                        }
                        selectionSearchString = getSelectionSearchString(editor);
                        if (selectionSearchString) {
                            controller.setSearchString(selectionSearchString);
                        }
                        if (!!this._run(controller)) return [3 /*break*/, 2];
                        return [4 /*yield*/, controller.start({
                                forceRevealReplace: false,
                                seedSearchStringFromSelection: editor.getOption(31 /* find */).seedSearchStringFromSelection ? 'single' : 'none',
                                seedSearchStringFromGlobalClipboard: false,
                                shouldFocus: 0 /* NoFocusChange */,
                                shouldAnimate: true,
                                updateSearchScope: false,
                                loop: editor.getOption(31 /* find */).loop
                            })];
                    case 1:
                        _a.sent();
                        this._run(controller);
                        _a.label = 2;
                    case 2: return [2 /*return*/];
                }
            });
        });
    };
    return SelectionMatchFindAction;
}(EditorAction));
export { SelectionMatchFindAction };
var NextSelectionMatchFindAction = /** @class */ (function (_super) {
    __extends(NextSelectionMatchFindAction, _super);
    function NextSelectionMatchFindAction() {
        return _super.call(this, {
            id: FIND_IDS.NextSelectionMatchFindAction,
            label: nls.localize('nextSelectionMatchFindAction', "Find Next Selection"),
            alias: 'Find Next Selection',
            precondition: undefined,
            kbOpts: {
                kbExpr: EditorContextKeys.focus,
                primary: 2048 /* CtrlCmd */ | 61 /* F3 */,
                weight: 100 /* EditorContrib */
            }
        }) || this;
    }
    NextSelectionMatchFindAction.prototype._run = function (controller) {
        return controller.moveToNextMatch();
    };
    return NextSelectionMatchFindAction;
}(SelectionMatchFindAction));
export { NextSelectionMatchFindAction };
var PreviousSelectionMatchFindAction = /** @class */ (function (_super) {
    __extends(PreviousSelectionMatchFindAction, _super);
    function PreviousSelectionMatchFindAction() {
        return _super.call(this, {
            id: FIND_IDS.PreviousSelectionMatchFindAction,
            label: nls.localize('previousSelectionMatchFindAction', "Find Previous Selection"),
            alias: 'Find Previous Selection',
            precondition: undefined,
            kbOpts: {
                kbExpr: EditorContextKeys.focus,
                primary: 2048 /* CtrlCmd */ | 1024 /* Shift */ | 61 /* F3 */,
                weight: 100 /* EditorContrib */
            }
        }) || this;
    }
    PreviousSelectionMatchFindAction.prototype._run = function (controller) {
        return controller.moveToPrevMatch();
    };
    return PreviousSelectionMatchFindAction;
}(SelectionMatchFindAction));
export { PreviousSelectionMatchFindAction };
export var StartFindReplaceAction = registerMultiEditorAction(new MultiEditorAction({
    id: FIND_IDS.StartFindReplaceAction,
    label: nls.localize('startReplace', "Replace"),
    alias: 'Replace',
    precondition: ContextKeyExpr.or(EditorContextKeys.focus, ContextKeyExpr.has('editorIsOpen')),
    kbOpts: {
        kbExpr: null,
        primary: 2048 /* CtrlCmd */ | 38 /* KEY_H */,
        mac: { primary: 2048 /* CtrlCmd */ | 512 /* Alt */ | 36 /* KEY_F */ },
        weight: 100 /* EditorContrib */
    },
    menuOpts: {
        menuId: MenuId.MenubarEditMenu,
        group: '3_find',
        title: nls.localize({ key: 'miReplace', comment: ['&& denotes a mnemonic'] }, "&&Replace"),
        order: 2
    }
}));
StartFindReplaceAction.addImplementation(0, function (accessor, args) {
    var codeEditorService = accessor.get(ICodeEditorService);
    var editor = codeEditorService.getFocusedCodeEditor() || codeEditorService.getActiveCodeEditor();
    if (!editor || !editor.hasModel() || editor.getOption(75 /* readOnly */)) {
        return false;
    }
    var controller = CommonFindController.get(editor);
    if (!controller) {
        return false;
    }
    var currentSelection = editor.getSelection();
    var findInputFocused = controller.isFindInputFocused();
    // we only seed search string from selection when the current selection is single line and not empty,
    // + the find input is not focused
    var seedSearchStringFromSelection = !currentSelection.isEmpty()
        && currentSelection.startLineNumber === currentSelection.endLineNumber && editor.getOption(31 /* find */).seedSearchStringFromSelection
        && !findInputFocused;
    /*
    * if the existing search string in find widget is empty and we don't seed search string from selection, it means the Find Input is still empty, so we should focus the Find Input instead of Replace Input.

    * findInputFocused true -> seedSearchStringFromSelection false, FocusReplaceInput
    * findInputFocused false, seedSearchStringFromSelection true FocusReplaceInput
    * findInputFocused false seedSearchStringFromSelection false FocusFindInput
    */
    var shouldFocus = (findInputFocused || seedSearchStringFromSelection) ?
        2 /* FocusReplaceInput */ : 1 /* FocusFindInput */;
    return controller.start({
        forceRevealReplace: true,
        seedSearchStringFromSelection: seedSearchStringFromSelection ? 'single' : 'none',
        seedSearchStringFromGlobalClipboard: editor.getOption(31 /* find */).seedSearchStringFromSelection,
        shouldFocus: shouldFocus,
        shouldAnimate: true,
        updateSearchScope: false,
        loop: editor.getOption(31 /* find */).loop
    });
});
registerEditorContribution(CommonFindController.ID, FindController);
registerEditorAction(StartFindWithSelectionAction);
registerEditorAction(NextMatchFindAction);
registerEditorAction(NextMatchFindAction2);
registerEditorAction(PreviousMatchFindAction);
registerEditorAction(PreviousMatchFindAction2);
registerEditorAction(NextSelectionMatchFindAction);
registerEditorAction(PreviousSelectionMatchFindAction);
var FindCommand = EditorCommand.bindToContribution(CommonFindController.get);
registerEditorCommand(new FindCommand({
    id: FIND_IDS.CloseFindWidgetCommand,
    precondition: CONTEXT_FIND_WIDGET_VISIBLE,
    handler: function (x) { return x.closeFindWidget(); },
    kbOpts: {
        weight: 100 /* EditorContrib */ + 5,
        kbExpr: ContextKeyExpr.and(EditorContextKeys.focus, ContextKeyExpr.not('isComposing')),
        primary: 9 /* Escape */,
        secondary: [1024 /* Shift */ | 9 /* Escape */]
    }
}));
registerEditorCommand(new FindCommand({
    id: FIND_IDS.ToggleCaseSensitiveCommand,
    precondition: undefined,
    handler: function (x) { return x.toggleCaseSensitive(); },
    kbOpts: {
        weight: 100 /* EditorContrib */ + 5,
        kbExpr: EditorContextKeys.focus,
        primary: ToggleCaseSensitiveKeybinding.primary,
        mac: ToggleCaseSensitiveKeybinding.mac,
        win: ToggleCaseSensitiveKeybinding.win,
        linux: ToggleCaseSensitiveKeybinding.linux
    }
}));
registerEditorCommand(new FindCommand({
    id: FIND_IDS.ToggleWholeWordCommand,
    precondition: undefined,
    handler: function (x) { return x.toggleWholeWords(); },
    kbOpts: {
        weight: 100 /* EditorContrib */ + 5,
        kbExpr: EditorContextKeys.focus,
        primary: ToggleWholeWordKeybinding.primary,
        mac: ToggleWholeWordKeybinding.mac,
        win: ToggleWholeWordKeybinding.win,
        linux: ToggleWholeWordKeybinding.linux
    }
}));
registerEditorCommand(new FindCommand({
    id: FIND_IDS.ToggleRegexCommand,
    precondition: undefined,
    handler: function (x) { return x.toggleRegex(); },
    kbOpts: {
        weight: 100 /* EditorContrib */ + 5,
        kbExpr: EditorContextKeys.focus,
        primary: ToggleRegexKeybinding.primary,
        mac: ToggleRegexKeybinding.mac,
        win: ToggleRegexKeybinding.win,
        linux: ToggleRegexKeybinding.linux
    }
}));
registerEditorCommand(new FindCommand({
    id: FIND_IDS.ToggleSearchScopeCommand,
    precondition: undefined,
    handler: function (x) { return x.toggleSearchScope(); },
    kbOpts: {
        weight: 100 /* EditorContrib */ + 5,
        kbExpr: EditorContextKeys.focus,
        primary: ToggleSearchScopeKeybinding.primary,
        mac: ToggleSearchScopeKeybinding.mac,
        win: ToggleSearchScopeKeybinding.win,
        linux: ToggleSearchScopeKeybinding.linux
    }
}));
registerEditorCommand(new FindCommand({
    id: FIND_IDS.TogglePreserveCaseCommand,
    precondition: undefined,
    handler: function (x) { return x.togglePreserveCase(); },
    kbOpts: {
        weight: 100 /* EditorContrib */ + 5,
        kbExpr: EditorContextKeys.focus,
        primary: TogglePreserveCaseKeybinding.primary,
        mac: TogglePreserveCaseKeybinding.mac,
        win: TogglePreserveCaseKeybinding.win,
        linux: TogglePreserveCaseKeybinding.linux
    }
}));
registerEditorCommand(new FindCommand({
    id: FIND_IDS.ReplaceOneAction,
    precondition: CONTEXT_FIND_WIDGET_VISIBLE,
    handler: function (x) { return x.replace(); },
    kbOpts: {
        weight: 100 /* EditorContrib */ + 5,
        kbExpr: EditorContextKeys.focus,
        primary: 2048 /* CtrlCmd */ | 1024 /* Shift */ | 22 /* KEY_1 */
    }
}));
registerEditorCommand(new FindCommand({
    id: FIND_IDS.ReplaceOneAction,
    precondition: CONTEXT_FIND_WIDGET_VISIBLE,
    handler: function (x) { return x.replace(); },
    kbOpts: {
        weight: 100 /* EditorContrib */ + 5,
        kbExpr: ContextKeyExpr.and(EditorContextKeys.focus, CONTEXT_REPLACE_INPUT_FOCUSED),
        primary: 3 /* Enter */
    }
}));
registerEditorCommand(new FindCommand({
    id: FIND_IDS.ReplaceAllAction,
    precondition: CONTEXT_FIND_WIDGET_VISIBLE,
    handler: function (x) { return x.replaceAll(); },
    kbOpts: {
        weight: 100 /* EditorContrib */ + 5,
        kbExpr: EditorContextKeys.focus,
        primary: 2048 /* CtrlCmd */ | 512 /* Alt */ | 3 /* Enter */
    }
}));
registerEditorCommand(new FindCommand({
    id: FIND_IDS.ReplaceAllAction,
    precondition: CONTEXT_FIND_WIDGET_VISIBLE,
    handler: function (x) { return x.replaceAll(); },
    kbOpts: {
        weight: 100 /* EditorContrib */ + 5,
        kbExpr: ContextKeyExpr.and(EditorContextKeys.focus, CONTEXT_REPLACE_INPUT_FOCUSED),
        primary: undefined,
        mac: {
            primary: 2048 /* CtrlCmd */ | 3 /* Enter */,
        }
    }
}));
registerEditorCommand(new FindCommand({
    id: FIND_IDS.SelectAllMatchesAction,
    precondition: CONTEXT_FIND_WIDGET_VISIBLE,
    handler: function (x) { return x.selectAllMatches(); },
    kbOpts: {
        weight: 100 /* EditorContrib */ + 5,
        kbExpr: EditorContextKeys.focus,
        primary: 512 /* Alt */ | 3 /* Enter */
    }
}));
