/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import { CancellationToken } from '../../../base/common/cancellation';
import { illegalArgument } from '../../../base/common/errors';
import { URI } from '../../../base/common/uri';
import { Range } from '../../common/core/range';
import { ColorProviderRegistry } from '../../common/modes';
import { IModelService } from '../../common/services/modelService';
import { CommandsRegistry } from '../../../platform/commands/common/commands';
export function getColors(model, token) {
    var colors = [];
    var providers = ColorProviderRegistry.ordered(model).reverse();
    var promises = providers.map(function (provider) { return Promise.resolve(provider.provideDocumentColors(model, token)).then(function (result) {
        var e_1, _a;
        if (Array.isArray(result)) {
            try {
                for (var result_1 = __values(result), result_1_1 = result_1.next(); !result_1_1.done; result_1_1 = result_1.next()) {
                    var colorInfo = result_1_1.value;
                    colors.push({ colorInfo: colorInfo, provider: provider });
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (result_1_1 && !result_1_1.done && (_a = result_1.return)) _a.call(result_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
    }); });
    return Promise.all(promises).then(function () { return colors; });
}
export function getColorPresentations(model, colorInfo, provider, token) {
    return Promise.resolve(provider.provideColorPresentations(model, colorInfo, token));
}
CommandsRegistry.registerCommand('_executeDocumentColorProvider', function (accessor) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    var _a = __read(args, 1), resource = _a[0];
    if (!(resource instanceof URI)) {
        throw illegalArgument();
    }
    var model = accessor.get(IModelService).getModel(resource);
    if (!model) {
        throw illegalArgument();
    }
    var rawCIs = [];
    var providers = ColorProviderRegistry.ordered(model).reverse();
    var promises = providers.map(function (provider) { return Promise.resolve(provider.provideDocumentColors(model, CancellationToken.None)).then(function (result) {
        var e_2, _a;
        if (Array.isArray(result)) {
            try {
                for (var result_2 = __values(result), result_2_1 = result_2.next(); !result_2_1.done; result_2_1 = result_2.next()) {
                    var ci = result_2_1.value;
                    rawCIs.push({ range: ci.range, color: [ci.color.red, ci.color.green, ci.color.blue, ci.color.alpha] });
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (result_2_1 && !result_2_1.done && (_a = result_2.return)) _a.call(result_2);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
    }); });
    return Promise.all(promises).then(function () { return rawCIs; });
});
CommandsRegistry.registerCommand('_executeColorPresentationProvider', function (accessor) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    var _a = __read(args, 2), color = _a[0], context = _a[1];
    var uri = context.uri, range = context.range;
    if (!(uri instanceof URI) || !Array.isArray(color) || color.length !== 4 || !Range.isIRange(range)) {
        throw illegalArgument();
    }
    var _b = __read(color, 4), red = _b[0], green = _b[1], blue = _b[2], alpha = _b[3];
    var model = accessor.get(IModelService).getModel(uri);
    if (!model) {
        throw illegalArgument();
    }
    var colorInfo = {
        range: range,
        color: { red: red, green: green, blue: blue, alpha: alpha }
    };
    var presentations = [];
    var providers = ColorProviderRegistry.ordered(model).reverse();
    var promises = providers.map(function (provider) { return Promise.resolve(provider.provideColorPresentations(model, colorInfo, CancellationToken.None)).then(function (result) {
        if (Array.isArray(result)) {
            presentations.push.apply(presentations, __spreadArray([], __read(result)));
        }
    }); });
    return Promise.all(promises).then(function () { return presentations; });
});
