/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import './media/tree.css';
import { dispose, Disposable, toDisposable, DisposableStore } from '../../../common/lifecycle';
import { List, MouseController, DefaultKeyboardNavigationDelegate, isInputElement, isMonacoEditor } from '../list/listWidget';
import { append, $, getDomNodePagePosition, hasParentWithClass, createStyleSheet, clearNode } from '../../dom';
import { Event, Relay, Emitter, EventBufferer } from '../../../common/event';
import { StandardKeyboardEvent } from '../../keyboardEvent';
import { TreeMouseEventTarget } from './tree';
import { StaticDND, DragAndDropData } from '../../dnd';
import { range, equals, distinctES6 } from '../../../common/arrays';
import { ElementsDragAndDropData } from '../list/listView';
import { domEvent } from '../../event';
import { fuzzyScore, FuzzyScore } from '../../../common/filters';
import { getVisibleState, isFilterResult } from './indexTreeModel';
import { localize } from '../../../../nls';
import { disposableTimeout } from '../../../common/async';
import { isMacintosh } from '../../../common/platform';
import { clamp } from '../../../common/numbers';
import { SetMap } from '../../../common/collections';
import { treeItemExpandedIcon, treeFilterOnTypeOnIcon, treeFilterOnTypeOffIcon, treeFilterClearIcon } from './treeIcons';
var TreeElementsDragAndDropData = /** @class */ (function (_super) {
    __extends(TreeElementsDragAndDropData, _super);
    function TreeElementsDragAndDropData(data) {
        var _this = _super.call(this, data.elements.map(function (node) { return node.element; })) || this;
        _this.data = data;
        return _this;
    }
    Object.defineProperty(TreeElementsDragAndDropData.prototype, "context", {
        get: function () {
            return this.data.context;
        },
        set: function (context) {
            this.data.context = context;
        },
        enumerable: false,
        configurable: true
    });
    return TreeElementsDragAndDropData;
}(ElementsDragAndDropData));
function asTreeDragAndDropData(data) {
    if (data instanceof ElementsDragAndDropData) {
        return new TreeElementsDragAndDropData(data);
    }
    return data;
}
var TreeNodeListDragAndDrop = /** @class */ (function () {
    function TreeNodeListDragAndDrop(modelProvider, dnd) {
        this.modelProvider = modelProvider;
        this.dnd = dnd;
        this.autoExpandDisposable = Disposable.None;
    }
    TreeNodeListDragAndDrop.prototype.getDragURI = function (node) {
        return this.dnd.getDragURI(node.element);
    };
    TreeNodeListDragAndDrop.prototype.getDragLabel = function (nodes, originalEvent) {
        if (this.dnd.getDragLabel) {
            return this.dnd.getDragLabel(nodes.map(function (node) { return node.element; }), originalEvent);
        }
        return undefined;
    };
    TreeNodeListDragAndDrop.prototype.onDragStart = function (data, originalEvent) {
        if (this.dnd.onDragStart) {
            this.dnd.onDragStart(asTreeDragAndDropData(data), originalEvent);
        }
    };
    TreeNodeListDragAndDrop.prototype.onDragOver = function (data, targetNode, targetIndex, originalEvent, raw) {
        var _this = this;
        if (raw === void 0) { raw = true; }
        var result = this.dnd.onDragOver(asTreeDragAndDropData(data), targetNode && targetNode.element, targetIndex, originalEvent);
        var didChangeAutoExpandNode = this.autoExpandNode !== targetNode;
        if (didChangeAutoExpandNode) {
            this.autoExpandDisposable.dispose();
            this.autoExpandNode = targetNode;
        }
        if (typeof targetNode === 'undefined') {
            return result;
        }
        if (didChangeAutoExpandNode && typeof result !== 'boolean' && result.autoExpand) {
            this.autoExpandDisposable = disposableTimeout(function () {
                var model = _this.modelProvider();
                var ref = model.getNodeLocation(targetNode);
                if (model.isCollapsed(ref)) {
                    model.setCollapsed(ref, false);
                }
                _this.autoExpandNode = undefined;
            }, 500);
        }
        if (typeof result === 'boolean' || !result.accept || typeof result.bubble === 'undefined' || result.feedback) {
            if (!raw) {
                var accept = typeof result === 'boolean' ? result : result.accept;
                var effect = typeof result === 'boolean' ? undefined : result.effect;
                return { accept: accept, effect: effect, feedback: [targetIndex] };
            }
            return result;
        }
        if (result.bubble === 1 /* Up */) {
            var model_1 = this.modelProvider();
            var ref_1 = model_1.getNodeLocation(targetNode);
            var parentRef = model_1.getParentNodeLocation(ref_1);
            var parentNode = model_1.getNode(parentRef);
            var parentIndex = parentRef && model_1.getListIndex(parentRef);
            return this.onDragOver(data, parentNode, parentIndex, originalEvent, false);
        }
        var model = this.modelProvider();
        var ref = model.getNodeLocation(targetNode);
        var start = model.getListIndex(ref);
        var length = model.getListRenderCount(ref);
        return __assign(__assign({}, result), { feedback: range(start, start + length) });
    };
    TreeNodeListDragAndDrop.prototype.drop = function (data, targetNode, targetIndex, originalEvent) {
        this.autoExpandDisposable.dispose();
        this.autoExpandNode = undefined;
        this.dnd.drop(asTreeDragAndDropData(data), targetNode && targetNode.element, targetIndex, originalEvent);
    };
    TreeNodeListDragAndDrop.prototype.onDragEnd = function (originalEvent) {
        if (this.dnd.onDragEnd) {
            this.dnd.onDragEnd(originalEvent);
        }
    };
    return TreeNodeListDragAndDrop;
}());
function asListOptions(modelProvider, options) {
    return options && __assign(__assign({}, options), { identityProvider: options.identityProvider && {
            getId: function (el) {
                return options.identityProvider.getId(el.element);
            }
        }, dnd: options.dnd && new TreeNodeListDragAndDrop(modelProvider, options.dnd), multipleSelectionController: options.multipleSelectionController && {
            isSelectionSingleChangeEvent: function (e) {
                return options.multipleSelectionController.isSelectionSingleChangeEvent(__assign(__assign({}, e), { element: e.element }));
            },
            isSelectionRangeChangeEvent: function (e) {
                return options.multipleSelectionController.isSelectionRangeChangeEvent(__assign(__assign({}, e), { element: e.element }));
            }
        }, accessibilityProvider: options.accessibilityProvider && __assign(__assign({}, options.accessibilityProvider), { getSetSize: function (node) {
                var model = modelProvider();
                var ref = model.getNodeLocation(node);
                var parentRef = model.getParentNodeLocation(ref);
                var parentNode = model.getNode(parentRef);
                return parentNode.visibleChildrenCount;
            },
            getPosInSet: function (node) {
                return node.visibleChildIndex + 1;
            }, isChecked: options.accessibilityProvider && options.accessibilityProvider.isChecked ? function (node) {
                return options.accessibilityProvider.isChecked(node.element);
            } : undefined, getRole: options.accessibilityProvider && options.accessibilityProvider.getRole ? function (node) {
                return options.accessibilityProvider.getRole(node.element);
            } : function () { return 'treeitem'; }, getAriaLabel: function (e) {
                return options.accessibilityProvider.getAriaLabel(e.element);
            },
            getWidgetAriaLabel: function () {
                return options.accessibilityProvider.getWidgetAriaLabel();
            }, getWidgetRole: options.accessibilityProvider && options.accessibilityProvider.getWidgetRole ? function () { return options.accessibilityProvider.getWidgetRole(); } : function () { return 'tree'; }, getAriaLevel: options.accessibilityProvider && options.accessibilityProvider.getAriaLevel ? function (node) { return options.accessibilityProvider.getAriaLevel(node.element); } : function (node) {
                return node.depth;
            }, getActiveDescendantId: options.accessibilityProvider.getActiveDescendantId && (function (node) {
                return options.accessibilityProvider.getActiveDescendantId(node.element);
            }) }), keyboardNavigationLabelProvider: options.keyboardNavigationLabelProvider && __assign(__assign({}, options.keyboardNavigationLabelProvider), { getKeyboardNavigationLabel: function (node) {
                return options.keyboardNavigationLabelProvider.getKeyboardNavigationLabel(node.element);
            } }), enableKeyboardNavigation: options.simpleKeyboardNavigation });
}
var ComposedTreeDelegate = /** @class */ (function () {
    function ComposedTreeDelegate(delegate) {
        this.delegate = delegate;
    }
    ComposedTreeDelegate.prototype.getHeight = function (element) {
        return this.delegate.getHeight(element.element);
    };
    ComposedTreeDelegate.prototype.getTemplateId = function (element) {
        return this.delegate.getTemplateId(element.element);
    };
    ComposedTreeDelegate.prototype.hasDynamicHeight = function (element) {
        return !!this.delegate.hasDynamicHeight && this.delegate.hasDynamicHeight(element.element);
    };
    ComposedTreeDelegate.prototype.setDynamicHeight = function (element, height) {
        if (this.delegate.setDynamicHeight) {
            this.delegate.setDynamicHeight(element.element, height);
        }
    };
    return ComposedTreeDelegate;
}());
export { ComposedTreeDelegate };
export var RenderIndentGuides;
(function (RenderIndentGuides) {
    RenderIndentGuides["None"] = "none";
    RenderIndentGuides["OnHover"] = "onHover";
    RenderIndentGuides["Always"] = "always";
})(RenderIndentGuides || (RenderIndentGuides = {}));
var EventCollection = /** @class */ (function () {
    function EventCollection(onDidChange, _elements) {
        var _this = this;
        if (_elements === void 0) { _elements = []; }
        this._elements = _elements;
        this.onDidChange = Event.forEach(onDidChange, function (elements) { return _this._elements = elements; });
    }
    Object.defineProperty(EventCollection.prototype, "elements", {
        get: function () {
            return this._elements;
        },
        enumerable: false,
        configurable: true
    });
    return EventCollection;
}());
var TreeRenderer = /** @class */ (function () {
    function TreeRenderer(renderer, modelProvider, onDidChangeCollapseState, activeNodes, options) {
        if (options === void 0) { options = {}; }
        this.renderer = renderer;
        this.modelProvider = modelProvider;
        this.activeNodes = activeNodes;
        this.renderedElements = new Map();
        this.renderedNodes = new Map();
        this.indent = TreeRenderer.DefaultIndent;
        this.hideTwistiesOfChildlessElements = false;
        this.shouldRenderIndentGuides = false;
        this.renderedIndentGuides = new SetMap();
        this.activeIndentNodes = new Set();
        this.indentGuidesDisposable = Disposable.None;
        this.disposables = new DisposableStore();
        this.templateId = renderer.templateId;
        this.updateOptions(options);
        Event.map(onDidChangeCollapseState, function (e) { return e.node; })(this.onDidChangeNodeTwistieState, this, this.disposables);
        if (renderer.onDidChangeTwistieState) {
            renderer.onDidChangeTwistieState(this.onDidChangeTwistieState, this, this.disposables);
        }
    }
    TreeRenderer.prototype.updateOptions = function (options) {
        if (options === void 0) { options = {}; }
        if (typeof options.indent !== 'undefined') {
            this.indent = clamp(options.indent, 0, 40);
        }
        if (typeof options.renderIndentGuides !== 'undefined') {
            var shouldRenderIndentGuides = options.renderIndentGuides !== RenderIndentGuides.None;
            if (shouldRenderIndentGuides !== this.shouldRenderIndentGuides) {
                this.shouldRenderIndentGuides = shouldRenderIndentGuides;
                this.indentGuidesDisposable.dispose();
                if (shouldRenderIndentGuides) {
                    var disposables = new DisposableStore();
                    this.activeNodes.onDidChange(this._onDidChangeActiveNodes, this, disposables);
                    this.indentGuidesDisposable = disposables;
                    this._onDidChangeActiveNodes(this.activeNodes.elements);
                }
            }
        }
        if (typeof options.hideTwistiesOfChildlessElements !== 'undefined') {
            this.hideTwistiesOfChildlessElements = options.hideTwistiesOfChildlessElements;
        }
    };
    TreeRenderer.prototype.renderTemplate = function (container) {
        var el = append(container, $('.monaco-tl-row'));
        var indent = append(el, $('.monaco-tl-indent'));
        var twistie = append(el, $('.monaco-tl-twistie'));
        var contents = append(el, $('.monaco-tl-contents'));
        var templateData = this.renderer.renderTemplate(contents);
        return { container: container, indent: indent, twistie: twistie, indentGuidesDisposable: Disposable.None, templateData: templateData };
    };
    TreeRenderer.prototype.renderElement = function (node, index, templateData, height) {
        if (typeof height === 'number') {
            this.renderedNodes.set(node, { templateData: templateData, height: height });
            this.renderedElements.set(node.element, node);
        }
        var indent = TreeRenderer.DefaultIndent + (node.depth - 1) * this.indent;
        templateData.twistie.style.paddingLeft = indent + "px";
        templateData.indent.style.width = indent + this.indent - 16 + "px";
        this.renderTwistie(node, templateData);
        if (typeof height === 'number') {
            this.renderIndentGuides(node, templateData);
        }
        this.renderer.renderElement(node, index, templateData.templateData, height);
    };
    TreeRenderer.prototype.disposeElement = function (node, index, templateData, height) {
        templateData.indentGuidesDisposable.dispose();
        if (this.renderer.disposeElement) {
            this.renderer.disposeElement(node, index, templateData.templateData, height);
        }
        if (typeof height === 'number') {
            this.renderedNodes.delete(node);
            this.renderedElements.delete(node.element);
        }
    };
    TreeRenderer.prototype.disposeTemplate = function (templateData) {
        this.renderer.disposeTemplate(templateData.templateData);
    };
    TreeRenderer.prototype.onDidChangeTwistieState = function (element) {
        var node = this.renderedElements.get(element);
        if (!node) {
            return;
        }
        this.onDidChangeNodeTwistieState(node);
    };
    TreeRenderer.prototype.onDidChangeNodeTwistieState = function (node) {
        var data = this.renderedNodes.get(node);
        if (!data) {
            return;
        }
        this.renderTwistie(node, data.templateData);
        this._onDidChangeActiveNodes(this.activeNodes.elements);
        this.renderIndentGuides(node, data.templateData);
    };
    TreeRenderer.prototype.renderTwistie = function (node, templateData) {
        var _a, _b;
        (_a = templateData.twistie.classList).remove.apply(_a, __spreadArray([], __read(treeItemExpandedIcon.classNamesArray)));
        var twistieRendered = false;
        if (this.renderer.renderTwistie) {
            twistieRendered = this.renderer.renderTwistie(node.element, templateData.twistie);
        }
        if (node.collapsible && (!this.hideTwistiesOfChildlessElements || node.visibleChildrenCount > 0)) {
            if (!twistieRendered) {
                (_b = templateData.twistie.classList).add.apply(_b, __spreadArray([], __read(treeItemExpandedIcon.classNamesArray)));
            }
            templateData.twistie.classList.add('collapsible');
            templateData.twistie.classList.toggle('collapsed', node.collapsed);
        }
        else {
            templateData.twistie.classList.remove('collapsible', 'collapsed');
        }
        if (node.collapsible) {
            templateData.container.setAttribute('aria-expanded', String(!node.collapsed));
        }
        else {
            templateData.container.removeAttribute('aria-expanded');
        }
    };
    TreeRenderer.prototype.renderIndentGuides = function (target, templateData) {
        var _this = this;
        clearNode(templateData.indent);
        templateData.indentGuidesDisposable.dispose();
        if (!this.shouldRenderIndentGuides) {
            return;
        }
        var disposableStore = new DisposableStore();
        var model = this.modelProvider();
        var node = target;
        var _loop_1 = function () {
            var ref = model.getNodeLocation(node);
            var parentRef = model.getParentNodeLocation(ref);
            if (!parentRef) {
                return "break";
            }
            var parent_1 = model.getNode(parentRef);
            var guide = $('.indent-guide', { style: "width: " + this_1.indent + "px" });
            if (this_1.activeIndentNodes.has(parent_1)) {
                guide.classList.add('active');
            }
            if (templateData.indent.childElementCount === 0) {
                templateData.indent.appendChild(guide);
            }
            else {
                templateData.indent.insertBefore(guide, templateData.indent.firstElementChild);
            }
            this_1.renderedIndentGuides.add(parent_1, guide);
            disposableStore.add(toDisposable(function () { return _this.renderedIndentGuides.delete(parent_1, guide); }));
            node = parent_1;
        };
        var this_1 = this;
        while (true) {
            var state_1 = _loop_1();
            if (state_1 === "break")
                break;
        }
        templateData.indentGuidesDisposable = disposableStore;
    };
    TreeRenderer.prototype._onDidChangeActiveNodes = function (nodes) {
        var _this = this;
        if (!this.shouldRenderIndentGuides) {
            return;
        }
        var set = new Set();
        var model = this.modelProvider();
        nodes.forEach(function (node) {
            var ref = model.getNodeLocation(node);
            try {
                var parentRef = model.getParentNodeLocation(ref);
                if (node.collapsible && node.children.length > 0 && !node.collapsed) {
                    set.add(node);
                }
                else if (parentRef) {
                    set.add(model.getNode(parentRef));
                }
            }
            catch (_a) {
                // noop
            }
        });
        this.activeIndentNodes.forEach(function (node) {
            if (!set.has(node)) {
                _this.renderedIndentGuides.forEach(node, function (line) { return line.classList.remove('active'); });
            }
        });
        set.forEach(function (node) {
            if (!_this.activeIndentNodes.has(node)) {
                _this.renderedIndentGuides.forEach(node, function (line) { return line.classList.add('active'); });
            }
        });
        this.activeIndentNodes = set;
    };
    TreeRenderer.prototype.dispose = function () {
        this.renderedNodes.clear();
        this.renderedElements.clear();
        this.indentGuidesDisposable.dispose();
        dispose(this.disposables);
    };
    TreeRenderer.DefaultIndent = 8;
    return TreeRenderer;
}());
var TypeFilter = /** @class */ (function () {
    function TypeFilter(tree, keyboardNavigationLabelProvider, _filter) {
        this.tree = tree;
        this.keyboardNavigationLabelProvider = keyboardNavigationLabelProvider;
        this._filter = _filter;
        this._totalCount = 0;
        this._matchCount = 0;
        this._pattern = '';
        this._lowercasePattern = '';
        this.disposables = new DisposableStore();
        tree.onWillRefilter(this.reset, this, this.disposables);
    }
    Object.defineProperty(TypeFilter.prototype, "totalCount", {
        get: function () { return this._totalCount; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TypeFilter.prototype, "matchCount", {
        get: function () { return this._matchCount; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TypeFilter.prototype, "pattern", {
        set: function (pattern) {
            this._pattern = pattern;
            this._lowercasePattern = pattern.toLowerCase();
        },
        enumerable: false,
        configurable: true
    });
    TypeFilter.prototype.filter = function (element, parentVisibility) {
        var e_1, _a;
        if (this._filter) {
            var result = this._filter.filter(element, parentVisibility);
            if (this.tree.options.simpleKeyboardNavigation) {
                return result;
            }
            var visibility = void 0;
            if (typeof result === 'boolean') {
                visibility = result ? 1 /* Visible */ : 0 /* Hidden */;
            }
            else if (isFilterResult(result)) {
                visibility = getVisibleState(result.visibility);
            }
            else {
                visibility = result;
            }
            if (visibility === 0 /* Hidden */) {
                return false;
            }
        }
        this._totalCount++;
        if (this.tree.options.simpleKeyboardNavigation || !this._pattern) {
            this._matchCount++;
            return { data: FuzzyScore.Default, visibility: true };
        }
        var label = this.keyboardNavigationLabelProvider.getKeyboardNavigationLabel(element);
        var labels = Array.isArray(label) ? label : [label];
        try {
            for (var labels_1 = __values(labels), labels_1_1 = labels_1.next(); !labels_1_1.done; labels_1_1 = labels_1.next()) {
                var l = labels_1_1.value;
                var labelStr = l && l.toString();
                if (typeof labelStr === 'undefined') {
                    return { data: FuzzyScore.Default, visibility: true };
                }
                var score = fuzzyScore(this._pattern, this._lowercasePattern, 0, labelStr, labelStr.toLowerCase(), 0, true);
                if (score) {
                    this._matchCount++;
                    return labels.length === 1 ?
                        { data: score, visibility: true } :
                        { data: { label: labelStr, score: score }, visibility: true };
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (labels_1_1 && !labels_1_1.done && (_a = labels_1.return)) _a.call(labels_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (this.tree.options.filterOnType) {
            return 2 /* Recurse */;
        }
        else {
            return { data: FuzzyScore.Default, visibility: true };
        }
    };
    TypeFilter.prototype.reset = function () {
        this._totalCount = 0;
        this._matchCount = 0;
    };
    TypeFilter.prototype.dispose = function () {
        dispose(this.disposables);
    };
    return TypeFilter;
}());
var TypeFilterController = /** @class */ (function () {
    function TypeFilterController(tree, model, view, filter, keyboardNavigationDelegate) {
        this.tree = tree;
        this.view = view;
        this.filter = filter;
        this.keyboardNavigationDelegate = keyboardNavigationDelegate;
        this._enabled = false;
        this._pattern = '';
        this._empty = false;
        this._onDidChangeEmptyState = new Emitter();
        this.onDidChangeEmptyState = Event.latch(this._onDidChangeEmptyState.event);
        this.positionClassName = 'ne';
        this.automaticKeyboardNavigation = true;
        this.triggered = false;
        this._onDidChangePattern = new Emitter();
        this.onDidChangePattern = this._onDidChangePattern.event;
        this.enabledDisposables = new DisposableStore();
        this.disposables = new DisposableStore();
        this.domNode = $(".monaco-list-type-filter." + this.positionClassName);
        this.domNode.draggable = true;
        domEvent(this.domNode, 'dragstart')(this.onDragStart, this, this.disposables);
        this.messageDomNode = append(view.getHTMLElement(), $(".monaco-list-type-filter-message"));
        this.labelDomNode = append(this.domNode, $('span.label'));
        var controls = append(this.domNode, $('.controls'));
        this._filterOnType = !!tree.options.filterOnType;
        this.filterOnTypeDomNode = append(controls, $('input.filter'));
        this.filterOnTypeDomNode.type = 'checkbox';
        this.filterOnTypeDomNode.checked = this._filterOnType;
        this.filterOnTypeDomNode.tabIndex = -1;
        this.updateFilterOnTypeTitleAndIcon();
        domEvent(this.filterOnTypeDomNode, 'input')(this.onDidChangeFilterOnType, this, this.disposables);
        this.clearDomNode = append(controls, $('button.clear' + treeFilterClearIcon.cssSelector));
        this.clearDomNode.tabIndex = -1;
        this.clearDomNode.title = localize('clear', "Clear");
        this.keyboardNavigationEventFilter = tree.options.keyboardNavigationEventFilter;
        model.onDidSplice(this.onDidSpliceModel, this, this.disposables);
        this.updateOptions(tree.options);
    }
    Object.defineProperty(TypeFilterController.prototype, "enabled", {
        get: function () { return this._enabled; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TypeFilterController.prototype, "pattern", {
        get: function () { return this._pattern; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TypeFilterController.prototype, "filterOnType", {
        get: function () { return this._filterOnType; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TypeFilterController.prototype, "empty", {
        get: function () { return this._empty; },
        enumerable: false,
        configurable: true
    });
    TypeFilterController.prototype.updateOptions = function (options) {
        if (options.simpleKeyboardNavigation) {
            this.disable();
        }
        else {
            this.enable();
        }
        if (typeof options.filterOnType !== 'undefined') {
            this._filterOnType = !!options.filterOnType;
            this.filterOnTypeDomNode.checked = this._filterOnType;
        }
        if (typeof options.automaticKeyboardNavigation !== 'undefined') {
            this.automaticKeyboardNavigation = options.automaticKeyboardNavigation;
        }
        this.tree.refilter();
        this.render();
        if (!this.automaticKeyboardNavigation) {
            this.onEventOrInput('');
        }
    };
    TypeFilterController.prototype.toggle = function () {
        this.triggered = !this.triggered;
        if (!this.triggered) {
            this.onEventOrInput('');
        }
    };
    TypeFilterController.prototype.enable = function () {
        var _this = this;
        if (this._enabled) {
            return;
        }
        var onKeyDown = Event.chain(domEvent(this.view.getHTMLElement(), 'keydown'))
            .filter(function (e) { return !isInputElement(e.target) || e.target === _this.filterOnTypeDomNode; })
            .filter(function (e) { return e.key !== 'Dead' && !/^Media/.test(e.key); })
            .map(function (e) { return new StandardKeyboardEvent(e); })
            .filter(this.keyboardNavigationEventFilter || (function () { return true; }))
            .filter(function () { return _this.automaticKeyboardNavigation || _this.triggered; })
            .filter(function (e) { return (_this.keyboardNavigationDelegate.mightProducePrintableCharacter(e) && !(e.keyCode === 18 /* DownArrow */ || e.keyCode === 16 /* UpArrow */ || e.keyCode === 15 /* LeftArrow */ || e.keyCode === 17 /* RightArrow */)) || ((_this.pattern.length > 0 || _this.triggered) && ((e.keyCode === 9 /* Escape */ || e.keyCode === 1 /* Backspace */) && !e.altKey && !e.ctrlKey && !e.metaKey) || (e.keyCode === 1 /* Backspace */ && (isMacintosh ? (e.altKey && !e.metaKey) : e.ctrlKey) && !e.shiftKey)); })
            .forEach(function (e) { e.stopPropagation(); e.preventDefault(); })
            .event;
        var onClear = domEvent(this.clearDomNode, 'click');
        Event.chain(Event.any(onKeyDown, onClear))
            .event(this.onEventOrInput, this, this.enabledDisposables);
        this.filter.pattern = '';
        this.tree.refilter();
        this.render();
        this._enabled = true;
        this.triggered = false;
    };
    TypeFilterController.prototype.disable = function () {
        if (!this._enabled) {
            return;
        }
        this.domNode.remove();
        this.enabledDisposables.clear();
        this.tree.refilter();
        this.render();
        this._enabled = false;
        this.triggered = false;
    };
    TypeFilterController.prototype.onEventOrInput = function (e) {
        if (typeof e === 'string') {
            this.onInput(e);
        }
        else if (e instanceof MouseEvent || e.keyCode === 9 /* Escape */ || (e.keyCode === 1 /* Backspace */ && (isMacintosh ? e.altKey : e.ctrlKey))) {
            this.onInput('');
        }
        else if (e.keyCode === 1 /* Backspace */) {
            this.onInput(this.pattern.length === 0 ? '' : this.pattern.substr(0, this.pattern.length - 1));
        }
        else {
            this.onInput(this.pattern + e.browserEvent.key);
        }
    };
    TypeFilterController.prototype.onInput = function (pattern) {
        var container = this.view.getHTMLElement();
        if (pattern && !this.domNode.parentElement) {
            container.append(this.domNode);
        }
        else if (!pattern && this.domNode.parentElement) {
            this.domNode.remove();
            this.tree.domFocus();
        }
        this._pattern = pattern;
        this._onDidChangePattern.fire(pattern);
        this.filter.pattern = pattern;
        this.tree.refilter();
        if (pattern) {
            this.tree.focusNext(0, true, undefined, function (node) { return !FuzzyScore.isDefault(node.filterData); });
        }
        var focus = this.tree.getFocus();
        if (focus.length > 0) {
            var element = focus[0];
            if (this.tree.getRelativeTop(element) === null) {
                this.tree.reveal(element, 0.5);
            }
        }
        this.render();
        if (!pattern) {
            this.triggered = false;
        }
    };
    TypeFilterController.prototype.onDragStart = function () {
        var _this = this;
        var container = this.view.getHTMLElement();
        var left = getDomNodePagePosition(container).left;
        var containerWidth = container.clientWidth;
        var midContainerWidth = containerWidth / 2;
        var width = this.domNode.clientWidth;
        var disposables = new DisposableStore();
        var positionClassName = this.positionClassName;
        var updatePosition = function () {
            switch (positionClassName) {
                case 'nw':
                    _this.domNode.style.top = "4px";
                    _this.domNode.style.left = "4px";
                    break;
                case 'ne':
                    _this.domNode.style.top = "4px";
                    _this.domNode.style.left = containerWidth - width - 6 + "px";
                    break;
            }
        };
        var onDragOver = function (event) {
            event.preventDefault(); // needed so that the drop event fires (https://stackoverflow.com/questions/21339924/drop-event-not-firing-in-chrome)
            var x = event.clientX - left;
            if (event.dataTransfer) {
                event.dataTransfer.dropEffect = 'none';
            }
            if (x < midContainerWidth) {
                positionClassName = 'nw';
            }
            else {
                positionClassName = 'ne';
            }
            updatePosition();
        };
        var onDragEnd = function () {
            _this.positionClassName = positionClassName;
            _this.domNode.className = "monaco-list-type-filter " + _this.positionClassName;
            _this.domNode.style.top = '';
            _this.domNode.style.left = '';
            dispose(disposables);
        };
        updatePosition();
        this.domNode.classList.remove(positionClassName);
        this.domNode.classList.add('dragging');
        disposables.add(toDisposable(function () { return _this.domNode.classList.remove('dragging'); }));
        domEvent(document, 'dragover')(onDragOver, null, disposables);
        domEvent(this.domNode, 'dragend')(onDragEnd, null, disposables);
        StaticDND.CurrentDragAndDropData = new DragAndDropData('vscode-ui');
        disposables.add(toDisposable(function () { return StaticDND.CurrentDragAndDropData = undefined; }));
    };
    TypeFilterController.prototype.onDidSpliceModel = function () {
        if (!this._enabled || this.pattern.length === 0) {
            return;
        }
        this.tree.refilter();
        this.render();
    };
    TypeFilterController.prototype.onDidChangeFilterOnType = function () {
        this.tree.updateOptions({ filterOnType: this.filterOnTypeDomNode.checked });
        this.tree.refilter();
        this.tree.domFocus();
        this.render();
        this.updateFilterOnTypeTitleAndIcon();
    };
    TypeFilterController.prototype.updateFilterOnTypeTitleAndIcon = function () {
        var _a, _b, _c, _d;
        if (this.filterOnType) {
            (_a = this.filterOnTypeDomNode.classList).remove.apply(_a, __spreadArray([], __read(treeFilterOnTypeOffIcon.classNamesArray)));
            (_b = this.filterOnTypeDomNode.classList).add.apply(_b, __spreadArray([], __read(treeFilterOnTypeOnIcon.classNamesArray)));
            this.filterOnTypeDomNode.title = localize('disable filter on type', "Disable Filter on Type");
        }
        else {
            (_c = this.filterOnTypeDomNode.classList).remove.apply(_c, __spreadArray([], __read(treeFilterOnTypeOnIcon.classNamesArray)));
            (_d = this.filterOnTypeDomNode.classList).add.apply(_d, __spreadArray([], __read(treeFilterOnTypeOffIcon.classNamesArray)));
            this.filterOnTypeDomNode.title = localize('enable filter on type', "Enable Filter on Type");
        }
    };
    TypeFilterController.prototype.render = function () {
        var noMatches = this.filter.totalCount > 0 && this.filter.matchCount === 0;
        if (this.pattern && this.tree.options.filterOnType && noMatches) {
            this.messageDomNode.textContent = localize('empty', "No elements found");
            this._empty = true;
        }
        else {
            this.messageDomNode.innerText = '';
            this._empty = false;
        }
        this.domNode.classList.toggle('no-matches', noMatches);
        this.domNode.title = localize('found', "Matched {0} out of {1} elements", this.filter.matchCount, this.filter.totalCount);
        this.labelDomNode.textContent = this.pattern.length > 16 ? '…' + this.pattern.substr(this.pattern.length - 16) : this.pattern;
        this._onDidChangeEmptyState.fire(this._empty);
    };
    TypeFilterController.prototype.shouldAllowFocus = function (node) {
        if (!this.enabled || !this.pattern || this.filterOnType) {
            return true;
        }
        if (this.filter.totalCount > 0 && this.filter.matchCount <= 1) {
            return true;
        }
        return !FuzzyScore.isDefault(node.filterData);
    };
    TypeFilterController.prototype.dispose = function () {
        if (this._enabled) {
            this.domNode.remove();
            this.enabledDisposables.dispose();
            this._enabled = false;
            this.triggered = false;
        }
        this._onDidChangePattern.dispose();
        dispose(this.disposables);
    };
    return TypeFilterController;
}());
function asTreeMouseEvent(event) {
    var target = TreeMouseEventTarget.Unknown;
    if (hasParentWithClass(event.browserEvent.target, 'monaco-tl-twistie', 'monaco-tl-row')) {
        target = TreeMouseEventTarget.Twistie;
    }
    else if (hasParentWithClass(event.browserEvent.target, 'monaco-tl-contents', 'monaco-tl-row')) {
        target = TreeMouseEventTarget.Element;
    }
    return {
        browserEvent: event.browserEvent,
        element: event.element ? event.element.element : null,
        target: target
    };
}
function asTreeContextMenuEvent(event) {
    return {
        element: event.element ? event.element.element : null,
        browserEvent: event.browserEvent,
        anchor: event.anchor
    };
}
function dfs(node, fn) {
    fn(node);
    node.children.forEach(function (child) { return dfs(child, fn); });
}
/**
 * The trait concept needs to exist at the tree level, because collapsed
 * tree nodes will not be known by the list.
 */
var Trait = /** @class */ (function () {
    function Trait(identityProvider) {
        this.identityProvider = identityProvider;
        this.nodes = [];
        this._onDidChange = new Emitter();
        this.onDidChange = this._onDidChange.event;
    }
    Object.defineProperty(Trait.prototype, "nodeSet", {
        get: function () {
            if (!this._nodeSet) {
                this._nodeSet = this.createNodeSet();
            }
            return this._nodeSet;
        },
        enumerable: false,
        configurable: true
    });
    Trait.prototype.set = function (nodes, browserEvent) {
        var _a;
        if (!((_a = browserEvent) === null || _a === void 0 ? void 0 : _a.__forceEvent) && equals(this.nodes, nodes)) {
            return;
        }
        this._set(nodes, false, browserEvent);
    };
    Trait.prototype._set = function (nodes, silent, browserEvent) {
        this.nodes = __spreadArray([], __read(nodes));
        this.elements = undefined;
        this._nodeSet = undefined;
        if (!silent) {
            var that_1 = this;
            this._onDidChange.fire({ get elements() { return that_1.get(); }, browserEvent: browserEvent });
        }
    };
    Trait.prototype.get = function () {
        if (!this.elements) {
            this.elements = this.nodes.map(function (node) { return node.element; });
        }
        return __spreadArray([], __read(this.elements));
    };
    Trait.prototype.getNodes = function () {
        return this.nodes;
    };
    Trait.prototype.has = function (node) {
        return this.nodeSet.has(node);
    };
    Trait.prototype.onDidModelSplice = function (_a) {
        var e_2, _b;
        var _this = this;
        var insertedNodes = _a.insertedNodes, deletedNodes = _a.deletedNodes;
        if (!this.identityProvider) {
            var set_1 = this.createNodeSet();
            var visit_1 = function (node) { return set_1.delete(node); };
            deletedNodes.forEach(function (node) { return dfs(node, visit_1); });
            this.set(__spreadArray([], __read(set_1.values())));
            return;
        }
        var deletedNodesIdSet = new Set();
        var deletedNodesVisitor = function (node) { return deletedNodesIdSet.add(_this.identityProvider.getId(node.element).toString()); };
        deletedNodes.forEach(function (node) { return dfs(node, deletedNodesVisitor); });
        var insertedNodesMap = new Map();
        var insertedNodesVisitor = function (node) { return insertedNodesMap.set(_this.identityProvider.getId(node.element).toString(), node); };
        insertedNodes.forEach(function (node) { return dfs(node, insertedNodesVisitor); });
        var nodes = [];
        try {
            for (var _c = __values(this.nodes), _d = _c.next(); !_d.done; _d = _c.next()) {
                var node = _d.value;
                var id = this.identityProvider.getId(node.element).toString();
                var wasDeleted = deletedNodesIdSet.has(id);
                if (!wasDeleted) {
                    nodes.push(node);
                }
                else {
                    var insertedNode = insertedNodesMap.get(id);
                    if (insertedNode) {
                        nodes.push(insertedNode);
                    }
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_b = _c.return)) _b.call(_c);
            }
            finally { if (e_2) throw e_2.error; }
        }
        this._set(nodes, true);
    };
    Trait.prototype.createNodeSet = function () {
        var e_3, _a;
        var set = new Set();
        try {
            for (var _b = __values(this.nodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                var node = _c.value;
                set.add(node);
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_3) throw e_3.error; }
        }
        return set;
    };
    return Trait;
}());
var TreeNodeListMouseController = /** @class */ (function (_super) {
    __extends(TreeNodeListMouseController, _super);
    function TreeNodeListMouseController(list, tree) {
        var _this = _super.call(this, list) || this;
        _this.tree = tree;
        return _this;
    }
    TreeNodeListMouseController.prototype.onViewPointer = function (e) {
        if (isInputElement(e.browserEvent.target) || isMonacoEditor(e.browserEvent.target)) {
            return;
        }
        var node = e.element;
        if (!node) {
            return _super.prototype.onViewPointer.call(this, e);
        }
        if (this.isSelectionRangeChangeEvent(e) || this.isSelectionSingleChangeEvent(e)) {
            return _super.prototype.onViewPointer.call(this, e);
        }
        var target = e.browserEvent.target;
        var onTwistie = target.classList.contains('monaco-tl-twistie')
            || (target.classList.contains('monaco-icon-label') && target.classList.contains('folder-icon') && e.browserEvent.offsetX < 16);
        var expandOnlyOnTwistieClick = false;
        if (typeof this.tree.expandOnlyOnTwistieClick === 'function') {
            expandOnlyOnTwistieClick = this.tree.expandOnlyOnTwistieClick(node.element);
        }
        else {
            expandOnlyOnTwistieClick = !!this.tree.expandOnlyOnTwistieClick;
        }
        if (expandOnlyOnTwistieClick && !onTwistie && e.browserEvent.detail !== 2) {
            return _super.prototype.onViewPointer.call(this, e);
        }
        if (!this.tree.expandOnDoubleClick && e.browserEvent.detail === 2) {
            return _super.prototype.onViewPointer.call(this, e);
        }
        if (node.collapsible) {
            var model = this.tree.model; // internal
            var location_1 = model.getNodeLocation(node);
            var recursive = e.browserEvent.altKey;
            this.tree.setFocus([location_1]);
            model.setCollapsed(location_1, undefined, recursive);
            if (expandOnlyOnTwistieClick && onTwistie) {
                return;
            }
        }
        _super.prototype.onViewPointer.call(this, e);
    };
    TreeNodeListMouseController.prototype.onDoubleClick = function (e) {
        var onTwistie = e.browserEvent.target.classList.contains('monaco-tl-twistie');
        if (onTwistie || !this.tree.expandOnDoubleClick) {
            return;
        }
        _super.prototype.onDoubleClick.call(this, e);
    };
    return TreeNodeListMouseController;
}(MouseController));
/**
 * We use this List subclass to restore selection and focus as nodes
 * get rendered in the list, possibly due to a node expand() call.
 */
var TreeNodeList = /** @class */ (function (_super) {
    __extends(TreeNodeList, _super);
    function TreeNodeList(user, container, virtualDelegate, renderers, focusTrait, selectionTrait, options) {
        var _this = _super.call(this, user, container, virtualDelegate, renderers, options) || this;
        _this.focusTrait = focusTrait;
        _this.selectionTrait = selectionTrait;
        return _this;
    }
    TreeNodeList.prototype.createMouseController = function (options) {
        return new TreeNodeListMouseController(this, options.tree);
    };
    TreeNodeList.prototype.splice = function (start, deleteCount, elements) {
        var _this = this;
        if (elements === void 0) { elements = []; }
        _super.prototype.splice.call(this, start, deleteCount, elements);
        if (elements.length === 0) {
            return;
        }
        var additionalFocus = [];
        var additionalSelection = [];
        elements.forEach(function (node, index) {
            if (_this.focusTrait.has(node)) {
                additionalFocus.push(start + index);
            }
            if (_this.selectionTrait.has(node)) {
                additionalSelection.push(start + index);
            }
        });
        if (additionalFocus.length > 0) {
            _super.prototype.setFocus.call(this, distinctES6(__spreadArray(__spreadArray([], __read(_super.prototype.getFocus.call(this))), __read(additionalFocus))));
        }
        if (additionalSelection.length > 0) {
            _super.prototype.setSelection.call(this, distinctES6(__spreadArray(__spreadArray([], __read(_super.prototype.getSelection.call(this))), __read(additionalSelection))));
        }
    };
    TreeNodeList.prototype.setFocus = function (indexes, browserEvent, fromAPI) {
        var _this = this;
        if (fromAPI === void 0) { fromAPI = false; }
        _super.prototype.setFocus.call(this, indexes, browserEvent);
        if (!fromAPI) {
            this.focusTrait.set(indexes.map(function (i) { return _this.element(i); }), browserEvent);
        }
    };
    TreeNodeList.prototype.setSelection = function (indexes, browserEvent, fromAPI) {
        var _this = this;
        if (fromAPI === void 0) { fromAPI = false; }
        _super.prototype.setSelection.call(this, indexes, browserEvent);
        if (!fromAPI) {
            this.selectionTrait.set(indexes.map(function (i) { return _this.element(i); }), browserEvent);
        }
    };
    return TreeNodeList;
}(List));
var AbstractTree = /** @class */ (function () {
    function AbstractTree(user, container, delegate, renderers, _options) {
        var e_4, _a;
        var _this = this;
        if (_options === void 0) { _options = {}; }
        this._options = _options;
        this.eventBufferer = new EventBufferer();
        this.disposables = new DisposableStore();
        this._onWillRefilter = new Emitter();
        this.onWillRefilter = this._onWillRefilter.event;
        this._onDidUpdateOptions = new Emitter();
        this.onDidUpdateOptions = this._onDidUpdateOptions.event;
        var treeDelegate = new ComposedTreeDelegate(delegate);
        var onDidChangeCollapseStateRelay = new Relay();
        var onDidChangeActiveNodes = new Relay();
        var activeNodes = new EventCollection(onDidChangeActiveNodes.event);
        this.renderers = renderers.map(function (r) { return new TreeRenderer(r, function () { return _this.model; }, onDidChangeCollapseStateRelay.event, activeNodes, _options); });
        try {
            for (var _b = __values(this.renderers), _c = _b.next(); !_c.done; _c = _b.next()) {
                var r = _c.value;
                this.disposables.add(r);
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_4) throw e_4.error; }
        }
        var filter;
        if (_options.keyboardNavigationLabelProvider) {
            filter = new TypeFilter(this, _options.keyboardNavigationLabelProvider, _options.filter);
            _options = __assign(__assign({}, _options), { filter: filter }); // TODO need typescript help here
            this.disposables.add(filter);
        }
        this.focus = new Trait(_options.identityProvider);
        this.selection = new Trait(_options.identityProvider);
        this.view = new TreeNodeList(user, container, treeDelegate, this.renderers, this.focus, this.selection, __assign(__assign({}, asListOptions(function () { return _this.model; }, _options)), { tree: this }));
        this.model = this.createModel(user, this.view, _options);
        onDidChangeCollapseStateRelay.input = this.model.onDidChangeCollapseState;
        var onDidModelSplice = Event.forEach(this.model.onDidSplice, function (e) {
            _this.eventBufferer.bufferEvents(function () {
                _this.focus.onDidModelSplice(e);
                _this.selection.onDidModelSplice(e);
            });
        });
        // Make sure the `forEach` always runs
        onDidModelSplice(function () { return null; }, null, this.disposables);
        // Active nodes can change when the model changes or when focus or selection change.
        // We debounce it with 0 delay since these events may fire in the same stack and we only
        // want to run this once. It also doesn't matter if it runs on the next tick since it's only
        // a nice to have UI feature.
        onDidChangeActiveNodes.input = Event.chain(Event.any(onDidModelSplice, this.focus.onDidChange, this.selection.onDidChange))
            .debounce(function () { return null; }, 0)
            .map(function () {
            var e_5, _a, e_6, _b;
            var set = new Set();
            try {
                for (var _c = __values(_this.focus.getNodes()), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var node = _d.value;
                    set.add(node);
                }
            }
            catch (e_5_1) { e_5 = { error: e_5_1 }; }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                }
                finally { if (e_5) throw e_5.error; }
            }
            try {
                for (var _e = __values(_this.selection.getNodes()), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var node = _f.value;
                    set.add(node);
                }
            }
            catch (e_6_1) { e_6 = { error: e_6_1 }; }
            finally {
                try {
                    if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                }
                finally { if (e_6) throw e_6.error; }
            }
            return __spreadArray([], __read(set.values()));
        }).event;
        if (_options.keyboardSupport !== false) {
            var onKeyDown = Event.chain(this.view.onKeyDown)
                .filter(function (e) { return !isInputElement(e.target); })
                .map(function (e) { return new StandardKeyboardEvent(e); });
            onKeyDown.filter(function (e) { return e.keyCode === 15 /* LeftArrow */; }).on(this.onLeftArrow, this, this.disposables);
            onKeyDown.filter(function (e) { return e.keyCode === 17 /* RightArrow */; }).on(this.onRightArrow, this, this.disposables);
            onKeyDown.filter(function (e) { return e.keyCode === 10 /* Space */; }).on(this.onSpace, this, this.disposables);
        }
        if (_options.keyboardNavigationLabelProvider) {
            var delegate_1 = _options.keyboardNavigationDelegate || DefaultKeyboardNavigationDelegate;
            this.typeFilterController = new TypeFilterController(this, this.model, this.view, filter, delegate_1);
            this.focusNavigationFilter = function (node) { return _this.typeFilterController.shouldAllowFocus(node); };
            this.disposables.add(this.typeFilterController);
        }
        this.styleElement = createStyleSheet(this.view.getHTMLElement());
        this.getHTMLElement().classList.toggle('always', this._options.renderIndentGuides === RenderIndentGuides.Always);
    }
    Object.defineProperty(AbstractTree.prototype, "onDidScroll", {
        get: function () { return this.view.onDidScroll; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "onDidChangeFocus", {
        get: function () { return this.eventBufferer.wrapEvent(this.focus.onDidChange); },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "onDidChangeSelection", {
        get: function () { return this.eventBufferer.wrapEvent(this.selection.onDidChange); },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "onMouseClick", {
        get: function () { return Event.map(this.view.onMouseClick, asTreeMouseEvent); },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "onMouseDblClick", {
        get: function () { return Event.map(this.view.onMouseDblClick, asTreeMouseEvent); },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "onContextMenu", {
        get: function () { return Event.map(this.view.onContextMenu, asTreeContextMenuEvent); },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "onTap", {
        get: function () { return Event.map(this.view.onTap, asTreeMouseEvent); },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "onPointer", {
        get: function () { return Event.map(this.view.onPointer, asTreeMouseEvent); },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "onKeyDown", {
        get: function () { return this.view.onKeyDown; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "onKeyUp", {
        get: function () { return this.view.onKeyUp; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "onKeyPress", {
        get: function () { return this.view.onKeyPress; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "onDidFocus", {
        get: function () { return this.view.onDidFocus; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "onDidBlur", {
        get: function () { return this.view.onDidBlur; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "onDidChangeCollapseState", {
        get: function () { return this.model.onDidChangeCollapseState; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "onDidChangeRenderNodeCount", {
        get: function () { return this.model.onDidChangeRenderNodeCount; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "filterOnType", {
        get: function () { return !!this._options.filterOnType; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "onDidChangeTypeFilterPattern", {
        get: function () { return this.typeFilterController ? this.typeFilterController.onDidChangePattern : Event.None; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "expandOnDoubleClick", {
        get: function () { return typeof this._options.expandOnDoubleClick === 'undefined' ? true : this._options.expandOnDoubleClick; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "expandOnlyOnTwistieClick", {
        get: function () { return typeof this._options.expandOnlyOnTwistieClick === 'undefined' ? true : this._options.expandOnlyOnTwistieClick; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "onDidDispose", {
        get: function () { return this.view.onDidDispose; },
        enumerable: false,
        configurable: true
    });
    AbstractTree.prototype.updateOptions = function (optionsUpdate) {
        var e_7, _a;
        if (optionsUpdate === void 0) { optionsUpdate = {}; }
        this._options = __assign(__assign({}, this._options), optionsUpdate);
        try {
            for (var _b = __values(this.renderers), _c = _b.next(); !_c.done; _c = _b.next()) {
                var renderer = _c.value;
                renderer.updateOptions(optionsUpdate);
            }
        }
        catch (e_7_1) { e_7 = { error: e_7_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_7) throw e_7.error; }
        }
        this.view.updateOptions({
            enableKeyboardNavigation: this._options.simpleKeyboardNavigation,
            automaticKeyboardNavigation: this._options.automaticKeyboardNavigation,
            smoothScrolling: this._options.smoothScrolling,
            horizontalScrolling: this._options.horizontalScrolling
        });
        if (this.typeFilterController) {
            this.typeFilterController.updateOptions(this._options);
        }
        this._onDidUpdateOptions.fire(this._options);
        this.getHTMLElement().classList.toggle('always', this._options.renderIndentGuides === RenderIndentGuides.Always);
    };
    Object.defineProperty(AbstractTree.prototype, "options", {
        get: function () {
            return this._options;
        },
        enumerable: false,
        configurable: true
    });
    AbstractTree.prototype.updateWidth = function (element) {
        var index = this.model.getListIndex(element);
        if (index === -1) {
            return;
        }
        this.view.updateWidth(index);
    };
    // Widget
    AbstractTree.prototype.getHTMLElement = function () {
        return this.view.getHTMLElement();
    };
    Object.defineProperty(AbstractTree.prototype, "contentHeight", {
        get: function () {
            if (this.typeFilterController && this.typeFilterController.filterOnType && this.typeFilterController.empty) {
                return 100;
            }
            return this.view.contentHeight;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "onDidChangeContentHeight", {
        get: function () {
            var _this = this;
            var result = this.view.onDidChangeContentHeight;
            if (this.typeFilterController) {
                result = Event.any(result, Event.map(this.typeFilterController.onDidChangeEmptyState, function () { return _this.contentHeight; }));
            }
            return result;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "scrollTop", {
        get: function () {
            return this.view.scrollTop;
        },
        set: function (scrollTop) {
            this.view.scrollTop = scrollTop;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "scrollLeft", {
        get: function () {
            return this.view.scrollLeft;
        },
        set: function (scrollLeft) {
            this.view.scrollLeft = scrollLeft;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "scrollHeight", {
        get: function () {
            return this.view.scrollHeight;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "renderHeight", {
        get: function () {
            return this.view.renderHeight;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "firstVisibleElement", {
        get: function () {
            var index = this.view.firstVisibleIndex;
            if (index < 0 || index >= this.view.length) {
                return undefined;
            }
            var node = this.view.element(index);
            return node.element;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "lastVisibleElement", {
        get: function () {
            var index = this.view.lastVisibleIndex;
            var node = this.view.element(index);
            return node.element;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractTree.prototype, "ariaLabel", {
        get: function () {
            return this.view.ariaLabel;
        },
        set: function (value) {
            this.view.ariaLabel = value;
        },
        enumerable: false,
        configurable: true
    });
    AbstractTree.prototype.domFocus = function () {
        this.view.domFocus();
    };
    AbstractTree.prototype.isDOMFocused = function () {
        return this.getHTMLElement() === document.activeElement;
    };
    AbstractTree.prototype.layout = function (height, width) {
        this.view.layout(height, width);
    };
    AbstractTree.prototype.style = function (styles) {
        var suffix = "." + this.view.domId;
        var content = [];
        if (styles.treeIndentGuidesStroke) {
            content.push(".monaco-list" + suffix + ":hover .monaco-tl-indent > .indent-guide, .monaco-list" + suffix + ".always .monaco-tl-indent > .indent-guide  { border-color: " + styles.treeIndentGuidesStroke.transparent(0.4) + "; }");
            content.push(".monaco-list" + suffix + " .monaco-tl-indent > .indent-guide.active { border-color: " + styles.treeIndentGuidesStroke + "; }");
        }
        this.styleElement.textContent = content.join('\n');
        this.view.style(styles);
    };
    // Tree navigation
    AbstractTree.prototype.getParentElement = function (location) {
        var parentRef = this.model.getParentNodeLocation(location);
        var parentNode = this.model.getNode(parentRef);
        return parentNode.element;
    };
    AbstractTree.prototype.getFirstElementChild = function (location) {
        return this.model.getFirstElementChild(location);
    };
    // Tree
    AbstractTree.prototype.getNode = function (location) {
        return this.model.getNode(location);
    };
    AbstractTree.prototype.collapse = function (location, recursive) {
        if (recursive === void 0) { recursive = false; }
        return this.model.setCollapsed(location, true, recursive);
    };
    AbstractTree.prototype.expand = function (location, recursive) {
        if (recursive === void 0) { recursive = false; }
        return this.model.setCollapsed(location, false, recursive);
    };
    AbstractTree.prototype.toggleCollapsed = function (location, recursive) {
        if (recursive === void 0) { recursive = false; }
        return this.model.setCollapsed(location, undefined, recursive);
    };
    AbstractTree.prototype.expandAll = function () {
        this.model.setCollapsed(this.model.rootRef, false, true);
    };
    AbstractTree.prototype.collapseAll = function () {
        this.model.setCollapsed(this.model.rootRef, true, true);
    };
    AbstractTree.prototype.isCollapsible = function (location) {
        return this.model.isCollapsible(location);
    };
    AbstractTree.prototype.setCollapsible = function (location, collapsible) {
        return this.model.setCollapsible(location, collapsible);
    };
    AbstractTree.prototype.isCollapsed = function (location) {
        return this.model.isCollapsed(location);
    };
    AbstractTree.prototype.toggleKeyboardNavigation = function () {
        this.view.toggleKeyboardNavigation();
        if (this.typeFilterController) {
            this.typeFilterController.toggle();
        }
    };
    AbstractTree.prototype.refilter = function () {
        this._onWillRefilter.fire(undefined);
        this.model.refilter();
    };
    AbstractTree.prototype.setSelection = function (elements, browserEvent) {
        var _this = this;
        var nodes = elements.map(function (e) { return _this.model.getNode(e); });
        this.selection.set(nodes, browserEvent);
        var indexes = elements.map(function (e) { return _this.model.getListIndex(e); }).filter(function (i) { return i > -1; });
        this.view.setSelection(indexes, browserEvent, true);
    };
    AbstractTree.prototype.getSelection = function () {
        return this.selection.get();
    };
    AbstractTree.prototype.setFocus = function (elements, browserEvent) {
        var _this = this;
        var nodes = elements.map(function (e) { return _this.model.getNode(e); });
        this.focus.set(nodes, browserEvent);
        var indexes = elements.map(function (e) { return _this.model.getListIndex(e); }).filter(function (i) { return i > -1; });
        this.view.setFocus(indexes, browserEvent, true);
    };
    AbstractTree.prototype.focusNext = function (n, loop, browserEvent, filter) {
        if (n === void 0) { n = 1; }
        if (loop === void 0) { loop = false; }
        if (filter === void 0) { filter = this.focusNavigationFilter; }
        this.view.focusNext(n, loop, browserEvent, filter);
    };
    AbstractTree.prototype.focusPrevious = function (n, loop, browserEvent, filter) {
        if (n === void 0) { n = 1; }
        if (loop === void 0) { loop = false; }
        if (filter === void 0) { filter = this.focusNavigationFilter; }
        this.view.focusPrevious(n, loop, browserEvent, filter);
    };
    AbstractTree.prototype.focusNextPage = function (browserEvent, filter) {
        if (filter === void 0) { filter = this.focusNavigationFilter; }
        this.view.focusNextPage(browserEvent, filter);
    };
    AbstractTree.prototype.focusPreviousPage = function (browserEvent, filter) {
        if (filter === void 0) { filter = this.focusNavigationFilter; }
        this.view.focusPreviousPage(browserEvent, filter);
    };
    AbstractTree.prototype.focusLast = function (browserEvent, filter) {
        if (filter === void 0) { filter = this.focusNavigationFilter; }
        this.view.focusLast(browserEvent, filter);
    };
    AbstractTree.prototype.focusFirst = function (browserEvent, filter) {
        if (filter === void 0) { filter = this.focusNavigationFilter; }
        this.view.focusFirst(browserEvent, filter);
    };
    AbstractTree.prototype.getFocus = function () {
        return this.focus.get();
    };
    AbstractTree.prototype.reveal = function (location, relativeTop) {
        this.model.expandTo(location);
        var index = this.model.getListIndex(location);
        if (index === -1) {
            return;
        }
        this.view.reveal(index, relativeTop);
    };
    /**
     * Returns the relative position of an element rendered in the list.
     * Returns `null` if the element isn't *entirely* in the visible viewport.
     */
    AbstractTree.prototype.getRelativeTop = function (location) {
        var index = this.model.getListIndex(location);
        if (index === -1) {
            return null;
        }
        return this.view.getRelativeTop(index);
    };
    // List
    AbstractTree.prototype.onLeftArrow = function (e) {
        e.preventDefault();
        e.stopPropagation();
        var nodes = this.view.getFocusedElements();
        if (nodes.length === 0) {
            return;
        }
        var node = nodes[0];
        var location = this.model.getNodeLocation(node);
        var didChange = this.model.setCollapsed(location, true);
        if (!didChange) {
            var parentLocation = this.model.getParentNodeLocation(location);
            if (!parentLocation) {
                return;
            }
            var parentListIndex = this.model.getListIndex(parentLocation);
            this.view.reveal(parentListIndex);
            this.view.setFocus([parentListIndex]);
        }
    };
    AbstractTree.prototype.onRightArrow = function (e) {
        e.preventDefault();
        e.stopPropagation();
        var nodes = this.view.getFocusedElements();
        if (nodes.length === 0) {
            return;
        }
        var node = nodes[0];
        var location = this.model.getNodeLocation(node);
        var didChange = this.model.setCollapsed(location, false);
        if (!didChange) {
            if (!node.children.some(function (child) { return child.visible; })) {
                return;
            }
            var _a = __read(this.view.getFocus(), 1), focusedIndex = _a[0];
            var firstChildIndex = focusedIndex + 1;
            this.view.reveal(firstChildIndex);
            this.view.setFocus([firstChildIndex]);
        }
    };
    AbstractTree.prototype.onSpace = function (e) {
        e.preventDefault();
        e.stopPropagation();
        var nodes = this.view.getFocusedElements();
        if (nodes.length === 0) {
            return;
        }
        var node = nodes[0];
        var location = this.model.getNodeLocation(node);
        var recursive = e.browserEvent.altKey;
        this.model.setCollapsed(location, undefined, recursive);
    };
    AbstractTree.prototype.navigate = function (start) {
        return new TreeNavigator(this.view, this.model, start);
    };
    AbstractTree.prototype.dispose = function () {
        dispose(this.disposables);
        this.view.dispose();
    };
    return AbstractTree;
}());
export { AbstractTree };
var TreeNavigator = /** @class */ (function () {
    function TreeNavigator(view, model, start) {
        this.view = view;
        this.model = model;
        if (start) {
            this.index = this.model.getListIndex(start);
        }
        else {
            this.index = -1;
        }
    }
    TreeNavigator.prototype.current = function () {
        if (this.index < 0 || this.index >= this.view.length) {
            return null;
        }
        return this.view.element(this.index).element;
    };
    TreeNavigator.prototype.previous = function () {
        this.index--;
        return this.current();
    };
    TreeNavigator.prototype.next = function () {
        this.index++;
        return this.current();
    };
    TreeNavigator.prototype.first = function () {
        this.index = 0;
        return this.current();
    };
    TreeNavigator.prototype.last = function () {
        this.index = this.view.length - 1;
        return this.current();
    };
    return TreeNavigator;
}());
