/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { $ } from '../../dom';
function removeFromParent(element) {
    try {
        if (element.parentElement) {
            element.parentElement.removeChild(element);
        }
    }
    catch (e) {
        // this will throw if this happens due to a blur event, nasty business
    }
}
var RowCache = /** @class */ (function () {
    function RowCache(renderers) {
        this.renderers = renderers;
        this.cache = new Map();
    }
    /**
     * Returns a row either by creating a new one or reusing
     * a previously released row which shares the same templateId.
     */
    RowCache.prototype.alloc = function (templateId) {
        var result = this.getTemplateCache(templateId).pop();
        if (!result) {
            var domNode = $('.monaco-list-row');
            var renderer = this.getRenderer(templateId);
            var templateData = renderer.renderTemplate(domNode);
            result = { domNode: domNode, templateId: templateId, templateData: templateData };
        }
        return result;
    };
    /**
     * Releases the row for eventual reuse.
     */
    RowCache.prototype.release = function (row) {
        if (!row) {
            return;
        }
        this.releaseRow(row);
    };
    RowCache.prototype.releaseRow = function (row) {
        var domNode = row.domNode, templateId = row.templateId;
        if (domNode) {
            domNode.classList.remove('scrolling');
            removeFromParent(domNode);
        }
        var cache = this.getTemplateCache(templateId);
        cache.push(row);
    };
    RowCache.prototype.getTemplateCache = function (templateId) {
        var result = this.cache.get(templateId);
        if (!result) {
            result = [];
            this.cache.set(templateId, result);
        }
        return result;
    };
    RowCache.prototype.dispose = function () {
        var _this = this;
        this.cache.forEach(function (cachedRows, templateId) {
            var e_1, _a;
            try {
                for (var cachedRows_1 = __values(cachedRows), cachedRows_1_1 = cachedRows_1.next(); !cachedRows_1_1.done; cachedRows_1_1 = cachedRows_1.next()) {
                    var cachedRow = cachedRows_1_1.value;
                    var renderer = _this.getRenderer(templateId);
                    renderer.disposeTemplate(cachedRow.templateData);
                    cachedRow.templateData = null;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (cachedRows_1_1 && !cachedRows_1_1.done && (_a = cachedRows_1.return)) _a.call(cachedRows_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        });
        this.cache.clear();
    };
    RowCache.prototype.getRenderer = function (templateId) {
        var renderer = this.renderers.get(templateId);
        if (!renderer) {
            throw new Error("No renderer found for " + templateId);
        }
        return renderer;
    };
    return RowCache;
}());
export { RowCache };
