/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import './dropdown.css';
import { Gesture, EventType as GestureEventType } from '../../touch';
import { ActionRunner } from '../../../common/actions';
import { EventHelper, EventType, append, $, addDisposableListener } from '../../dom';
import { StandardKeyboardEvent } from '../../keyboardEvent';
import { Emitter } from '../../../common/event';
var BaseDropdown = /** @class */ (function (_super) {
    __extends(BaseDropdown, _super);
    function BaseDropdown(container, options) {
        var e_1, _a, e_2, _b;
        var _this = _super.call(this) || this;
        _this._onDidChangeVisibility = new Emitter();
        _this.onDidChangeVisibility = _this._onDidChangeVisibility.event;
        _this._element = append(container, $('.monaco-dropdown'));
        _this._label = append(_this._element, $('.dropdown-label'));
        var labelRenderer = options.labelRenderer;
        if (!labelRenderer) {
            labelRenderer = function (container) {
                container.textContent = options.label || '';
                return null;
            };
        }
        try {
            for (var _c = __values([EventType.CLICK, EventType.MOUSE_DOWN, GestureEventType.Tap]), _d = _c.next(); !_d.done; _d = _c.next()) {
                var event_1 = _d.value;
                _this._register(addDisposableListener(_this.element, event_1, function (e) { return EventHelper.stop(e, true); })); // prevent default click behaviour to trigger
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_1) throw e_1.error; }
        }
        try {
            for (var _e = __values([EventType.MOUSE_DOWN, GestureEventType.Tap]), _f = _e.next(); !_f.done; _f = _e.next()) {
                var event_2 = _f.value;
                _this._register(addDisposableListener(_this._label, event_2, function (e) {
                    if (e instanceof MouseEvent && e.detail > 1) {
                        return; // prevent multiple clicks to open multiple context menus (https://github.com/microsoft/vscode/issues/41363)
                    }
                    if (_this.visible) {
                        _this.hide();
                    }
                    else {
                        _this.show();
                    }
                }));
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
            }
            finally { if (e_2) throw e_2.error; }
        }
        _this._register(addDisposableListener(_this._label, EventType.KEY_UP, function (e) {
            var event = new StandardKeyboardEvent(e);
            if (event.equals(3 /* Enter */) || event.equals(10 /* Space */)) {
                EventHelper.stop(e, true); // https://github.com/microsoft/vscode/issues/57997
                if (_this.visible) {
                    _this.hide();
                }
                else {
                    _this.show();
                }
            }
        }));
        var cleanupFn = labelRenderer(_this._label);
        if (cleanupFn) {
            _this._register(cleanupFn);
        }
        _this._register(Gesture.addTarget(_this._label));
        return _this;
    }
    Object.defineProperty(BaseDropdown.prototype, "element", {
        get: function () {
            return this._element;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BaseDropdown.prototype, "label", {
        get: function () {
            return this._label;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BaseDropdown.prototype, "tooltip", {
        set: function (tooltip) {
            if (this._label) {
                this._label.title = tooltip;
            }
        },
        enumerable: false,
        configurable: true
    });
    BaseDropdown.prototype.show = function () {
        if (!this.visible) {
            this.visible = true;
            this._onDidChangeVisibility.fire(true);
        }
    };
    BaseDropdown.prototype.hide = function () {
        if (this.visible) {
            this.visible = false;
            this._onDidChangeVisibility.fire(false);
        }
    };
    BaseDropdown.prototype.isVisible = function () {
        return !!this.visible;
    };
    BaseDropdown.prototype.onEvent = function (e, activeElement) {
        this.hide();
    };
    BaseDropdown.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        this.hide();
        if (this.boxContainer) {
            this.boxContainer.remove();
            this.boxContainer = undefined;
        }
        if (this.contents) {
            this.contents.remove();
            this.contents = undefined;
        }
        if (this._label) {
            this._label.remove();
            this._label = undefined;
        }
    };
    return BaseDropdown;
}(ActionRunner));
export { BaseDropdown };
var Dropdown = /** @class */ (function (_super) {
    __extends(Dropdown, _super);
    function Dropdown(container, options) {
        var _this = _super.call(this, container, options) || this;
        _this.contextViewProvider = options.contextViewProvider;
        return _this;
    }
    Dropdown.prototype.show = function () {
        var _this = this;
        _super.prototype.show.call(this);
        this.element.classList.add('active');
        this.contextViewProvider.showContextView({
            getAnchor: function () { return _this.getAnchor(); },
            render: function (container) {
                return _this.renderContents(container);
            },
            onDOMEvent: function (e, activeElement) {
                _this.onEvent(e, activeElement);
            },
            onHide: function () { return _this.onHide(); }
        });
    };
    Dropdown.prototype.getAnchor = function () {
        return this.element;
    };
    Dropdown.prototype.onHide = function () {
        this.element.classList.remove('active');
    };
    Dropdown.prototype.hide = function () {
        _super.prototype.hide.call(this);
        if (this.contextViewProvider) {
            this.contextViewProvider.hideContextView();
        }
    };
    Dropdown.prototype.renderContents = function (container) {
        return null;
    };
    return Dropdown;
}(BaseDropdown));
export { Dropdown };
var DropdownMenu = /** @class */ (function (_super) {
    __extends(DropdownMenu, _super);
    function DropdownMenu(container, options) {
        var _this = _super.call(this, container, options) || this;
        _this._actions = [];
        _this._contextMenuProvider = options.contextMenuProvider;
        _this.actions = options.actions || [];
        _this.actionProvider = options.actionProvider;
        _this.menuClassName = options.menuClassName || '';
        _this.menuAsChild = !!options.menuAsChild;
        return _this;
    }
    Object.defineProperty(DropdownMenu.prototype, "menuOptions", {
        get: function () {
            return this._menuOptions;
        },
        set: function (options) {
            this._menuOptions = options;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DropdownMenu.prototype, "actions", {
        get: function () {
            if (this.actionProvider) {
                return this.actionProvider.getActions();
            }
            return this._actions;
        },
        set: function (actions) {
            this._actions = actions;
        },
        enumerable: false,
        configurable: true
    });
    DropdownMenu.prototype.show = function () {
        var _this = this;
        _super.prototype.show.call(this);
        this.element.classList.add('active');
        this._contextMenuProvider.showContextMenu({
            getAnchor: function () { return _this.element; },
            getActions: function () { return _this.actions; },
            getActionsContext: function () { return _this.menuOptions ? _this.menuOptions.context : null; },
            getActionViewItem: function (action) { return _this.menuOptions && _this.menuOptions.actionViewItemProvider ? _this.menuOptions.actionViewItemProvider(action) : undefined; },
            getKeyBinding: function (action) { return _this.menuOptions && _this.menuOptions.getKeyBinding ? _this.menuOptions.getKeyBinding(action) : undefined; },
            getMenuClassName: function () { return _this.menuClassName; },
            onHide: function () { return _this.onHide(); },
            actionRunner: this.menuOptions ? this.menuOptions.actionRunner : undefined,
            anchorAlignment: this.menuOptions ? this.menuOptions.anchorAlignment : 0 /* LEFT */,
            domForShadowRoot: this.menuAsChild ? this.element : undefined
        });
    };
    DropdownMenu.prototype.hide = function () {
        _super.prototype.hide.call(this);
    };
    DropdownMenu.prototype.onHide = function () {
        this.hide();
        this.element.classList.remove('active');
    };
    return DropdownMenu;
}(BaseDropdown));
export { DropdownMenu };
