/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import './button.css';
import { StandardKeyboardEvent } from '../../keyboardEvent';
import { Color } from '../../../common/color';
import { mixin } from '../../../common/objects';
import { Emitter } from '../../../common/event';
import { Disposable } from '../../../common/lifecycle';
import { Gesture, EventType as TouchEventType } from '../../touch';
import { renderLabelWithIcons } from '../iconLabel/iconLabels';
import { addDisposableListener, EventType, EventHelper, trackFocus, reset } from '../../dom';
import { Action } from '../../../common/actions';
import { CSSIcon, Codicon } from '../../../common/codicons';
var defaultOptions = {
    buttonBackground: Color.fromHex('#0E639C'),
    buttonHoverBackground: Color.fromHex('#006BB3'),
    buttonForeground: Color.white
};
var Button = /** @class */ (function (_super) {
    __extends(Button, _super);
    function Button(container, options) {
        var _this = _super.call(this) || this;
        _this._onDidClick = _this._register(new Emitter());
        _this.options = options || Object.create(null);
        mixin(_this.options, defaultOptions, false);
        _this.buttonForeground = _this.options.buttonForeground;
        _this.buttonBackground = _this.options.buttonBackground;
        _this.buttonHoverBackground = _this.options.buttonHoverBackground;
        _this.buttonSecondaryForeground = _this.options.buttonSecondaryForeground;
        _this.buttonSecondaryBackground = _this.options.buttonSecondaryBackground;
        _this.buttonSecondaryHoverBackground = _this.options.buttonSecondaryHoverBackground;
        _this.buttonBorder = _this.options.buttonBorder;
        _this._element = document.createElement('a');
        _this._element.classList.add('monaco-button');
        _this._element.tabIndex = 0;
        _this._element.setAttribute('role', 'button');
        container.appendChild(_this._element);
        _this._register(Gesture.addTarget(_this._element));
        [EventType.CLICK, TouchEventType.Tap].forEach(function (eventType) {
            _this._register(addDisposableListener(_this._element, eventType, function (e) {
                if (!_this.enabled) {
                    EventHelper.stop(e);
                    return;
                }
                _this._onDidClick.fire(e);
            }));
        });
        _this._register(addDisposableListener(_this._element, EventType.KEY_DOWN, function (e) {
            var event = new StandardKeyboardEvent(e);
            var eventHandled = false;
            if (_this.enabled && (event.equals(3 /* Enter */) || event.equals(10 /* Space */))) {
                _this._onDidClick.fire(e);
                eventHandled = true;
            }
            else if (event.equals(9 /* Escape */)) {
                _this._element.blur();
                eventHandled = true;
            }
            if (eventHandled) {
                EventHelper.stop(event, true);
            }
        }));
        _this._register(addDisposableListener(_this._element, EventType.MOUSE_OVER, function (e) {
            if (!_this._element.classList.contains('disabled')) {
                _this.setHoverBackground();
            }
        }));
        _this._register(addDisposableListener(_this._element, EventType.MOUSE_OUT, function (e) {
            _this.applyStyles(); // restore standard styles
        }));
        // Also set hover background when button is focused for feedback
        _this.focusTracker = _this._register(trackFocus(_this._element));
        _this._register(_this.focusTracker.onDidFocus(function () { return _this.setHoverBackground(); }));
        _this._register(_this.focusTracker.onDidBlur(function () { return _this.applyStyles(); })); // restore standard styles
        _this.applyStyles();
        return _this;
    }
    Object.defineProperty(Button.prototype, "onDidClick", {
        get: function () { return this._onDidClick.event; },
        enumerable: false,
        configurable: true
    });
    Button.prototype.setHoverBackground = function () {
        var hoverBackground;
        if (this.options.secondary) {
            hoverBackground = this.buttonSecondaryHoverBackground ? this.buttonSecondaryHoverBackground.toString() : null;
        }
        else {
            hoverBackground = this.buttonHoverBackground ? this.buttonHoverBackground.toString() : null;
        }
        if (hoverBackground) {
            this._element.style.backgroundColor = hoverBackground;
        }
    };
    Button.prototype.style = function (styles) {
        this.buttonForeground = styles.buttonForeground;
        this.buttonBackground = styles.buttonBackground;
        this.buttonHoverBackground = styles.buttonHoverBackground;
        this.buttonSecondaryForeground = styles.buttonSecondaryForeground;
        this.buttonSecondaryBackground = styles.buttonSecondaryBackground;
        this.buttonSecondaryHoverBackground = styles.buttonSecondaryHoverBackground;
        this.buttonBorder = styles.buttonBorder;
        this.applyStyles();
    };
    Button.prototype.applyStyles = function () {
        if (this._element) {
            var background = void 0, foreground = void 0;
            if (this.options.secondary) {
                foreground = this.buttonSecondaryForeground ? this.buttonSecondaryForeground.toString() : '';
                background = this.buttonSecondaryBackground ? this.buttonSecondaryBackground.toString() : '';
            }
            else {
                foreground = this.buttonForeground ? this.buttonForeground.toString() : '';
                background = this.buttonBackground ? this.buttonBackground.toString() : '';
            }
            var border = this.buttonBorder ? this.buttonBorder.toString() : '';
            this._element.style.color = foreground;
            this._element.style.backgroundColor = background;
            this._element.style.borderWidth = border ? '1px' : '';
            this._element.style.borderStyle = border ? 'solid' : '';
            this._element.style.borderColor = border;
        }
    };
    Object.defineProperty(Button.prototype, "element", {
        get: function () {
            return this._element;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Button.prototype, "label", {
        set: function (value) {
            this._element.classList.add('monaco-text-button');
            if (this.options.supportIcons) {
                reset.apply(void 0, __spreadArray([this._element], __read(renderLabelWithIcons(value))));
            }
            else {
                this._element.textContent = value;
            }
            if (typeof this.options.title === 'string') {
                this._element.title = this.options.title;
            }
            else if (this.options.title) {
                this._element.title = value;
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Button.prototype, "icon", {
        set: function (icon) {
            var _a;
            (_a = this._element.classList).add.apply(_a, __spreadArray([], __read(CSSIcon.asClassNameArray(icon))));
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Button.prototype, "enabled", {
        get: function () {
            return !this._element.classList.contains('disabled');
        },
        set: function (value) {
            if (value) {
                this._element.classList.remove('disabled');
                this._element.setAttribute('aria-disabled', String(false));
                this._element.tabIndex = 0;
            }
            else {
                this._element.classList.add('disabled');
                this._element.setAttribute('aria-disabled', String(true));
            }
        },
        enumerable: false,
        configurable: true
    });
    Button.prototype.focus = function () {
        this._element.focus();
    };
    Button.prototype.hasFocus = function () {
        return this._element === document.activeElement;
    };
    return Button;
}(Disposable));
export { Button };
var ButtonWithDropdown = /** @class */ (function (_super) {
    __extends(ButtonWithDropdown, _super);
    function ButtonWithDropdown(container, options) {
        var _this = _super.call(this) || this;
        _this._onDidClick = _this._register(new Emitter());
        _this.onDidClick = _this._onDidClick.event;
        _this.element = document.createElement('div');
        _this.element.classList.add('monaco-button-dropdown');
        container.appendChild(_this.element);
        _this.button = _this._register(new Button(_this.element, options));
        _this._register(_this.button.onDidClick(function (e) { return _this._onDidClick.fire(e); }));
        _this.action = _this._register(new Action('primaryAction', _this.button.label, undefined, true, function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2 /*return*/, this._onDidClick.fire(undefined)];
        }); }); }));
        _this.dropdownButton = _this._register(new Button(_this.element, __assign(__assign({}, options), { title: false, supportIcons: true })));
        _this.dropdownButton.element.classList.add('monaco-dropdown-button');
        _this.dropdownButton.icon = Codicon.dropDownButton;
        _this._register(_this.dropdownButton.onDidClick(function (e) {
            options.contextMenuProvider.showContextMenu({
                getAnchor: function () { return _this.dropdownButton.element; },
                getActions: function () { return __spreadArray([_this.action], __read(options.actions)); },
                actionRunner: options.actionRunner,
                onHide: function () { return _this.dropdownButton.element.setAttribute('aria-expanded', 'false'); }
            });
            _this.dropdownButton.element.setAttribute('aria-expanded', 'true');
        }));
        return _this;
    }
    Object.defineProperty(ButtonWithDropdown.prototype, "label", {
        set: function (value) {
            this.button.label = value;
            this.action.label = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ButtonWithDropdown.prototype, "icon", {
        set: function (icon) {
            this.button.icon = icon;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ButtonWithDropdown.prototype, "enabled", {
        get: function () {
            return this.button.enabled;
        },
        set: function (enabled) {
            this.button.enabled = enabled;
            this.dropdownButton.enabled = enabled;
        },
        enumerable: false,
        configurable: true
    });
    ButtonWithDropdown.prototype.style = function (styles) {
        this.button.style(styles);
        this.dropdownButton.style(styles);
    };
    ButtonWithDropdown.prototype.focus = function () {
        this.button.focus();
    };
    ButtonWithDropdown.prototype.hasFocus = function () {
        return this.button.hasFocus() || this.dropdownButton.hasFocus();
    };
    return ButtonWithDropdown;
}(Disposable));
export { ButtonWithDropdown };
var ButtonBar = /** @class */ (function (_super) {
    __extends(ButtonBar, _super);
    function ButtonBar(container) {
        var _this = _super.call(this) || this;
        _this.container = container;
        _this._buttons = [];
        return _this;
    }
    Object.defineProperty(ButtonBar.prototype, "buttons", {
        get: function () {
            return this._buttons;
        },
        enumerable: false,
        configurable: true
    });
    ButtonBar.prototype.addButton = function (options) {
        var button = this._register(new Button(this.container, options));
        this.pushButton(button);
        return button;
    };
    ButtonBar.prototype.addButtonWithDropdown = function (options) {
        var button = this._register(new ButtonWithDropdown(this.container, options));
        this.pushButton(button);
        return button;
    };
    ButtonBar.prototype.pushButton = function (button) {
        var _this = this;
        this._buttons.push(button);
        var index = this._buttons.length - 1;
        this._register(addDisposableListener(button.element, EventType.KEY_DOWN, function (e) {
            var event = new StandardKeyboardEvent(e);
            var eventHandled = true;
            // Next / Previous Button
            var buttonIndexToFocus;
            if (event.equals(15 /* LeftArrow */)) {
                buttonIndexToFocus = index > 0 ? index - 1 : _this._buttons.length - 1;
            }
            else if (event.equals(17 /* RightArrow */)) {
                buttonIndexToFocus = index === _this._buttons.length - 1 ? 0 : index + 1;
            }
            else {
                eventHandled = false;
            }
            if (eventHandled && typeof buttonIndexToFocus === 'number') {
                _this._buttons[buttonIndexToFocus].focus();
                EventHelper.stop(e, true);
            }
        }));
    };
    return ButtonBar;
}(Disposable));
export { ButtonBar };
