/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import * as dom from './dom';
import { IframeUtils } from './iframe';
import { StandardMouseEvent } from './mouseEvent';
import { DisposableStore } from '../common/lifecycle';
export function standardMouseMoveMerger(lastEvent, currentEvent) {
    var ev = new StandardMouseEvent(currentEvent);
    ev.preventDefault();
    return {
        leftButton: ev.leftButton,
        buttons: ev.buttons,
        posx: ev.posx,
        posy: ev.posy
    };
}
var GlobalMouseMoveMonitor = /** @class */ (function () {
    function GlobalMouseMoveMonitor() {
        this._hooks = new DisposableStore();
        this._mouseMoveEventMerger = null;
        this._mouseMoveCallback = null;
        this._onStopCallback = null;
    }
    GlobalMouseMoveMonitor.prototype.dispose = function () {
        this.stopMonitoring(false);
        this._hooks.dispose();
    };
    GlobalMouseMoveMonitor.prototype.stopMonitoring = function (invokeStopCallback, browserEvent) {
        if (!this.isMonitoring()) {
            // Not monitoring
            return;
        }
        // Unhook
        this._hooks.clear();
        this._mouseMoveEventMerger = null;
        this._mouseMoveCallback = null;
        var onStopCallback = this._onStopCallback;
        this._onStopCallback = null;
        if (invokeStopCallback && onStopCallback) {
            onStopCallback(browserEvent);
        }
    };
    GlobalMouseMoveMonitor.prototype.isMonitoring = function () {
        return !!this._mouseMoveEventMerger;
    };
    GlobalMouseMoveMonitor.prototype.startMonitoring = function (initialElement, initialButtons, mouseMoveEventMerger, mouseMoveCallback, onStopCallback) {
        var e_1, _a;
        var _this = this;
        if (this.isMonitoring()) {
            // I am already hooked
            return;
        }
        this._mouseMoveEventMerger = mouseMoveEventMerger;
        this._mouseMoveCallback = mouseMoveCallback;
        this._onStopCallback = onStopCallback;
        var windowChain = IframeUtils.getSameOriginWindowChain();
        var mouseMove = 'mousemove';
        var mouseUp = 'mouseup';
        var listenTo = windowChain.map(function (element) { return element.window.document; });
        var shadowRoot = dom.getShadowRoot(initialElement);
        if (shadowRoot) {
            listenTo.unshift(shadowRoot);
        }
        try {
            for (var listenTo_1 = __values(listenTo), listenTo_1_1 = listenTo_1.next(); !listenTo_1_1.done; listenTo_1_1 = listenTo_1.next()) {
                var element = listenTo_1_1.value;
                this._hooks.add(dom.addDisposableThrottledListener(element, mouseMove, function (data) {
                    if (data.buttons !== initialButtons) {
                        // Buttons state has changed in the meantime
                        _this.stopMonitoring(true);
                        return;
                    }
                    _this._mouseMoveCallback(data);
                }, function (lastEvent, currentEvent) { return _this._mouseMoveEventMerger(lastEvent, currentEvent); }));
                this._hooks.add(dom.addDisposableListener(element, mouseUp, function (e) { return _this.stopMonitoring(true); }));
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (listenTo_1_1 && !listenTo_1_1.done && (_a = listenTo_1.return)) _a.call(listenTo_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (IframeUtils.hasDifferentOriginAncestor()) {
            var lastSameOriginAncestor = windowChain[windowChain.length - 1];
            // We might miss a mouse up if it happens outside the iframe
            // This one is for Chrome
            this._hooks.add(dom.addDisposableListener(lastSameOriginAncestor.window.document, 'mouseout', function (browserEvent) {
                var e = new StandardMouseEvent(browserEvent);
                if (e.target.tagName.toLowerCase() === 'html') {
                    _this.stopMonitoring(true);
                }
            }));
            // This one is for FF
            this._hooks.add(dom.addDisposableListener(lastSameOriginAncestor.window.document, 'mouseover', function (browserEvent) {
                var e = new StandardMouseEvent(browserEvent);
                if (e.target.tagName.toLowerCase() === 'html') {
                    _this.stopMonitoring(true);
                }
            }));
            // This one is for IE
            this._hooks.add(dom.addDisposableListener(lastSameOriginAncestor.window.document.body, 'mouseleave', function (browserEvent) {
                _this.stopMonitoring(true);
            }));
        }
    };
    return GlobalMouseMoveMonitor;
}());
export { GlobalMouseMoveMonitor };
