"use strict";
/********************************************************************************
 * Copyright (C) 2021 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpWebsocketAdapter = exports.DEFAULT_HTTP_WEBSOCKET_ADAPTER_TIMEOUT = exports.HttpWebsocketAdapterTimeout = exports.HttpWebsocketAdapterFactory = void 0;
const ws = require("ws");
const inversify_1 = require("inversify");
const common_1 = require("../../common");
const promise_util_1 = require("../../common/promise-util");
exports.HttpWebsocketAdapterFactory = Symbol('HttpWebsocketAdapterFactory');
exports.HttpWebsocketAdapterTimeout = Symbol('HttpWebsocketAdapterTimeout');
exports.DEFAULT_HTTP_WEBSOCKET_ADAPTER_TIMEOUT = 4000;
let HttpWebsocketAdapter = class HttpWebsocketAdapter {
    constructor() {
        this.readyState = ws.OPEN;
        this.alive = true;
        this.pendingMessages = [];
        this.deferredMessageHandler = new promise_util_1.Deferred();
    }
    getPendingMessages() {
        this.alive = true;
        this.deferredMessageHandler = new promise_util_1.Deferred();
        if (!this.pendingMessages.length) {
            this.pendingTimeout = new common_1.CancellationTokenSource();
            promise_util_1.timeout(this.adapterTimeout, this.pendingTimeout.token)
                .then(() => this.deferredMessageHandler.resolve([]))
                .catch(() => { });
        }
        else {
            this.deferredMessageHandler.resolve(this.pendingMessages);
            this.pendingMessages = [];
        }
        return this.deferredMessageHandler.promise;
    }
    onerror(error) {
        if (this._onerror) {
            this._onerror(error);
        }
    }
    onclose(code, reason) {
        this.readyState = ws.CLOSING;
        if (this._onclose) {
            this._onclose(code, reason);
        }
        this.readyState = ws.CLOSED;
    }
    onmessage(data) {
        if (this._onmessage) {
            this._onmessage(data);
        }
    }
    send(data) {
        var _a;
        this.pendingMessages.push(data);
        if (this.deferredMessageHandler.state === 'unresolved') {
            (_a = this.pendingTimeout) === null || _a === void 0 ? void 0 : _a.cancel();
            this.deferredMessageHandler.resolve(this.pendingMessages);
            this.pendingMessages = [];
        }
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    on(event, listener) {
        if (event === 'error') {
            this.onerror = listener;
        }
        else if (event === 'message') {
            this.onmessage = listener;
        }
        else if (event === 'close') {
            this.onclose = listener;
        }
        return this;
    }
};
__decorate([
    inversify_1.inject(exports.HttpWebsocketAdapterTimeout),
    __metadata("design:type", Number)
], HttpWebsocketAdapter.prototype, "adapterTimeout", void 0);
HttpWebsocketAdapter = __decorate([
    inversify_1.injectable()
], HttpWebsocketAdapter);
exports.HttpWebsocketAdapter = HttpWebsocketAdapter;
//# sourceMappingURL=http-websocket-adapter.js.map