(global["webpackChunkarduino_ide"] = global["webpackChunkarduino_ide"] || []).push([["vendors-node_modules_theia_variable-resolver_lib_browser_variable-quick-open-service_js"],{

/***/ "./node_modules/@theia/core/shared/@phosphor/coreutils/index.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@theia/core/shared/@phosphor/coreutils/index.js ***!
  \**********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! @phosphor/coreutils */ "./node_modules/@phosphor/coreutils/lib/index.js");


/***/ }),

/***/ "./node_modules/@theia/variable-resolver/lib/browser/variable-quick-open-service.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@theia/variable-resolver/lib/browser/variable-quick-open-service.js ***!
  \******************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.VariableQuickOpenService = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const message_service_1 = __webpack_require__(/*! @theia/core/lib/common/message-service */ "./node_modules/@theia/core/lib/common/message-service.js");
const variable_1 = __webpack_require__(/*! ./variable */ "./node_modules/@theia/variable-resolver/lib/browser/variable.js");
const variable_resolver_service_1 = __webpack_require__(/*! ./variable-resolver-service */ "./node_modules/@theia/variable-resolver/lib/browser/variable-resolver-service.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
let VariableQuickOpenService = class VariableQuickOpenService {
    constructor(variableRegistry) {
        this.variableRegistry = variableRegistry;
    }
    open() {
        var _a;
        this.items = this.variableRegistry.getVariables().map(v => ({
            label: '${' + v.name + '}',
            detail: v.description,
            execute: () => {
                setTimeout(() => this.showValue(v));
            }
        }));
        (_a = this.quickInputService) === null || _a === void 0 ? void 0 : _a.showQuickPick(this.items, { placeholder: 'Registered variables' });
    }
    async showValue(variable) {
        var _a;
        const argument = await ((_a = this.quickInputService) === null || _a === void 0 ? void 0 : _a.input({
            placeHolder: 'Type a variable argument'
        }));
        const value = await this.variableResolver.resolve('${' + variable.name + ':' + argument + '}');
        if (typeof value === 'string') {
            this.messages.info(value);
        }
    }
};
__decorate([
    inversify_1.inject(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], VariableQuickOpenService.prototype, "messages", void 0);
__decorate([
    inversify_1.inject(browser_1.QuickInputService),
    inversify_1.optional(),
    __metadata("design:type", Object)
], VariableQuickOpenService.prototype, "quickInputService", void 0);
__decorate([
    inversify_1.inject(variable_resolver_service_1.VariableResolverService),
    __metadata("design:type", variable_resolver_service_1.VariableResolverService)
], VariableQuickOpenService.prototype, "variableResolver", void 0);
VariableQuickOpenService = __decorate([
    inversify_1.injectable(),
    __param(0, inversify_1.inject(variable_1.VariableRegistry)),
    __metadata("design:paramtypes", [variable_1.VariableRegistry])
], VariableQuickOpenService);
exports.VariableQuickOpenService = VariableQuickOpenService;


/***/ }),

/***/ "./node_modules/@theia/variable-resolver/lib/browser/variable-resolver-service.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@theia/variable-resolver/lib/browser/variable-resolver-service.js ***!
  \****************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var VariableResolverService_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.VariableResolverService = void 0;
/* eslint-disable @typescript-eslint/no-explicit-any */
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const variable_1 = __webpack_require__(/*! ./variable */ "./node_modules/@theia/variable-resolver/lib/browser/variable.js");
const coreutils_1 = __webpack_require__(/*! @theia/core/shared/@phosphor/coreutils */ "./node_modules/@theia/core/shared/@phosphor/coreutils/index.js");
/**
 * The variable resolver service should be used to resolve variables in strings.
 */
let VariableResolverService = VariableResolverService_1 = class VariableResolverService {
    /**
     * Resolve the variables in the given string array.
     * @param value The array of data to resolve
     * @param options options of the variable resolution
     * @returns promise resolved to the provided string array with already resolved variables.
     * Never reject.
     */
    resolveArray(value, options = {}) {
        return this.resolve(value, options);
    }
    /**
     * Resolve the variables in the given string.
     * @param value Data to resolve
     * @param options options of the variable resolution
     * @returns promise resolved to the provided string with already resolved variables.
     * Never reject.
     */
    async resolve(value, options = {}) {
        const context = new VariableResolverService_1.Context(this.variableRegistry, options);
        const resolved = await this.doResolve(value, context);
        return resolved;
    }
    async doResolve(value, context) {
        // eslint-disable-next-line no-null/no-null
        if (value === undefined || value === null) {
            return value;
        }
        if (typeof value === 'string') {
            return this.doResolveString(value, context);
        }
        if (Array.isArray(value)) {
            return this.doResolveArray(value, context);
        }
        if (typeof value === 'object') {
            return this.doResolveObject(value, context);
        }
        return value;
    }
    async doResolveObject(obj, context) {
        const result = {};
        for (const name of Object.keys(obj)) {
            const value = obj[name];
            const resolved = await this.doResolve(value, context);
            result[name] = resolved;
        }
        return result;
    }
    async doResolveArray(values, context) {
        const result = [];
        for (const value of values) {
            const resolved = await this.doResolve(value, context);
            result.push(resolved);
        }
        return result;
    }
    async doResolveString(value, context) {
        await this.resolveVariables(value, context);
        return value.replace(VariableResolverService_1.VAR_REGEXP, (match, varName) => {
            const varValue = context.get(varName);
            return varValue !== undefined ? varValue : match;
        });
    }
    async resolveVariables(value, context) {
        const variableRegExp = new RegExp(VariableResolverService_1.VAR_REGEXP);
        let match;
        // eslint-disable-next-line no-null/no-null
        while ((match = variableRegExp.exec(value)) !== null) {
            const variableName = match[1];
            await context.resolve(variableName);
        }
    }
};
VariableResolverService.VAR_REGEXP = /\$\{(.*?)\}/g;
__decorate([
    inversify_1.inject(variable_1.VariableRegistry),
    __metadata("design:type", variable_1.VariableRegistry)
], VariableResolverService.prototype, "variableRegistry", void 0);
VariableResolverService = VariableResolverService_1 = __decorate([
    inversify_1.injectable()
], VariableResolverService);
exports.VariableResolverService = VariableResolverService;
(function (VariableResolverService) {
    class Context {
        constructor(variableRegistry, options) {
            this.variableRegistry = variableRegistry;
            this.options = options;
            this.resolved = new Map();
        }
        get(name) {
            return this.resolved.get(name);
        }
        async resolve(name) {
            if (this.resolved.has(name)) {
                return;
            }
            try {
                let variableName = name;
                let argument;
                const parts = name.split(':');
                if (parts.length > 1) {
                    variableName = parts[0];
                    argument = parts[1];
                }
                const variable = this.variableRegistry.getVariable(variableName);
                const value = variable && await variable.resolve(this.options.context, argument, this.options.configurationSection);
                // eslint-disable-next-line no-null/no-null
                const stringValue = value !== undefined && value !== null && coreutils_1.JSONExt.isPrimitive(value) ? String(value) : undefined;
                this.resolved.set(name, stringValue);
            }
            catch (e) {
                console.error(`Failed to resolved '${name}' variable`, e);
                this.resolved.set(name, undefined);
            }
        }
    }
    VariableResolverService.Context = Context;
})(VariableResolverService = exports.VariableResolverService || (exports.VariableResolverService = {}));
exports.VariableResolverService = VariableResolverService;


/***/ }),

/***/ "./node_modules/@theia/variable-resolver/lib/browser/variable.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@theia/variable-resolver/lib/browser/variable.js ***!
  \***********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.VariableRegistry = exports.VariableContribution = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "./node_modules/@theia/core/lib/common/index.js");
exports.VariableContribution = Symbol('VariableContribution');
/**
 * The variable registry manages variables.
 */
let VariableRegistry = class VariableRegistry {
    constructor() {
        this.variables = new Map();
        this.toDispose = new core_1.DisposableCollection();
    }
    dispose() {
        this.toDispose.dispose();
    }
    /**
     * Register the given variable.
     * Do nothing if a variable is already registered for the given variable name.
     */
    registerVariable(variable) {
        if (this.variables.has(variable.name)) {
            console.warn(`A variables with name ${variable.name} is already registered.`);
            return core_1.Disposable.NULL;
        }
        this.variables.set(variable.name, variable);
        const disposable = {
            dispose: () => this.variables.delete(variable.name)
        };
        this.toDispose.push(disposable);
        return disposable;
    }
    /**
     * Return all registered variables.
     */
    getVariables() {
        return [...this.variables.values()];
    }
    /**
     * Get a variable for the given name or `undefined` if none.
     */
    getVariable(name) {
        return this.variables.get(name);
    }
    /**
     * Register an array of variables.
     * Do nothing if a variable is already registered for the given variable name.
     */
    registerVariables(variables) {
        return variables.map(v => this.registerVariable(v));
    }
};
VariableRegistry = __decorate([
    inversify_1.injectable()
], VariableRegistry);
exports.VariableRegistry = VariableRegistry;


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_variable-resolver_lib_browser_variable-quick-open-service_js.bundle.js.map