(global["webpackChunkarduino_ide"] = global["webpackChunkarduino_ide"] || []).push([["vendors-node_modules_theia_timeline_lib_browser_timeline-contribution_js-node_modules_theia_t-47f69f"],{

/***/ "./node_modules/@theia/core/shared/@phosphor/algorithm/index.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@theia/core/shared/@phosphor/algorithm/index.js ***!
  \**********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! @phosphor/algorithm */ "./node_modules/@phosphor/algorithm/lib/index.js");


/***/ }),

/***/ "./node_modules/@theia/timeline/lib/browser/timeline-context-key-service.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@theia/timeline/lib/browser/timeline-context-key-service.js ***!
  \**********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2020 RedHat and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TimelineContextKeyService = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "./node_modules/@theia/core/lib/browser/context-key-service.js");
let TimelineContextKeyService = class TimelineContextKeyService {
    get timelineItem() {
        return this._timelineItem;
    }
    init() {
        this._timelineItem = this.contextKeyService.createKey('timelineItem', undefined);
    }
};
__decorate([
    inversify_1.inject(context_key_service_1.ContextKeyService),
    __metadata("design:type", Object)
], TimelineContextKeyService.prototype, "contextKeyService", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TimelineContextKeyService.prototype, "init", null);
TimelineContextKeyService = __decorate([
    inversify_1.injectable()
], TimelineContextKeyService);
exports.TimelineContextKeyService = TimelineContextKeyService;


/***/ }),

/***/ "./node_modules/@theia/timeline/lib/browser/timeline-contribution.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@theia/timeline/lib/browser/timeline-contribution.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2020 RedHat and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var TimelineContribution_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TimelineContribution = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const browser_2 = __webpack_require__(/*! @theia/navigator/lib/browser */ "./node_modules/@theia/navigator/lib/browser/index.js");
const timeline_widget_1 = __webpack_require__(/*! ./timeline-widget */ "./node_modules/@theia/timeline/lib/browser/timeline-widget.js");
const timeline_service_1 = __webpack_require__(/*! ./timeline-service */ "./node_modules/@theia/timeline/lib/browser/timeline-service.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "./node_modules/@theia/core/lib/common/index.js");
const tab_bar_toolbar_1 = __webpack_require__(/*! @theia/core/lib/browser/shell/tab-bar-toolbar */ "./node_modules/@theia/core/lib/browser/shell/tab-bar-toolbar.js");
const algorithm_1 = __webpack_require__(/*! @theia/core/shared/@phosphor/algorithm */ "./node_modules/@theia/core/shared/@phosphor/algorithm/index.js");
let TimelineContribution = TimelineContribution_1 = class TimelineContribution {
    constructor() {
        this.toolbarItem = {
            id: 'timeline-refresh-toolbar-item',
            command: 'timeline-refresh',
            tooltip: 'Refresh',
            icon: browser_1.codicon('refresh')
        };
    }
    registerToolbarItems(registry) {
        registry.registerItem(this.toolbarItem);
    }
    registerCommands(commands) {
        const attachTimeline = async (explorer) => {
            const timeline = await this.widgetManager.getOrCreateWidget(timeline_widget_1.TimelineWidget.ID);
            if (explorer instanceof browser_1.ViewContainer && explorer.getTrackableWidgets().indexOf(timeline) === -1) {
                explorer.addWidget(timeline, { initiallyCollapsed: true });
            }
        };
        this.widgetManager.onWillCreateWidget(async (event) => {
            if (event.widget.id === browser_2.EXPLORER_VIEW_CONTAINER_ID && this.timelineService.getSources().length > 0) {
                event.waitUntil(attachTimeline(event.widget));
            }
        });
        this.timelineService.onDidChangeProviders(async (event) => {
            const explorer = await this.widgetManager.getWidget(browser_2.EXPLORER_VIEW_CONTAINER_ID);
            if (explorer && event.added && event.added.length > 0) {
                attachTimeline(explorer);
            }
            else if (event.removed && this.timelineService.getSources().length === 0) {
                const timeline = await this.widgetManager.getWidget(timeline_widget_1.TimelineWidget.ID);
                if (timeline) {
                    timeline.close();
                }
            }
        });
        commands.registerCommand(TimelineContribution_1.LOAD_MORE_COMMAND, {
            execute: async () => {
                const widget = algorithm_1.toArray(this.shell.mainPanel.widgets()).find(w => browser_1.Navigatable.is(w) && w.isVisible && !w.isHidden);
                if (browser_1.Navigatable.is(widget)) {
                    const uri = widget.getResourceUri();
                    const timeline = await this.widgetManager.getWidget(timeline_widget_1.TimelineWidget.ID);
                    if (uri && timeline) {
                        timeline.loadTimeline(uri, false);
                    }
                }
            }
        });
        commands.registerCommand({ id: this.toolbarItem.command }, {
            execute: widget => this.checkWidget(widget, async () => {
                const timeline = await this.widgetManager.getWidget(timeline_widget_1.TimelineWidget.ID);
                if (timeline) {
                    timeline.update();
                }
            }),
            isEnabled: widget => this.checkWidget(widget, () => true),
            isVisible: widget => this.checkWidget(widget, () => true)
        });
    }
    checkWidget(widget, cb) {
        if (widget instanceof timeline_widget_1.TimelineWidget && widget.id === timeline_widget_1.TimelineWidget.ID) {
            return cb();
        }
        return false;
    }
};
TimelineContribution.LOAD_MORE_COMMAND = {
    id: 'timeline-load-more'
};
__decorate([
    inversify_1.inject(browser_1.WidgetManager),
    __metadata("design:type", browser_1.WidgetManager)
], TimelineContribution.prototype, "widgetManager", void 0);
__decorate([
    inversify_1.inject(timeline_service_1.TimelineService),
    __metadata("design:type", timeline_service_1.TimelineService)
], TimelineContribution.prototype, "timelineService", void 0);
__decorate([
    inversify_1.inject(common_1.CommandRegistry),
    __metadata("design:type", common_1.CommandRegistry)
], TimelineContribution.prototype, "commandRegistry", void 0);
__decorate([
    inversify_1.inject(tab_bar_toolbar_1.TabBarToolbarRegistry),
    __metadata("design:type", tab_bar_toolbar_1.TabBarToolbarRegistry)
], TimelineContribution.prototype, "tabBarToolbar", void 0);
__decorate([
    inversify_1.inject(browser_1.ApplicationShell),
    __metadata("design:type", browser_1.ApplicationShell)
], TimelineContribution.prototype, "shell", void 0);
TimelineContribution = TimelineContribution_1 = __decorate([
    inversify_1.injectable()
], TimelineContribution);
exports.TimelineContribution = TimelineContribution;


/***/ }),

/***/ "./node_modules/@theia/timeline/lib/browser/timeline-empty-widget.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@theia/timeline/lib/browser/timeline-empty-widget.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2020 RedHat and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var TimelineEmptyWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TimelineEmptyWidget = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const alert_message_1 = __webpack_require__(/*! @theia/core/lib/browser/widgets/alert-message */ "./node_modules/@theia/core/lib/browser/widgets/alert-message.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "./node_modules/@theia/core/shared/react/index.js");
let TimelineEmptyWidget = TimelineEmptyWidget_1 = class TimelineEmptyWidget extends browser_1.ReactWidget {
    constructor() {
        super();
        this.addClass('theia-timeline-empty');
        this.id = TimelineEmptyWidget_1.ID;
    }
    render() {
        return React.createElement(alert_message_1.AlertMessage, { type: 'WARNING', header: 'The active editor cannot provide timeline information.' });
    }
};
TimelineEmptyWidget.ID = 'timeline-empty-widget';
TimelineEmptyWidget = TimelineEmptyWidget_1 = __decorate([
    inversify_1.injectable(),
    __metadata("design:paramtypes", [])
], TimelineEmptyWidget);
exports.TimelineEmptyWidget = TimelineEmptyWidget;


/***/ }),

/***/ "./node_modules/@theia/timeline/lib/browser/timeline-service.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@theia/timeline/lib/browser/timeline-service.js ***!
  \**********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2020 RedHat and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TimelineAggregate = exports.TimelineService = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "./node_modules/@theia/core/lib/common/index.js");
let TimelineService = class TimelineService {
    constructor() {
        this.providers = new Map();
        this.onDidChangeProvidersEmitter = new common_1.Emitter();
        this.onDidChangeProviders = this.onDidChangeProvidersEmitter.event;
        this.onDidChangeTimelineEmitter = new common_1.Emitter();
        this.onDidChangeTimeline = this.onDidChangeTimelineEmitter.event;
    }
    registerTimelineProvider(provider) {
        const id = provider.id;
        this.providers.set(id, provider);
        if (provider.onDidChange) {
            provider.onDidChange(e => this.onDidChangeTimelineEmitter.fire(e));
        }
        this.onDidChangeProvidersEmitter.fire({ added: [id] });
        return common_1.Disposable.create(() => this.unregisterTimelineProvider(id));
    }
    unregisterTimelineProvider(id) {
        const provider = this.providers.get(id);
        if (provider) {
            provider.dispose();
            this.providers.delete(id);
            this.onDidChangeProvidersEmitter.fire({ removed: [id] });
        }
    }
    getSources() {
        return [...this.providers.values()].map(p => ({ id: p.id, label: p.label }));
    }
    getSchemas() {
        const result = [];
        Array.from(this.providers.values()).forEach(provider => {
            const scheme = provider.scheme;
            if (typeof scheme === 'string') {
                result.push(scheme);
            }
            else {
                scheme.forEach(s => result.push(s));
            }
        });
        return result;
    }
    getTimeline(id, uri, options, internalOptions) {
        const provider = this.providers.get(id);
        if (!provider) {
            return Promise.resolve(undefined);
        }
        if (typeof provider.scheme === 'string') {
            if (provider.scheme !== '*' && provider.scheme !== uri.scheme) {
                return Promise.resolve(undefined);
            }
        }
        return provider.provideTimeline(uri, options, internalOptions)
            .then(result => {
            if (!result) {
                return undefined;
            }
            result.items = result.items.map(item => (Object.assign(Object.assign({}, item), { source: provider.id })));
            return result;
        });
    }
};
TimelineService = __decorate([
    inversify_1.injectable()
], TimelineService);
exports.TimelineService = TimelineService;
class TimelineAggregate {
    constructor(timeline) {
        var _a;
        this.source = timeline.source;
        this.items = timeline.items;
        this._cursor = (_a = timeline.paging) === null || _a === void 0 ? void 0 : _a.cursor;
    }
    get cursor() {
        return this._cursor;
    }
    set cursor(cursor) {
        this._cursor = cursor;
    }
    add(items) {
        this.items.push(...items);
        this.items.sort((a, b) => b.timestamp - a.timestamp);
    }
}
exports.TimelineAggregate = TimelineAggregate;


/***/ }),

/***/ "./node_modules/@theia/timeline/lib/browser/timeline-tree-model.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@theia/timeline/lib/browser/timeline-tree-model.js ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2020 RedHat and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TimelineTreeModel = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const tree_1 = __webpack_require__(/*! @theia/core/lib/browser/tree */ "./node_modules/@theia/core/lib/browser/tree/index.js");
const timeline_contribution_1 = __webpack_require__(/*! ./timeline-contribution */ "./node_modules/@theia/timeline/lib/browser/timeline-contribution.js");
let TimelineTreeModel = class TimelineTreeModel extends tree_1.TreeModelImpl {
    updateTree(items, hasMoreItems) {
        const root = {
            id: 'timeline-tree-root',
            parent: undefined,
            visible: false,
            children: []
        };
        const children = items.map(item => ({
            timelineItem: item,
            id: item.id ? item.id : item.timestamp.toString(),
            parent: root,
            detail: item.detail,
            selected: false,
            visible: true
        }));
        let loadMore;
        if (hasMoreItems) {
            const loadMoreNode = { label: 'Load-more', timestamp: 0, handle: '', uri: '', source: '' };
            loadMoreNode.command = timeline_contribution_1.TimelineContribution.LOAD_MORE_COMMAND;
            loadMore = {
                timelineItem: loadMoreNode,
                id: 'load-more',
                parent: root,
                selected: true
            };
            children.push(loadMore);
        }
        root.children = children;
        this.root = root;
        if (loadMore) {
            this.selectionService.addSelection(loadMore);
        }
    }
};
TimelineTreeModel = __decorate([
    inversify_1.injectable()
], TimelineTreeModel);
exports.TimelineTreeModel = TimelineTreeModel;


/***/ }),

/***/ "./node_modules/@theia/timeline/lib/browser/timeline-tree-widget.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@theia/timeline/lib/browser/timeline-tree-widget.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2020 RedHat and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var TimelineTreeWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TimelineItemNode = exports.TimelineTreeWidget = exports.TIMELINE_ITEM_CONTEXT_MENU = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "./node_modules/@theia/core/lib/common/index.js");
const tree_1 = __webpack_require__(/*! @theia/core/lib/browser/tree */ "./node_modules/@theia/core/lib/browser/tree/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const timeline_tree_model_1 = __webpack_require__(/*! ./timeline-tree-model */ "./node_modules/@theia/timeline/lib/browser/timeline-tree-model.js");
const timeline_service_1 = __webpack_require__(/*! ./timeline-service */ "./node_modules/@theia/timeline/lib/browser/timeline-service.js");
const timeline_context_key_service_1 = __webpack_require__(/*! ./timeline-context-key-service */ "./node_modules/@theia/timeline/lib/browser/timeline-context-key-service.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "./node_modules/@theia/core/shared/react/index.js");
exports.TIMELINE_ITEM_CONTEXT_MENU = ['timeline-item-context-menu'];
let TimelineTreeWidget = TimelineTreeWidget_1 = class TimelineTreeWidget extends tree_1.TreeWidget {
    constructor(props, timelineService, model, contextMenuRenderer, commandRegistry) {
        super(props, model, contextMenuRenderer);
        this.props = props;
        this.timelineService = timelineService;
        this.model = model;
        this.contextMenuRenderer = contextMenuRenderer;
        this.commandRegistry = commandRegistry;
        this.id = TimelineTreeWidget_1.ID;
        this.addClass('timeline-outer-container');
    }
    renderNode(node, props) {
        const attributes = this.createNodeAttributes(node, props);
        const content = React.createElement(TimelineItemNode, { timelineItem: node.timelineItem, commandRegistry: this.commandRegistry, contextKeys: this.contextKeys, contextMenuRenderer: this.contextMenuRenderer });
        return React.createElement('div', attributes, content);
    }
    handleEnter(event) {
        const node = this.model.selectedNodes[0];
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        const command = node.timelineItem.command;
        if (command) {
            this.commandRegistry.executeCommand(command.id, ...command.arguments ? command.arguments : []);
        }
    }
    async handleLeft(event) {
        this.model.selectPrevNode();
    }
};
TimelineTreeWidget.ID = 'timeline-tree-widget';
TimelineTreeWidget.PAGE_SIZE = 20;
__decorate([
    inversify_1.inject(common_1.MenuModelRegistry),
    __metadata("design:type", common_1.MenuModelRegistry)
], TimelineTreeWidget.prototype, "menus", void 0);
__decorate([
    inversify_1.inject(timeline_context_key_service_1.TimelineContextKeyService),
    __metadata("design:type", timeline_context_key_service_1.TimelineContextKeyService)
], TimelineTreeWidget.prototype, "contextKeys", void 0);
TimelineTreeWidget = TimelineTreeWidget_1 = __decorate([
    inversify_1.injectable(),
    __param(0, inversify_1.inject(tree_1.TreeProps)),
    __param(1, inversify_1.inject(timeline_service_1.TimelineService)),
    __param(2, inversify_1.inject(timeline_tree_model_1.TimelineTreeModel)),
    __param(3, inversify_1.inject(browser_1.ContextMenuRenderer)),
    __param(4, inversify_1.inject(common_1.CommandRegistry)),
    __metadata("design:paramtypes", [Object, timeline_service_1.TimelineService,
        timeline_tree_model_1.TimelineTreeModel,
        browser_1.ContextMenuRenderer,
        common_1.CommandRegistry])
], TimelineTreeWidget);
exports.TimelineTreeWidget = TimelineTreeWidget;
class TimelineItemNode extends React.Component {
    constructor() {
        super(...arguments);
        this.open = () => {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            const command = this.props.timelineItem.command;
            if (command) {
                this.props.commandRegistry.executeCommand(command.id, ...command.arguments ? command.arguments : []);
            }
        };
        this.renderContextMenu = (event) => {
            event.preventDefault();
            event.stopPropagation();
            const { timelineItem, contextKeys, contextMenuRenderer } = this.props;
            const currentTimelineItem = contextKeys.timelineItem.get();
            contextKeys.timelineItem.set(timelineItem.contextValue);
            try {
                contextMenuRenderer.render({
                    menuPath: exports.TIMELINE_ITEM_CONTEXT_MENU,
                    anchor: event.nativeEvent,
                    args: [timelineItem]
                });
            }
            finally {
                contextKeys.timelineItem.set(currentTimelineItem);
            }
        };
    }
    render() {
        const { label, description, detail } = this.props.timelineItem;
        return React.createElement("div", { className: 'timeline-item', title: detail, onContextMenu: this.renderContextMenu, onClick: this.open },
            React.createElement("div", { className: `noWrapInfo ${tree_1.TREE_NODE_SEGMENT_GROW_CLASS}` },
                React.createElement("span", { className: 'name' }, label),
                React.createElement("span", { className: 'label' }, description)));
    }
}
exports.TimelineItemNode = TimelineItemNode;


/***/ }),

/***/ "./node_modules/@theia/timeline/lib/browser/timeline-widget.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@theia/timeline/lib/browser/timeline-widget.js ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2020 RedHat and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var TimelineWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TimelineWidget = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const timeline_tree_widget_1 = __webpack_require__(/*! ./timeline-tree-widget */ "./node_modules/@theia/timeline/lib/browser/timeline-tree-widget.js");
const timeline_service_1 = __webpack_require__(/*! ./timeline-service */ "./node_modules/@theia/timeline/lib/browser/timeline-service.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "./node_modules/@theia/core/lib/common/index.js");
const timeline_empty_widget_1 = __webpack_require__(/*! ./timeline-empty-widget */ "./node_modules/@theia/timeline/lib/browser/timeline-empty-widget.js");
const algorithm_1 = __webpack_require__(/*! @theia/core/shared/@phosphor/algorithm */ "./node_modules/@theia/core/shared/@phosphor/algorithm/index.js");
const vscode_uri_1 = __webpack_require__(/*! @theia/core/shared/vscode-uri */ "./node_modules/@theia/core/shared/vscode-uri/index.js");
let TimelineWidget = TimelineWidget_1 = class TimelineWidget extends browser_1.BaseWidget {
    constructor() {
        super();
        this.timelinesBySource = new Map();
        this.id = TimelineWidget_1.ID;
        this.title.label = 'Timeline';
        this.title.caption = this.title.label;
        this.addClass('theia-timeline');
    }
    init() {
        const layout = new browser_1.PanelLayout();
        this.layout = layout;
        this.panel = new browser_1.Panel({ layout: new browser_1.PanelLayout({}) });
        this.panel.node.tabIndex = -1;
        layout.addWidget(this.panel);
        this.containerLayout.addWidget(this.resourceWidget);
        this.containerLayout.addWidget(this.timelineEmptyWidget);
        this.refresh();
        this.toDispose.push(this.timelineService.onDidChangeTimeline(event => {
            const currentWidgetUri = this.getCurrentWidgetUri();
            if (currentWidgetUri) {
                this.loadTimeline(currentWidgetUri, event.reset);
            }
        }));
        this.toDispose.push(this.selectionService.onSelectionChanged(selection => {
            if (Array.isArray(selection) && !!selection[0] && 'uri' in selection[0]) {
                this.refresh(selection[0].uri);
            }
        }));
        this.toDispose.push(this.applicationShell.onDidChangeCurrentWidget(async (e) => {
            if ((e.newValue && browser_1.Navigatable.is(e.newValue)) || !this.suitableWidgetsOpened()) {
                this.refresh();
            }
        }));
        this.toDispose.push(this.applicationShell.onDidRemoveWidget(widget => {
            if (browser_1.NavigatableWidget.is(widget)) {
                this.refresh();
            }
        }));
        this.toDispose.push(this.timelineService.onDidChangeProviders(() => this.refresh()));
    }
    async loadTimelineForSource(source, uri, reset) {
        var _a;
        if (reset) {
            this.timelinesBySource.delete(source);
        }
        let timeline = this.timelinesBySource.get(source);
        const cursor = timeline === null || timeline === void 0 ? void 0 : timeline.cursor;
        const options = { cursor: reset ? undefined : cursor, limit: timeline_tree_widget_1.TimelineTreeWidget.PAGE_SIZE };
        const timelineResult = await this.timelineService.getTimeline(source, uri, options, { cacheResults: true, resetCache: reset });
        if (timelineResult) {
            const items = timelineResult.items;
            if (items) {
                if (timeline) {
                    timeline.add(items);
                    timeline.cursor = (_a = timelineResult.paging) === null || _a === void 0 ? void 0 : _a.cursor;
                }
                else {
                    timeline = new timeline_service_1.TimelineAggregate(timelineResult);
                }
                this.timelinesBySource.set(source, timeline);
                this.resourceWidget.model.updateTree(timeline.items, !!timeline.cursor);
            }
        }
    }
    async loadTimeline(uri, reset) {
        for (const source of this.timelineService.getSources().map(s => s.id)) {
            this.loadTimelineForSource(source, vscode_uri_1.URI.parse(uri.toString()), reset);
        }
    }
    refresh(uri) {
        if (!uri) {
            uri = this.getCurrentWidgetUri();
        }
        if (uri) {
            this.timelineEmptyWidget.hide();
            this.resourceWidget.show();
            this.loadTimeline(uri, true);
        }
        else if (!this.suitableWidgetsOpened()) {
            this.timelineEmptyWidget.show();
            this.resourceWidget.hide();
        }
    }
    suitableWidgetsOpened() {
        return !!algorithm_1.toArray(this.applicationShell.mainPanel.widgets()).find(widget => {
            if (browser_1.NavigatableWidget.is(widget)) {
                const uri = widget.getResourceUri();
                if ((uri === null || uri === void 0 ? void 0 : uri.scheme) && this.timelineService.getSchemas().indexOf(uri === null || uri === void 0 ? void 0 : uri.scheme) > -1) {
                    return true;
                }
            }
        });
    }
    getCurrentWidgetUri() {
        let current = this.applicationShell.currentWidget;
        if (!browser_1.NavigatableWidget.is(current)) {
            current = algorithm_1.toArray(this.applicationShell.mainPanel.widgets()).find(widget => {
                if (widget.isVisible && !widget.isHidden) {
                    return widget;
                }
            });
        }
        return browser_1.NavigatableWidget.is(current) ? current.getResourceUri() : undefined;
    }
    get containerLayout() {
        return this.panel.layout;
    }
    onUpdateRequest(msg) {
        browser_1.MessageLoop.sendMessage(this.resourceWidget, msg);
        browser_1.MessageLoop.sendMessage(this.timelineEmptyWidget, msg);
        this.refresh();
        super.onUpdateRequest(msg);
    }
    onAfterAttach(msg) {
        this.node.appendChild(this.resourceWidget.node);
        this.node.appendChild(this.timelineEmptyWidget.node);
        super.onAfterAttach(msg);
        this.update();
    }
};
TimelineWidget.ID = 'timeline-view';
__decorate([
    inversify_1.inject(timeline_tree_widget_1.TimelineTreeWidget),
    __metadata("design:type", timeline_tree_widget_1.TimelineTreeWidget)
], TimelineWidget.prototype, "resourceWidget", void 0);
__decorate([
    inversify_1.inject(timeline_service_1.TimelineService),
    __metadata("design:type", timeline_service_1.TimelineService)
], TimelineWidget.prototype, "timelineService", void 0);
__decorate([
    inversify_1.inject(common_1.CommandRegistry),
    __metadata("design:type", common_1.CommandRegistry)
], TimelineWidget.prototype, "commandRegistry", void 0);
__decorate([
    inversify_1.inject(browser_1.ApplicationShell),
    __metadata("design:type", browser_1.ApplicationShell)
], TimelineWidget.prototype, "applicationShell", void 0);
__decorate([
    inversify_1.inject(timeline_empty_widget_1.TimelineEmptyWidget),
    __metadata("design:type", timeline_empty_widget_1.TimelineEmptyWidget)
], TimelineWidget.prototype, "timelineEmptyWidget", void 0);
__decorate([
    inversify_1.inject(common_1.SelectionService),
    __metadata("design:type", common_1.SelectionService)
], TimelineWidget.prototype, "selectionService", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TimelineWidget.prototype, "init", null);
TimelineWidget = TimelineWidget_1 = __decorate([
    inversify_1.injectable(),
    __metadata("design:paramtypes", [])
], TimelineWidget);
exports.TimelineWidget = TimelineWidget;


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_timeline_lib_browser_timeline-contribution_js-node_modules_theia_t-47f69f.bundle.js.map