(global["webpackChunkarduino_ide"] = global["webpackChunkarduino_ide"] || []).push([["vendors-node_modules_theia_preferences_lib_browser_preferences-contribution_js"],{

/***/ "./node_modules/@theia/core/shared/fuzzy/index.js":
/*!********************************************************!*\
  !*** ./node_modules/@theia/core/shared/fuzzy/index.js ***!
  \********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! fuzzy */ "./node_modules/fuzzy/lib/fuzzy.js");


/***/ }),

/***/ "./node_modules/@theia/preferences/lib/browser/abstract-resource-preference-provider.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@theia/preferences/lib/browser/abstract-resource-preference-provider.js ***!
  \**********************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2018 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AbstractResourcePreferenceProvider = void 0;
/* eslint-disable @typescript-eslint/no-explicit-any */
/* eslint-disable no-null/no-null */
const jsoncparser = __webpack_require__(/*! jsonc-parser */ "./node_modules/jsonc-parser/lib/esm/main.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const disposable_1 = __webpack_require__(/*! @theia/core/lib/common/disposable */ "./node_modules/@theia/core/lib/common/disposable.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "./node_modules/@theia/core/lib/common/uri.js");
const preference_configurations_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences/preference-configurations */ "./node_modules/@theia/core/lib/browser/preferences/preference-configurations.js");
const promise_util_1 = __webpack_require__(/*! @theia/core/lib/common/promise-util */ "./node_modules/@theia/core/lib/common/promise-util.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "./node_modules/@theia/filesystem/lib/browser/file-service.js");
const preference_transaction_manager_1 = __webpack_require__(/*! ./preference-transaction-manager */ "./node_modules/@theia/preferences/lib/browser/preference-transaction-manager.js");
const core_1 = __webpack_require__(/*! @theia/core */ "./node_modules/@theia/core/lib/common/index.js");
let AbstractResourcePreferenceProvider = class AbstractResourcePreferenceProvider extends browser_1.PreferenceProvider {
    constructor() {
        super(...arguments);
        this.preferences = {};
        this._fileExists = false;
        this.loading = new promise_util_1.Deferred();
        this.onDidChangeValidityEmitter = new core_1.Emitter();
    }
    set fileExists(exists) {
        if (exists !== this._fileExists) {
            this._fileExists = exists;
            this.onDidChangeValidityEmitter.fire(exists);
        }
    }
    get onDidChangeValidity() {
        return this.onDidChangeValidityEmitter.event;
    }
    async init() {
        const uri = this.getUri();
        this.toDispose.push(disposable_1.Disposable.create(() => this.loading.reject(new Error(`preference provider for '${uri}' was disposed`))));
        await this.readPreferencesFromFile();
        this._ready.resolve();
        this.loading.resolve();
        this.toDispose.pushAll([
            this.fileService.watch(uri),
            this.fileService.onDidFilesChange(e => {
                if (e.contains(uri)) {
                    this.readPreferencesFromFile();
                }
            }),
            disposable_1.Disposable.create(() => this.reset()),
        ]);
    }
    get valid() {
        return this._fileExists;
    }
    getConfigUri(resourceUri) {
        if (!resourceUri) {
            return this.getUri();
        }
        return this.valid && this.contains(resourceUri) ? this.getUri() : undefined;
    }
    contains(resourceUri) {
        if (!resourceUri) {
            return true;
        }
        const domain = this.getDomain();
        if (!domain) {
            return true;
        }
        const resourcePath = new uri_1.default(resourceUri).path;
        return domain.some(uri => new uri_1.default(uri).path.relativity(resourcePath) >= 0);
    }
    getPreferences(resourceUri) {
        return this.valid && this.contains(resourceUri) ? this.preferences : {};
    }
    async setPreference(key, value, resourceUri) {
        let path;
        if (this.toDispose.disposed || !(path = this.getPath(key)) || !this.contains(resourceUri)) {
            return false;
        }
        return this.doSetPreference(key, path, value);
    }
    async doSetPreference(key, path, value) {
        var _a;
        if (!((_a = this.transaction) === null || _a === void 0 ? void 0 : _a.open)) {
            const current = this.transaction;
            this.transaction = this.transactionFactory(this);
            this.transaction.onWillConclude(({ status, waitUntil }) => {
                if (status) {
                    waitUntil((async () => {
                        await this.readPreferencesFromFile();
                        await this.fireDidPreferencesChanged(); // Ensure all consumers of the event have received it.
                    })());
                }
            });
            this.toDispose.push(this.transaction);
            await (current === null || current === void 0 ? void 0 : current.result);
        }
        return this.transaction.enqueueAction(key, path, value);
    }
    getPath(preferenceName) {
        return [preferenceName];
    }
    async readPreferencesFromFile() {
        const content = await this.fileService.read(this.getUri())
            .then(value => {
            this.fileExists = true;
            return value;
        })
            .catch(() => {
            this.fileExists = false;
            return { value: '' };
        });
        this.readPreferencesFromContent(content.value);
    }
    readPreferencesFromContent(content) {
        let preferencesInJson;
        try {
            preferencesInJson = this.parse(content);
        }
        catch (_a) {
            preferencesInJson = {};
        }
        const parsedPreferences = this.getParsedContent(preferencesInJson);
        this.handlePreferenceChanges(parsedPreferences);
    }
    parse(content) {
        content = content.trim();
        if (!content) {
            return undefined;
        }
        const strippedContent = jsoncparser.stripComments(content);
        return jsoncparser.parse(strippedContent);
    }
    handlePreferenceChanges(newPrefs) {
        const oldPrefs = Object.assign({}, this.preferences);
        this.preferences = newPrefs;
        const prefNames = new Set([...Object.keys(oldPrefs), ...Object.keys(newPrefs)]);
        const prefChanges = [];
        const uri = this.getUri();
        for (const prefName of prefNames.values()) {
            const oldValue = oldPrefs[prefName];
            const newValue = newPrefs[prefName];
            const schemaProperties = this.schemaProvider.getCombinedSchema().properties[prefName];
            if (schemaProperties) {
                const scope = schemaProperties.scope;
                // do not emit the change event if the change is made out of the defined preference scope
                if (!this.schemaProvider.isValidInScope(prefName, this.getScope())) {
                    console.warn(`Preference ${prefName} in ${uri} can only be defined in scopes: ${browser_1.PreferenceScope.getScopeNames(scope).join(', ')}.`);
                    continue;
                }
            }
            if (!browser_1.PreferenceProvider.deepEqual(newValue, oldValue)) {
                prefChanges.push({
                    preferenceName: prefName, newValue, oldValue, scope: this.getScope(), domain: this.getDomain()
                });
            }
        }
        if (prefChanges.length > 0) {
            this.emitPreferencesChangedEvent(prefChanges);
        }
    }
    reset() {
        const preferences = this.preferences;
        this.preferences = {};
        const changes = [];
        for (const prefName of Object.keys(preferences)) {
            const value = preferences[prefName];
            if (value !== undefined) {
                changes.push({
                    preferenceName: prefName, newValue: undefined, oldValue: value, scope: this.getScope(), domain: this.getDomain()
                });
            }
        }
        if (changes.length > 0) {
            this.emitPreferencesChangedEvent(changes);
        }
    }
};
__decorate([
    inversify_1.inject(preference_transaction_manager_1.PreferenceTransactionFactory),
    __metadata("design:type", Function)
], AbstractResourcePreferenceProvider.prototype, "transactionFactory", void 0);
__decorate([
    inversify_1.inject(browser_1.PreferenceSchemaProvider),
    __metadata("design:type", browser_1.PreferenceSchemaProvider)
], AbstractResourcePreferenceProvider.prototype, "schemaProvider", void 0);
__decorate([
    inversify_1.inject(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], AbstractResourcePreferenceProvider.prototype, "fileService", void 0);
__decorate([
    inversify_1.inject(preference_configurations_1.PreferenceConfigurations),
    __metadata("design:type", preference_configurations_1.PreferenceConfigurations)
], AbstractResourcePreferenceProvider.prototype, "configurations", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], AbstractResourcePreferenceProvider.prototype, "init", null);
AbstractResourcePreferenceProvider = __decorate([
    inversify_1.injectable()
], AbstractResourcePreferenceProvider);
exports.AbstractResourcePreferenceProvider = AbstractResourcePreferenceProvider;


/***/ }),

/***/ "./node_modules/@theia/preferences/lib/browser/monaco-jsonc-editor.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@theia/preferences/lib/browser/monaco-jsonc-editor.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MonacoJSONCEditor = void 0;
const jsoncparser = __webpack_require__(/*! jsonc-parser */ "./node_modules/jsonc-parser/lib/esm/main.js");
const monaco_workspace_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-workspace */ "./node_modules/@theia/monaco/lib/browser/monaco-workspace.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
let MonacoJSONCEditor = class MonacoJSONCEditor {
    async setValue(model, path, value, shouldSave = true) {
        const edits = this.getEditOperations(model, path, value);
        if (edits.length > 0) {
            await this.workspace.applyBackgroundEdit(model, edits, shouldSave);
        }
    }
    getEditOperations(model, path, value) {
        const textModel = model.textEditorModel;
        const content = model.getText().trim();
        // Everything is already undefined - no need for changes.
        if (!content && value === undefined) {
            return [];
        }
        // Delete the entire document.
        if (!path.length && value === undefined) {
            return [{
                    range: textModel.getFullModelRange(),
                    text: null,
                    forceMoveMarkers: false
                }];
        }
        const { insertSpaces, tabSize, defaultEOL } = textModel.getOptions();
        const jsonCOptions = {
            formattingOptions: {
                insertSpaces,
                tabSize,
                eol: defaultEOL === monaco.editor.DefaultEndOfLine.LF ? '\n' : '\r\n'
            }
        };
        return jsoncparser.modify(content, path, value, jsonCOptions).map(edit => {
            const start = textModel.getPositionAt(edit.offset);
            const end = textModel.getPositionAt(edit.offset + edit.length);
            return {
                range: monaco.Range.fromPositions(start, end),
                text: edit.content || null,
                forceMoveMarkers: false
            };
        });
    }
};
__decorate([
    inversify_1.inject(monaco_workspace_1.MonacoWorkspace),
    __metadata("design:type", monaco_workspace_1.MonacoWorkspace)
], MonacoJSONCEditor.prototype, "workspace", void 0);
MonacoJSONCEditor = __decorate([
    inversify_1.injectable()
], MonacoJSONCEditor);
exports.MonacoJSONCEditor = MonacoJSONCEditor;


/***/ }),

/***/ "./node_modules/@theia/preferences/lib/browser/preference-transaction-manager.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@theia/preferences/lib/browser/preference-transaction-manager.js ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceTransactionFactory = exports.PreferenceTransaction = exports.PreferenceContext = exports.Transaction = void 0;
const core_1 = __webpack_require__(/*! @theia/core */ "./node_modules/@theia/core/lib/common/index.js");
const promise_util_1 = __webpack_require__(/*! @theia/core/lib/common/promise-util */ "./node_modules/@theia/core/lib/common/promise-util.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const preference_scope_1 = __webpack_require__(/*! @theia/core/lib/common/preferences/preference-scope */ "./node_modules/@theia/core/lib/common/preferences/preference-scope.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "./node_modules/@theia/core/lib/common/uri.js");
const async_mutex_1 = __webpack_require__(/*! async-mutex */ "./node_modules/async-mutex/lib/index.js");
const monaco_text_model_service_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-text-model-service */ "./node_modules/@theia/monaco/lib/browser/monaco-text-model-service.js");
const monaco_jsonc_editor_1 = __webpack_require__(/*! ./monaco-jsonc-editor */ "./node_modules/@theia/preferences/lib/browser/monaco-jsonc-editor.js");
const editor_manager_1 = __webpack_require__(/*! @theia/editor/lib/browser/editor-manager */ "./node_modules/@theia/editor/lib/browser/editor-manager.js");
let Transaction = 
/**
 * Represents a batch of interactions with an underlying resource.
 */
class Transaction {
    constructor() {
        this._open = true;
        this._result = new promise_util_1.Deferred();
        /**
         * The transaction will self-dispose when the queue is empty, once at least one action has been processed.
         */
        this.queue = new async_mutex_1.Mutex(new core_1.CancellationError());
        this.onWillConcludeEmitter = new core_1.Emitter();
        this.status = new promise_util_1.Deferred();
        /**
         * Whether any actions have been added to the transaction.
         * The Transaction will not self-dispose until at least one action has been performed.
         */
        this.inUse = false;
    }
    /**
     * Whether the transaction is still accepting new interactions.
     * Enqueueing an action when the Transaction is no longer open will throw an error.
     */
    get open() {
        return this._open;
    }
    /**
     * The status of the transaction when complete.
     */
    get result() {
        return this._result.promise;
    }
    /**
     * An event fired when the transaction is wrapping up.
     * Consumers can call `waitUntil` on the event to delay the resolution of the `result` Promise.
     */
    get onWillConclude() {
        return this.onWillConcludeEmitter.event;
    }
    async init() {
        const release = await this.queue.acquire();
        try {
            const status = await this.setUp();
            this.status.resolve(status);
        }
        catch (_a) {
            this.dispose();
        }
        finally {
            release();
        }
    }
    /**
     * @returns a promise reflecting the result of performing an action. Typically the promise will not resolve until the whole transaction is complete.
     */
    async enqueueAction(...args) {
        if (this._open) {
            let release;
            try {
                release = await this.queue.acquire();
                if (!this.inUse) {
                    this.inUse = true;
                    this.queue.waitForUnlock().then(() => this.dispose());
                }
                return this.act(...args);
            }
            catch (e) {
                if (e instanceof core_1.CancellationError) {
                    throw e;
                }
                return false;
            }
            finally {
                if (release) {
                    release();
                }
            }
        }
        else {
            throw new Error('Transaction used after disposal.');
        }
    }
    async conclude() {
        if (this._open) {
            try {
                this._open = false;
                this.queue.cancel();
                const result = await this.tearDown();
                const status = this.status.state === 'unresolved' || this.status.state === 'rejected' ? false : await this.status.promise;
                await core_1.WaitUntilEvent.fire(this.onWillConcludeEmitter, { status });
                this.onWillConcludeEmitter.dispose();
                this._result.resolve(result);
            }
            catch (_a) {
                this._result.resolve(false);
            }
        }
    }
    dispose() {
        this.conclude();
    }
};
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], Transaction.prototype, "init", null);
Transaction = __decorate([
    inversify_1.injectable()
    /**
     * Represents a batch of interactions with an underlying resource.
     */
], Transaction);
exports.Transaction = Transaction;
exports.PreferenceContext = Symbol('PreferenceContext');
let PreferenceTransaction = class PreferenceTransaction extends Transaction {
    async setUp() {
        const reference = await this.textModelService.createModelReference(this.context.getConfigUri());
        if (this._open) {
            this.reference = reference;
        }
        else {
            reference.dispose();
            return false;
        }
        if (reference.object.dirty) {
            const shouldContinue = await this.handleDirtyEditor();
            if (!shouldContinue) {
                this.dispose();
                return false;
            }
        }
        return true;
    }
    /**
     * @returns whether the setting operation in progress, and any others started in the meantime, should continue.
     */
    async handleDirtyEditor() {
        var _a;
        const saveAndRetry = core_1.nls.localizeByDefault('Save and Retry');
        const open = core_1.nls.localizeByDefault('Open File');
        const msg = await this.messageService.error(core_1.nls.localizeByDefault('Unable to write into {0} settings because the file has unsaved changes. Please save the {0} settings file first and then try again.', core_1.nls.localizeByDefault(preference_scope_1.PreferenceScope[this.context.getScope()].toLocaleLowerCase())), saveAndRetry, open);
        if ((_a = this.reference) === null || _a === void 0 ? void 0 : _a.object) {
            if (msg === open) {
                this.editorManager.open(new uri_1.default(this.reference.object.uri));
            }
            else if (msg === saveAndRetry) {
                await this.reference.object.save();
                return true;
            }
        }
        return false;
    }
    async act(key, path, value) {
        var _a;
        const model = (_a = this.reference) === null || _a === void 0 ? void 0 : _a.object;
        try {
            if (model) {
                await this.jsoncEditor.setValue(model, path, value);
                return this.result;
            }
            return false;
        }
        catch (e) {
            const message = `Failed to update the value of '${key}' in '${this.context.getConfigUri()}'.`;
            this.messageService.error(`${message} Please check if it is corrupted.`);
            console.error(`${message}`, e);
            return false;
        }
    }
    async tearDown() {
        var _a, _b;
        const model = (_a = this.reference) === null || _a === void 0 ? void 0 : _a.object;
        if (model) {
            if (this.status.state === 'resolved' && await this.status.promise) {
                await model.save();
                return true;
            }
            (_b = this.reference) === null || _b === void 0 ? void 0 : _b.dispose();
            this.reference = undefined;
        }
        return false;
    }
};
__decorate([
    inversify_1.inject(exports.PreferenceContext),
    __metadata("design:type", Object)
], PreferenceTransaction.prototype, "context", void 0);
__decorate([
    inversify_1.inject(monaco_text_model_service_1.MonacoTextModelService),
    __metadata("design:type", monaco_text_model_service_1.MonacoTextModelService)
], PreferenceTransaction.prototype, "textModelService", void 0);
__decorate([
    inversify_1.inject(monaco_jsonc_editor_1.MonacoJSONCEditor),
    __metadata("design:type", monaco_jsonc_editor_1.MonacoJSONCEditor)
], PreferenceTransaction.prototype, "jsoncEditor", void 0);
__decorate([
    inversify_1.inject(core_1.MessageService),
    __metadata("design:type", core_1.MessageService)
], PreferenceTransaction.prototype, "messageService", void 0);
__decorate([
    inversify_1.inject(editor_manager_1.EditorManager),
    __metadata("design:type", editor_manager_1.EditorManager)
], PreferenceTransaction.prototype, "editorManager", void 0);
PreferenceTransaction = __decorate([
    inversify_1.injectable()
], PreferenceTransaction);
exports.PreferenceTransaction = PreferenceTransaction;
exports.PreferenceTransactionFactory = Symbol('PreferenceTransactionFactory');


/***/ }),

/***/ "./node_modules/@theia/preferences/lib/browser/preference-tree-model.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@theia/preferences/lib/browser/preference-tree-model.js ***!
  \******************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceTreeModel = exports.PreferenceFilterChangeSource = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "./node_modules/@theia/core/lib/common/index.js");
const preference_searchbar_widget_1 = __webpack_require__(/*! ./views/preference-searchbar-widget */ "./node_modules/@theia/preferences/lib/browser/views/preference-searchbar-widget.js");
const preference_tree_generator_1 = __webpack_require__(/*! ./util/preference-tree-generator */ "./node_modules/@theia/preferences/lib/browser/util/preference-tree-generator.js");
const fuzzy = __webpack_require__(/*! @theia/core/shared/fuzzy */ "./node_modules/@theia/core/shared/fuzzy/index.js");
const preference_scope_tabbar_widget_1 = __webpack_require__(/*! ./views/preference-scope-tabbar-widget */ "./node_modules/@theia/preferences/lib/browser/views/preference-scope-tabbar-widget.js");
const preference_types_1 = __webpack_require__(/*! ./util/preference-types */ "./node_modules/@theia/preferences/lib/browser/util/preference-types.js");
var PreferenceFilterChangeSource;
(function (PreferenceFilterChangeSource) {
    PreferenceFilterChangeSource[PreferenceFilterChangeSource["Schema"] = 0] = "Schema";
    PreferenceFilterChangeSource[PreferenceFilterChangeSource["Search"] = 1] = "Search";
    PreferenceFilterChangeSource[PreferenceFilterChangeSource["Scope"] = 2] = "Scope";
})(PreferenceFilterChangeSource = exports.PreferenceFilterChangeSource || (exports.PreferenceFilterChangeSource = {}));
let PreferenceTreeModel = class PreferenceTreeModel extends browser_1.TreeModelImpl {
    constructor() {
        super(...arguments);
        this.onTreeFilterChangedEmitter = new core_1.Emitter();
        this.onFilterChanged = this.onTreeFilterChangedEmitter.event;
        this.lastSearchedFuzzy = '';
        this.lastSearchedLiteral = '';
        this._currentScope = Number(preference_types_1.Preference.DEFAULT_SCOPE.scope);
        this._isFiltered = false;
        this._currentRows = new Map();
        this._totalVisibleLeaves = 0;
    }
    get currentRows() {
        return this._currentRows;
    }
    get totalVisibleLeaves() {
        return this._totalVisibleLeaves;
    }
    get isFiltered() {
        return this._isFiltered;
    }
    get propertyList() {
        return this.schemaProvider.getCombinedSchema().properties;
    }
    get currentScope() {
        return this.scopeTracker.currentScope;
    }
    get onSchemaChanged() {
        return this.treeGenerator.onSchemaChanged;
    }
    async init() {
        super.init();
        this.toDispose.pushAll([
            this.treeGenerator.onSchemaChanged(newTree => this.handleNewSchema(newTree)),
            this.scopeTracker.onScopeChanged(scopeDetails => {
                this._currentScope = scopeDetails.scope;
                this.updateFilteredRows(PreferenceFilterChangeSource.Scope);
            }),
            this.filterInput.onFilterChanged(newSearchTerm => {
                this.lastSearchedLiteral = newSearchTerm;
                this.lastSearchedFuzzy = newSearchTerm.replace(/\s/g, '');
                this._isFiltered = newSearchTerm.length > 2;
                if (this.isFiltered) {
                    this.expandAll();
                }
                else if (browser_1.CompositeTreeNode.is(this.root)) {
                    this.collapseAll(this.root);
                }
                this.updateFilteredRows(PreferenceFilterChangeSource.Search);
            }),
            this.onFilterChanged(() => {
                this.filterInput.updateResultsCount(this._totalVisibleLeaves);
            }),
            this.onTreeFilterChangedEmitter,
        ]);
        await this.preferenceService.ready;
        this.handleNewSchema(this.treeGenerator.root);
    }
    handleNewSchema(newRoot) {
        this.root = newRoot;
        if (this.isFiltered) {
            this.expandAll();
        }
        this.updateFilteredRows(PreferenceFilterChangeSource.Schema);
    }
    updateRows() {
        const root = this.root;
        this._currentRows = new Map();
        if (root) {
            this._totalVisibleLeaves = 0;
            let index = 0;
            for (const node of new browser_1.TopDownTreeIterator(root, {
                pruneCollapsed: false,
                pruneSiblings: true
            })) {
                if (browser_1.TreeNode.isVisible(node) && preference_types_1.Preference.TreeNode.is(node)) {
                    const { id } = preference_types_1.Preference.TreeNode.getGroupAndIdFromNodeId(node.id);
                    if (browser_1.CompositeTreeNode.is(node) || this.passesCurrentFilters(node, id)) {
                        this.updateVisibleChildren(node);
                        this._currentRows.set(node.id, {
                            index: index++,
                            node,
                            depth: node.depth,
                            visibleChildren: 0,
                        });
                    }
                }
            }
        }
    }
    updateFilteredRows(source) {
        this.updateRows();
        this.onTreeFilterChangedEmitter.fire({ source });
    }
    passesCurrentFilters(node, prefID) {
        var _a;
        if (!this.schemaProvider.isValidInScope(prefID, this._currentScope)) {
            return false;
        }
        if (!this._isFiltered) {
            return true;
        }
        // When filtering, VSCode will render an item that is present in the commonly used section only once but render both its possible parents in the left-hand tree.
        // E.g. searching for editor.renderWhitespace will show one item in the main panel, but both 'Commonly Used' and 'Text Editor' in the left tree.
        // That seems counterintuitive and introduces a number of special cases, so I prefer to remove the commonly used section entirely when the user searches.
        if (node.id.startsWith(preference_tree_generator_1.COMMONLY_USED_SECTION_PREFIX)) {
            return false;
        }
        return fuzzy.test(this.lastSearchedFuzzy, prefID) // search matches preference name.
            // search matches description. Fuzzy isn't ideal here because the score depends on the order of discovery.
            || ((_a = node.preference.data.description) !== null && _a !== void 0 ? _a : '').includes(this.lastSearchedLiteral);
    }
    isVisibleSelectableNode(node) {
        var _a;
        return browser_1.CompositeTreeNode.is(node) && !!((_a = this._currentRows.get(node.id)) === null || _a === void 0 ? void 0 : _a.visibleChildren);
    }
    updateVisibleChildren(node) {
        var _a, _b, _c, _d;
        if (!browser_1.CompositeTreeNode.is(node)) {
            this._totalVisibleLeaves++;
            let nextParent = ((_a = node.parent) === null || _a === void 0 ? void 0 : _a.id) && this._currentRows.get((_b = node.parent) === null || _b === void 0 ? void 0 : _b.id);
            while (nextParent && nextParent.node !== this.root) {
                if (nextParent) {
                    nextParent.visibleChildren += 1;
                }
                nextParent = ((_c = nextParent.node.parent) === null || _c === void 0 ? void 0 : _c.id) && this._currentRows.get((_d = nextParent.node.parent) === null || _d === void 0 ? void 0 : _d.id);
                if (nextParent) {
                    nextParent.isExpansible = true;
                }
            }
        }
    }
    collapseAllExcept(openNode) {
        if (browser_1.ExpandableTreeNode.is(openNode)) {
            this.expandNode(openNode);
        }
        if (browser_1.CompositeTreeNode.is(this.root)) {
            this.root.children.forEach(child => {
                if (child !== openNode && browser_1.ExpandableTreeNode.is(child)) {
                    this.collapseNode(child);
                }
            });
        }
    }
    expandAll() {
        if (browser_1.CompositeTreeNode.is(this.root)) {
            this.root.children.forEach(child => {
                if (browser_1.ExpandableTreeNode.is(child)) {
                    this.expandNode(child);
                }
            });
        }
    }
    getNodeFromPreferenceId(id) {
        const node = this.getNode(this.treeGenerator.getNodeId(id));
        return node && preference_types_1.Preference.TreeNode.is(node) ? node : undefined;
    }
    /**
     * @returns true if selection changed, false otherwise
     */
    selectIfNotSelected(node) {
        const currentlySelected = this.selectedNodes[0];
        if (node !== currentlySelected) {
            this.selectNode(node);
            return true;
        }
        return false;
    }
};
__decorate([
    inversify_1.inject(browser_1.PreferenceSchemaProvider),
    __metadata("design:type", browser_1.PreferenceSchemaProvider)
], PreferenceTreeModel.prototype, "schemaProvider", void 0);
__decorate([
    inversify_1.inject(preference_searchbar_widget_1.PreferencesSearchbarWidget),
    __metadata("design:type", preference_searchbar_widget_1.PreferencesSearchbarWidget)
], PreferenceTreeModel.prototype, "filterInput", void 0);
__decorate([
    inversify_1.inject(preference_tree_generator_1.PreferenceTreeGenerator),
    __metadata("design:type", preference_tree_generator_1.PreferenceTreeGenerator)
], PreferenceTreeModel.prototype, "treeGenerator", void 0);
__decorate([
    inversify_1.inject(preference_scope_tabbar_widget_1.PreferencesScopeTabBar),
    __metadata("design:type", preference_scope_tabbar_widget_1.PreferencesScopeTabBar)
], PreferenceTreeModel.prototype, "scopeTracker", void 0);
__decorate([
    inversify_1.inject(browser_1.PreferenceService),
    __metadata("design:type", Object)
], PreferenceTreeModel.prototype, "preferenceService", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], PreferenceTreeModel.prototype, "init", null);
PreferenceTreeModel = __decorate([
    inversify_1.injectable()
], PreferenceTreeModel);
exports.PreferenceTreeModel = PreferenceTreeModel;


/***/ }),

/***/ "./node_modules/@theia/preferences/lib/browser/preferences-contribution.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@theia/preferences/lib/browser/preferences-contribution.js ***!
  \*********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2018 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferencesContribution = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const os_1 = __webpack_require__(/*! @theia/core/lib/common/os */ "./node_modules/@theia/core/lib/common/os.js");
const browser_2 = __webpack_require__(/*! @theia/editor/lib/browser */ "./node_modules/@theia/editor/lib/browser/index.js");
const preference_widget_1 = __webpack_require__(/*! ./views/preference-widget */ "./node_modules/@theia/preferences/lib/browser/views/preference-widget.js");
const workspace_preference_provider_1 = __webpack_require__(/*! ./workspace-preference-provider */ "./node_modules/@theia/preferences/lib/browser/workspace-preference-provider.js");
const preference_types_1 = __webpack_require__(/*! ./util/preference-types */ "./node_modules/@theia/preferences/lib/browser/util/preference-types.js");
const clipboard_service_1 = __webpack_require__(/*! @theia/core/lib/browser/clipboard-service */ "./node_modules/@theia/core/lib/browser/clipboard-service.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "./node_modules/@theia/filesystem/lib/browser/file-service.js");
const browser_3 = __webpack_require__(/*! @theia/workspace/lib/browser */ "./node_modules/@theia/workspace/lib/browser/index.js");
let PreferencesContribution = class PreferencesContribution extends browser_1.AbstractViewContribution {
    constructor() {
        super({
            widgetId: preference_widget_1.PreferencesWidget.ID,
            widgetName: preference_widget_1.PreferencesWidget.LABEL,
            defaultWidgetOptions: {
                area: 'main',
            },
        });
    }
    registerCommands(commands) {
        commands.registerCommand(browser_1.CommonCommands.OPEN_PREFERENCES, {
            execute: async (query) => {
                const widget = await this.openView({ activate: true });
                if (typeof query === 'string') {
                    widget.setSearchTerm(query);
                }
            },
        });
        commands.registerCommand(preference_types_1.PreferencesCommands.OPEN_PREFERENCES_JSON_TOOLBAR, {
            isEnabled: () => true,
            isVisible: w => this.withWidget(w, () => true),
            execute: (preferenceId) => {
                this.openPreferencesJSON(preferenceId);
            }
        });
        commands.registerCommand(preference_types_1.PreferencesCommands.COPY_JSON_NAME, {
            isEnabled: preference_types_1.Preference.EditorCommandArgs.is,
            isVisible: preference_types_1.Preference.EditorCommandArgs.is,
            execute: ({ id, value }) => {
                this.clipboardService.writeText(id);
            }
        });
        commands.registerCommand(preference_types_1.PreferencesCommands.COPY_JSON_VALUE, {
            isEnabled: preference_types_1.Preference.EditorCommandArgs.is,
            isVisible: preference_types_1.Preference.EditorCommandArgs.is,
            execute: ({ id, value }) => {
                const jsonString = `"${id}": ${JSON.stringify(value)}`;
                this.clipboardService.writeText(jsonString);
            }
        });
        commands.registerCommand(preference_types_1.PreferencesCommands.RESET_PREFERENCE, {
            isEnabled: preference_types_1.Preference.EditorCommandArgs.is,
            isVisible: preference_types_1.Preference.EditorCommandArgs.is,
            execute: ({ id }) => {
                this.preferenceService.set(id, undefined, Number(this.scopeTracker.currentScope.scope), this.scopeTracker.currentScope.uri);
            }
        });
        commands.registerCommand(preference_types_1.PreferencesCommands.OPEN_USER_PREFERENCES, {
            execute: async () => {
                const widget = await this.openView({ activate: true });
                widget.setScope(browser_1.PreferenceScope.User);
            }
        });
        commands.registerCommand(preference_types_1.PreferencesCommands.OPEN_WORKSPACE_PREFERENCES, {
            isEnabled: () => !!this.workspaceService.workspace,
            isVisible: () => !!this.workspaceService.workspace,
            execute: async () => {
                const widget = await this.openView({ activate: true });
                widget.setScope(browser_1.PreferenceScope.Workspace);
            }
        });
        commands.registerCommand(preference_types_1.PreferencesCommands.OPEN_FOLDER_PREFERENCES, {
            isEnabled: () => !!this.workspaceService.isMultiRootWorkspaceOpened && this.workspaceService.tryGetRoots().length > 0,
            isVisible: () => !!this.workspaceService.isMultiRootWorkspaceOpened && this.workspaceService.tryGetRoots().length > 0,
            execute: () => this.openFolderPreferences(root => {
                this.openView({ activate: true });
                this.scopeTracker.setScope(root.resource);
            })
        });
        commands.registerCommand(preference_types_1.PreferencesCommands.OPEN_USER_PREFERENCES_JSON, {
            execute: async () => this.openJson(browser_1.PreferenceScope.User)
        });
        commands.registerCommand(preference_types_1.PreferencesCommands.OPEN_WORKSPACE_PREFERENCES_JSON, {
            isEnabled: () => !!this.workspaceService.workspace,
            isVisible: () => !!this.workspaceService.workspace,
            execute: async () => this.openJson(browser_1.PreferenceScope.Workspace)
        });
        commands.registerCommand(preference_types_1.PreferencesCommands.OPEN_FOLDER_PREFERENCES_JSON, {
            isEnabled: () => !!this.workspaceService.isMultiRootWorkspaceOpened && this.workspaceService.tryGetRoots().length > 0,
            isVisible: () => !!this.workspaceService.isMultiRootWorkspaceOpened && this.workspaceService.tryGetRoots().length > 0,
            execute: () => this.openFolderPreferences(root => this.openJson(browser_1.PreferenceScope.Folder, root.resource.toString()))
        });
    }
    registerMenus(menus) {
        menus.registerMenuAction(browser_1.CommonMenus.FILE_SETTINGS_SUBMENU_OPEN, {
            commandId: browser_1.CommonCommands.OPEN_PREFERENCES.id,
            label: browser_1.CommonCommands.OPEN_PREFERENCES.label,
            order: 'a10',
        });
        menus.registerMenuAction(browser_1.CommonMenus.SETTINGS_OPEN, {
            commandId: browser_1.CommonCommands.OPEN_PREFERENCES.id,
            label: browser_1.CommonCommands.OPEN_PREFERENCES.label,
            order: 'a10',
        });
        menus.registerMenuAction(preference_types_1.PreferenceMenus.PREFERENCE_EDITOR_CONTEXT_MENU, {
            commandId: preference_types_1.PreferencesCommands.RESET_PREFERENCE.id,
            label: preference_types_1.PreferencesCommands.RESET_PREFERENCE.label,
            order: 'a'
        });
        menus.registerMenuAction(preference_types_1.PreferenceMenus.PREFERENCE_EDITOR_COPY_ACTIONS, {
            commandId: preference_types_1.PreferencesCommands.COPY_JSON_VALUE.id,
            label: preference_types_1.PreferencesCommands.COPY_JSON_VALUE.label,
            order: 'b'
        });
        menus.registerMenuAction(preference_types_1.PreferenceMenus.PREFERENCE_EDITOR_COPY_ACTIONS, {
            commandId: preference_types_1.PreferencesCommands.COPY_JSON_NAME.id,
            label: preference_types_1.PreferencesCommands.COPY_JSON_NAME.label,
            order: 'c'
        });
    }
    registerKeybindings(keybindings) {
        keybindings.registerKeybinding({
            command: browser_1.CommonCommands.OPEN_PREFERENCES.id,
            keybinding: (os_1.isOSX && !browser_1.isFirefox) ? 'cmd+,' : 'ctrl+,'
        });
    }
    registerToolbarItems(toolbar) {
        toolbar.registerItem({
            id: preference_types_1.PreferencesCommands.OPEN_PREFERENCES_JSON_TOOLBAR.id,
            command: preference_types_1.PreferencesCommands.OPEN_PREFERENCES_JSON_TOOLBAR.id,
            tooltip: preference_types_1.PreferencesCommands.OPEN_USER_PREFERENCES_JSON.label,
            priority: 0,
        });
    }
    async openPreferencesJSON(opener) {
        var _a;
        const { scope, activeScopeIsFolder, uri } = this.scopeTracker.currentScope;
        const scopeID = Number(scope);
        let preferenceId = '';
        if (typeof opener === 'string') {
            preferenceId = opener;
            const currentPreferenceValue = this.preferenceService.inspect(preferenceId, uri);
            const valueInCurrentScope = (_a = preference_types_1.Preference.getValueInScope(currentPreferenceValue, scopeID)) !== null && _a !== void 0 ? _a : currentPreferenceValue === null || currentPreferenceValue === void 0 ? void 0 : currentPreferenceValue.defaultValue;
            this.preferenceService.set(preferenceId, valueInCurrentScope, scopeID, uri);
        }
        let jsonEditorWidget;
        const jsonUriToOpen = await this.obtainConfigUri(scopeID, activeScopeIsFolder, uri);
        if (jsonUriToOpen) {
            jsonEditorWidget = await this.editorManager.open(jsonUriToOpen);
            if (preferenceId) {
                const text = jsonEditorWidget.editor.document.getText();
                if (preferenceId) {
                    const { index } = text.match(preferenceId);
                    const numReturns = text.slice(0, index).match(new RegExp('\n', 'g')).length;
                    jsonEditorWidget.editor.cursor = { line: numReturns, character: 4 + preferenceId.length + 4 };
                }
            }
        }
    }
    async openJson(scope, resource) {
        const jsonUriToOpen = await this.obtainConfigUri(scope, false, resource);
        if (jsonUriToOpen) {
            await this.editorManager.open(jsonUriToOpen);
        }
    }
    /**
     * Prompts which workspace root folder to open the JSON settings.
     */
    async openFolderPreferences(callback) {
        var _a;
        const roots = this.workspaceService.tryGetRoots();
        if (roots.length === 1) {
            callback(roots[0]);
        }
        else {
            const items = roots.map(root => ({
                label: root.name,
                description: root.resource.path.toString(),
                execute: () => callback(root)
            }));
            (_a = this.quickInputService) === null || _a === void 0 ? void 0 : _a.showQuickPick(items, { placeholder: 'Select workspace folder' });
        }
    }
    async obtainConfigUri(serializedScope, activeScopeIsFolder, resource) {
        let scope = serializedScope;
        if (activeScopeIsFolder) {
            scope = browser_1.PreferenceScope.Folder;
        }
        const resourceUri = !!resource ? resource : undefined;
        const configUri = this.preferenceService.getConfigUri(scope, resourceUri);
        if (!configUri) {
            return undefined;
        }
        if (configUri && !await this.fileService.exists(configUri)) {
            await this.fileService.create(configUri);
        }
        return configUri;
    }
    /**
     * Determine if the current widget is the PreferencesWidget.
     */
    withWidget(widget = this.tryGetWidget(), fn) {
        if (widget instanceof preference_widget_1.PreferencesWidget && widget.id === preference_widget_1.PreferencesWidget.ID) {
            return fn(widget);
        }
        return false;
    }
};
__decorate([
    inversify_1.inject(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], PreferencesContribution.prototype, "fileService", void 0);
__decorate([
    inversify_1.inject(browser_1.PreferenceProvider),
    inversify_1.named(browser_1.PreferenceScope.Workspace),
    __metadata("design:type", workspace_preference_provider_1.WorkspacePreferenceProvider)
], PreferencesContribution.prototype, "workspacePreferenceProvider", void 0);
__decorate([
    inversify_1.inject(browser_2.EditorManager),
    __metadata("design:type", browser_2.EditorManager)
], PreferencesContribution.prototype, "editorManager", void 0);
__decorate([
    inversify_1.inject(browser_1.PreferenceService),
    __metadata("design:type", Object)
], PreferencesContribution.prototype, "preferenceService", void 0);
__decorate([
    inversify_1.inject(clipboard_service_1.ClipboardService),
    __metadata("design:type", Object)
], PreferencesContribution.prototype, "clipboardService", void 0);
__decorate([
    inversify_1.inject(preference_widget_1.PreferencesWidget),
    __metadata("design:type", preference_widget_1.PreferencesWidget)
], PreferencesContribution.prototype, "scopeTracker", void 0);
__decorate([
    inversify_1.inject(browser_3.WorkspaceService),
    __metadata("design:type", browser_3.WorkspaceService)
], PreferencesContribution.prototype, "workspaceService", void 0);
__decorate([
    inversify_1.inject(browser_1.QuickInputService),
    inversify_1.optional(),
    __metadata("design:type", Object)
], PreferencesContribution.prototype, "quickInputService", void 0);
PreferencesContribution = __decorate([
    inversify_1.injectable(),
    __metadata("design:paramtypes", [])
], PreferencesContribution);
exports.PreferencesContribution = PreferencesContribution;


/***/ }),

/***/ "./node_modules/@theia/preferences/lib/browser/util/preference-scope-command-manager.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@theia/preferences/lib/browser/util/preference-scope-command-manager.js ***!
  \**********************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceScopeCommandManager = exports.FOLDER_SCOPE_MENU_PATH = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "./node_modules/@theia/core/lib/common/index.js");
const preference_types_1 = __webpack_require__(/*! ./preference-types */ "./node_modules/@theia/preferences/lib/browser/util/preference-types.js");
/**
 * @deprecated since 1.17.0 moved to PreferenceMenus namespace.
 */
exports.FOLDER_SCOPE_MENU_PATH = preference_types_1.PreferenceMenus.FOLDER_SCOPE_MENU_PATH;
/**
 * @deprecated since 1.17.0. This work is now done in the PreferenceScopeTabbarWidget.
 */
let PreferenceScopeCommandManager = class PreferenceScopeCommandManager {
    constructor() {
        this.foldersAsCommands = [];
    }
    createFolderWorkspacesMenu(folderWorkspaces, currentFolderURI) {
        this.foldersAsCommands.forEach(folderCommand => {
            this.menuModelRegistry.unregisterMenuAction(folderCommand, exports.FOLDER_SCOPE_MENU_PATH);
            this.commandRegistry.unregisterCommand(folderCommand);
        });
        this.foldersAsCommands.length = 0;
        folderWorkspaces.forEach(folderWorkspace => {
            const folderLabel = this.labelProvider.getName(folderWorkspace.resource);
            const iconClass = currentFolderURI === folderWorkspace.resource.toString() ? browser_1.codicon('pass') : '';
            const newFolderAsCommand = {
                id: `preferenceScopeCommand:${folderWorkspace.resource.toString()}`,
                label: folderLabel,
                iconClass: iconClass
            };
            this.foldersAsCommands.push(newFolderAsCommand);
            this.commandRegistry.registerCommand(newFolderAsCommand, {
                isVisible: (callback, check) => check === 'from-tabbar',
                isEnabled: (callback, check) => check === 'from-tabbar',
                execute: (callback) => {
                    callback({ scope: browser_1.PreferenceScope.Folder, uri: folderWorkspace.resource.toString(), activeScopeIsFolder: true });
                }
            });
            this.menuModelRegistry.registerMenuAction(exports.FOLDER_SCOPE_MENU_PATH, {
                commandId: newFolderAsCommand.id,
                label: newFolderAsCommand.label
            });
        });
    }
};
__decorate([
    inversify_1.inject(common_1.CommandRegistry),
    __metadata("design:type", common_1.CommandRegistry)
], PreferenceScopeCommandManager.prototype, "commandRegistry", void 0);
__decorate([
    inversify_1.inject(common_1.MenuModelRegistry),
    __metadata("design:type", common_1.MenuModelRegistry)
], PreferenceScopeCommandManager.prototype, "menuModelRegistry", void 0);
__decorate([
    inversify_1.inject(browser_1.LabelProvider),
    __metadata("design:type", browser_1.LabelProvider)
], PreferenceScopeCommandManager.prototype, "labelProvider", void 0);
PreferenceScopeCommandManager = __decorate([
    inversify_1.injectable()
], PreferenceScopeCommandManager);
exports.PreferenceScopeCommandManager = PreferenceScopeCommandManager;


/***/ }),

/***/ "./node_modules/@theia/preferences/lib/browser/util/preference-tree-generator.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@theia/preferences/lib/browser/util/preference-tree-generator.js ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceTreeGenerator = exports.COMMONLY_USED_SECTION_PREFIX = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const preference_configurations_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences/preference-configurations */ "./node_modules/@theia/core/lib/browser/preferences/preference-configurations.js");
const core_1 = __webpack_require__(/*! @theia/core */ "./node_modules/@theia/core/lib/common/index.js");
const debounce = __webpack_require__(/*! @theia/core/shared/lodash.debounce */ "./node_modules/@theia/core/shared/lodash.debounce/index.js");
const preference_types_1 = __webpack_require__(/*! ./preference-types */ "./node_modules/@theia/preferences/lib/browser/util/preference-types.js");
exports.COMMONLY_USED_SECTION_PREFIX = 'commonly-used';
let PreferenceTreeGenerator = class PreferenceTreeGenerator {
    constructor() {
        this.onSchemaChangedEmitter = new core_1.Emitter();
        this.onSchemaChanged = this.onSchemaChangedEmitter.event;
        this.commonlyUsedPreferences = [
            'editor.autoSave', 'editor.autoSaveDelay', 'editor.fontSize',
            'editor.fontFamily', 'editor.tabSize', 'editor.renderWhitespace',
            'editor.cursorStyle', 'editor.multiCursorModifier', 'editor.insertSpaces',
            'editor.wordWrap', 'files.exclude', 'files.associations'
        ];
        this.topLevelCategories = new Map([
            [exports.COMMONLY_USED_SECTION_PREFIX, 'Commonly Used'],
            ['editor', 'Text Editor'],
            ['workbench', 'Workbench'],
            ['window', 'Window'],
            ['features', 'Features'],
            ['application', 'Application'],
            ['extensions', 'Extensions']
        ]);
        this.sectionAssignments = new Map([
            ['breadcrumbs', 'workbench'],
            ['comments', 'features'],
            ['debug', 'features'],
            ['diffEditor', 'editor'],
            ['explorer', 'features'],
            ['extensions', 'features'],
            ['files', 'editor'],
            ['hosted-plugin', 'features'],
            ['keyboard', 'application'],
            ['output', 'features'],
            ['problems', 'features'],
            ['preview', 'features'],
            ['search', 'features'],
            ['task', 'features'],
            ['terminal', 'features'],
            ['webview', 'features'],
            ['workspace', 'application'],
        ]);
        this.defaultTopLevelCategory = 'extensions';
        this.handleChangedSchema = debounce(this.doHandleChangedSchema, 200);
    }
    get root() {
        var _a;
        return (_a = this._root) !== null && _a !== void 0 ? _a : this.generateTree();
    }
    async init() {
        await this.schemaProvider.ready;
        this.schemaProvider.onDidPreferenceSchemaChanged(() => this.handleChangedSchema());
        this.handleChangedSchema();
    }
    generateTree() {
        const preferencesSchema = this.schemaProvider.getCombinedSchema();
        const propertyNames = Object.keys(preferencesSchema.properties);
        const groups = new Map();
        const root = this.createRootNode();
        for (const id of this.topLevelCategories.keys()) {
            this.getOrCreatePreferencesGroup(id, id, root, groups);
        }
        const commonlyUsed = this.getOrCreatePreferencesGroup(exports.COMMONLY_USED_SECTION_PREFIX, exports.COMMONLY_USED_SECTION_PREFIX, root, groups);
        for (const preference of this.commonlyUsedPreferences) {
            if (preference in preferencesSchema.properties) {
                this.createLeafNode(preference, commonlyUsed, preferencesSchema.properties[preference]);
            }
        }
        for (const propertyName of propertyNames) {
            if (!this.preferenceConfigs.isSectionName(propertyName) && !browser_1.OVERRIDE_PROPERTY_PATTERN.test(propertyName)) {
                const labels = propertyName.split('.');
                const groupID = this.getGroupName(labels);
                const subgroupName = this.getSubgroupName(labels, groupID);
                const subgroupID = [groupID, subgroupName].join('.');
                const toplevelParent = this.getOrCreatePreferencesGroup(groupID, groupID, root, groups);
                const immediateParent = subgroupName && this.getOrCreatePreferencesGroup(subgroupID, groupID, toplevelParent, groups);
                this.createLeafNode(propertyName, immediateParent || toplevelParent, preferencesSchema.properties[propertyName]);
            }
        }
        for (const group of groups.values()) {
            if (group.id !== `${exports.COMMONLY_USED_SECTION_PREFIX}@${exports.COMMONLY_USED_SECTION_PREFIX}`) {
                group.children.sort((a, b) => {
                    const aIsComposite = browser_1.CompositeTreeNode.is(a);
                    const bIsComposite = browser_1.CompositeTreeNode.is(b);
                    if (aIsComposite && !bIsComposite) {
                        return 1;
                    }
                    if (bIsComposite && !aIsComposite) {
                        return -1;
                    }
                    return a.id.localeCompare(b.id);
                });
            }
        }
        this._root = root;
        return root;
    }
    ;
    getNodeId(preferenceId) {
        const expectedGroup = this.getGroupName(preferenceId.split('.'));
        const expectedId = `${expectedGroup}@${preferenceId}`;
        return expectedId;
    }
    getGroupName(labels) {
        const defaultGroup = labels[0];
        if (this.topLevelCategories.has(defaultGroup)) {
            return defaultGroup;
        }
        const assignedGroup = this.sectionAssignments.get(defaultGroup);
        if (assignedGroup) {
            return assignedGroup;
        }
        return this.defaultTopLevelCategory;
    }
    getSubgroupName(labels, computedGroupName) {
        if (computedGroupName !== labels[0]) {
            return labels[0];
        }
        else if (labels.length > 2) {
            return labels[1];
        }
    }
    doHandleChangedSchema() {
        const newTree = this.generateTree();
        this.onSchemaChangedEmitter.fire(newTree);
    }
    createRootNode() {
        return {
            id: 'root-node-id',
            name: '',
            parent: undefined,
            visible: true,
            children: []
        };
    }
    createLeafNode(property, preferencesGroup, data) {
        const { group } = preference_types_1.Preference.TreeNode.getGroupAndIdFromNodeId(preferencesGroup.id);
        const newNode = {
            id: `${group}@${property}`,
            preferenceId: property,
            parent: preferencesGroup,
            visible: true,
            preference: { data },
            depth: preference_types_1.Preference.TreeNode.isTopLevel(preferencesGroup) ? 1 : 2,
        };
        browser_1.CompositeTreeNode.addChild(preferencesGroup, newNode);
        return newNode;
    }
    createPreferencesGroup(id, group, root) {
        const newNode = {
            id: `${group}@${id}`,
            visible: true,
            parent: root,
            children: [],
            expanded: false,
            selected: false,
            depth: 0,
        };
        const isTopLevel = preference_types_1.Preference.TreeNode.isTopLevel(newNode);
        if (!isTopLevel) {
            delete newNode.expanded;
        }
        newNode.depth = isTopLevel ? 0 : 1;
        browser_1.CompositeTreeNode.addChild(root, newNode);
        return newNode;
    }
    getCustomLabelFor(id) {
        return this.topLevelCategories.get(id);
    }
    getOrCreatePreferencesGroup(id, group, root, groups) {
        const existingGroup = groups.get(id);
        if (existingGroup) {
            return existingGroup;
        }
        const newNode = this.createPreferencesGroup(id, group, root);
        groups.set(id, newNode);
        return newNode;
    }
    ;
};
__decorate([
    inversify_1.inject(browser_1.PreferenceSchemaProvider),
    __metadata("design:type", browser_1.PreferenceSchemaProvider)
], PreferenceTreeGenerator.prototype, "schemaProvider", void 0);
__decorate([
    inversify_1.inject(preference_configurations_1.PreferenceConfigurations),
    __metadata("design:type", preference_configurations_1.PreferenceConfigurations)
], PreferenceTreeGenerator.prototype, "preferenceConfigs", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], PreferenceTreeGenerator.prototype, "init", null);
PreferenceTreeGenerator = __decorate([
    inversify_1.injectable()
], PreferenceTreeGenerator);
exports.PreferenceTreeGenerator = PreferenceTreeGenerator;


/***/ }),

/***/ "./node_modules/@theia/preferences/lib/browser/util/preference-tree-label-provider.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@theia/preferences/lib/browser/util/preference-tree-label-provider.js ***!
  \********************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceTreeLabelProvider = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const preference_types_1 = __webpack_require__(/*! ./preference-types */ "./node_modules/@theia/preferences/lib/browser/util/preference-types.js");
const preference_tree_generator_1 = __webpack_require__(/*! ./preference-tree-generator */ "./node_modules/@theia/preferences/lib/browser/util/preference-tree-generator.js");
let PreferenceTreeLabelProvider = class PreferenceTreeLabelProvider {
    canHandle(element) {
        return browser_1.TreeNode.is(element) && preference_types_1.Preference.TreeNode.is(element) ? 150 : 0;
    }
    getName(node) {
        var _a;
        const { id } = preference_types_1.Preference.TreeNode.getGroupAndIdFromNodeId(node.id);
        return this.formatString((_a = this.treeGenerator.getCustomLabelFor(id)) !== null && _a !== void 0 ? _a : id.split('.').pop());
    }
    getPrefix(node, fullPath = false) {
        const { depth } = node;
        const { id, group } = preference_types_1.Preference.TreeNode.getGroupAndIdFromNodeId(node.id);
        const segments = id.split('.');
        const segmentsHandled = group === segments[0] ? depth : depth - 1;
        segments.pop(); // Ignore the leaf name.
        const prefixSegments = fullPath ? segments : segments.slice(segmentsHandled);
        if (prefixSegments.length) {
            let output = prefixSegments.length > 1 ? `${this.formatString(prefixSegments[0])} › ` : `${this.formatString(prefixSegments[0])}: `;
            for (const segment of prefixSegments.slice(1)) {
                output += `${this.formatString(segment)}: `;
            }
            return output;
        }
    }
    formatString(string) {
        let formattedString = string[0].toLocaleUpperCase();
        for (let i = 1; i < string.length; i++) {
            if (this.isUpperCase(string[i]) && !/\s/.test(string[i - 1]) && !this.isUpperCase(string[i - 1])) {
                formattedString += ' ';
            }
            formattedString += string[i];
        }
        return formattedString.trim();
    }
    isUpperCase(char) {
        return char === char.toLocaleUpperCase() && char.toLocaleLowerCase() !== char.toLocaleUpperCase();
    }
};
__decorate([
    inversify_1.inject(preference_tree_generator_1.PreferenceTreeGenerator),
    __metadata("design:type", preference_tree_generator_1.PreferenceTreeGenerator)
], PreferenceTreeLabelProvider.prototype, "treeGenerator", void 0);
PreferenceTreeLabelProvider = __decorate([
    inversify_1.injectable()
], PreferenceTreeLabelProvider);
exports.PreferenceTreeLabelProvider = PreferenceTreeLabelProvider;


/***/ }),

/***/ "./node_modules/@theia/preferences/lib/browser/util/preference-types.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@theia/preferences/lib/browser/util/preference-types.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceMenus = exports.PreferencesCommands = exports.Preference = void 0;
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "./node_modules/@theia/core/lib/common/index.js");
var Preference;
(function (Preference) {
    let EditorCommandArgs;
    (function (EditorCommandArgs) {
        function is(prefObject) {
            return !!prefObject && 'id' in prefObject && 'value' in prefObject;
        }
        EditorCommandArgs.is = is;
    })(EditorCommandArgs = Preference.EditorCommandArgs || (Preference.EditorCommandArgs = {}));
    Preference.Node = Symbol('Preference.Node');
    let TreeNode;
    (function (TreeNode) {
        TreeNode.is = (node) => 'depth' in node;
        TreeNode.isTopLevel = (node) => {
            const { group, id } = TreeNode.getGroupAndIdFromNodeId(node.id);
            return group === id;
        };
        TreeNode.getGroupAndIdFromNodeId = (nodeId) => {
            const separator = nodeId.indexOf('@');
            const group = nodeId.substring(0, separator);
            const id = nodeId.substring(separator + 1, nodeId.length);
            return { group, id };
        };
    })(TreeNode = Preference.TreeNode || (Preference.TreeNode = {}));
    let LeafNode;
    (function (LeafNode) {
        LeafNode.is = (node) => 'preference' in node && !!node.preference.data;
    })(LeafNode = Preference.LeafNode || (Preference.LeafNode = {}));
    Preference.getValueInScope = (preferenceInfo, scope) => {
        if (!preferenceInfo) {
            return undefined;
        }
        switch (scope) {
            case browser_1.PreferenceScope.User:
                return preferenceInfo.globalValue;
            case browser_1.PreferenceScope.Workspace:
                return preferenceInfo.workspaceValue;
            case browser_1.PreferenceScope.Folder:
                return preferenceInfo.workspaceFolderValue;
            default:
                return undefined;
        }
    };
    ;
    Preference.DEFAULT_SCOPE = {
        scope: browser_1.PreferenceScope.User,
        uri: undefined,
        activeScopeIsFolder: false
    };
})(Preference = exports.Preference || (exports.Preference = {}));
var PreferencesCommands;
(function (PreferencesCommands) {
    PreferencesCommands.OPEN_PREFERENCES_JSON_TOOLBAR = {
        id: 'preferences:openJson.toolbar',
        iconClass: 'codicon codicon-json'
    };
    PreferencesCommands.COPY_JSON_NAME = core_1.Command.toDefaultLocalizedCommand({
        id: 'preferences:copyJson.name',
        label: 'Copy Setting ID'
    });
    PreferencesCommands.RESET_PREFERENCE = core_1.Command.toDefaultLocalizedCommand({
        id: 'preferences:reset',
        label: 'Reset Setting'
    });
    PreferencesCommands.COPY_JSON_VALUE = core_1.Command.toDefaultLocalizedCommand({
        id: 'preferences:copyJson.value',
        label: 'Copy Setting as JSON',
    });
    PreferencesCommands.OPEN_USER_PREFERENCES = core_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.openGlobalSettings',
        category: browser_1.CommonCommands.PREFERENCES_CATEGORY,
        label: 'Open User Settings',
    });
    PreferencesCommands.OPEN_WORKSPACE_PREFERENCES = core_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.openWorkspaceSettings',
        category: browser_1.CommonCommands.PREFERENCES_CATEGORY,
        label: 'Open Workspace Settings',
    });
    PreferencesCommands.OPEN_FOLDER_PREFERENCES = core_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.openFolderSettings',
        category: browser_1.CommonCommands.PREFERENCES_CATEGORY,
        label: 'Open Folder Settings'
    });
    PreferencesCommands.OPEN_USER_PREFERENCES_JSON = core_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.openSettingsJson',
        category: browser_1.CommonCommands.PREFERENCES_CATEGORY,
        label: 'Open Settings (JSON)'
    });
    PreferencesCommands.OPEN_WORKSPACE_PREFERENCES_JSON = core_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.openWorkspaceSettingsFile',
        category: browser_1.CommonCommands.PREFERENCES_CATEGORY,
        label: 'Open Workspace Settings (JSON)',
    });
    PreferencesCommands.OPEN_FOLDER_PREFERENCES_JSON = core_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.openFolderSettingsFile',
        category: browser_1.CommonCommands.PREFERENCES_CATEGORY,
        label: 'Open Folder Settings (JSON)',
    });
})(PreferencesCommands = exports.PreferencesCommands || (exports.PreferencesCommands = {}));
var PreferenceMenus;
(function (PreferenceMenus) {
    PreferenceMenus.PREFERENCE_EDITOR_CONTEXT_MENU = ['preferences:editor.contextMenu'];
    PreferenceMenus.PREFERENCE_EDITOR_COPY_ACTIONS = [...PreferenceMenus.PREFERENCE_EDITOR_CONTEXT_MENU, 'preferences:editor.contextMenu.copy'];
    PreferenceMenus.FOLDER_SCOPE_MENU_PATH = ['preferences:scope.menu'];
})(PreferenceMenus = exports.PreferenceMenus || (exports.PreferenceMenus = {}));


/***/ }),

/***/ "./node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer.js ***!
  \**************************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceLeafNodeRenderer = exports.PreferenceHeaderRenderer = exports.PreferenceNodeRenderer = exports.SUBHEADER_CLASS = exports.HEADER_CLASS = exports.PreferenceNodeRendererFactory = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const preference_types_1 = __webpack_require__(/*! ../../util/preference-types */ "./node_modules/@theia/preferences/lib/browser/util/preference-types.js");
const preference_tree_label_provider_1 = __webpack_require__(/*! ../../util/preference-tree-label-provider */ "./node_modules/@theia/preferences/lib/browser/util/preference-tree-label-provider.js");
const preference_scope_tabbar_widget_1 = __webpack_require__(/*! ../preference-scope-tabbar-widget */ "./node_modules/@theia/preferences/lib/browser/views/preference-scope-tabbar-widget.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "./node_modules/@theia/core/lib/common/index.js");
const debounce = __webpack_require__(/*! @theia/core/shared/lodash.debounce */ "./node_modules/@theia/core/shared/lodash.debounce/index.js");
const preference_tree_model_1 = __webpack_require__(/*! ../../preference-tree-model */ "./node_modules/@theia/preferences/lib/browser/preference-tree-model.js");
const preference_searchbar_widget_1 = __webpack_require__(/*! ../preference-searchbar-widget */ "./node_modules/@theia/preferences/lib/browser/views/preference-searchbar-widget.js");
const window_service_1 = __webpack_require__(/*! @theia/core/lib/browser/window/window-service */ "./node_modules/@theia/core/lib/browser/window/window-service.js");
const markdownit = __webpack_require__(/*! @theia/core/shared/markdown-it */ "./node_modules/@theia/core/shared/markdown-it.js");
const DOMPurify = __webpack_require__(/*! @theia/core/shared/dompurify */ "./node_modules/@theia/core/shared/dompurify/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "./node_modules/@theia/core/lib/common/uri.js");
exports.PreferenceNodeRendererFactory = Symbol('PreferenceNodeRendererFactory');
exports.HEADER_CLASS = 'settings-section-category-title';
exports.SUBHEADER_CLASS = 'settings-section-subcategory-title';
let PreferenceNodeRenderer = class PreferenceNodeRenderer {
    constructor() {
        this.attached = false;
    }
    get node() {
        return this.domNode;
    }
    get nodeId() {
        return this.preferenceNode.id;
    }
    get id() {
        return this._id;
    }
    get group() {
        return this._group;
    }
    get visible() {
        return !this.node.classList.contains('hidden');
    }
    init() {
        this.setId();
        this.domNode = this.createDomNode();
    }
    setId() {
        var _a;
        const { id, group } = preference_types_1.Preference.TreeNode.getGroupAndIdFromNodeId(this.preferenceNode.id);
        const segments = id.split('.');
        this._id = id;
        this._group = group;
        this._subgroup = (_a = (group === segments[0] ? segments[1] : segments[0])) !== null && _a !== void 0 ? _a : '';
    }
    insertBefore(nextSibling) {
        nextSibling.insertAdjacentElement('beforebegin', this.domNode);
        this.attached = true;
    }
    insertAfter(previousSibling) {
        previousSibling.insertAdjacentElement('afterend', this.domNode);
    }
    appendTo(parent) {
        parent.appendChild(this.domNode);
    }
    prependTo(parent) {
        parent.prepend(this.domNode);
    }
    hide() {
        this.domNode.classList.add('hidden');
    }
    show() {
        this.domNode.classList.remove('hidden');
    }
    dispose() {
        this.domNode.remove();
    }
};
__decorate([
    inversify_1.inject(preference_types_1.Preference.Node),
    __metadata("design:type", Object)
], PreferenceNodeRenderer.prototype, "preferenceNode", void 0);
__decorate([
    inversify_1.inject(preference_tree_label_provider_1.PreferenceTreeLabelProvider),
    __metadata("design:type", preference_tree_label_provider_1.PreferenceTreeLabelProvider)
], PreferenceNodeRenderer.prototype, "labelProvider", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PreferenceNodeRenderer.prototype, "init", null);
PreferenceNodeRenderer = __decorate([
    inversify_1.injectable()
], PreferenceNodeRenderer);
exports.PreferenceNodeRenderer = PreferenceNodeRenderer;
class PreferenceHeaderRenderer extends PreferenceNodeRenderer {
    createDomNode() {
        const wrapper = document.createElement('ul');
        wrapper.className = 'settings-section';
        wrapper.id = `${this.preferenceNode.id}-editor`;
        const isCategory = preference_types_1.Preference.TreeNode.isTopLevel(this.preferenceNode);
        const hierarchyClassName = isCategory ? exports.HEADER_CLASS : exports.SUBHEADER_CLASS;
        const name = this.labelProvider.getName(this.preferenceNode);
        const label = document.createElement('li');
        label.classList.add('settings-section-title', hierarchyClassName);
        label.textContent = name;
        wrapper.appendChild(label);
        return wrapper;
    }
}
exports.PreferenceHeaderRenderer = PreferenceHeaderRenderer;
let PreferenceLeafNodeRenderer = class PreferenceLeafNodeRenderer extends PreferenceNodeRenderer {
    constructor() {
        super(...arguments);
        this.isModifiedFromDefault = false;
        this.setPreferenceWithDebounce = debounce(this.setPreferenceImmediately.bind(this), 500, { leading: false, trailing: true });
    }
    init() {
        this.setId();
        this.updateInspection();
        this.markdownRenderer = this.buildMarkdownRenderer();
        this.domNode = this.createDomNode();
        this.updateModificationStatus();
    }
    updateInspection() {
        this.inspection = this.preferenceService.inspect(this.id, this.scopeTracker.currentScope.uri);
    }
    buildMarkdownRenderer() {
        const engine = markdownit();
        const inlineCode = engine.renderer.rules.code_inline;
        engine.renderer.rules.code_inline = (tokens, idx, options, env, self) => {
            const token = tokens[idx];
            const content = token.content;
            if (content.startsWith('#') && content.endsWith('#')) {
                const preferenceId = content.substring(1, content.length - 1);
                const preferenceNode = this.model.getNodeFromPreferenceId(preferenceId);
                if (preferenceNode) {
                    let name = this.labelProvider.getName(preferenceNode);
                    const prefix = this.labelProvider.getPrefix(preferenceNode, true);
                    if (prefix) {
                        name = prefix + name;
                    }
                    return `<a title="${preferenceId}" href="preference:${preferenceId}">${name}</a>`;
                }
                else {
                    console.warn(`Linked preference "${preferenceId}" not found. Source: "${this.preferenceNode.preferenceId}"`);
                }
            }
            return inlineCode ? inlineCode(tokens, idx, options, env, self) : '';
        };
        return engine;
    }
    openLink(event) {
        if (event.target instanceof HTMLAnchorElement) {
            event.preventDefault();
            event.stopPropagation();
            // Exclude right click
            if (event.button < 2) {
                const uri = new uri_1.default(event.target.href);
                if (uri.scheme === 'preference') {
                    this.selectPreference(uri.path.toString());
                }
                else {
                    // Opens link in external browser
                    this.windowService.openNewWindow(event.target.href, { external: true });
                }
            }
        }
    }
    async selectPreference(preferenceId) {
        // Selects the rendered html preference node that does not belong to the commonly used group
        const selector = `li[data-pref-id="${preferenceId}"]:not([data-node-id^="commonly-used@"])`;
        const element = document.querySelector(selector);
        if (element) {
            if (element.classList.contains('hidden')) {
                // We clear the search term as we have clicked on a hidden preference
                await this.searchbar.updateSearchTerm('');
                await browser_1.animationFrame();
            }
            element.scrollIntoView();
        }
    }
    createDomNode() {
        const wrapper = document.createElement('li');
        wrapper.classList.add('single-pref');
        wrapper.id = `${this.id}-editor`;
        wrapper.setAttribute('data-pref-id', this.id);
        wrapper.setAttribute('data-node-id', this.preferenceNode.id);
        const headlineWrapper = document.createElement('div');
        headlineWrapper.classList.add('pref-name');
        headlineWrapper.title = this.id;
        this.headlineWrapper = headlineWrapper;
        wrapper.appendChild(headlineWrapper);
        this.updateHeadline();
        const gutter = document.createElement('div');
        gutter.classList.add('pref-context-gutter');
        this.gutter = gutter;
        wrapper.appendChild(gutter);
        const cog = document.createElement('i');
        cog.className = `${browser_1.codicon('settings-gear', true)} settings-context-menu-btn`;
        cog.setAttribute('aria-label', 'Open Context Menu');
        cog.setAttribute('role', 'button');
        cog.onclick = this.handleCogAction.bind(this);
        cog.onkeydown = this.handleCogAction.bind(this);
        cog.title = common_1.nls.localizeByDefault('More Actions...');
        gutter.appendChild(cog);
        const activeType = Array.isArray(this.preferenceNode.preference.data.type) ? this.preferenceNode.preference.data.type[0] : this.preferenceNode.preference.data.type;
        const contentWrapper = document.createElement('div');
        contentWrapper.classList.add('pref-content-container', activeType !== null && activeType !== void 0 ? activeType : 'open-json');
        wrapper.appendChild(contentWrapper);
        const { description, markdownDescription } = this.preferenceNode.preference.data;
        if (markdownDescription || description) {
            const descriptionWrapper = document.createElement('div');
            descriptionWrapper.classList.add('pref-description');
            if (markdownDescription) {
                const renderedDescription = this.markdownRenderer.renderInline(markdownDescription);
                descriptionWrapper.onauxclick = this.openLink.bind(this);
                descriptionWrapper.onclick = this.openLink.bind(this);
                descriptionWrapper.oncontextmenu = () => false;
                descriptionWrapper.innerHTML = DOMPurify.sanitize(renderedDescription, {
                    ALLOW_UNKNOWN_PROTOCOLS: true
                });
            }
            else if (description) {
                descriptionWrapper.textContent = description;
            }
            contentWrapper.appendChild(descriptionWrapper);
        }
        const interactableWrapper = document.createElement('div');
        interactableWrapper.classList.add('pref-input');
        contentWrapper.appendChild(interactableWrapper);
        this.createInteractable(interactableWrapper);
        return wrapper;
    }
    handleCogAction({ currentTarget }) {
        var _a, _b;
        const value = (_a = preference_types_1.Preference.getValueInScope(this.inspection, this.scopeTracker.currentScope.scope)) !== null && _a !== void 0 ? _a : (_b = this.inspection) === null || _b === void 0 ? void 0 : _b.defaultValue;
        const target = currentTarget;
        if (target && value !== undefined) {
            this.showCog();
            const domRect = target.getBoundingClientRect();
            this.menuRenderer.render({
                menuPath: preference_types_1.PreferenceMenus.PREFERENCE_EDITOR_CONTEXT_MENU,
                anchor: { x: domRect.left, y: domRect.bottom },
                args: [{ id: this.id, value }],
                onHide: () => this.hideCog()
            });
        }
    }
    addModifiedMarking() {
        this.gutter.classList.add('theia-mod-item-modified');
    }
    removeModifiedMarking() {
        this.gutter.classList.remove('theia-mod-item-modified');
    }
    showCog() {
        this.gutter.classList.add('show-cog');
    }
    hideCog() {
        this.gutter.classList.remove('show-cog');
    }
    updateModificationStatus(knownCurrentValue) {
        const wasModified = this.isModifiedFromDefault;
        const { inspection } = this;
        const valueInCurrentScope = knownCurrentValue !== null && knownCurrentValue !== void 0 ? knownCurrentValue : preference_types_1.Preference.getValueInScope(inspection, this.scopeTracker.currentScope.scope);
        this.isModifiedFromDefault = valueInCurrentScope !== undefined && !browser_1.PreferenceProvider.deepEqual(valueInCurrentScope, inspection === null || inspection === void 0 ? void 0 : inspection.defaultValue);
        if (wasModified !== this.isModifiedFromDefault) {
            this.gutter.classList.toggle('theia-mod-item-modified', this.isModifiedFromDefault);
        }
    }
    updateHeadline(filtered = this.model.isFiltered) {
        const { headlineWrapper } = this;
        if (this.headlineWrapper.childElementCount === 0) {
            const name = this.labelProvider.getName(this.preferenceNode);
            const nameWrapper = document.createElement('span');
            nameWrapper.classList.add('preference-leaf-headline-name');
            nameWrapper.textContent = name;
            headlineWrapper.appendChild(nameWrapper);
        }
        const prefix = this.labelProvider.getPrefix(this.preferenceNode, filtered);
        const currentFirstChild = headlineWrapper.children[0];
        const currentFirstChildIsPrefix = currentFirstChild.classList.contains('preference-leaf-headline-prefix');
        if (prefix) {
            let prefixWrapper;
            if (currentFirstChildIsPrefix) {
                prefixWrapper = currentFirstChild;
            }
            else {
                prefixWrapper = document.createElement('span');
                prefixWrapper.classList.add('preference-leaf-headline-prefix');
                headlineWrapper.insertBefore(prefixWrapper, currentFirstChild);
            }
            prefixWrapper.textContent = prefix;
        }
        else if (currentFirstChildIsPrefix) {
            headlineWrapper.removeChild(currentFirstChild);
        }
        const currentLastChild = headlineWrapper.lastChild;
        if (currentLastChild.classList.contains('preference-leaf-headline-suffix')) {
            this.compareOtherModifiedScopes(headlineWrapper, currentLastChild);
        }
        else {
            this.createOtherModifiedScopes(headlineWrapper);
        }
    }
    compareOtherModifiedScopes(headlineWrapper, currentSuffix) {
        const modifiedScopes = this.getModifiedScopesAsStrings();
        if (modifiedScopes.length === 0) {
            headlineWrapper.removeChild(currentSuffix);
        }
        else {
            const modifiedMessagePrefix = currentSuffix.children[0];
            const newMessagePrefix = this.getModifiedMessagePrefix();
            if (modifiedMessagePrefix.textContent !== newMessagePrefix) {
                modifiedMessagePrefix.textContent = newMessagePrefix;
            }
            const [firstModifiedScope, secondModifiedScope] = modifiedScopes;
            const firstScopeMessage = currentSuffix.children[1];
            const secondScopeMessage = currentSuffix.children[2];
            firstScopeMessage.children[0].textContent = browser_1.PreferenceScope[firstModifiedScope];
            this.addEventHandlerToModifiedScope(firstModifiedScope, firstScopeMessage.children[0]);
            if (modifiedScopes.length === 1 && secondScopeMessage) {
                currentSuffix.removeChild(secondScopeMessage);
            }
            else if (modifiedScopes.length === 2 && !secondScopeMessage) {
                const newSecondMessage = this.createModifiedScopeMessage(secondModifiedScope);
                currentSuffix.appendChild(newSecondMessage);
            }
            // If both scopes are modified and both messages are present, do nothing.
        }
    }
    createOtherModifiedScopes(headlineWrapper) {
        const modifiedScopes = this.getModifiedScopesAsStrings();
        if (modifiedScopes.length !== 0) {
            const wrapper = document.createElement('i');
            wrapper.classList.add('preference-leaf-headline-suffix');
            headlineWrapper.appendChild(wrapper);
            const messagePrefix = this.getModifiedMessagePrefix();
            const messageWrapper = document.createElement('span');
            messageWrapper.classList.add('preference-other-modified-scope-alert');
            messageWrapper.textContent = messagePrefix;
            wrapper.appendChild(messageWrapper);
            modifiedScopes.forEach((scopeName, i) => {
                const scopeWrapper = this.createModifiedScopeMessage(scopeName);
                wrapper.appendChild(scopeWrapper);
            });
        }
    }
    createModifiedScopeMessage(scope) {
        const scopeWrapper = document.createElement('span');
        scopeWrapper.classList.add('preference-modified-scope-wrapper');
        const scopeInteractable = document.createElement('span');
        scopeInteractable.classList.add('preference-scope-underlined');
        const scopeName = browser_1.PreferenceScope[scope];
        this.addEventHandlerToModifiedScope(scope, scopeInteractable);
        scopeInteractable.textContent = scopeName;
        scopeWrapper.appendChild(scopeInteractable);
        return scopeWrapper;
    }
    getModifiedMessagePrefix() {
        return (this.isModifiedFromDefault ? common_1.nls.localizeByDefault('Also modified in') : common_1.nls.localizeByDefault('Modified in')) + ': ';
    }
    addEventHandlerToModifiedScope(scope, scopeWrapper) {
        if (scope === browser_1.PreferenceScope.User || scope === browser_1.PreferenceScope.Workspace) {
            const eventHandler = () => {
                this.scopeTracker.setScope(scope);
                this.searchbar.updateSearchTerm(this.id);
            };
            scopeWrapper.onclick = eventHandler;
            scopeWrapper.onkeydown = eventHandler;
            scopeWrapper.tabIndex = 0;
        }
        else {
            scopeWrapper.onclick = null; // eslint-disable-line no-null/no-null
            scopeWrapper.onkeydown = null; // eslint-disable-line no-null/no-null
            scopeWrapper.tabIndex = -1;
        }
    }
    getModifiedScopesAsStrings() {
        const currentScopeInView = this.scopeTracker.currentScope.scope;
        const { inspection } = this;
        const modifiedScopes = [];
        if (inspection) {
            for (const otherScope of [browser_1.PreferenceScope.User, browser_1.PreferenceScope.Workspace]) {
                if (otherScope !== currentScopeInView) {
                    const valueInOtherScope = preference_types_1.Preference.getValueInScope(inspection, otherScope);
                    if (valueInOtherScope !== undefined && !browser_1.PreferenceProvider.deepEqual(valueInOtherScope, inspection.defaultValue)) {
                        modifiedScopes.push(otherScope);
                    }
                }
            }
        }
        return modifiedScopes;
    }
    getValue() {
        var _a;
        let currentValue = preference_types_1.Preference.getValueInScope(this.inspection, this.scopeTracker.currentScope.scope);
        if (currentValue === undefined) {
            currentValue = (_a = this.inspection) === null || _a === void 0 ? void 0 : _a.defaultValue;
        }
        return currentValue !== null && currentValue !== void 0 ? currentValue : this.getFallbackValue();
    }
    setPreferenceImmediately(value) {
        return this.preferenceService.set(this.id, value, this.scopeTracker.currentScope.scope, this.scopeTracker.currentScope.uri)
            .catch(() => this.handleValueChange());
    }
    handleSearchChange(isFiltered = this.model.isFiltered) {
        this.updateHeadline(isFiltered);
    }
    handleScopeChange(isFiltered = this.model.isFiltered) {
        this.handleValueChange();
        this.updateHeadline(isFiltered);
    }
    handleValueChange() {
        this.doHandleValueChange();
        this.updateHeadline();
    }
};
__decorate([
    inversify_1.inject(preference_types_1.Preference.Node),
    __metadata("design:type", Object)
], PreferenceLeafNodeRenderer.prototype, "preferenceNode", void 0);
__decorate([
    inversify_1.inject(browser_1.PreferenceService),
    __metadata("design:type", Object)
], PreferenceLeafNodeRenderer.prototype, "preferenceService", void 0);
__decorate([
    inversify_1.inject(browser_1.ContextMenuRenderer),
    __metadata("design:type", browser_1.ContextMenuRenderer)
], PreferenceLeafNodeRenderer.prototype, "menuRenderer", void 0);
__decorate([
    inversify_1.inject(preference_scope_tabbar_widget_1.PreferencesScopeTabBar),
    __metadata("design:type", preference_scope_tabbar_widget_1.PreferencesScopeTabBar)
], PreferenceLeafNodeRenderer.prototype, "scopeTracker", void 0);
__decorate([
    inversify_1.inject(preference_tree_model_1.PreferenceTreeModel),
    __metadata("design:type", preference_tree_model_1.PreferenceTreeModel)
], PreferenceLeafNodeRenderer.prototype, "model", void 0);
__decorate([
    inversify_1.inject(preference_searchbar_widget_1.PreferencesSearchbarWidget),
    __metadata("design:type", preference_searchbar_widget_1.PreferencesSearchbarWidget)
], PreferenceLeafNodeRenderer.prototype, "searchbar", void 0);
__decorate([
    inversify_1.inject(window_service_1.WindowService),
    __metadata("design:type", Object)
], PreferenceLeafNodeRenderer.prototype, "windowService", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PreferenceLeafNodeRenderer.prototype, "init", null);
PreferenceLeafNodeRenderer = __decorate([
    inversify_1.injectable()
], PreferenceLeafNodeRenderer);
exports.PreferenceLeafNodeRenderer = PreferenceLeafNodeRenderer;


/***/ }),

/***/ "./node_modules/@theia/preferences/lib/browser/views/preference-editor-widget.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@theia/preferences/lib/browser/views/preference-editor-widget.js ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var PreferencesEditorWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferencesEditorWidget = void 0;
/* eslint-disable @typescript-eslint/no-explicit-any */
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const throttle = __webpack_require__(/*! @theia/core/shared/lodash.throttle */ "./node_modules/@theia/core/shared/lodash.throttle/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "./node_modules/@theia/core/lib/common/index.js");
const widget_1 = __webpack_require__(/*! @theia/core/lib/browser/widgets/widget */ "./node_modules/@theia/core/lib/browser/widgets/widget.js");
const preference_tree_model_1 = __webpack_require__(/*! ../preference-tree-model */ "./node_modules/@theia/preferences/lib/browser/preference-tree-model.js");
const preference_node_renderer_1 = __webpack_require__(/*! ./components/preference-node-renderer */ "./node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer.js");
const preference_types_1 = __webpack_require__(/*! ../util/preference-types */ "./node_modules/@theia/preferences/lib/browser/util/preference-types.js");
const preference_tree_generator_1 = __webpack_require__(/*! ../util/preference-tree-generator */ "./node_modules/@theia/preferences/lib/browser/util/preference-tree-generator.js");
const preference_scope_tabbar_widget_1 = __webpack_require__(/*! ./preference-scope-tabbar-widget */ "./node_modules/@theia/preferences/lib/browser/views/preference-scope-tabbar-widget.js");
let PreferencesEditorWidget = PreferencesEditorWidget_1 = class PreferencesEditorWidget extends widget_1.BaseWidget {
    constructor() {
        super(...arguments);
        this.scrollOptions = widget_1.DEFAULT_SCROLL_OPTIONS;
        /**
         * Guards against scroll events and selection events looping into each other. Set before this widget initiates a selection.
         */
        this.currentModelSelectionId = '';
        /**
         * Permits the user to expand multiple nodes without each one being collapsed on a new selection.
         */
        this.lastUserSelection = '';
        this.isAtScrollTop = true;
        this.firstVisibleChildID = '';
        this.renderers = new Map();
        // The commonly used section will duplicate preference ID's, so we'll keep a separate list of them.
        this.commonlyUsedRenderers = new Map();
        this.onScroll = throttle(this.doOnScroll.bind(this), 50);
    }
    async init() {
        this.id = PreferencesEditorWidget_1.ID;
        this.title.label = PreferencesEditorWidget_1.LABEL;
        this.addClass('settings-main');
        this.toDispose.pushAll([
            this.preferenceService.onPreferencesChanged(e => this.handlePreferenceChanges(e)),
            this.model.onFilterChanged(e => this.handleDisplayChange(e)),
            this.model.onSelectionChanged(e => this.handleSelectionChange(e)),
        ]);
        this.createContainers();
        await this.preferenceService.ready;
        this.handleDisplayChange({ source: preference_tree_model_1.PreferenceFilterChangeSource.Schema });
    }
    createContainers() {
        const innerWrapper = document.createElement('div');
        innerWrapper.classList.add('settings-main-scroll-container');
        this.scrollContainer = innerWrapper;
        innerWrapper.addEventListener('scroll', this.onScroll, { passive: true });
        this.node.appendChild(innerWrapper);
        const noLeavesMessage = document.createElement('div');
        noLeavesMessage.classList.add('settings-no-results-announcement');
        noLeavesMessage.textContent = 'That search query has returned no results.';
        this.node.appendChild(noLeavesMessage);
    }
    handleDisplayChange(e) {
        const { isFiltered } = this.model;
        const currentFirstVisible = this.firstVisibleChildID;
        const leavesAreVisible = this.areLeavesVisible();
        if (e.source === preference_tree_model_1.PreferenceFilterChangeSource.Search) {
            this.handleSearchChange(isFiltered, leavesAreVisible);
        }
        else if (e.source === preference_tree_model_1.PreferenceFilterChangeSource.Scope) {
            this.handleScopeChange(isFiltered);
        }
        else if (e.source === preference_tree_model_1.PreferenceFilterChangeSource.Schema) {
            this.handleSchemaChange(isFiltered);
        }
        else {
            common_1.unreachable(e.source, 'Not all PreferenceFilterChangeSource enum variants handled.');
        }
        this.resetScroll(currentFirstVisible, e.source === preference_tree_model_1.PreferenceFilterChangeSource.Search && !isFiltered);
    }
    handleSchemaChange(isFiltered) {
        var _a;
        for (const [id, renderer, collection] of this.allRenderers()) {
            if (!this.model.getNode(renderer.nodeId)) {
                renderer.dispose();
                collection.delete(id);
            }
        }
        if (this.model.root) {
            const nodeIterator = Array.from(this.scrollContainer.children)[Symbol.iterator]();
            let nextNode = nodeIterator.next().value;
            for (const node of new browser_1.TopDownTreeIterator(this.model.root)) {
                if (preference_types_1.Preference.TreeNode.is(node)) {
                    const { collection, id } = this.analyzeIDAndGetRendererGroup(node.id);
                    const renderer = (_a = collection.get(id)) !== null && _a !== void 0 ? _a : this.rendererFactory(node);
                    if (!renderer.node.parentElement) { // If it hasn't been attached yet, it hasn't been checked for the current search.
                        this.hideIfFailsFilters(renderer, isFiltered);
                        collection.set(id, renderer);
                    }
                    if (nextNode !== renderer.node) {
                        if (nextNode) {
                            renderer.insertBefore(nextNode);
                        }
                        else {
                            renderer.appendTo(this.scrollContainer);
                        }
                    }
                    else {
                        nextNode = nodeIterator.next().value;
                    }
                }
            }
        }
    }
    handleScopeChange(isFiltered = this.model.isFiltered) {
        var _a;
        for (const [, renderer] of this.allRenderers()) {
            const isHidden = this.hideIfFailsFilters(renderer, isFiltered);
            if (isFiltered || !isHidden) {
                (_a = renderer.handleScopeChange) === null || _a === void 0 ? void 0 : _a.call(renderer, isFiltered);
            }
        }
    }
    handleSearchChange(isFiltered, leavesAreVisible) {
        var _a;
        if (leavesAreVisible) {
            for (const [, renderer] of this.allRenderers()) {
                const isHidden = this.hideIfFailsFilters(renderer, isFiltered);
                if (!isHidden) {
                    (_a = renderer.handleSearchChange) === null || _a === void 0 ? void 0 : _a.call(renderer, isFiltered);
                }
            }
        }
    }
    areLeavesVisible() {
        const leavesAreVisible = this.model.totalVisibleLeaves > 0;
        this.node.classList.toggle('no-results', !leavesAreVisible);
        this.scrollContainer.classList.toggle('hidden', !leavesAreVisible);
        return leavesAreVisible;
    }
    *allRenderers() {
        for (const [id, renderer] of this.commonlyUsedRenderers.entries()) {
            yield [id, renderer, this.commonlyUsedRenderers];
        }
        for (const [id, renderer] of this.renderers.entries()) {
            yield [id, renderer, this.renderers];
        }
    }
    handlePreferenceChanges(e) {
        var _a, _b, _c, _d;
        for (const id of Object.keys(e)) {
            (_b = (_a = this.commonlyUsedRenderers.get(id)) === null || _a === void 0 ? void 0 : _a.handleValueChange) === null || _b === void 0 ? void 0 : _b.call(_a);
            (_d = (_c = this.renderers.get(id)) === null || _c === void 0 ? void 0 : _c.handleValueChange) === null || _d === void 0 ? void 0 : _d.call(_c);
        }
    }
    /**
     * @returns true if the renderer is hidden, false otherwise.
     */
    hideIfFailsFilters(renderer, isFiltered) {
        const row = this.model.currentRows.get(renderer.nodeId);
        if (!row || (browser_1.CompositeTreeNode.is(row.node) && (isFiltered || row.visibleChildren === 0))) {
            renderer.hide();
            return true;
        }
        else {
            renderer.show();
            return false;
        }
    }
    resetScroll(nodeIDToScrollTo, filterWasCleared = false) {
        if (this.scrollBar) { // Absent on widget creation
            this.doResetScroll(nodeIDToScrollTo, filterWasCleared);
        }
        else {
            const interval = setInterval(() => {
                if (this.scrollBar) {
                    clearInterval(interval);
                    this.doResetScroll(nodeIDToScrollTo, filterWasCleared);
                }
            }, 500);
        }
    }
    doResetScroll(nodeIDToScrollTo, filterWasCleared = false) {
        requestAnimationFrame(() => {
            var _a;
            (_a = this.scrollBar) === null || _a === void 0 ? void 0 : _a.update();
            if (!filterWasCleared && nodeIDToScrollTo) {
                const { id, collection } = this.analyzeIDAndGetRendererGroup(nodeIDToScrollTo);
                const renderer = collection.get(id);
                if (renderer === null || renderer === void 0 ? void 0 : renderer.visible) {
                    renderer.node.scrollIntoView();
                    return;
                }
            }
            this.scrollContainer.scrollTop = 0;
        });
    }
    ;
    doOnScroll() {
        const { scrollContainer } = this;
        const firstVisibleChildID = this.findFirstVisibleChildID();
        this.setFirstVisibleChildID(firstVisibleChildID);
        if (this.isAtScrollTop && scrollContainer.scrollTop !== 0) {
            this.isAtScrollTop = false;
            this.tabbar.toggleShadow(true);
        }
        else if (!this.isAtScrollTop && scrollContainer.scrollTop === 0) {
            this.isAtScrollTop = true;
            this.tabbar.toggleShadow(false);
        }
    }
    ;
    findFirstVisibleChildID() {
        const { scrollTop } = this.scrollContainer;
        for (const [, renderer] of this.allRenderers()) {
            const { offsetTop, offsetHeight } = renderer.node;
            if (Math.abs(offsetTop - scrollTop) <= offsetHeight / 2) {
                return renderer.nodeId;
            }
        }
    }
    setFirstVisibleChildID(id) {
        if (id && id !== this.firstVisibleChildID) {
            this.firstVisibleChildID = id;
            let currentNode = this.model.getNode(id);
            let expansionAncestor;
            let selectionAncestor;
            while (currentNode && (!expansionAncestor || !selectionAncestor)) {
                if (!selectionAncestor && browser_1.SelectableTreeNode.is(currentNode)) {
                    selectionAncestor = currentNode;
                }
                if (!expansionAncestor && browser_1.ExpandableTreeNode.is(currentNode)) {
                    expansionAncestor = currentNode;
                }
                currentNode = currentNode.parent;
            }
            if (selectionAncestor) {
                this.currentModelSelectionId = selectionAncestor.id;
                expansionAncestor = expansionAncestor !== null && expansionAncestor !== void 0 ? expansionAncestor : selectionAncestor;
                this.model.selectIfNotSelected(selectionAncestor);
                if (!this.model.isFiltered && id !== this.lastUserSelection) {
                    this.lastUserSelection = '';
                    this.model.collapseAllExcept(expansionAncestor);
                }
            }
        }
    }
    handleSelectionChange(selectionEvent) {
        const node = selectionEvent[0];
        if (node && node.id !== this.currentModelSelectionId) {
            this.currentModelSelectionId = node.id;
            this.lastUserSelection = node.id;
            if (this.model.isFiltered && browser_1.CompositeTreeNode.is(node)) {
                for (const candidate of new browser_1.TopDownTreeIterator(node, { pruneSiblings: true })) {
                    const { id, collection } = this.analyzeIDAndGetRendererGroup(candidate.id);
                    const renderer = collection.get(id);
                    if (renderer === null || renderer === void 0 ? void 0 : renderer.visible) {
                        // When filtered, treat the first visible child as the selected node, since it will be the one scrolled to.
                        this.lastUserSelection = renderer.nodeId;
                        renderer.node.scrollIntoView();
                        return;
                    }
                }
            }
            else {
                const { id, collection } = this.analyzeIDAndGetRendererGroup(node.id);
                const renderer = collection.get(id);
                renderer === null || renderer === void 0 ? void 0 : renderer.node.scrollIntoView();
            }
        }
    }
    analyzeIDAndGetRendererGroup(nodeID) {
        const { id, group } = preference_types_1.Preference.TreeNode.getGroupAndIdFromNodeId(nodeID);
        const collection = group === preference_tree_generator_1.COMMONLY_USED_SECTION_PREFIX ? this.commonlyUsedRenderers : this.renderers;
        return { id, group, collection };
    }
    getScrollContainer() {
        return this.scrollContainer;
    }
    storeState() {
        return {
            firstVisibleChildID: this.firstVisibleChildID,
        };
    }
    restoreState(oldState) {
        this.firstVisibleChildID = oldState.firstVisibleChildID;
        this.resetScroll(this.firstVisibleChildID);
    }
};
PreferencesEditorWidget.ID = 'settings.editor';
PreferencesEditorWidget.LABEL = 'Settings Editor';
__decorate([
    inversify_1.inject(browser_1.PreferenceService),
    __metadata("design:type", Object)
], PreferencesEditorWidget.prototype, "preferenceService", void 0);
__decorate([
    inversify_1.inject(preference_tree_model_1.PreferenceTreeModel),
    __metadata("design:type", preference_tree_model_1.PreferenceTreeModel)
], PreferencesEditorWidget.prototype, "model", void 0);
__decorate([
    inversify_1.inject(preference_node_renderer_1.PreferenceNodeRendererFactory),
    __metadata("design:type", Function)
], PreferencesEditorWidget.prototype, "rendererFactory", void 0);
__decorate([
    inversify_1.inject(preference_scope_tabbar_widget_1.PreferencesScopeTabBar),
    __metadata("design:type", preference_scope_tabbar_widget_1.PreferencesScopeTabBar)
], PreferencesEditorWidget.prototype, "tabbar", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], PreferencesEditorWidget.prototype, "init", null);
PreferencesEditorWidget = PreferencesEditorWidget_1 = __decorate([
    inversify_1.injectable()
], PreferencesEditorWidget);
exports.PreferencesEditorWidget = PreferencesEditorWidget;


/***/ }),

/***/ "./node_modules/@theia/preferences/lib/browser/views/preference-scope-tabbar-widget.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@theia/preferences/lib/browser/views/preference-scope-tabbar-widget.js ***!
  \*********************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var PreferencesScopeTabBar_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferencesScopeTabBar = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const widgets_1 = __webpack_require__(/*! @theia/core/shared/@phosphor/widgets */ "./node_modules/@theia/core/shared/@phosphor/widgets/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const workspace_service_1 = __webpack_require__(/*! @theia/workspace/lib/browser/workspace-service */ "./node_modules/@theia/workspace/lib/browser/workspace-service.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "./node_modules/@theia/core/lib/common/uri.js");
const preference_scope_command_manager_1 = __webpack_require__(/*! ../util/preference-scope-command-manager */ "./node_modules/@theia/preferences/lib/browser/util/preference-scope-command-manager.js");
const preference_types_1 = __webpack_require__(/*! ../util/preference-types */ "./node_modules/@theia/preferences/lib/browser/util/preference-types.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "./node_modules/@theia/core/lib/common/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "./node_modules/@theia/core/lib/common/nls.js");
const USER_TAB_LABEL = nls_1.nls.localizeByDefault('User');
const USER_TAB_INDEX = browser_1.PreferenceScope['User'];
const WORKSPACE_TAB_LABEL = nls_1.nls.localizeByDefault('Workspace');
const WORKSPACE_TAB_INDEX = browser_1.PreferenceScope['Workspace'];
const FOLDER_TAB_LABEL = nls_1.nls.localizeByDefault('Folder');
const FOLDER_TAB_INDEX = browser_1.PreferenceScope['Folder'];
const PREFERENCE_TAB_CLASSNAME = 'preferences-scope-tab';
const GENERAL_FOLDER_TAB_CLASSNAME = 'preference-folder';
const LABELED_FOLDER_TAB_CLASSNAME = 'preferences-folder-tab';
const FOLDER_DROPDOWN_CLASSNAME = 'preferences-folder-dropdown';
const FOLDER_DROPDOWN_ICON_CLASSNAME = 'preferences-folder-dropdown-icon ' + browser_1.codicon('chevron-down');
const TABBAR_UNDERLINE_CLASSNAME = 'tabbar-underline';
const SINGLE_FOLDER_TAB_CLASSNAME = `${PREFERENCE_TAB_CLASSNAME} ${GENERAL_FOLDER_TAB_CLASSNAME} ${LABELED_FOLDER_TAB_CLASSNAME}`;
const UNSELECTED_FOLDER_DROPDOWN_CLASSNAME = `${PREFERENCE_TAB_CLASSNAME} ${GENERAL_FOLDER_TAB_CLASSNAME} ${FOLDER_DROPDOWN_CLASSNAME}`;
const SELECTED_FOLDER_DROPDOWN_CLASSNAME = `${PREFERENCE_TAB_CLASSNAME} ${GENERAL_FOLDER_TAB_CLASSNAME} ${LABELED_FOLDER_TAB_CLASSNAME} ${FOLDER_DROPDOWN_CLASSNAME}`;
const SHADOW_CLASSNAME = 'with-shadow';
let PreferencesScopeTabBar = PreferencesScopeTabBar_1 = class PreferencesScopeTabBar extends widgets_1.TabBar {
    constructor() {
        super(...arguments);
        this.onScopeChangedEmitter = new common_1.Emitter();
        this.onScopeChanged = this.onScopeChangedEmitter.event;
        this.toDispose = new common_1.DisposableCollection();
        this.currentWorkspaceRoots = [];
        this.currentSelection = preference_types_1.Preference.DEFAULT_SCOPE;
        this.editorScrollAtTop = true;
        this.folderSelectionCallback = (newScope) => { this.setNewScopeSelection(newScope); };
    }
    get currentScope() {
        return this.currentSelection;
    }
    setNewScopeSelection(newSelection) {
        const stringifiedSelectionScope = newSelection.scope.toString();
        const newIndex = this.titles.findIndex(title => title.dataset.scope === stringifiedSelectionScope);
        if (newIndex !== -1) {
            this.currentSelection = newSelection;
            this.currentIndex = newIndex;
            if (newSelection.scope === browser_1.PreferenceScope.Folder) {
                this.addOrUpdateFolderTab();
            }
            this.emitNewScope();
        }
    }
    init() {
        this.id = PreferencesScopeTabBar_1.ID;
        this.setupInitialDisplay();
        this.tabActivateRequested.connect((sender, args) => {
            const scopeDetails = this.toScopeDetails(args.title);
            if (scopeDetails) {
                this.setNewScopeSelection(scopeDetails);
            }
        });
        this.toDispose.pushAll([
            this.workspaceService.onWorkspaceChanged(newRoots => this.doUpdateDisplay(newRoots)),
            this.workspaceService.onWorkspaceLocationChanged(() => this.doUpdateDisplay(this.workspaceService.tryGetRoots())),
        ]);
        const tabUnderline = document.createElement('div');
        tabUnderline.className = TABBAR_UNDERLINE_CLASSNAME;
        this.node.append(tabUnderline);
    }
    toScopeDetails(title) {
        if (title) {
            const source = 'dataset' in title ? title.dataset : title;
            const { scope, uri, activeScopeIsFolder } = source;
            return {
                scope: Number(scope),
                uri: uri || undefined,
                activeScopeIsFolder: activeScopeIsFolder === 'true' || activeScopeIsFolder === true,
            };
        }
    }
    toDataSet(scopeDetails) {
        const { scope, uri, activeScopeIsFolder } = scopeDetails;
        return {
            scope: scope.toString(),
            uri: uri !== null && uri !== void 0 ? uri : '',
            activeScopeIsFolder: activeScopeIsFolder.toString()
        };
    }
    setupInitialDisplay() {
        this.addUserTab();
        if (this.workspaceService.workspace) {
            this.addWorkspaceTab(this.workspaceService.workspace);
        }
        this.addOrUpdateFolderTab();
    }
    onUpdateRequest(msg) {
        super.onUpdateRequest(msg);
        this.addTabIndexToTabs();
    }
    addTabIndexToTabs() {
        this.node.querySelectorAll('li').forEach((tab, index) => {
            tab.tabIndex = 0;
            const handler = () => {
                if (tab.className.includes(GENERAL_FOLDER_TAB_CLASSNAME) && this.currentWorkspaceRoots.length > 1) {
                    const tabRect = tab.getBoundingClientRect();
                    this.openContextMenu(tabRect, tab, 'keypress');
                }
                else {
                    const details = this.toScopeDetails(this.titles[index]);
                    if (details) {
                        this.setNewScopeSelection(details);
                    }
                }
            };
            tab.onkeydown = handler;
            tab.onclick = handler;
        });
    }
    addUserTab() {
        this.addTab(new widgets_1.Title({
            dataset: { uri: '', scope: USER_TAB_INDEX.toString() },
            label: USER_TAB_LABEL,
            owner: this,
            className: PREFERENCE_TAB_CLASSNAME
        }));
    }
    addWorkspaceTab(currentWorkspace) {
        const scopeDetails = this.getWorkspaceDataset(currentWorkspace);
        const workspaceTabTitle = new widgets_1.Title({
            dataset: this.toDataSet(scopeDetails),
            label: WORKSPACE_TAB_LABEL,
            owner: this,
            className: PREFERENCE_TAB_CLASSNAME,
        });
        this.addTab(workspaceTabTitle);
        return workspaceTabTitle;
    }
    getWorkspaceDataset(currentWorkspace) {
        const { resource, isDirectory } = currentWorkspace;
        const scope = WORKSPACE_TAB_INDEX;
        return { uri: resource.toString(), activeScopeIsFolder: isDirectory, scope };
    }
    addOrUpdateFolderTab() {
        if (!!this.workspaceService.workspace) {
            this.currentWorkspaceRoots = this.workspaceService.tryGetRoots();
            const multipleFolderRootsAreAvailable = this.currentWorkspaceRoots && this.currentWorkspaceRoots.length > 1;
            const noFolderRootsAreAvailable = this.currentWorkspaceRoots.length === 0;
            const shouldShowFoldersSeparately = this.workspaceService.saved;
            if (!noFolderRootsAreAvailable) {
                if (!this.folderTitle) {
                    this.folderTitle = new widgets_1.Title({
                        label: '',
                        caption: FOLDER_TAB_LABEL,
                        owner: this,
                    });
                }
                this.setFolderTitleProperties(multipleFolderRootsAreAvailable);
                if (multipleFolderRootsAreAvailable || shouldShowFoldersSeparately) {
                    this.addTab(this.folderTitle);
                }
            }
            else {
                const folderTabIndex = this.titles.findIndex(title => title.caption === FOLDER_TAB_LABEL);
                if (folderTabIndex > -1) {
                    this.removeTabAt(folderTabIndex);
                }
            }
        }
    }
    setFolderTitleProperties(multipleFolderRootsAreAvailable) {
        this.folderTitle.iconClass = multipleFolderRootsAreAvailable ? FOLDER_DROPDOWN_ICON_CLASSNAME : '';
        if (this.currentSelection.scope === FOLDER_TAB_INDEX) {
            this.folderTitle.label = this.labelProvider.getName(new uri_1.default(this.currentSelection.uri));
            this.folderTitle.dataset = this.toDataSet(this.currentSelection);
            this.folderTitle.className = multipleFolderRootsAreAvailable ? SELECTED_FOLDER_DROPDOWN_CLASSNAME : SINGLE_FOLDER_TAB_CLASSNAME;
        }
        else {
            const singleFolderRoot = this.currentWorkspaceRoots[0].resource;
            const singleFolderLabel = this.labelProvider.getName(singleFolderRoot);
            const defaultURI = multipleFolderRootsAreAvailable ? '' : singleFolderRoot.toString();
            this.folderTitle.label = multipleFolderRootsAreAvailable ? FOLDER_TAB_LABEL : singleFolderLabel;
            this.folderTitle.className = multipleFolderRootsAreAvailable ? UNSELECTED_FOLDER_DROPDOWN_CLASSNAME : SINGLE_FOLDER_TAB_CLASSNAME;
            this.folderTitle.dataset = { folderTitle: 'true', scope: FOLDER_TAB_INDEX.toString(), uri: defaultURI };
        }
    }
    getFolderContextMenu(workspaceRoots = this.workspaceService.tryGetRoots()) {
        this.preferencesMenuFactory.createFolderWorkspacesMenu(workspaceRoots, this.currentSelection.uri);
    }
    handleEvent() {
        // Don't - the handlers are defined in PreferenceScopeTabbarWidget.addTabIndexToTabs()
    }
    openContextMenu(tabRect, folderTabNode, source) {
        const toDisposeOnHide = new common_1.DisposableCollection();
        for (const root of this.workspaceService.tryGetRoots()) {
            const id = `set-scope-to-${root.resource.toString()}`;
            toDisposeOnHide.pushAll([
                this.commandRegistry.registerCommand({ id }, { execute: () => this.setScope(root.resource) }),
                this.menuModelRegistry.registerMenuAction(preference_types_1.PreferenceMenus.FOLDER_SCOPE_MENU_PATH, {
                    commandId: id,
                    label: this.labelProvider.getName(root),
                })
            ]);
        }
        this.contextMenuRenderer.render({
            menuPath: preference_types_1.PreferenceMenus.FOLDER_SCOPE_MENU_PATH,
            anchor: { x: tabRect.left, y: tabRect.bottom },
            onHide: () => {
                setTimeout(() => toDisposeOnHide.dispose());
                if (source === 'click') {
                    folderTabNode.blur();
                }
            }
        });
    }
    doUpdateDisplay(newRoots) {
        const folderWasRemoved = newRoots.length < this.currentWorkspaceRoots.length;
        this.currentWorkspaceRoots = newRoots;
        if (folderWasRemoved) {
            const removedFolderWasSelectedScope = !this.currentWorkspaceRoots.some(root => root.resource.toString() === this.currentSelection.uri);
            if (removedFolderWasSelectedScope) {
                this.setNewScopeSelection(preference_types_1.Preference.DEFAULT_SCOPE);
            }
        }
        this.updateWorkspaceTab();
        this.addOrUpdateFolderTab();
    }
    updateWorkspaceTab() {
        var _a;
        const currentWorkspace = this.workspaceService.workspace;
        if (currentWorkspace) {
            const workspaceTitle = (_a = this.titles.find(title => title.label === WORKSPACE_TAB_LABEL)) !== null && _a !== void 0 ? _a : this.addWorkspaceTab(currentWorkspace);
            const scopeDetails = this.getWorkspaceDataset(currentWorkspace);
            workspaceTitle.dataset = this.toDataSet(scopeDetails);
            if (this.currentSelection.scope === browser_1.PreferenceScope.Workspace) {
                this.setNewScopeSelection(scopeDetails);
            }
        }
    }
    emitNewScope() {
        this.onScopeChangedEmitter.fire(this.currentSelection);
    }
    setScope(scope) {
        const details = scope instanceof uri_1.default ? this.getDetailsForResource(scope) : this.getDetailsForScope(scope);
        if (details) {
            this.setNewScopeSelection(details);
        }
    }
    getDetailsForScope(scope) {
        const stringifiedSelectionScope = scope.toString();
        const correspondingTitle = this.titles.find(title => title.dataset.scope === stringifiedSelectionScope);
        return this.toScopeDetails(correspondingTitle);
    }
    getDetailsForResource(resource) {
        const parent = this.workspaceService.getWorkspaceRootUri(resource);
        if (!parent) {
            return undefined;
        }
        if (!this.workspaceService.isMultiRootWorkspaceOpened) {
            return this.getDetailsForScope(browser_1.PreferenceScope.Workspace);
        }
        return ({ scope: browser_1.PreferenceScope.Folder, uri: parent.toString(), activeScopeIsFolder: true });
    }
    storeState() {
        return {
            scopeDetails: this.currentScope
        };
    }
    restoreState(oldState) {
        const scopeDetails = this.toScopeDetails(oldState.scopeDetails);
        if (scopeDetails) {
            this.setNewScopeSelection(scopeDetails);
        }
    }
    toggleShadow(showShadow) {
        this.toggleClass(SHADOW_CLASSNAME, showShadow);
    }
    dispose() {
        super.dispose();
        this.toDispose.dispose();
    }
};
PreferencesScopeTabBar.ID = 'preferences-scope-tab-bar';
__decorate([
    inversify_1.inject(workspace_service_1.WorkspaceService),
    __metadata("design:type", workspace_service_1.WorkspaceService)
], PreferencesScopeTabBar.prototype, "workspaceService", void 0);
__decorate([
    inversify_1.inject(preference_scope_command_manager_1.PreferenceScopeCommandManager),
    __metadata("design:type", preference_scope_command_manager_1.PreferenceScopeCommandManager)
], PreferencesScopeTabBar.prototype, "preferencesMenuFactory", void 0);
__decorate([
    inversify_1.inject(browser_1.ContextMenuRenderer),
    __metadata("design:type", browser_1.ContextMenuRenderer)
], PreferencesScopeTabBar.prototype, "contextMenuRenderer", void 0);
__decorate([
    inversify_1.inject(browser_1.LabelProvider),
    __metadata("design:type", browser_1.LabelProvider)
], PreferencesScopeTabBar.prototype, "labelProvider", void 0);
__decorate([
    inversify_1.inject(common_1.CommandRegistry),
    __metadata("design:type", common_1.CommandRegistry)
], PreferencesScopeTabBar.prototype, "commandRegistry", void 0);
__decorate([
    inversify_1.inject(common_1.MenuModelRegistry),
    __metadata("design:type", common_1.MenuModelRegistry)
], PreferencesScopeTabBar.prototype, "menuModelRegistry", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PreferencesScopeTabBar.prototype, "init", null);
PreferencesScopeTabBar = PreferencesScopeTabBar_1 = __decorate([
    inversify_1.injectable()
], PreferencesScopeTabBar);
exports.PreferencesScopeTabBar = PreferencesScopeTabBar;


/***/ }),

/***/ "./node_modules/@theia/preferences/lib/browser/views/preference-searchbar-widget.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@theia/preferences/lib/browser/views/preference-searchbar-widget.js ***!
  \******************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var PreferencesSearchbarWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferencesSearchbarWidget = void 0;
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "./node_modules/@theia/core/shared/react/index.js");
const debounce = __webpack_require__(/*! p-debounce */ "./node_modules/p-debounce/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "./node_modules/@theia/core/lib/common/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "./node_modules/@theia/core/lib/common/nls.js");
let PreferencesSearchbarWidget = PreferencesSearchbarWidget_1 = class PreferencesSearchbarWidget extends browser_1.ReactWidget {
    constructor() {
        super(...arguments);
        this.onFilterStringChangedEmitter = new core_1.Emitter();
        this.onFilterChanged = this.onFilterStringChangedEmitter.event;
        this.searchbarRef = React.createRef();
        this.resultsCount = 0;
        this.handleSearch = (e) => this.search(e.target.value);
        this.search = debounce(async (value) => {
            this.onFilterStringChangedEmitter.fire(value);
            this.update();
        }, 200);
        /**
         * Clears the search input and all search results.
         * @param e on-click mouse event.
         */
        this.clearSearchResults = async (e) => {
            const search = document.getElementById(PreferencesSearchbarWidget_1.SEARCHBAR_ID);
            if (search) {
                search.value = '';
                await this.search(search.value);
                this.update();
            }
        };
    }
    init() {
        this.onRender.push(core_1.Disposable.create(() => this.focus()));
        this.id = PreferencesSearchbarWidget_1.ID;
        this.title.label = PreferencesSearchbarWidget_1.LABEL;
        this.update();
    }
    focus() {
        if (this.searchbarRef.current) {
            this.searchbarRef.current.focus();
        }
    }
    /**
     * Renders all search bar options.
     */
    renderOptionContainer() {
        const resultsCount = this.renderResultsCountOption();
        const clearAllOption = this.renderClearAllOption();
        return React.createElement("div", { className: "option-buttons" },
            " ",
            resultsCount,
            " ",
            clearAllOption,
            " ");
    }
    /**
     * Renders a badge displaying search results count.
     */
    renderResultsCountOption() {
        let resultsFound;
        if (this.resultsCount === 0) {
            resultsFound = nls_1.nls.localizeByDefault('No Settings Found');
        }
        else if (this.resultsCount === 1) {
            resultsFound = nls_1.nls.localizeByDefault('1 Setting Found');
        }
        else {
            resultsFound = nls_1.nls.localizeByDefault('{0} Settings Found', this.resultsCount.toFixed(0));
        }
        return this.searchTermExists() ?
            (React.createElement("span", { className: "results-found", title: resultsFound }, resultsFound))
            : '';
    }
    /**
     * Renders a clear all button.
     */
    renderClearAllOption() {
        return React.createElement("span", { className: `${browser_1.codicon('clear-all')} option ${(this.searchTermExists() ? 'enabled' : '')}`, title: nls_1.nls.localizeByDefault('Clear Search Results'), onClick: this.clearSearchResults });
    }
    /**
     * Determines whether the search input currently has a value.
     * @returns true, if the search input currently has a value; false, otherwise.
     */
    searchTermExists() {
        var _a;
        return !!((_a = this.searchbarRef.current) === null || _a === void 0 ? void 0 : _a.value);
    }
    getSearchTerm() {
        const search = document.getElementById(PreferencesSearchbarWidget_1.SEARCHBAR_ID);
        return search === null || search === void 0 ? void 0 : search.value;
    }
    async updateSearchTerm(searchTerm) {
        const search = document.getElementById(PreferencesSearchbarWidget_1.SEARCHBAR_ID);
        if (!search || search.value === searchTerm) {
            return;
        }
        search.value = searchTerm;
        await this.search(search.value);
        this.update();
    }
    render() {
        const optionContainer = this.renderOptionContainer();
        return (React.createElement("div", { className: 'settings-header' },
            React.createElement("div", { className: "settings-search-container" },
                React.createElement("input", { type: "text", id: PreferencesSearchbarWidget_1.SEARCHBAR_ID, spellCheck: false, placeholder: nls_1.nls.localizeByDefault('Search Settings'), className: "settings-search-input theia-input", onChange: this.handleSearch, ref: this.searchbarRef }),
                optionContainer)));
    }
    /**
     * Updates the search result count.
     * @param count the result count.
     */
    updateResultsCount(count) {
        this.resultsCount = count;
        this.update();
    }
    storeState() {
        return {
            searchTerm: this.getSearchTerm()
        };
    }
    restoreState(oldState) {
        const searchInputExists = this.onDidChangeVisibility(() => {
            this.updateSearchTerm(oldState.searchTerm || '');
            searchInputExists.dispose();
        });
    }
};
PreferencesSearchbarWidget.ID = 'settings.header';
PreferencesSearchbarWidget.LABEL = 'Settings Header';
PreferencesSearchbarWidget.SEARCHBAR_ID = 'preference-searchbar';
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PreferencesSearchbarWidget.prototype, "init", null);
PreferencesSearchbarWidget = PreferencesSearchbarWidget_1 = __decorate([
    inversify_1.injectable()
], PreferencesSearchbarWidget);
exports.PreferencesSearchbarWidget = PreferencesSearchbarWidget;


/***/ }),

/***/ "./node_modules/@theia/preferences/lib/browser/views/preference-tree-widget.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@theia/preferences/lib/browser/views/preference-tree-widget.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var PreferencesTreeWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferencesTreeWidget = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "./node_modules/@theia/core/shared/react/index.js");
const preference_tree_model_1 = __webpack_require__(/*! ../preference-tree-model */ "./node_modules/@theia/preferences/lib/browser/preference-tree-model.js");
let PreferencesTreeWidget = PreferencesTreeWidget_1 = class PreferencesTreeWidget extends browser_1.TreeWidget {
    constructor() {
        super(...arguments);
        this.shouldFireSelectionEvents = true;
    }
    init() {
        super.init();
        this.id = PreferencesTreeWidget_1.ID;
        this.toDispose.pushAll([
            this.model.onFilterChanged(() => {
                this.updateRows();
            }),
        ]);
    }
    doUpdateRows() {
        this.rows = new Map();
        let index = 0;
        for (const [id, nodeRow] of this.model.currentRows.entries()) {
            if (nodeRow.visibleChildren > 0 && (browser_1.ExpandableTreeNode.is(nodeRow.node) || browser_1.ExpandableTreeNode.isExpanded(nodeRow.node.parent))) {
                this.rows.set(id, Object.assign(Object.assign({}, nodeRow), { index: index++ }));
            }
        }
        this.updateScrollToRow();
    }
    doRenderNodeRow({ depth, visibleChildren, node, isExpansible }) {
        return this.renderNode(node, { depth, visibleChildren, isExpansible });
    }
    renderNode(node, props) {
        if (!browser_1.TreeNode.isVisible(node)) {
            return undefined;
        }
        const attributes = this.createNodeAttributes(node, props);
        const content = React.createElement("div", { className: browser_1.TREE_NODE_CONTENT_CLASS },
            this.renderExpansionToggle(node, props),
            this.renderCaption(node, props));
        return React.createElement('div', attributes, content);
    }
    renderExpansionToggle(node, props) {
        if (browser_1.ExpandableTreeNode.is(node) && !props.isExpansible) {
            return React.createElement("div", { className: 'preferences-tree-spacer' });
        }
        return super.renderExpansionToggle(node, props);
    }
    toNodeName(node) {
        var _a;
        const visibleChildren = (_a = this.model.currentRows.get(node.id)) === null || _a === void 0 ? void 0 : _a.visibleChildren;
        const baseName = this.labelProvider.getName(node);
        const printedNameWithVisibleChildren = this.model.isFiltered && visibleChildren !== undefined
            ? `${baseName} (${visibleChildren})`
            : baseName;
        return printedNameWithVisibleChildren;
    }
};
PreferencesTreeWidget.ID = 'preferences.tree';
__decorate([
    inversify_1.inject(preference_tree_model_1.PreferenceTreeModel),
    __metadata("design:type", preference_tree_model_1.PreferenceTreeModel)
], PreferencesTreeWidget.prototype, "model", void 0);
__decorate([
    inversify_1.inject(browser_1.TreeProps),
    __metadata("design:type", Object)
], PreferencesTreeWidget.prototype, "treeProps", void 0);
__decorate([
    inversify_1.inject(browser_1.ContextMenuRenderer),
    __metadata("design:type", browser_1.ContextMenuRenderer)
], PreferencesTreeWidget.prototype, "contextMenuRenderer", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PreferencesTreeWidget.prototype, "init", null);
PreferencesTreeWidget = PreferencesTreeWidget_1 = __decorate([
    inversify_1.injectable()
], PreferencesTreeWidget);
exports.PreferencesTreeWidget = PreferencesTreeWidget;


/***/ }),

/***/ "./node_modules/@theia/preferences/lib/browser/views/preference-widget.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@theia/preferences/lib/browser/views/preference-widget.js ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var PreferencesWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferencesWidget = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const preference_editor_widget_1 = __webpack_require__(/*! ./preference-editor-widget */ "./node_modules/@theia/preferences/lib/browser/views/preference-editor-widget.js");
const preference_tree_widget_1 = __webpack_require__(/*! ./preference-tree-widget */ "./node_modules/@theia/preferences/lib/browser/views/preference-tree-widget.js");
const preference_searchbar_widget_1 = __webpack_require__(/*! ./preference-searchbar-widget */ "./node_modules/@theia/preferences/lib/browser/views/preference-searchbar-widget.js");
const preference_scope_tabbar_widget_1 = __webpack_require__(/*! ./preference-scope-tabbar-widget */ "./node_modules/@theia/preferences/lib/browser/views/preference-scope-tabbar-widget.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "./node_modules/@theia/core/lib/common/nls.js");
let PreferencesWidget = PreferencesWidget_1 = class PreferencesWidget extends browser_1.Panel {
    get currentScope() {
        return this.tabBarWidget.currentScope;
    }
    setSearchTerm(query) {
        this.searchbarWidget.updateSearchTerm(query);
    }
    setScope(scope) {
        this.tabBarWidget.setScope(scope);
    }
    onResize(msg) {
        super.onResize(msg);
        if (msg.width < 600 && this.treeWidget && !this.treeWidget.isHidden) {
            this.treeWidget.hide();
            this.editorWidget.addClass('full-pane');
        }
        else if (msg.width >= 600 && this.treeWidget && this.treeWidget.isHidden) {
            this.treeWidget.show();
            this.editorWidget.removeClass('full-pane');
        }
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        this.searchbarWidget.focus();
    }
    init() {
        this.id = PreferencesWidget_1.ID;
        this.title.label = PreferencesWidget_1.LABEL;
        this.title.closable = true;
        this.addClass('theia-settings-container');
        this.title.iconClass = browser_1.codicon('settings');
        this.searchbarWidget.addClass('preferences-searchbar-widget');
        this.addWidget(this.searchbarWidget);
        this.tabBarWidget.addClass('preferences-tabbar-widget');
        this.addWidget(this.tabBarWidget);
        this.treeWidget.addClass('preferences-tree-widget');
        this.addWidget(this.treeWidget);
        this.editorWidget.addClass('preferences-editor-widget');
        this.addWidget(this.editorWidget);
        this.update();
    }
    storeState() {
        return {
            scopeTabBarState: this.tabBarWidget.storeState(),
            editorState: this.editorWidget.storeState(),
            searchbarWidgetState: this.searchbarWidget.storeState(),
        };
    }
    restoreState(state) {
        this.tabBarWidget.restoreState(state.scopeTabBarState);
        this.editorWidget.restoreState(state.editorState);
        this.searchbarWidget.restoreState(state.searchbarWidgetState);
    }
};
/**
 * The widget `id`.
 */
PreferencesWidget.ID = 'settings_widget';
/**
 * The widget `label` which is used for display purposes.
 */
PreferencesWidget.LABEL = nls_1.nls.localizeByDefault('Preferences');
__decorate([
    inversify_1.inject(preference_editor_widget_1.PreferencesEditorWidget),
    __metadata("design:type", preference_editor_widget_1.PreferencesEditorWidget)
], PreferencesWidget.prototype, "editorWidget", void 0);
__decorate([
    inversify_1.inject(preference_tree_widget_1.PreferencesTreeWidget),
    __metadata("design:type", preference_tree_widget_1.PreferencesTreeWidget)
], PreferencesWidget.prototype, "treeWidget", void 0);
__decorate([
    inversify_1.inject(preference_searchbar_widget_1.PreferencesSearchbarWidget),
    __metadata("design:type", preference_searchbar_widget_1.PreferencesSearchbarWidget)
], PreferencesWidget.prototype, "searchbarWidget", void 0);
__decorate([
    inversify_1.inject(preference_scope_tabbar_widget_1.PreferencesScopeTabBar),
    __metadata("design:type", preference_scope_tabbar_widget_1.PreferencesScopeTabBar)
], PreferencesWidget.prototype, "tabBarWidget", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PreferencesWidget.prototype, "init", null);
PreferencesWidget = PreferencesWidget_1 = __decorate([
    inversify_1.injectable()
], PreferencesWidget);
exports.PreferencesWidget = PreferencesWidget;


/***/ }),

/***/ "./node_modules/@theia/preferences/lib/browser/workspace-file-preference-provider.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@theia/preferences/lib/browser/workspace-file-preference-provider.js ***!
  \*******************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceFilePreferenceProvider = exports.WorkspaceFilePreferenceProviderFactory = exports.WorkspaceFilePreferenceProviderOptions = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const preferences_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences */ "./node_modules/@theia/core/lib/browser/preferences/index.js");
const workspace_service_1 = __webpack_require__(/*! @theia/workspace/lib/browser/workspace-service */ "./node_modules/@theia/workspace/lib/browser/workspace-service.js");
const abstract_resource_preference_provider_1 = __webpack_require__(/*! ./abstract-resource-preference-provider */ "./node_modules/@theia/preferences/lib/browser/abstract-resource-preference-provider.js");
let WorkspaceFilePreferenceProviderOptions = class WorkspaceFilePreferenceProviderOptions {
};
WorkspaceFilePreferenceProviderOptions = __decorate([
    inversify_1.injectable()
], WorkspaceFilePreferenceProviderOptions);
exports.WorkspaceFilePreferenceProviderOptions = WorkspaceFilePreferenceProviderOptions;
exports.WorkspaceFilePreferenceProviderFactory = Symbol('WorkspaceFilePreferenceProviderFactory');
let WorkspaceFilePreferenceProvider = class WorkspaceFilePreferenceProvider extends abstract_resource_preference_provider_1.AbstractResourcePreferenceProvider {
    constructor() {
        super(...arguments);
        this.sectionsInsideSettings = new Set();
    }
    getUri() {
        return this.options.workspaceUri;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    parse(content) {
        const data = super.parse(content);
        if (workspace_service_1.WorkspaceData.is(data)) {
            const settings = Object.assign({}, data.settings);
            for (const key of this.configurations.getSectionNames().filter(name => name !== 'settings')) {
                // If the user has written configuration inside the "settings" object, we will respect that.
                if (settings[key]) {
                    this.sectionsInsideSettings.add(key);
                }
                // Favor sections outside the "settings" object to agree with VSCode behavior
                if (data[key]) {
                    settings[key] = data[key];
                    this.sectionsInsideSettings.delete(key);
                }
            }
            return settings;
        }
        return {};
    }
    getPath(preferenceName) {
        const firstSegment = preferenceName.split('.', 1)[0];
        const remainder = preferenceName.slice(firstSegment.length + 1);
        if (this.belongsInSection(firstSegment, remainder)) {
            // Default to writing sections outside the "settings" object.
            const path = [firstSegment];
            if (remainder) {
                path.push(remainder);
            }
            // If the user has already written this section inside the "settings" object, modify it there.
            if (this.sectionsInsideSettings.has(firstSegment)) {
                path.unshift('settings');
            }
            return path;
        }
        return ['settings', preferenceName];
    }
    belongsInSection(firstSegment, remainder) {
        return this.configurations.isSectionName(firstSegment);
    }
    getScope() {
        return preferences_1.PreferenceScope.Workspace;
    }
    getDomain() {
        // workspace file is treated as part of the workspace
        return this.workspaceService.tryGetRoots().map(r => r.resource.toString()).concat([this.options.workspaceUri.toString()]);
    }
};
__decorate([
    inversify_1.inject(workspace_service_1.WorkspaceService),
    __metadata("design:type", workspace_service_1.WorkspaceService)
], WorkspaceFilePreferenceProvider.prototype, "workspaceService", void 0);
__decorate([
    inversify_1.inject(WorkspaceFilePreferenceProviderOptions),
    __metadata("design:type", WorkspaceFilePreferenceProviderOptions)
], WorkspaceFilePreferenceProvider.prototype, "options", void 0);
WorkspaceFilePreferenceProvider = __decorate([
    inversify_1.injectable()
], WorkspaceFilePreferenceProvider);
exports.WorkspaceFilePreferenceProvider = WorkspaceFilePreferenceProvider;


/***/ }),

/***/ "./node_modules/@theia/preferences/lib/browser/workspace-preference-provider.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@theia/preferences/lib/browser/workspace-preference-provider.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2018 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspacePreferenceProvider = void 0;
/* eslint-disable @typescript-eslint/no-explicit-any */
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const disposable_1 = __webpack_require__(/*! @theia/core/lib/common/disposable */ "./node_modules/@theia/core/lib/common/disposable.js");
const preferences_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences */ "./node_modules/@theia/core/lib/browser/preferences/index.js");
const workspace_service_1 = __webpack_require__(/*! @theia/workspace/lib/browser/workspace-service */ "./node_modules/@theia/workspace/lib/browser/workspace-service.js");
const workspace_file_preference_provider_1 = __webpack_require__(/*! ./workspace-file-preference-provider */ "./node_modules/@theia/preferences/lib/browser/workspace-file-preference-provider.js");
let WorkspacePreferenceProvider = class WorkspacePreferenceProvider extends preferences_1.PreferenceProvider {
    constructor() {
        super(...arguments);
        this.toDisposeOnEnsureDelegateUpToDate = new disposable_1.DisposableCollection();
    }
    async init() {
        this.workspaceService.ready.then(() => {
            // If there is no workspace after the workspace service is initialized, then no more work is needed for this provider to be ready.
            // If there is a workspace, then we wait for the new delegate to be ready before declaring this provider ready.
            if (!this.workspaceService.workspace) {
                this._ready.resolve();
            }
        });
        this.workspaceService.onWorkspaceLocationChanged(() => this.ensureDelegateUpToDate());
        this.workspaceService.onWorkspaceChanged(() => this.ensureDelegateUpToDate());
    }
    getConfigUri(resourceUri = this.ensureResourceUri(), sectionName) {
        var _a;
        return (_a = this.delegate) === null || _a === void 0 ? void 0 : _a.getConfigUri(resourceUri, sectionName);
    }
    getContainingConfigUri(resourceUri = this.ensureResourceUri(), sectionName) {
        var _a, _b;
        return (_b = (_a = this.delegate) === null || _a === void 0 ? void 0 : _a.getContainingConfigUri) === null || _b === void 0 ? void 0 : _b.call(_a, resourceUri, sectionName);
    }
    get delegate() {
        return this._delegate;
    }
    ensureDelegateUpToDate() {
        const delegate = this.createDelegate();
        if (this._delegate !== delegate) {
            this.toDisposeOnEnsureDelegateUpToDate.dispose();
            this.toDispose.push(this.toDisposeOnEnsureDelegateUpToDate);
            this._delegate = delegate;
            if (delegate) {
                // If this provider has not yet declared itself ready, it should do so when the new delegate is ready.
                delegate.ready.then(() => this._ready.resolve(), () => { });
            }
            if (delegate instanceof workspace_file_preference_provider_1.WorkspaceFilePreferenceProvider) {
                this.toDisposeOnEnsureDelegateUpToDate.pushAll([
                    delegate,
                    delegate.onDidPreferencesChanged(changes => this.onDidPreferencesChangedEmitter.fire(changes))
                ]);
            }
        }
    }
    createDelegate() {
        const workspace = this.workspaceService.workspace;
        if (!workspace) {
            return undefined;
        }
        if (!this.workspaceService.isMultiRootWorkspaceOpened) {
            return this.folderPreferenceProvider;
        }
        if (this._delegate instanceof workspace_file_preference_provider_1.WorkspaceFilePreferenceProvider && this._delegate.getConfigUri().isEqual(workspace.resource)) {
            return this._delegate;
        }
        return this.workspaceFileProviderFactory({
            workspaceUri: workspace.resource
        });
    }
    get(preferenceName, resourceUri = this.ensureResourceUri()) {
        const delegate = this.delegate;
        return delegate ? delegate.get(preferenceName, resourceUri) : undefined;
    }
    resolve(preferenceName, resourceUri = this.ensureResourceUri()) {
        const delegate = this.delegate;
        return delegate ? delegate.resolve(preferenceName, resourceUri) : {};
    }
    getPreferences(resourceUri = this.ensureResourceUri()) {
        const delegate = this.delegate;
        return delegate ? delegate.getPreferences(resourceUri) : {};
    }
    async setPreference(preferenceName, value, resourceUri = this.ensureResourceUri()) {
        const delegate = this.delegate;
        if (delegate) {
            return delegate.setPreference(preferenceName, value, resourceUri);
        }
        return false;
    }
    ensureResourceUri() {
        if (this.workspaceService.workspace && !this.workspaceService.isMultiRootWorkspaceOpened) {
            return this.workspaceService.workspace.resource.toString();
        }
        return undefined;
    }
};
__decorate([
    inversify_1.inject(workspace_service_1.WorkspaceService),
    __metadata("design:type", workspace_service_1.WorkspaceService)
], WorkspacePreferenceProvider.prototype, "workspaceService", void 0);
__decorate([
    inversify_1.inject(workspace_file_preference_provider_1.WorkspaceFilePreferenceProviderFactory),
    __metadata("design:type", Function)
], WorkspacePreferenceProvider.prototype, "workspaceFileProviderFactory", void 0);
__decorate([
    inversify_1.inject(preferences_1.PreferenceProvider),
    inversify_1.named(preferences_1.PreferenceScope.Folder),
    __metadata("design:type", preferences_1.PreferenceProvider)
], WorkspacePreferenceProvider.prototype, "folderPreferenceProvider", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], WorkspacePreferenceProvider.prototype, "init", null);
WorkspacePreferenceProvider = __decorate([
    inversify_1.injectable()
], WorkspacePreferenceProvider);
exports.WorkspacePreferenceProvider = WorkspacePreferenceProvider;


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_preferences_lib_browser_preferences-contribution_js.bundle.js.map