"use strict";
(global["webpackChunkarduino_ide"] = global["webpackChunkarduino_ide"] || []).push([["vendors-node_modules_theia_plugin-ext_lib_common_connection_js-node_modules_theia_plugin-ext_-a7fdb5"],{

/***/ "./node_modules/@theia/plugin-ext/lib/common/connection.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@theia/plugin-ext/lib/common/connection.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectionImpl = exports.PluginChannel = void 0;
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "./node_modules/@theia/core/lib/common/event.js");
/**
 * A channel communicating with a counterpart in a plugin host.
 */
class PluginChannel {
    constructor(id, connection) {
        this.id = id;
        this.connection = connection;
        this.messageEmitter = new event_1.Emitter();
        this.errorEmitter = new event_1.Emitter();
        this.closedEmitter = new event_1.Emitter();
    }
    send(content) {
        this.connection.$sendMessage(this.id, content);
    }
    fireMessageReceived(msg) {
        this.messageEmitter.fire(msg);
    }
    fireError(error) {
        this.errorEmitter.fire(error);
    }
    fireClosed() {
        this.closedEmitter.fire();
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    onMessage(cb) {
        this.messageEmitter.event(cb);
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    onError(cb) {
        this.errorEmitter.event(cb);
    }
    onClose(cb) {
        this.closedEmitter.event(() => cb(-1, 'closed'));
    }
    close() {
        this.connection.$deleteConnection(this.id);
    }
}
exports.PluginChannel = PluginChannel;
class ConnectionImpl {
    constructor(proxy) {
        this.connections = new Map();
        this.proxy = proxy;
    }
    /**
     * Gets the connection between plugin by id and sends string message to it.
     *
     * @param id connection's id
     * @param message incoming message
     */
    async $sendMessage(id, message) {
        if (this.connections.has(id)) {
            this.connections.get(id).fireMessageReceived(message);
        }
        else {
            console.warn(`Received message for unknown connection: ${id}`);
        }
    }
    /**
     * Instantiates a new connection by the given id.
     * @param id the connection id
     */
    async $createConnection(id) {
        console.debug(`Creating plugin connection: ${id}`);
        await this.doEnsureConnection(id);
    }
    /**
     * Deletes a connection.
     * @param id the connection id
     */
    async $deleteConnection(id) {
        console.debug(`Deleting plugin connection: ${id}`);
        const connection = this.connections.get(id);
        if (connection) {
            this.connections.delete(id);
            connection.fireClosed();
        }
    }
    /**
     * Returns existed connection or creates a new one.
     * @param id the connection id
     */
    async ensureConnection(id) {
        console.debug(`Creating local connection: ${id}`);
        const connection = await this.doEnsureConnection(id);
        await this.proxy.$createConnection(id);
        return connection;
    }
    /**
     * Returns existed connection or creates a new one.
     * @param id the connection id
     */
    async doEnsureConnection(id) {
        const connection = this.connections.get(id) || await this.doCreateConnection(id);
        this.connections.set(id, connection);
        return connection;
    }
    async doCreateConnection(id) {
        const channel = new PluginChannel(id, this.proxy);
        channel.onClose(() => this.connections.delete(id));
        return channel;
    }
}
exports.ConnectionImpl = ConnectionImpl;


/***/ }),

/***/ "./node_modules/@theia/plugin-ext/lib/common/editor-options.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@theia/plugin-ext/lib/common/editor-options.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.cursorStyleToString = exports.TextEditorCursorStyle = void 0;
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// enum copied from monaco.d.ts
/**
 * The style in which the editor's cursor should be rendered.
 */
var TextEditorCursorStyle;
(function (TextEditorCursorStyle) {
    /**
     * As a vertical line
     */
    TextEditorCursorStyle[TextEditorCursorStyle["Line"] = 1] = "Line";
    /**
     * As a block
     */
    TextEditorCursorStyle[TextEditorCursorStyle["Block"] = 2] = "Block";
    /**
     * As a horizontal line, under character
     */
    TextEditorCursorStyle[TextEditorCursorStyle["Underline"] = 3] = "Underline";
    /**
     * As a thin vertical line
     */
    TextEditorCursorStyle[TextEditorCursorStyle["LineThin"] = 4] = "LineThin";
    /**
     * As an outlined block, on top of a character
     */
    TextEditorCursorStyle[TextEditorCursorStyle["BlockOutline"] = 5] = "BlockOutline";
    /**
     * As a thin horizontal line, under a character
     */
    TextEditorCursorStyle[TextEditorCursorStyle["UnderlineThin"] = 6] = "UnderlineThin";
})(TextEditorCursorStyle = exports.TextEditorCursorStyle || (exports.TextEditorCursorStyle = {}));
function cursorStyleToString(cursorStyle) {
    switch (cursorStyle) {
        case TextEditorCursorStyle.Line:
            return 'line';
        case TextEditorCursorStyle.Block:
            return 'block';
        case TextEditorCursorStyle.Underline:
            return 'underline';
        case TextEditorCursorStyle.LineThin:
            return 'line-thin';
        case TextEditorCursorStyle.BlockOutline:
            return 'block-outline';
        case TextEditorCursorStyle.UnderlineThin:
            return 'underline-thin';
        default:
            throw new Error('cursorStyleToString: Unknown cursorStyle');
    }
}
exports.cursorStyleToString = cursorStyleToString;


/***/ }),

/***/ "./node_modules/@theia/plugin-ext/lib/common/object-identifier.js":
/*!************************************************************************!*\
  !*** ./node_modules/@theia/plugin-ext/lib/common/object-identifier.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ObjectIdentifier = void 0;
var ObjectIdentifier;
(function (ObjectIdentifier) {
    ObjectIdentifier.name = '$ident';
    function mixin(obj, id) {
        Object.defineProperty(obj, ObjectIdentifier.name, { value: id, enumerable: true });
        return obj;
    }
    ObjectIdentifier.mixin = mixin;
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    function of(obj) {
        return obj[ObjectIdentifier.name];
    }
    ObjectIdentifier.of = of;
})(ObjectIdentifier = exports.ObjectIdentifier || (exports.ObjectIdentifier = {}));


/***/ }),

/***/ "./node_modules/@theia/plugin-ext/lib/common/semantic-tokens-dto.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@theia/plugin-ext/lib/common/semantic-tokens-dto.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.decodeSemanticTokensDto = exports.encodeSemanticTokensDto = void 0;
// copied and modified from https://github.com/microsoft/vscode/blob/0eb3a02ca2bcfab5faa3dc6e52d7c079efafcab0/src/vs/workbench/api/common/shared/semanticTokensDto.ts
const buffer_1 = __webpack_require__(/*! @theia/core/lib/common/buffer */ "./node_modules/@theia/core/lib/common/buffer.js");
let _isLittleEndian = true;
let _isLittleEndianComputed = false;
function isLittleEndian() {
    if (!_isLittleEndianComputed) {
        _isLittleEndianComputed = true;
        const test = new Uint8Array(2);
        test[0] = 1;
        test[1] = 2;
        const view = new Uint16Array(test.buffer);
        _isLittleEndian = (view[0] === (2 << 8) + 1);
    }
    return _isLittleEndian;
}
function reverseEndianness(arr) {
    for (let i = 0, len = arr.length; i < len; i += 4) {
        // flip bytes 0<->3 and 1<->2
        const b0 = arr[i + 0];
        const b1 = arr[i + 1];
        const b2 = arr[i + 2];
        const b3 = arr[i + 3];
        arr[i + 0] = b3;
        arr[i + 1] = b2;
        arr[i + 2] = b1;
        arr[i + 3] = b0;
    }
}
function toLittleEndianBuffer(arr) {
    const uint8Arr = new Uint8Array(arr.buffer, arr.byteOffset, arr.length * 4);
    if (!isLittleEndian()) {
        // the byte order must be changed
        reverseEndianness(uint8Arr);
    }
    return buffer_1.BinaryBuffer.wrap(uint8Arr);
}
function fromLittleEndianBuffer(buff) {
    const uint8Arr = buff.buffer;
    if (!isLittleEndian()) {
        // the byte order must be changed
        reverseEndianness(uint8Arr);
    }
    if (uint8Arr.byteOffset % 4 === 0) {
        return new Uint32Array(uint8Arr.buffer, uint8Arr.byteOffset, uint8Arr.length / 4);
    }
    else {
        // unaligned memory access doesn't work on all platforms
        const data = new Uint8Array(uint8Arr.byteLength);
        data.set(uint8Arr);
        return new Uint32Array(data.buffer, data.byteOffset, data.length / 4);
    }
}
function encodeSemanticTokensDto(semanticTokens) {
    const dest = new Uint32Array(encodeSemanticTokensDtoSize(semanticTokens));
    let offset = 0;
    dest[offset++] = semanticTokens.id;
    if (semanticTokens.type === 'full') {
        dest[offset++] = 1 /* Full */;
        dest[offset++] = semanticTokens.data.length;
        dest.set(semanticTokens.data, offset);
        offset += semanticTokens.data.length;
    }
    else {
        dest[offset++] = 2 /* Delta */;
        dest[offset++] = semanticTokens.deltas.length;
        for (const delta of semanticTokens.deltas) {
            dest[offset++] = delta.start;
            dest[offset++] = delta.deleteCount;
            if (delta.data) {
                dest[offset++] = delta.data.length;
                dest.set(delta.data, offset);
                offset += delta.data.length;
            }
            else {
                dest[offset++] = 0;
            }
        }
    }
    return toLittleEndianBuffer(dest);
}
exports.encodeSemanticTokensDto = encodeSemanticTokensDto;
function encodeSemanticTokensDtoSize(semanticTokens) {
    let result = 0;
    result += (+1 // id
        + 1 // type
    );
    if (semanticTokens.type === 'full') {
        result += (+1 // data length
            + semanticTokens.data.length);
    }
    else {
        result += (+1 // delta count
        );
        result += (+1 // start
            + 1 // deleteCount
            + 1 // data length
        ) * semanticTokens.deltas.length;
        for (const delta of semanticTokens.deltas) {
            if (delta.data) {
                result += delta.data.length;
            }
        }
    }
    return result;
}
function decodeSemanticTokensDto(_buff) {
    const src = fromLittleEndianBuffer(_buff);
    let offset = 0;
    const id = src[offset++];
    const type = src[offset++];
    if (type === 1 /* Full */) {
        const length = src[offset++];
        const data = src.subarray(offset, offset + length);
        offset += length;
        return {
            id: id,
            type: 'full',
            data: data
        };
    }
    const deltaCount = src[offset++];
    const deltas = [];
    for (let i = 0; i < deltaCount; i++) {
        const start = src[offset++];
        const deleteCount = src[offset++];
        const length = src[offset++];
        let data;
        if (length > 0) {
            data = src.subarray(offset, offset + length);
            offset += length;
        }
        deltas[i] = { start, deleteCount, data };
    }
    return {
        id: id,
        type: 'delta',
        deltas: deltas
    };
}
exports.decodeSemanticTokensDto = decodeSemanticTokensDto;


/***/ }),

/***/ "./node_modules/@theia/plugin-ext/lib/plugin/quick-open.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@theia/plugin-ext/lib/plugin/quick-open.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.QuickPickExt = exports.InputBoxExt = exports.QuickInputExt = exports.QuickOpenExtImpl = exports.getDarkIconUri = exports.getLightIconUri = exports.getIconUris = exports.isPromiseCanceledError = void 0;
/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/* eslint-disable @typescript-eslint/no-explicit-any */
const plugin_api_rpc_1 = __webpack_require__(/*! ../common/plugin-api-rpc */ "./node_modules/@theia/plugin-ext/lib/common/plugin-api-rpc.js");
const cancellation_1 = __webpack_require__(/*! @theia/core/lib/common/cancellation */ "./node_modules/@theia/core/lib/common/cancellation.js");
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "./node_modules/@theia/core/lib/common/event.js");
const disposable_1 = __webpack_require__(/*! @theia/core/lib/common/disposable */ "./node_modules/@theia/core/lib/common/disposable.js");
const types_impl_1 = __webpack_require__(/*! ./types-impl */ "./node_modules/@theia/plugin-ext/lib/plugin/types-impl.js");
const vscode_uri_1 = __webpack_require__(/*! @theia/core/shared/vscode-uri */ "./node_modules/@theia/core/shared/vscode-uri/index.js");
const path = __webpack_require__(/*! path */ "path");
const type_converters_1 = __webpack_require__(/*! ./type-converters */ "./node_modules/@theia/plugin-ext/lib/plugin/type-converters.js");
const plugin_protocol_1 = __webpack_require__(/*! ../common/plugin-protocol */ "./node_modules/@theia/plugin-ext/lib/common/plugin-protocol.js");
const canceledName = 'Canceled';
/**
 * Checks if the given error is a promise in canceled state
 */
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function isPromiseCanceledError(error) {
    return error instanceof Error && error.name === canceledName && error.message === canceledName;
}
exports.isPromiseCanceledError = isPromiseCanceledError;
function getIconUris(iconPath) {
    if (types_impl_1.ThemeIcon.is(iconPath)) {
        return { id: iconPath.id };
    }
    const dark = getDarkIconUri(iconPath);
    const light = getLightIconUri(iconPath);
    // Tolerate strings: https://github.com/microsoft/vscode/issues/110432#issuecomment-726144556
    return {
        dark: typeof dark === 'string' ? vscode_uri_1.URI.file(dark) : dark,
        light: typeof light === 'string' ? vscode_uri_1.URI.file(light) : light
    };
}
exports.getIconUris = getIconUris;
function getLightIconUri(iconPath) {
    return typeof iconPath === 'object' && 'light' in iconPath ? iconPath.light : iconPath;
}
exports.getLightIconUri = getLightIconUri;
function getDarkIconUri(iconPath) {
    return typeof iconPath === 'object' && 'dark' in iconPath ? iconPath.dark : iconPath;
}
exports.getDarkIconUri = getDarkIconUri;
class QuickOpenExtImpl {
    constructor(rpc) {
        this._sessions = new Map(); // Each quickinput will have a number so that we know where to fire events
        this._instances = 0;
        this.proxy = rpc.getProxy(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.QUICK_OPEN_MAIN);
    }
    showQuickPick(itemsOrItemsPromise, options, token = cancellation_1.CancellationToken.None) {
        this.onDidSelectItem = undefined;
        const itemsPromise = Promise.resolve(itemsOrItemsPromise);
        const instance = ++this._instances;
        const widgetPromise = this.proxy.$show(instance, {
            canPickMany: options && options.canPickMany,
            placeHolder: options && options.placeHolder,
            matchOnDescription: options && options.matchOnDescription,
            matchOnDetail: options && options.matchOnDetail,
            ignoreFocusLost: options && options.ignoreFocusOut
        }, token);
        const widgetClosedMarker = {};
        const widgetClosedPromise = widgetPromise.then(() => widgetClosedMarker);
        return Promise.race([widgetClosedPromise, itemsPromise]).then(result => {
            if (result === widgetClosedMarker) {
                return undefined;
            }
            return itemsPromise.then(async (items) => {
                const pickItems = type_converters_1.convertToTransferQuickPickItems(items);
                if (options && typeof options.onDidSelectItem === 'function') {
                    this.onDidSelectItem = handle => {
                        options.onDidSelectItem(items[handle]);
                    };
                }
                this.proxy.$setItems(instance, pickItems);
                return widgetPromise.then(handle => {
                    if (typeof handle === 'number') {
                        if (options && options.canPickMany) {
                            return Array.of(items[handle]);
                        }
                        else {
                            return items[handle];
                        }
                    }
                    else if (Array.isArray(handle)) {
                        return handle.map(h => items[h]);
                    }
                    return undefined;
                });
            });
        }).then(undefined, err => {
            if (isPromiseCanceledError(err)) {
                return undefined;
            }
            this.proxy.$setError(instance, err);
            return Promise.reject(err);
        });
    }
    $onItemSelected(handle) {
        if (this.onDidSelectItem) {
            this.onDidSelectItem(handle);
        }
    }
    // ---- input
    showInput(options, token = cancellation_1.CancellationToken.None) {
        this.validateInputHandler = options === null || options === void 0 ? void 0 : options.validateInput;
        if (!options) {
            options = { placeHolder: '' };
        }
        return this.proxy.$input(options, typeof this.validateInputHandler === 'function', token);
    }
    async showInputBox(options) {
        this.validateInputHandler = typeof options.validateInput === 'function' ? options.validateInput : undefined;
        return this.proxy.$showInputBox(options, typeof this.validateInputHandler === 'function');
    }
    $validateInput(input) {
        if (this.validateInputHandler) {
            return Promise.resolve(this.validateInputHandler(input));
        }
        return undefined;
    }
    // ---- QuickInput
    createQuickPick(plugin) {
        const session = new QuickPickExt(this, this.proxy, plugin, () => this._sessions.delete(session._id));
        this._sessions.set(session._id, session);
        return session;
    }
    createInputBox(plugin) {
        const session = new InputBoxExt(this, this.proxy, plugin, () => this._sessions.delete(session._id));
        this._sessions.set(session._id, session);
        return session;
    }
    hide() {
        this.proxy.$hide();
    }
    async $acceptOnDidAccept(sessionId) {
        const session = this._sessions.get(sessionId);
        if (session) {
            session._fireAccept();
        }
    }
    async $acceptDidChangeValue(sessionId, changedValue) {
        const session = this._sessions.get(sessionId);
        if (session) {
            session._fireChangedValue(changedValue);
        }
    }
    async $acceptOnDidHide(sessionId) {
        const session = this._sessions.get(sessionId);
        if (session) {
            session._fireHide();
        }
    }
    async $acceptOnDidTriggerButton(sessionId, btn) {
        const session = this._sessions.get(sessionId);
        if (session) {
            if (btn.index === -1) {
                session._fireButtonTrigger(types_impl_1.QuickInputButtons.Back);
            }
            else if (session && (session instanceof InputBoxExt || session instanceof QuickPickExt)) {
                const btnFromIndex = session.buttons[btn.index];
                session._fireButtonTrigger(btnFromIndex);
            }
        }
    }
    $onDidChangeActive(sessionId, handles) {
        const session = this._sessions.get(sessionId);
        if (session instanceof QuickPickExt) {
            session._fireDidChangeActive(handles);
        }
    }
    $onDidChangeSelection(sessionId, handles) {
        const session = this._sessions.get(sessionId);
        if (session instanceof QuickPickExt) {
            session._fireDidChangeSelection(handles);
        }
    }
}
exports.QuickOpenExtImpl = QuickOpenExtImpl;
class QuickInputExt {
    constructor(quickOpen, quickOpenMain, plugin, _onDidDispose) {
        this.quickOpen = quickOpen;
        this.quickOpenMain = quickOpenMain;
        this.plugin = plugin;
        this._onDidDispose = _onDidDispose;
        this._id = QuickInputExt._nextId++;
        this._buttons = [];
        this._handlesToButtons = new Map();
        this.expectingHide = false;
        this._disposed = false;
        this._pendingUpdate = { id: this._id };
        this.title = undefined;
        this.step = undefined;
        this.totalSteps = undefined;
        this.enabled = true;
        this.busy = false;
        this.ignoreFocusOut = false;
        this.value = '';
        this.visible = false;
        this.disposableCollection = new disposable_1.DisposableCollection();
        this.disposableCollection.push(this.onDidAcceptEmitter = new event_1.Emitter());
        this.disposableCollection.push(this._onDidChangeValueEmitter = new event_1.Emitter());
        this.disposableCollection.push(this.onDidHideEmitter = new event_1.Emitter());
        this.disposableCollection.push(this.onDidTriggerButtonEmitter = new event_1.Emitter());
    }
    get title() {
        return this._title;
    }
    set title(title) {
        this._title = title;
        this.update({ title });
    }
    get step() {
        return this._step;
    }
    set step(step) {
        this._step = step;
        this.update({ step });
    }
    get totalSteps() {
        return this._totalSteps;
    }
    set totalSteps(totalSteps) {
        this._totalSteps = totalSteps;
        this.update({ totalSteps });
    }
    get enabled() {
        return this._enabled;
    }
    set enabled(enabled) {
        this._enabled = enabled;
        this.update({ enabled });
    }
    get busy() {
        return this._busy;
    }
    set busy(busy) {
        this._busy = busy;
        this.update({ busy });
    }
    get ignoreFocusOut() {
        return this._ignoreFocusOut;
    }
    set ignoreFocusOut(ignoreFocusOut) {
        this._ignoreFocusOut = ignoreFocusOut;
        this.update({ ignoreFocusOut });
    }
    get value() {
        return this._value;
    }
    set value(value) {
        this._value = value;
        this.update({ value });
    }
    get placeholder() {
        return this._placeholder;
    }
    set placeholder(placeholder) {
        this._placeholder = placeholder;
        this.update({ placeholder });
    }
    get buttons() {
        return this._buttons;
    }
    set buttons(buttons) {
        this._buttons = buttons.slice();
        this._handlesToButtons.clear();
        buttons.forEach((button, i) => {
            const handle = button === types_impl_1.QuickInputButtons.Back ? -1 : i;
            this._handlesToButtons.set(handle, button);
        });
        this.update({
            buttons: buttons.map((button, i) => ({
                iconPath: getIconUris(button.iconPath),
                tooltip: button.tooltip,
                handle: button === types_impl_1.QuickInputButtons.Back ? -1 : i,
            }))
        });
    }
    show() {
        this.visible = true;
        this.expectingHide = true;
        this.update({ visible: true });
    }
    dispose() {
        if (this._disposed) {
            return;
        }
        this._disposed = true;
        this._fireHide();
        this.disposableCollection.dispose();
        this._onDidDispose();
        this.quickOpenMain.$dispose(this._id);
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    update(properties) {
        if (this._disposed) {
            return;
        }
        for (const key of Object.keys(properties)) {
            const value = properties[key];
            this._pendingUpdate[key] = value === undefined ? null : value;
        }
        if ('visible' in this._pendingUpdate) {
            if (this._updateTimeout) {
                clearTimeout(this._updateTimeout);
                this._updateTimeout = undefined;
            }
            this.dispatchUpdate();
        }
        else if (this.visible && !this._updateTimeout) {
            // Defer the update so that multiple changes to setters dont cause a redraw each
            this._updateTimeout = setTimeout(() => {
                this._updateTimeout = undefined;
                this.dispatchUpdate();
            }, 0);
        }
    }
    dispatchUpdate() {
        this.quickOpenMain.$createOrUpdate(this._pendingUpdate);
        this._pendingUpdate = { id: this._id };
    }
    hide() {
        this.quickOpenMain.$hide();
        this.dispose();
    }
    convertURL(iconPath) {
        const toUrl = (arg) => {
            arg = arg instanceof monaco.Uri && arg.scheme === 'file' ? arg.fsPath : arg;
            if (typeof arg !== 'string') {
                return arg.toString(true);
            }
            const { packagePath } = this.plugin.rawModel;
            const absolutePath = path.isAbsolute(arg) ? arg : path.join(packagePath, arg);
            const normalizedPath = path.normalize(absolutePath);
            const relativePath = path.relative(packagePath, normalizedPath);
            return plugin_protocol_1.PluginPackage.toPluginUrl(this.plugin.rawModel, relativePath);
        };
        if (types_impl_1.ThemeIcon.is(iconPath)) {
            return iconPath;
        }
        else if (typeof iconPath === 'string' || iconPath instanceof monaco.Uri) {
            return vscode_uri_1.URI.parse(toUrl(iconPath));
        }
        else {
            const { light, dark } = iconPath;
            return {
                light: toUrl(light),
                dark: toUrl(dark)
            };
        }
    }
    _fireAccept() {
        this.onDidAcceptEmitter.fire(undefined);
    }
    _fireChangedValue(changedValue) {
        this._onDidChangeValueEmitter.fire(changedValue);
    }
    _fireHide() {
        if (this.expectingHide) {
            this.expectingHide = false;
            this.onDidHideEmitter.fire(undefined);
        }
    }
    _fireButtonTrigger(btn) {
        this.onDidTriggerButtonEmitter.fire(btn);
    }
    get onDidHide() {
        return this.onDidHideEmitter.event;
    }
    get onDidAccept() {
        return this.onDidAcceptEmitter.event;
    }
    get onDidChangeValue() {
        return this._onDidChangeValueEmitter.event;
    }
    get onDidTriggerButton() {
        return this.onDidTriggerButtonEmitter.event;
    }
}
exports.QuickInputExt = QuickInputExt;
QuickInputExt._nextId = 1;
/**
 * Base implementation of {@link InputBox} that uses {@link QuickOpenExt}.
 * Missing functionality is going to be implemented in the scope of https://github.com/eclipse-theia/theia/issues/5109
 */
class InputBoxExt extends QuickInputExt {
    constructor(quickOpen, quickOpenMain, plugin, onDispose) {
        super(quickOpen, quickOpenMain, plugin, onDispose);
        this.quickOpen = quickOpen;
        this.quickOpenMain = quickOpenMain;
        this.plugin = plugin;
        this.buttons = [];
        this.password = false;
        this.value = '';
    }
    get password() {
        return this._password;
    }
    set password(password) {
        this._password = password;
        this.update({ password });
    }
    get prompt() {
        return this._prompt;
    }
    set prompt(prompt) {
        this._prompt = prompt;
        this.update({ prompt });
    }
    get validationMessage() {
        return this._validationMessage;
    }
    set validationMessage(validationMessage) {
        if (this._validationMessage !== validationMessage) {
            this._validationMessage = validationMessage;
            this.update({ validationMessage });
        }
    }
    async show() {
        super.show();
        const update = (value) => {
            this.value = value;
            if (this.validationMessage && this.validationMessage.length > 0) {
                return this.validationMessage;
            }
        };
        this.quickOpen.showInputBox({
            id: this._id,
            busy: this.busy,
            buttons: this.buttons,
            enabled: this.enabled,
            ignoreFocusOut: this.ignoreFocusOut,
            password: this.password,
            placeholder: this.placeholder,
            prompt: this.prompt,
            step: this.step,
            title: this.title,
            totalSteps: this.totalSteps,
            validationMessage: this.validationMessage,
            value: this.value,
            visible: this.visible,
            validateInput(value) {
                if (value.length > 0) {
                    return update(value);
                }
            }
        });
    }
}
exports.InputBoxExt = InputBoxExt;
/**
 * Base implementation of {@link QuickPick} that uses {@link QuickOpenExt}.
 * Missing functionality is going to be implemented in the scope of https://github.com/eclipse-theia/theia/issues/5059
 */
class QuickPickExt extends QuickInputExt {
    constructor(quickOpen, quickOpenMain, plugin, onDispose) {
        super(quickOpen, quickOpenMain, plugin, onDispose);
        this.quickOpen = quickOpen;
        this.quickOpenMain = quickOpenMain;
        this.plugin = plugin;
        this._items = [];
        this._handlesToItems = new Map();
        this._itemsToHandles = new Map();
        this._canSelectMany = false;
        this._matchOnDescription = true;
        this._matchOnDetail = true;
        this._sortByLabel = true;
        this._activeItems = [];
        this._selectedItems = [];
        this._onDidChangeActiveEmitter = new event_1.Emitter();
        this._onDidChangeSelectionEmitter = new event_1.Emitter();
        this.onDidChangeActive = this._onDidChangeActiveEmitter.event;
        this.onDidChangeSelection = this._onDidChangeSelectionEmitter.event;
        this.buttons = [];
        this.disposableCollection.push(this._onDidChangeActiveEmitter);
        this.disposableCollection.push(this._onDidChangeSelectionEmitter);
        this.update({ type: 'quickPick' });
    }
    get items() {
        return this._items;
    }
    set items(items) {
        this._items = items.slice();
        this._handlesToItems.clear();
        this._itemsToHandles.clear();
        items.forEach((item, i) => {
            this._handlesToItems.set(i, item);
            this._itemsToHandles.set(item, i);
        });
        this.update({
            items: items.map((item, i) => ({
                type: item.type,
                label: item.label,
                description: item.description,
                handle: i,
                detail: item.detail,
                picked: item.picked,
                alwaysShow: item.alwaysShow
            }))
        });
    }
    get canSelectMany() {
        return this._canSelectMany;
    }
    set canSelectMany(canSelectMany) {
        this._canSelectMany = canSelectMany;
        this.update({ canSelectMany });
    }
    get matchOnDescription() {
        return this._matchOnDescription;
    }
    set matchOnDescription(matchOnDescription) {
        this._matchOnDescription = matchOnDescription;
        this.update({ matchOnDescription });
    }
    get matchOnDetail() {
        return this._matchOnDetail;
    }
    set matchOnDetail(matchOnDetail) {
        this._matchOnDetail = matchOnDetail;
        this.update({ matchOnDetail });
    }
    get sortByLabel() {
        return this._sortByLabel;
    }
    set sortByLabel(sortByLabel) {
        this._sortByLabel = sortByLabel;
        this.update({ sortByLabel });
    }
    get activeItems() {
        return this._activeItems;
    }
    set activeItems(activeItems) {
        this._activeItems = activeItems.filter(item => this._itemsToHandles.has(item));
        this.update({ activeItems: this._activeItems.map(item => this._itemsToHandles.get(item)) });
    }
    get selectedItems() {
        return this._selectedItems;
    }
    set selectedItems(selectedItems) {
        this._selectedItems = selectedItems.filter(item => this._itemsToHandles.has(item));
        this.update({ selectedItems: this._selectedItems.map(item => this._itemsToHandles.get(item)) });
    }
    _fireDidChangeActive(handles) {
        const items = handles.map(handle => this._handlesToItems.get(handle)).filter(e => !!e);
        this._activeItems = items;
        this._onDidChangeActiveEmitter.fire(items);
    }
    _fireDidChangeSelection(handles) {
        const items = handles.map(handle => this._handlesToItems.get(handle)).filter(e => !!e);
        this._selectedItems = items;
        this._onDidChangeSelectionEmitter.fire(items);
    }
}
exports.QuickPickExt = QuickPickExt;


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_plugin-ext_lib_common_connection_js-node_modules_theia_plugin-ext_-a7fdb5.bundle.js.map