(global["webpackChunkarduino_ide"] = global["webpackChunkarduino_ide"] || []).push([["vendors-node_modules_theia_monaco_lib_browser_monaco-workspace_js"],{

/***/ "./node_modules/@theia/core/shared/@phosphor/domutils/index.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@theia/core/shared/@phosphor/domutils/index.js ***!
  \*********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! @phosphor/domutils */ "./node_modules/@phosphor/domutils/lib/index.js");


/***/ }),

/***/ "./node_modules/@theia/markers/lib/browser/index.js":
/*!**********************************************************!*\
  !*** ./node_modules/@theia/markers/lib/browser/index.js ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./marker-manager */ "./node_modules/@theia/markers/lib/browser/marker-manager.js"), exports);
__exportStar(__webpack_require__(/*! ./problem/problem-manager */ "./node_modules/@theia/markers/lib/browser/problem/problem-manager.js"), exports);


/***/ }),

/***/ "./node_modules/@theia/monaco/lib/browser/monaco-editor.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@theia/monaco/lib/browser/monaco-editor.js ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MonacoEditor = exports.MonacoEditorServices = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const domutils_1 = __webpack_require__(/*! @theia/core/shared/@phosphor/domutils */ "./node_modules/@theia/core/shared/@phosphor/domutils/index.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "./node_modules/@theia/core/lib/browser/context-key-service.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "./node_modules/@theia/core/lib/common/index.js");
const monaco_to_protocol_converter_1 = __webpack_require__(/*! ./monaco-to-protocol-converter */ "./node_modules/@theia/monaco/lib/browser/monaco-to-protocol-converter.js");
const protocol_to_monaco_converter_1 = __webpack_require__(/*! ./protocol-to-monaco-converter */ "./node_modules/@theia/monaco/lib/browser/protocol-to-monaco-converter.js");
const encodings_1 = __webpack_require__(/*! @theia/core/lib/common/encodings */ "./node_modules/@theia/core/lib/common/encodings.js");
let MonacoEditorServices = class MonacoEditorServices {
    constructor(services) {
        Object.assign(this, services);
    }
};
__decorate([
    inversify_1.inject(monaco_to_protocol_converter_1.MonacoToProtocolConverter),
    __metadata("design:type", monaco_to_protocol_converter_1.MonacoToProtocolConverter)
], MonacoEditorServices.prototype, "m2p", void 0);
__decorate([
    inversify_1.inject(protocol_to_monaco_converter_1.ProtocolToMonacoConverter),
    __metadata("design:type", protocol_to_monaco_converter_1.ProtocolToMonacoConverter)
], MonacoEditorServices.prototype, "p2m", void 0);
__decorate([
    inversify_1.inject(context_key_service_1.ContextKeyService),
    __metadata("design:type", Object)
], MonacoEditorServices.prototype, "contextKeyService", void 0);
MonacoEditorServices = __decorate([
    inversify_1.injectable(),
    __param(0, inversify_1.unmanaged()),
    __metadata("design:paramtypes", [MonacoEditorServices])
], MonacoEditorServices);
exports.MonacoEditorServices = MonacoEditorServices;
class MonacoEditor extends MonacoEditorServices {
    constructor(uri, document, node, services, options, override) {
        super(services);
        this.uri = uri;
        this.document = document;
        this.node = node;
        this.toDispose = new common_1.DisposableCollection();
        this.onCursorPositionChangedEmitter = new common_1.Emitter();
        this.onSelectionChangedEmitter = new common_1.Emitter();
        this.onFocusChangedEmitter = new common_1.Emitter();
        this.onDocumentContentChangedEmitter = new common_1.Emitter();
        this.onMouseDownEmitter = new common_1.Emitter();
        this.onLanguageChangedEmitter = new common_1.Emitter();
        this.onLanguageChanged = this.onLanguageChangedEmitter.event;
        this.onScrollChangedEmitter = new common_1.Emitter();
        this.onEncodingChanged = this.document.onDidChangeEncoding;
        // eslint-disable-next-line no-null/no-null
        this.onResizeEmitter = new common_1.Emitter();
        this.onDidResize = this.onResizeEmitter.event;
        this.documents = new Set();
        /* `true` because it is derived from an URI during the instantiation */
        this._languageAutoDetected = true;
        this.toDispose.pushAll([
            this.onCursorPositionChangedEmitter,
            this.onSelectionChangedEmitter,
            this.onFocusChangedEmitter,
            this.onDocumentContentChangedEmitter,
            this.onMouseDownEmitter,
            this.onLanguageChangedEmitter,
            this.onScrollChangedEmitter
        ]);
        this.documents.add(document);
        this.autoSizing = options && options.autoSizing !== undefined ? options.autoSizing : false;
        this.minHeight = options && options.minHeight !== undefined ? options.minHeight : -1;
        this.maxHeight = options && options.maxHeight !== undefined ? options.maxHeight : -1;
        this.toDispose.push(this.create(options, override));
        this.addHandlers(this.editor);
    }
    getEncoding() {
        return this.document.getEncoding() || encodings_1.UTF8;
    }
    setEncoding(encoding, mode) {
        return this.document.setEncoding(encoding, mode);
    }
    create(options, override) {
        return this.editor = monaco.editor.create(this.node, Object.assign(Object.assign({}, options), { lightbulb: { enabled: true }, fixedOverflowWidgets: true, scrollbar: {
                useShadows: false,
                verticalHasArrows: false,
                horizontalHasArrows: false,
                verticalScrollbarSize: 10,
                horizontalScrollbarSize: 10
            } }), override);
    }
    addHandlers(codeEditor) {
        this.toDispose.push(codeEditor.onDidChangeModelLanguage(e => this.fireLanguageChanged(e.newLanguage)));
        this.toDispose.push(codeEditor.onDidChangeConfiguration(() => this.refresh()));
        this.toDispose.push(codeEditor.onDidChangeModel(() => this.refresh()));
        this.toDispose.push(codeEditor.onDidChangeModelContent(e => {
            this.refresh();
            this.onDocumentContentChangedEmitter.fire({ document: this.document, contentChanges: e.changes.map(this.mapModelContentChange.bind(this)) });
        }));
        this.toDispose.push(codeEditor.onDidChangeCursorPosition(() => this.onCursorPositionChangedEmitter.fire(this.cursor)));
        this.toDispose.push(codeEditor.onDidChangeCursorSelection(() => this.onSelectionChangedEmitter.fire(this.selection)));
        this.toDispose.push(codeEditor.onDidFocusEditorText(() => this.onFocusChangedEmitter.fire(this.isFocused())));
        this.toDispose.push(codeEditor.onDidBlurEditorText(() => this.onFocusChangedEmitter.fire(this.isFocused())));
        this.toDispose.push(codeEditor.onMouseDown(e => {
            const { element, position, range } = e.target;
            this.onMouseDownEmitter.fire({
                target: Object.assign(Object.assign({}, e.target), { element: element || undefined, mouseColumn: this.m2p.asPosition(undefined, e.target.mouseColumn).character, range: range && this.m2p.asRange(range) || undefined, position: position && this.m2p.asPosition(position.lineNumber, position.column) || undefined }),
                event: e.event.browserEvent
            });
        }));
        this.toDispose.push(codeEditor.onDidScrollChange(e => {
            this.onScrollChangedEmitter.fire(undefined);
        }));
    }
    getVisibleRanges() {
        return this.editor.getVisibleRanges().map(range => this.m2p.asRange(range));
    }
    mapModelContentChange(change) {
        return {
            range: this.m2p.asRange(change.range),
            rangeLength: change.rangeLength,
            text: change.text
        };
    }
    get onDispose() {
        return this.toDispose.onDispose;
    }
    get onDocumentContentChanged() {
        return this.onDocumentContentChangedEmitter.event;
    }
    get cursor() {
        const { lineNumber, column } = this.editor.getPosition();
        return this.m2p.asPosition(lineNumber, column);
    }
    set cursor(cursor) {
        const position = this.p2m.asPosition(cursor);
        this.editor.setPosition(position);
    }
    get onCursorPositionChanged() {
        return this.onCursorPositionChangedEmitter.event;
    }
    get selection() {
        return this.m2p.asRange(this.editor.getSelection());
    }
    set selection(selection) {
        const range = this.p2m.asRange(selection);
        this.editor.setSelection(range);
    }
    get onSelectionChanged() {
        return this.onSelectionChangedEmitter.event;
    }
    get onScrollChanged() {
        return this.onScrollChangedEmitter.event;
    }
    revealPosition(raw, options = { vertical: 'center' }) {
        const position = this.p2m.asPosition(raw);
        switch (options.vertical) {
            case 'auto':
                this.editor.revealPosition(position);
                break;
            case 'center':
                this.editor.revealPositionInCenter(position);
                break;
            case 'centerIfOutsideViewport':
                this.editor.revealPositionInCenterIfOutsideViewport(position);
                break;
        }
    }
    revealRange(raw, options = { at: 'center' }) {
        const range = this.p2m.asRange(raw);
        switch (options.at) {
            case 'top':
                this.editor.revealRangeAtTop(range);
                break;
            case 'center':
                this.editor.revealRangeInCenter(range);
                break;
            case 'centerIfOutsideViewport':
                this.editor.revealRangeInCenterIfOutsideViewport(range);
                break;
            case 'auto':
                this.editor.revealRange(range);
                break;
        }
    }
    focus() {
        /**
         * `this.editor.focus` forcefully changes the focus editor state,
         * regardless whether the textarea actually received the focus.
         * It could lead to issues like https://github.com/eclipse-theia/theia/issues/7902
         * Instead we focus the underlying textarea.
         */
        const node = this.editor.getDomNode();
        if (node) {
            const textarea = node.querySelector('textarea');
            textarea.focus();
        }
    }
    blur() {
        const node = this.editor.getDomNode();
        if (node) {
            const textarea = node.querySelector('textarea');
            textarea.blur();
        }
    }
    isFocused({ strict } = { strict: false }) {
        if (!this.editor.hasTextFocus()) {
            return false;
        }
        if (strict) {
            return !this.isSuggestWidgetVisible() && !this.isFindWidgetVisible() && !this.isRenameInputVisible();
        }
        return true;
    }
    get onFocusChanged() {
        return this.onFocusChangedEmitter.event;
    }
    get onMouseDown() {
        return this.onMouseDownEmitter.event;
    }
    /**
     * `true` if the suggest widget is visible in the editor. Otherwise, `false`.
     */
    isSuggestWidgetVisible() {
        return this.contextKeyService.match('suggestWidgetVisible', this.editor.getDomNode() || this.node);
    }
    /**
     * `true` if the find (and replace) widget is visible in the editor. Otherwise, `false`.
     */
    isFindWidgetVisible() {
        return this.contextKeyService.match('findWidgetVisible', this.editor.getDomNode() || this.node);
    }
    /**
     * `true` if the name rename refactoring input HTML element is visible. Otherwise, `false`.
     */
    isRenameInputVisible() {
        return this.contextKeyService.match('renameInputVisible', this.editor.getDomNode() || this.node);
    }
    dispose() {
        this.toDispose.dispose();
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    trigger(source, handlerId, payload) {
        this.editor.trigger(source, handlerId, payload);
    }
    getControl() {
        return this.editor;
    }
    refresh() {
        this.autoresize();
    }
    resizeToFit() {
        this.autoresize();
        // eslint-disable-next-line no-null/no-null
        this.onResizeEmitter.fire(null);
    }
    setSize(dimension) {
        this.resize(dimension);
        this.onResizeEmitter.fire(dimension);
    }
    autoresize() {
        if (this.autoSizing) {
            // eslint-disable-next-line no-null/no-null
            this.resize(null);
        }
    }
    resize(dimension) {
        if (this.node) {
            const layoutSize = this.computeLayoutSize(this.node, dimension);
            this.editor.layout(layoutSize);
        }
    }
    computeLayoutSize(hostNode, dimension) {
        if (dimension && dimension.width >= 0 && dimension.height >= 0) {
            return dimension;
        }
        const boxSizing = domutils_1.ElementExt.boxSizing(hostNode);
        const width = (!dimension || dimension.width < 0) ?
            this.getWidth(hostNode, boxSizing) :
            dimension.width;
        const height = (!dimension || dimension.height < 0) ?
            this.getHeight(hostNode, boxSizing) :
            dimension.height;
        return { width, height };
    }
    getWidth(hostNode, boxSizing) {
        return hostNode.offsetWidth - boxSizing.horizontalSum;
    }
    getHeight(hostNode, boxSizing) {
        if (!this.autoSizing) {
            return hostNode.offsetHeight - boxSizing.verticalSum;
        }
        const lineHeight = this.editor.getOption(monaco.editor.EditorOption.lineHeight);
        const lineCount = this.editor.getModel().getLineCount();
        const contentHeight = lineHeight * lineCount;
        const horizontalScrollbarHeight = this.editor.getLayoutInfo().horizontalScrollbarHeight;
        const editorHeight = contentHeight + horizontalScrollbarHeight;
        if (this.minHeight >= 0) {
            const minHeight = lineHeight * this.minHeight + horizontalScrollbarHeight;
            if (editorHeight < minHeight) {
                return minHeight;
            }
        }
        if (this.maxHeight >= 0) {
            const maxHeight = lineHeight * this.maxHeight + horizontalScrollbarHeight;
            return Math.min(maxHeight, editorHeight);
        }
        return editorHeight;
    }
    isActionSupported(id) {
        const action = this.editor.getAction(id);
        return !!action && action.isSupported();
    }
    async runAction(id) {
        const action = this.editor.getAction(id);
        if (action && action.isSupported()) {
            await action.run();
        }
    }
    get commandService() {
        return this.editor._commandService;
    }
    get instantiationService() {
        return this.editor._instantiationService;
    }
    deltaDecorations(params) {
        const oldDecorations = params.oldDecorations;
        const newDecorations = this.toDeltaDecorations(params);
        return this.editor.deltaDecorations(oldDecorations, newDecorations);
    }
    toDeltaDecorations(params) {
        return params.newDecorations.map(decoration => (Object.assign(Object.assign({}, decoration), { range: this.p2m.asRange(decoration.range) })));
    }
    getLinesDecorations(startLineNumber, endLineNumber) {
        const toPosition = (line) => this.p2m.asPosition({ line, character: 0 });
        const start = toPosition(startLineNumber).lineNumber;
        const end = toPosition(endLineNumber).lineNumber;
        return this.editor
            .getModel()
            .getLinesDecorations(start, end)
            .map(this.toEditorDecoration.bind(this));
    }
    toEditorDecoration(decoration) {
        const range = this.m2p.asRange(decoration.range);
        const { id, options } = decoration;
        return {
            options,
            range,
            id
        };
    }
    getVisibleColumn(position) {
        return this.editor.getVisibleColumnFromPosition(this.p2m.asPosition(position));
    }
    async replaceText(params) {
        const edits = params.replaceOperations.map(param => {
            const range = monaco.Range.fromPositions(this.p2m.asPosition(param.range.start), this.p2m.asPosition(param.range.end));
            return {
                forceMoveMarkers: true,
                identifier: {
                    major: range.startLineNumber,
                    minor: range.startColumn
                },
                range,
                text: param.text
            };
        });
        return this.editor.executeEdits(params.source, edits);
    }
    executeEdits(edits) {
        return this.editor.executeEdits('MonacoEditor', this.p2m.asTextEdits(edits));
    }
    storeViewState() {
        return this.editor.saveViewState();
    }
    restoreViewState(state) {
        this.editor.restoreViewState(state);
    }
    get languageAutoDetected() {
        return this._languageAutoDetected;
    }
    async detectLanguage() {
        const modeService = monaco.services.StaticServices.modeService.get();
        const firstLine = this.document.textEditorModel.getLineContent(1);
        const model = this.getControl().getModel();
        const language = modeService.createByFilepathOrFirstLine(model && model.uri, firstLine);
        this.setLanguage(language.languageIdentifier.language);
        this._languageAutoDetected = true;
    }
    setLanguage(languageId) {
        for (const document of this.documents) {
            monaco.editor.setModelLanguage(document.textEditorModel, languageId);
        }
    }
    fireLanguageChanged(languageId) {
        this._languageAutoDetected = false;
        this.onLanguageChangedEmitter.fire(languageId);
    }
    getResourceUri() {
        return this.uri;
    }
    createMoveToUri(resourceUri) {
        return this.uri.withPath(resourceUri.path);
    }
}
exports.MonacoEditor = MonacoEditor;
(function (MonacoEditor) {
    function getAll(manager) {
        return manager.all.map(e => get(e)).filter(e => !!e);
    }
    MonacoEditor.getAll = getAll;
    function getCurrent(manager) {
        return get(manager.currentEditor);
    }
    MonacoEditor.getCurrent = getCurrent;
    function getActive(manager) {
        return get(manager.activeEditor);
    }
    MonacoEditor.getActive = getActive;
    function get(editorWidget) {
        if (editorWidget && editorWidget.editor instanceof MonacoEditor) {
            return editorWidget.editor;
        }
        return undefined;
    }
    MonacoEditor.get = get;
    function findByDocument(manager, document) {
        return getAll(manager).filter(editor => editor.documents.has(document));
    }
    MonacoEditor.findByDocument = findByDocument;
    function getWidgetFor(manager, control) {
        if (!control) {
            return undefined;
        }
        return manager.all.find(widget => {
            const editor = get(widget);
            return !!editor && editor.getControl() === control;
        });
    }
    MonacoEditor.getWidgetFor = getWidgetFor;
})(MonacoEditor = exports.MonacoEditor || (exports.MonacoEditor = {}));


/***/ }),

/***/ "./node_modules/@theia/monaco/lib/browser/monaco-workspace.js":
/*!********************************************************************!*\
  !*** ./node_modules/@theia/monaco/lib/browser/monaco-workspace.js ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MonacoWorkspace = exports.ResourceTextEdit = exports.ResourceFileEdit = exports.WorkspaceTextEdit = exports.WorkspaceFileEdit = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "./node_modules/@theia/core/lib/common/uri.js");
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "./node_modules/@theia/core/lib/common/event.js");
const browser_1 = __webpack_require__(/*! @theia/filesystem/lib/browser */ "./node_modules/@theia/filesystem/lib/browser/index.js");
const browser_2 = __webpack_require__(/*! @theia/editor/lib/browser */ "./node_modules/@theia/editor/lib/browser/index.js");
const monaco_text_model_service_1 = __webpack_require__(/*! ./monaco-text-model-service */ "./node_modules/@theia/monaco/lib/browser/monaco-text-model-service.js");
const monaco_editor_1 = __webpack_require__(/*! ./monaco-editor */ "./node_modules/@theia/monaco/lib/browser/monaco-editor.js");
const browser_3 = __webpack_require__(/*! @theia/markers/lib/browser */ "./node_modules/@theia/markers/lib/browser/index.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "./node_modules/@theia/filesystem/lib/browser/file-service.js");
var WorkspaceFileEdit;
(function (WorkspaceFileEdit) {
    function is(arg) {
        return ('oldUri' in arg && monaco.Uri.isUri(arg.oldUri)) ||
            ('newUri' in arg && monaco.Uri.isUri(arg.newUri));
    }
    WorkspaceFileEdit.is = is;
})(WorkspaceFileEdit = exports.WorkspaceFileEdit || (exports.WorkspaceFileEdit = {}));
var WorkspaceTextEdit;
(function (WorkspaceTextEdit) {
    function is(arg) {
        return !!arg && typeof arg === 'object'
            && 'resource' in arg
            && monaco.Uri.isUri(arg.resource)
            && 'edit' in arg
            && arg.edit !== null
            && typeof arg.edit === 'object';
    }
    WorkspaceTextEdit.is = is;
})(WorkspaceTextEdit = exports.WorkspaceTextEdit || (exports.WorkspaceTextEdit = {}));
var ResourceFileEdit;
(function (ResourceFileEdit) {
    function is(arg) {
        return typeof arg === 'object' && (('oldResource' in arg) && monaco.Uri.isUri(arg.oldResource)) ||
            ('newResource' in arg && monaco.Uri.isUri(arg.newResource));
    }
    ResourceFileEdit.is = is;
})(ResourceFileEdit = exports.ResourceFileEdit || (exports.ResourceFileEdit = {}));
var ResourceTextEdit;
(function (ResourceTextEdit) {
    function is(arg) {
        return ('resource' in arg && monaco.Uri.isUri(arg.resource));
    }
    ResourceTextEdit.is = is;
})(ResourceTextEdit = exports.ResourceTextEdit || (exports.ResourceTextEdit = {}));
let MonacoWorkspace = class MonacoWorkspace {
    constructor() {
        this.ready = new Promise(resolve => {
            this.resolveReady = resolve;
        });
        this.onDidOpenTextDocumentEmitter = new event_1.Emitter();
        this.onDidOpenTextDocument = this.onDidOpenTextDocumentEmitter.event;
        this.onDidCloseTextDocumentEmitter = new event_1.Emitter();
        this.onDidCloseTextDocument = this.onDidCloseTextDocumentEmitter.event;
        this.onDidChangeTextDocumentEmitter = new event_1.Emitter();
        this.onDidChangeTextDocument = this.onDidChangeTextDocumentEmitter.event;
        this.onWillSaveTextDocumentEmitter = new event_1.Emitter();
        this.onWillSaveTextDocument = this.onWillSaveTextDocumentEmitter.event;
        this.onDidSaveTextDocumentEmitter = new event_1.Emitter();
        this.onDidSaveTextDocument = this.onDidSaveTextDocumentEmitter.event;
        this.suppressedOpenIfDirty = [];
    }
    init() {
        this.resolveReady();
        for (const model of this.textModelService.models) {
            this.fireDidOpen(model);
        }
        this.textModelService.onDidCreate(model => this.fireDidOpen(model));
    }
    get textDocuments() {
        return this.textModelService.models;
    }
    getTextDocument(uri) {
        return this.textModelService.get(uri);
    }
    fireDidOpen(model) {
        this.doFireDidOpen(model);
        model.textEditorModel.onDidChangeLanguage(e => {
            this.problems.cleanAllMarkers(new uri_1.default(model.uri));
            model.setLanguageId(e.oldLanguage);
            try {
                this.fireDidClose(model);
            }
            finally {
                model.setLanguageId(undefined);
            }
            this.doFireDidOpen(model);
        });
        model.onDidChangeContent(event => this.fireDidChangeContent(event));
        model.onDidSaveModel(() => this.fireDidSave(model));
        model.onWillSaveModel(event => this.fireWillSave(event));
        model.onDirtyChanged(() => this.openEditorIfDirty(model));
        model.onDispose(() => this.fireDidClose(model));
    }
    doFireDidOpen(model) {
        this.onDidOpenTextDocumentEmitter.fire(model);
    }
    fireDidClose(model) {
        this.onDidCloseTextDocumentEmitter.fire(model);
    }
    fireDidChangeContent(event) {
        this.onDidChangeTextDocumentEmitter.fire(event);
    }
    fireWillSave(event) {
        this.onWillSaveTextDocumentEmitter.fire(event);
    }
    fireDidSave(model) {
        this.onDidSaveTextDocumentEmitter.fire(model);
    }
    openEditorIfDirty(model) {
        if (model.suppressOpenEditorWhenDirty || this.suppressedOpenIfDirty.indexOf(model) !== -1) {
            return;
        }
        if (model.dirty && monaco_editor_1.MonacoEditor.findByDocument(this.editorManager, model).length === 0) {
            // create a new reference to make sure the model is not disposed before it is
            // acquired by the editor, thus losing the changes that made it dirty.
            this.textModelService.createModelReference(model.textEditorModel.uri).then(ref => {
                (model.autoSave === 'on' ? new Promise(resolve => model.onDidSaveModel(resolve)) :
                    this.editorManager.open(new uri_1.default(model.uri), { mode: 'open' })).then(() => ref.dispose());
            });
        }
    }
    async suppressOpenIfDirty(model, cb) {
        this.suppressedOpenIfDirty.push(model);
        try {
            await cb();
        }
        finally {
            const i = this.suppressedOpenIfDirty.indexOf(model);
            if (i !== -1) {
                this.suppressedOpenIfDirty.splice(i, 1);
            }
        }
    }
    /**
     * Applies given edits to the given model.
     * The model is saved if no editors is opened for it.
     */
    applyBackgroundEdit(model, editOperations, shouldSave = true) {
        return this.suppressOpenIfDirty(model, async () => {
            const editor = monaco_editor_1.MonacoEditor.findByDocument(this.editorManager, model)[0];
            const cursorState = editor && editor.getControl().getSelections() || [];
            model.textEditorModel.pushStackElement();
            model.textEditorModel.pushEditOperations(cursorState, editOperations, () => cursorState);
            model.textEditorModel.pushStackElement();
            if (!editor && shouldSave) {
                await model.save();
            }
        });
    }
    async applyBulkEdit(edits) {
        try {
            let totalEdits = 0;
            let totalFiles = 0;
            const fileEdits = edits.filter(edit => edit instanceof monaco.editor.ResourceFileEdit);
            const textEdits = edits.filter(edit => edit instanceof monaco.editor.ResourceTextEdit);
            if (fileEdits.length > 0) {
                await this.performFileEdits(fileEdits);
            }
            if (textEdits.length > 0) {
                const result = await this.performTextEdits(textEdits);
                totalEdits += result.totalEdits;
                totalFiles += result.totalFiles;
            }
            const ariaSummary = this.getAriaSummary(totalEdits, totalFiles);
            return { ariaSummary, success: true };
        }
        catch (e) {
            console.error('Failed to apply Resource edits:', e);
            return {
                ariaSummary: `Error applying Resource edits: ${e.toString()}`,
                success: false
            };
        }
    }
    getAriaSummary(totalEdits, totalFiles) {
        if (totalEdits === 0) {
            return 'Made no edits';
        }
        if (totalEdits > 1 && totalFiles > 1) {
            return `Made ${totalEdits} text edits in ${totalFiles} files`;
        }
        return `Made ${totalEdits} text edits in one file`;
    }
    async performTextEdits(edits) {
        let totalEdits = 0;
        let totalFiles = 0;
        const resourceEdits = new Map();
        for (const edit of edits) {
            if (typeof edit.versionId === 'number') {
                const model = this.textModelService.get(edit.resource.toString());
                if (model && model.textEditorModel.getVersionId() !== edit.versionId) {
                    throw new Error(`${model.uri} has changed in the meantime`);
                }
            }
            const key = edit.resource.toString();
            let array = resourceEdits.get(key);
            if (!array) {
                array = [];
                resourceEdits.set(key, array);
            }
            array.push(edit);
        }
        const pending = [];
        for (const [key, value] of resourceEdits) {
            pending.push((async () => {
                const uri = monaco.Uri.parse(key);
                let eol;
                const editOperations = [];
                const minimalEdits = await monaco.services.StaticServices.editorWorkerService.get().computeMoreMinimalEdits(uri, value.map(v => v.textEdit));
                if (minimalEdits) {
                    for (const textEdit of minimalEdits) {
                        if (typeof textEdit.eol === 'number') {
                            eol = textEdit.eol;
                        }
                        if (monaco.Range.isEmpty(textEdit.range) && !textEdit.text) {
                            // skip no-op
                            continue;
                        }
                        editOperations.push({
                            forceMoveMarkers: false,
                            range: monaco.Range.lift(textEdit.range),
                            text: textEdit.text
                        });
                    }
                }
                if (!editOperations.length && eol === undefined) {
                    return;
                }
                const reference = await this.textModelService.createModelReference(uri);
                try {
                    const model = reference.object.textEditorModel;
                    const editor = monaco_editor_1.MonacoEditor.findByDocument(this.editorManager, reference.object)[0];
                    const cursorState = (editor === null || editor === void 0 ? void 0 : editor.getControl().getSelections()) || [];
                    // start a fresh operation
                    model.pushStackElement();
                    if (editOperations.length) {
                        model.pushEditOperations(cursorState, editOperations, () => cursorState);
                    }
                    if (eol !== undefined) {
                        model.pushEOL(eol);
                    }
                    // push again to make this change an undoable operation
                    model.pushStackElement();
                    totalFiles += 1;
                    totalEdits += editOperations.length;
                }
                finally {
                    reference.dispose();
                }
            })());
        }
        await Promise.all(pending);
        return { totalEdits, totalFiles };
    }
    async performFileEdits(edits) {
        for (const edit of edits) {
            const options = edit.options || {};
            if (edit.newResource && edit.oldResource) {
                // rename
                if (options.overwrite === undefined && options.ignoreIfExists && await this.fileService.exists(new uri_1.default(edit.newResource))) {
                    return; // not overwriting, but ignoring, and the target file exists
                }
                await this.fileService.move(new uri_1.default(edit.oldResource), new uri_1.default(edit.newResource), { overwrite: options.overwrite });
            }
            else if (!edit.newResource && edit.oldResource) {
                // delete file
                if (await this.fileService.exists(new uri_1.default(edit.oldResource))) {
                    let useTrash = this.filePreferences['files.enableTrash'];
                    if (useTrash && !(this.fileService.hasCapability(new uri_1.default(edit.oldResource), 4096 /* Trash */))) {
                        useTrash = false; // not supported by provider
                    }
                    await this.fileService.delete(new uri_1.default(edit.oldResource), { useTrash, recursive: options.recursive });
                }
                else if (!options.ignoreIfNotExists) {
                    throw new Error(`${edit.oldResource} does not exist and can not be deleted`);
                }
            }
            else if (edit.newResource && !edit.oldResource) {
                // create file
                if (options.overwrite === undefined && options.ignoreIfExists && await this.fileService.exists(new uri_1.default(edit.newResource))) {
                    return; // not overwriting, but ignoring, and the target file exists
                }
                await this.fileService.create(new uri_1.default(edit.newResource), undefined, { overwrite: options.overwrite });
            }
        }
    }
};
__decorate([
    inversify_1.inject(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], MonacoWorkspace.prototype, "fileService", void 0);
__decorate([
    inversify_1.inject(browser_1.FileSystemPreferences),
    __metadata("design:type", Object)
], MonacoWorkspace.prototype, "filePreferences", void 0);
__decorate([
    inversify_1.inject(monaco_text_model_service_1.MonacoTextModelService),
    __metadata("design:type", monaco_text_model_service_1.MonacoTextModelService)
], MonacoWorkspace.prototype, "textModelService", void 0);
__decorate([
    inversify_1.inject(browser_2.EditorManager),
    __metadata("design:type", browser_2.EditorManager)
], MonacoWorkspace.prototype, "editorManager", void 0);
__decorate([
    inversify_1.inject(browser_3.ProblemManager),
    __metadata("design:type", browser_3.ProblemManager)
], MonacoWorkspace.prototype, "problems", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], MonacoWorkspace.prototype, "init", null);
MonacoWorkspace = __decorate([
    inversify_1.injectable()
], MonacoWorkspace);
exports.MonacoWorkspace = MonacoWorkspace;


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_monaco_lib_browser_monaco-workspace_js.bundle.js.map