"use strict";
(global["webpackChunkarduino_ide"] = global["webpackChunkarduino_ide"] || []).push([["vendors-node_modules_theia_monaco_lib_browser_monaco-text-model-service_js"],{

/***/ "./node_modules/@theia/monaco/lib/browser/monaco-editor-model.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@theia/monaco/lib/browser/monaco-editor-model.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MonacoEditorModel = exports.TextDocumentSaveReason = void 0;
const vscode_languageserver_protocol_1 = __webpack_require__(/*! @theia/core/shared/vscode-languageserver-protocol */ "./node_modules/@theia/core/shared/vscode-languageserver-protocol/index.js");
Object.defineProperty(exports, "TextDocumentSaveReason", ({ enumerable: true, get: function () { return vscode_languageserver_protocol_1.TextDocumentSaveReason; } }));
const browser_1 = __webpack_require__(/*! @theia/editor/lib/browser */ "./node_modules/@theia/editor/lib/browser/index.js");
const disposable_1 = __webpack_require__(/*! @theia/core/lib/common/disposable */ "./node_modules/@theia/core/lib/common/disposable.js");
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "./node_modules/@theia/core/lib/common/event.js");
const cancellation_1 = __webpack_require__(/*! @theia/core/lib/common/cancellation */ "./node_modules/@theia/core/lib/common/cancellation.js");
const resource_1 = __webpack_require__(/*! @theia/core/lib/common/resource */ "./node_modules/@theia/core/lib/common/resource.js");
class MonacoEditorModel {
    constructor(resource, m2p, p2m, logger, editorPreferences) {
        this.resource = resource;
        this.m2p = m2p;
        this.p2m = p2m;
        this.logger = logger;
        this.editorPreferences = editorPreferences;
        this.autoSave = 'on';
        this.autoSaveDelay = 500;
        this.suppressOpenEditorWhenDirty = false;
        this.lineNumbersMinChars = 3;
        /* @deprecated there is no general save timeout, each participant should introduce a sensible timeout  */
        this.onWillSaveLoopTimeOut = 1500;
        this.toDispose = new disposable_1.DisposableCollection();
        this.toDisposeOnAutoSave = new disposable_1.DisposableCollection();
        this.onDidChangeContentEmitter = new event_1.Emitter();
        this.onDidChangeContent = this.onDidChangeContentEmitter.event;
        this.onDidSaveModelEmitter = new event_1.Emitter();
        this.onDidSaveModel = this.onDidSaveModelEmitter.event;
        this.onWillSaveModelEmitter = new event_1.Emitter();
        this.onWillSaveModel = this.onWillSaveModelEmitter.event;
        this.onDidChangeValidEmitter = new event_1.Emitter();
        this.onDidChangeValid = this.onDidChangeValidEmitter.event;
        this.onDidChangeEncodingEmitter = new event_1.Emitter();
        this.onDidChangeEncoding = this.onDidChangeEncodingEmitter.event;
        /**
         * Use `valid` to access it.
         * Use `setValid` to mutate it.
         */
        this._valid = false;
        this._dirty = false;
        this.onDirtyChangedEmitter = new event_1.Emitter();
        this.pendingOperation = Promise.resolve();
        this.syncCancellationTokenSource = new cancellation_1.CancellationTokenSource();
        this.ignoreDirtyEdits = false;
        this.saveCancellationTokenSource = new cancellation_1.CancellationTokenSource();
        this.ignoreContentChanges = false;
        this.contentChanges = [];
        this.toDispose.push(resource);
        this.toDispose.push(this.toDisposeOnAutoSave);
        this.toDispose.push(this.onDidChangeContentEmitter);
        this.toDispose.push(this.onDidSaveModelEmitter);
        this.toDispose.push(this.onWillSaveModelEmitter);
        this.toDispose.push(this.onDirtyChangedEmitter);
        this.toDispose.push(this.onDidChangeValidEmitter);
        this.toDispose.push(disposable_1.Disposable.create(() => this.cancelSave()));
        this.toDispose.push(disposable_1.Disposable.create(() => this.cancelSync()));
        this.resolveModel = this.readContents().then(content => this.initialize(content || ''));
    }
    dispose() {
        this.toDispose.dispose();
    }
    setEncoding(encoding, mode) {
        if (mode === 1 /* Decode */ && this.dirty) {
            return Promise.resolve();
        }
        if (!this.setPreferredEncoding(encoding)) {
            return Promise.resolve();
        }
        if (mode === 1 /* Decode */) {
            return this.sync();
        }
        return this.scheduleSave(vscode_languageserver_protocol_1.TextDocumentSaveReason.Manual, this.cancelSave(), true);
    }
    getEncoding() {
        return this.preferredEncoding || this.contentEncoding;
    }
    setPreferredEncoding(encoding) {
        if (encoding === this.preferredEncoding || (!this.preferredEncoding && encoding === this.contentEncoding)) {
            return false;
        }
        this.preferredEncoding = encoding;
        this.onDidChangeEncodingEmitter.fire(encoding);
        return true;
    }
    updateContentEncoding() {
        const contentEncoding = this.resource.encoding;
        if (!contentEncoding || this.contentEncoding === contentEncoding) {
            return;
        }
        this.contentEncoding = contentEncoding;
        if (!this.preferredEncoding) {
            this.onDidChangeEncodingEmitter.fire(contentEncoding);
        }
    }
    /**
     * #### Important
     * Only this method can create an instance of `monaco.editor.IModel`,
     * there should not be other calls to `monaco.editor.createModel`.
     */
    initialize(value) {
        if (!this.toDispose.disposed) {
            const uri = monaco.Uri.parse(this.resource.uri.toString());
            let firstLine;
            if (typeof value === 'string') {
                firstLine = value;
                const firstLF = value.indexOf('\n');
                if (firstLF !== -1) {
                    firstLine = value.substring(0, firstLF);
                }
            }
            else {
                firstLine = value.getFirstLineText(1000);
            }
            const languageSelection = monaco.services.StaticServices.modeService.get().createByFilepathOrFirstLine(uri, firstLine);
            this.model = monaco.services.StaticServices.modelService.get().createModel(value, languageSelection, uri);
            this.resourceVersion = this.resource.version;
            this.updateSavedVersionId();
            this.toDispose.push(this.model);
            this.toDispose.push(this.model.onDidChangeContent(event => this.fireDidChangeContent(event)));
            if (this.resource.onDidChangeContents) {
                this.toDispose.push(this.resource.onDidChangeContents(() => this.sync()));
            }
        }
    }
    /**
     * Whether it is possible to load content from the underlying resource.
     */
    get valid() {
        return this._valid;
    }
    setValid(valid) {
        if (valid === this._valid) {
            return;
        }
        this._valid = valid;
        this.onDidChangeValidEmitter.fire(undefined);
    }
    get dirty() {
        return this._dirty;
    }
    setDirty(dirty) {
        if (dirty === this._dirty) {
            return;
        }
        this._dirty = dirty;
        if (dirty === false) {
            this.updateSavedVersionId();
        }
        this.onDirtyChangedEmitter.fire(undefined);
    }
    updateSavedVersionId() {
        this.bufferSavedVersionId = this.model.getAlternativeVersionId();
    }
    get onDirtyChanged() {
        return this.onDirtyChangedEmitter.event;
    }
    get uri() {
        return this.resource.uri.toString();
    }
    get languageId() {
        return this._languageId !== undefined ? this._languageId : this.model.getModeId();
    }
    /**
     * It's a hack to dispatch close notification with an old language id, don't use it.
     */
    setLanguageId(languageId) {
        this._languageId = languageId;
    }
    get version() {
        return this.model.getVersionId();
    }
    /**
     * Return selected text by Range or all text by default
     */
    getText(range) {
        if (!range) {
            return this.model.getValue();
        }
        else {
            return this.model.getValueInRange(this.p2m.asRange(range));
        }
    }
    positionAt(offset) {
        const { lineNumber, column } = this.model.getPositionAt(offset);
        return this.m2p.asPosition(lineNumber, column);
    }
    offsetAt(position) {
        return this.model.getOffsetAt(this.p2m.asPosition(position));
    }
    get lineCount() {
        return this.model.getLineCount();
    }
    /**
     * Retrieves a line in a text document expressed as a one-based position.
     */
    getLineContent(lineNumber) {
        return this.model.getLineContent(lineNumber);
    }
    getLineMaxColumn(lineNumber) {
        return this.model.getLineMaxColumn(lineNumber);
    }
    get readOnly() {
        return this.resource.saveContents === undefined;
    }
    get onDispose() {
        return this.toDispose.onDispose;
    }
    get textEditorModel() {
        return this.model;
    }
    /**
     * Find all matches in an editor for the given options.
     * @param options the options for finding matches.
     *
     * @returns the list of matches.
     */
    findMatches(options) {
        const wordSeparators = this.editorPreferences ? this.editorPreferences['editor.wordSeparators'] : browser_1.DEFAULT_WORD_SEPARATORS;
        const results = this.model.findMatches(options.searchString, false, options.isRegex, options.matchCase, 
        // eslint-disable-next-line no-null/no-null
        options.matchWholeWord ? wordSeparators : null, true, options.limitResultCount);
        const extractedMatches = [];
        results.forEach(r => {
            if (r.matches) {
                extractedMatches.push({
                    matches: r.matches,
                    range: vscode_languageserver_protocol_1.Range.create(r.range.startLineNumber, r.range.startColumn, r.range.endLineNumber, r.range.endColumn)
                });
            }
        });
        return extractedMatches;
    }
    async load() {
        await this.resolveModel;
        return this;
    }
    save(options) {
        return this.scheduleSave(vscode_languageserver_protocol_1.TextDocumentSaveReason.Manual, undefined, undefined, options);
    }
    async run(operation) {
        if (this.toDispose.disposed) {
            return;
        }
        return this.pendingOperation = this.pendingOperation.then(async () => {
            try {
                await operation();
            }
            catch (e) {
                console.error(e);
            }
        });
    }
    cancelSync() {
        this.trace(log => log('MonacoEditorModel.cancelSync'));
        this.syncCancellationTokenSource.cancel();
        this.syncCancellationTokenSource = new cancellation_1.CancellationTokenSource();
        return this.syncCancellationTokenSource.token;
    }
    async sync() {
        const token = this.cancelSync();
        return this.run(() => this.doSync(token));
    }
    async doSync(token) {
        this.trace(log => log('MonacoEditorModel.doSync - enter'));
        if (token.isCancellationRequested) {
            this.trace(log => log('MonacoEditorModel.doSync - exit - cancelled'));
            return;
        }
        const value = await this.readContents();
        if (value === undefined) {
            this.trace(log => log('MonacoEditorModel.doSync - exit - resource not found'));
            return;
        }
        if (token.isCancellationRequested) {
            this.trace(log => log('MonacoEditorModel.doSync - exit - cancelled while looking for a resource'));
            return;
        }
        if (this._dirty) {
            this.trace(log => log('MonacoEditorModel.doSync - exit - pending dirty changes'));
            return;
        }
        this.resourceVersion = this.resource.version;
        this.updateModel(() => monaco.services.StaticServices.modelService.get().updateModel(this.model, value), {
            ignoreDirty: true,
            ignoreContentChanges: true
        });
        this.trace(log => log('MonacoEditorModel.doSync - exit'));
    }
    async readContents() {
        try {
            const options = { encoding: this.getEncoding() };
            const content = await (this.resource.readStream ? this.resource.readStream(options) : this.resource.readContents(options));
            let value;
            if (typeof content === 'string') {
                value = content;
            }
            else {
                value = monaco.textModel.createTextBufferFactoryFromStream(content);
            }
            this.updateContentEncoding();
            this.setValid(true);
            return value;
        }
        catch (e) {
            this.setValid(false);
            if (resource_1.ResourceError.NotFound.is(e)) {
                return undefined;
            }
            throw e;
        }
    }
    markAsDirty() {
        this.trace(log => log('MonacoEditorModel.markAsDirty - enter'));
        if (this.ignoreDirtyEdits) {
            this.trace(log => log('MonacoEditorModel.markAsDirty - exit - ignoring dirty changes enabled'));
            return;
        }
        this.cancelSync();
        this.setDirty(true);
        this.doAutoSave();
        this.trace(log => log('MonacoEditorModel.markAsDirty - exit'));
    }
    doAutoSave() {
        if (this.autoSave === 'on') {
            const token = this.cancelSave();
            this.toDisposeOnAutoSave.dispose();
            const handle = window.setTimeout(() => {
                this.scheduleSave(vscode_languageserver_protocol_1.TextDocumentSaveReason.AfterDelay, token);
            }, this.autoSaveDelay);
            this.toDisposeOnAutoSave.push(disposable_1.Disposable.create(() => window.clearTimeout(handle)));
        }
    }
    cancelSave() {
        this.trace(log => log('MonacoEditorModel.cancelSave'));
        this.saveCancellationTokenSource.cancel();
        this.saveCancellationTokenSource = new cancellation_1.CancellationTokenSource();
        return this.saveCancellationTokenSource.token;
    }
    scheduleSave(reason, token = this.cancelSave(), overwriteEncoding, options) {
        return this.run(() => this.doSave(reason, token, overwriteEncoding, options));
    }
    pushContentChanges(contentChanges) {
        if (!this.ignoreContentChanges) {
            this.contentChanges.push(...contentChanges);
        }
    }
    fireDidChangeContent(event) {
        this.trace(log => log(`MonacoEditorModel.fireDidChangeContent - enter - ${JSON.stringify(event, undefined, 2)}`));
        if (this.model.getAlternativeVersionId() === this.bufferSavedVersionId) {
            this.setDirty(false);
        }
        else {
            this.markAsDirty();
        }
        const changeContentEvent = this.asContentChangedEvent(event);
        this.onDidChangeContentEmitter.fire(changeContentEvent);
        this.pushContentChanges(changeContentEvent.contentChanges);
        this.trace(log => log('MonacoEditorModel.fireDidChangeContent - exit'));
    }
    asContentChangedEvent(event) {
        const contentChanges = event.changes.map(change => this.asTextDocumentContentChangeEvent(change));
        return { model: this, contentChanges };
    }
    asTextDocumentContentChangeEvent(change) {
        const range = this.m2p.asRange(change.range);
        const rangeLength = change.rangeLength;
        const text = change.text;
        return { range, rangeLength, text };
    }
    applyEdits(operations, options) {
        return this.updateModel(() => this.model.applyEdits(operations), options);
    }
    updateModel(doUpdate, options) {
        const resolvedOptions = Object.assign({ ignoreDirty: false, ignoreContentChanges: false }, options);
        const { ignoreDirtyEdits, ignoreContentChanges } = this;
        this.ignoreDirtyEdits = resolvedOptions.ignoreDirty;
        this.ignoreContentChanges = resolvedOptions.ignoreContentChanges;
        try {
            return doUpdate();
        }
        finally {
            this.ignoreDirtyEdits = ignoreDirtyEdits;
            this.ignoreContentChanges = ignoreContentChanges;
        }
    }
    async doSave(reason, token, overwriteEncoding, options) {
        if (token.isCancellationRequested || !this.resource.saveContents) {
            return;
        }
        await this.fireWillSaveModel(reason, token, options);
        if (token.isCancellationRequested) {
            return;
        }
        const changes = [...this.contentChanges];
        if (changes.length === 0 && !overwriteEncoding && reason !== vscode_languageserver_protocol_1.TextDocumentSaveReason.Manual) {
            return;
        }
        const contentLength = this.model.getValueLength();
        const content = this.model.createSnapshot() || this.model.getValue();
        try {
            const encoding = this.getEncoding();
            const version = this.resourceVersion;
            await resource_1.Resource.save(this.resource, { changes, content, contentLength, options: { encoding, overwriteEncoding, version } }, token);
            this.contentChanges.splice(0, changes.length);
            this.resourceVersion = this.resource.version;
            this.updateContentEncoding();
            this.setValid(true);
            if (token.isCancellationRequested) {
                return;
            }
            this.setDirty(false);
            this.fireDidSaveModel();
        }
        catch (e) {
            if (!resource_1.ResourceError.OutOfSync.is(e)) {
                throw e;
            }
        }
    }
    async fireWillSaveModel(reason, token, options) {
        const firing = this.onWillSaveModelEmitter.sequence(async (listener) => {
            if (token.isCancellationRequested) {
                return false;
            }
            const waitables = [];
            const { version } = this;
            const event = {
                model: this, reason, options,
                waitUntil: (thenable) => {
                    if (Object.isFrozen(waitables)) {
                        throw new Error('waitUntil cannot be called asynchronously.');
                    }
                    waitables.push(thenable);
                }
            };
            // Fire.
            try {
                listener(event);
            }
            catch (err) {
                console.error(err);
                return true;
            }
            // Asynchronous calls to `waitUntil` should fail.
            Object.freeze(waitables);
            // Wait for all promises.
            const edits = await Promise.all(waitables).then(allOperations => [].concat(...allOperations));
            if (token.isCancellationRequested) {
                return false;
            }
            // In a perfect world, we should only apply edits if document is clean.
            if (version !== this.version) {
                console.error('onWillSave listeners should provide edits, not directly alter the document.');
            }
            // Finally apply edits provided by this listener before firing the next.
            if (edits && edits.length > 0) {
                this.applyEdits(edits, {
                    ignoreDirty: true,
                });
            }
            return true;
        });
        try {
            await firing;
        }
        catch (e) {
            console.error(e);
        }
    }
    fireDidSaveModel() {
        this.onDidSaveModelEmitter.fire(this.model);
    }
    async revert(options) {
        this.trace(log => log('MonacoEditorModel.revert - enter'));
        this.cancelSave();
        const soft = options && options.soft;
        if (soft !== true) {
            const dirty = this._dirty;
            this._dirty = false;
            try {
                await this.sync();
            }
            finally {
                this._dirty = dirty;
            }
        }
        this.setDirty(false);
        this.trace(log => log('MonacoEditorModel.revert - exit'));
    }
    createSnapshot() {
        return {
            value: this.getText()
        };
    }
    applySnapshot(snapshot) {
        this.model.setValue(snapshot.value);
    }
    trace(loggable) {
        if (this.logger) {
            this.logger.debug((log) => loggable((message, ...params) => log(message, ...params, this.resource.uri.toString(true))));
        }
    }
}
exports.MonacoEditorModel = MonacoEditorModel;


/***/ }),

/***/ "./node_modules/@theia/monaco/lib/browser/monaco-text-model-service.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@theia/monaco/lib/browser/monaco-text-model-service.js ***!
  \*****************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MonacoTextModelService = exports.MonacoEditorModelFactory = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "./node_modules/@theia/core/lib/common/uri.js");
const core_1 = __webpack_require__(/*! @theia/core */ "./node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/editor/lib/browser */ "./node_modules/@theia/editor/lib/browser/index.js");
const monaco_editor_model_1 = __webpack_require__(/*! ./monaco-editor-model */ "./node_modules/@theia/monaco/lib/browser/monaco-editor-model.js");
const monaco_to_protocol_converter_1 = __webpack_require__(/*! ./monaco-to-protocol-converter */ "./node_modules/@theia/monaco/lib/browser/monaco-to-protocol-converter.js");
const protocol_to_monaco_converter_1 = __webpack_require__(/*! ./protocol-to-monaco-converter */ "./node_modules/@theia/monaco/lib/browser/protocol-to-monaco-converter.js");
const logger_1 = __webpack_require__(/*! @theia/core/lib/common/logger */ "./node_modules/@theia/core/lib/common/logger.js");
const application_protocol_1 = __webpack_require__(/*! @theia/core/lib/common/application-protocol */ "./node_modules/@theia/core/lib/common/application-protocol.js");
const promise_util_1 = __webpack_require__(/*! @theia/core/lib/common/promise-util */ "./node_modules/@theia/core/lib/common/promise-util.js");
exports.MonacoEditorModelFactory = Symbol('MonacoEditorModelFactory');
let MonacoTextModelService = class MonacoTextModelService {
    constructor() {
        this._ready = new promise_util_1.Deferred();
        /**
         * This component does some asynchronous work before being fully initialized.
         */
        this.ready = this._ready.promise;
        this._models = new core_1.ReferenceCollection(uri => this.loadModel(new uri_1.default(uri)));
        this.modelOptions = {
            'editor.tabSize': 'tabSize',
            'editor.insertSpaces': 'insertSpaces'
        };
    }
    init() {
        let isWindowsBackend = false;
        this.applicationServer.getBackendOS().then(os => {
            isWindowsBackend = os === core_1.OS.Type.Windows;
        }, () => undefined).then(() => this._ready.resolve());
        const staticServices = monaco.services.StaticServices;
        if (staticServices.resourcePropertiesService) {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            const original = staticServices.resourcePropertiesService.get();
            original.getEOL = () => {
                const eol = this.editorPreferences['files.eol'];
                if (eol) {
                    if (eol !== 'auto') {
                        return eol;
                    }
                }
                return isWindowsBackend ? '\r\n' : '\n';
            };
        }
    }
    get models() {
        return this._models.values();
    }
    get(uri) {
        return this._models.get(uri);
    }
    get onDidCreate() {
        return this._models.onDidCreate;
    }
    createModelReference(raw) {
        return this._models.acquire(raw.toString());
    }
    async loadModel(uri) {
        await this.ready;
        await this.editorPreferences.ready;
        const resource = await this.resourceProvider(uri);
        const model = await (await this.createModel(resource)).load();
        this.updateModel(model);
        model.textEditorModel.onDidChangeLanguage(() => this.updateModel(model));
        const disposable = this.editorPreferences.onPreferenceChanged(change => this.updateModel(model, change));
        model.onDispose(() => disposable.dispose());
        return model;
    }
    createModel(resource) {
        const factory = this.factories.getContributions().find(({ scheme }) => resource.uri.scheme === scheme);
        return factory ? factory.createModel(resource) : new monaco_editor_model_1.MonacoEditorModel(resource, this.m2p, this.p2m, this.logger, this.editorPreferences);
    }
    updateModel(model, change) {
        if (change) {
            if (!change.affects(model.uri, model.languageId)) {
                return;
            }
            if (change.preferenceName === 'editor.autoSave') {
                model.autoSave = this.editorPreferences.get('editor.autoSave', undefined, model.uri);
            }
            if (change.preferenceName === 'editor.autoSaveDelay') {
                model.autoSaveDelay = this.editorPreferences.get('editor.autoSaveDelay', undefined, model.uri);
            }
            const modelOption = this.modelOptions[change.preferenceName];
            if (modelOption) {
                const options = {};
                // eslint-disable-next-line @typescript-eslint/no-explicit-any
                options[modelOption] = change.newValue;
                model.textEditorModel.updateOptions(options);
            }
        }
        else {
            model.autoSave = this.editorPreferences.get('editor.autoSave', undefined, model.uri);
            model.autoSaveDelay = this.editorPreferences.get('editor.autoSaveDelay', undefined, model.uri);
            model.textEditorModel.updateOptions(this.getModelOptions(model));
        }
    }
    getModelOptions(arg) {
        const uri = typeof arg === 'string' ? arg : arg.uri;
        const overrideIdentifier = typeof arg === 'string' ? undefined : arg.languageId;
        return {
            tabSize: this.editorPreferences.get({ preferenceName: 'editor.tabSize', overrideIdentifier }, undefined, uri),
            insertSpaces: this.editorPreferences.get({ preferenceName: 'editor.insertSpaces', overrideIdentifier }, undefined, uri)
        };
    }
    registerTextModelContentProvider(scheme, provider) {
        return {
            dispose() {
                // no-op
            }
        };
    }
};
__decorate([
    inversify_1.inject(core_1.ResourceProvider),
    __metadata("design:type", Function)
], MonacoTextModelService.prototype, "resourceProvider", void 0);
__decorate([
    inversify_1.inject(browser_1.EditorPreferences),
    __metadata("design:type", Object)
], MonacoTextModelService.prototype, "editorPreferences", void 0);
__decorate([
    inversify_1.inject(monaco_to_protocol_converter_1.MonacoToProtocolConverter),
    __metadata("design:type", monaco_to_protocol_converter_1.MonacoToProtocolConverter)
], MonacoTextModelService.prototype, "m2p", void 0);
__decorate([
    inversify_1.inject(protocol_to_monaco_converter_1.ProtocolToMonacoConverter),
    __metadata("design:type", protocol_to_monaco_converter_1.ProtocolToMonacoConverter)
], MonacoTextModelService.prototype, "p2m", void 0);
__decorate([
    inversify_1.inject(core_1.ContributionProvider),
    inversify_1.named(exports.MonacoEditorModelFactory),
    __metadata("design:type", Object)
], MonacoTextModelService.prototype, "factories", void 0);
__decorate([
    inversify_1.inject(logger_1.ILogger),
    __metadata("design:type", Object)
], MonacoTextModelService.prototype, "logger", void 0);
__decorate([
    inversify_1.inject(application_protocol_1.ApplicationServer),
    __metadata("design:type", Object)
], MonacoTextModelService.prototype, "applicationServer", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], MonacoTextModelService.prototype, "init", null);
MonacoTextModelService = __decorate([
    inversify_1.injectable()
], MonacoTextModelService);
exports.MonacoTextModelService = MonacoTextModelService;


/***/ }),

/***/ "./node_modules/@theia/monaco/lib/browser/monaco-to-protocol-converter.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@theia/monaco/lib/browser/monaco-to-protocol-converter.js ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MonacoToProtocolConverter = exports.MonacoRangeReplace = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
;
var MonacoRangeReplace;
(function (MonacoRangeReplace) {
    function is(v) {
        return v.insert !== undefined;
    }
    MonacoRangeReplace.is = is;
})(MonacoRangeReplace = exports.MonacoRangeReplace || (exports.MonacoRangeReplace = {}));
let MonacoToProtocolConverter = class MonacoToProtocolConverter {
    asPosition(lineNumber, column) {
        const line = typeof lineNumber !== 'number' ? undefined : lineNumber - 1;
        const character = typeof column !== 'number' ? undefined : column - 1;
        return {
            line, character
        };
    }
    asRange(range) {
        if (range === undefined) {
            return undefined;
        }
        if (MonacoRangeReplace.is(range)) {
            return this.asRange(range.insert);
        }
        else {
            const start = this.asPosition(range.startLineNumber, range.startColumn);
            const end = this.asPosition(range.endLineNumber, range.endColumn);
            return {
                start, end
            };
        }
    }
};
MonacoToProtocolConverter = __decorate([
    inversify_1.injectable()
], MonacoToProtocolConverter);
exports.MonacoToProtocolConverter = MonacoToProtocolConverter;


/***/ }),

/***/ "./node_modules/@theia/monaco/lib/browser/protocol-to-monaco-converter.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@theia/monaco/lib/browser/protocol-to-monaco-converter.js ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProtocolToMonacoConverter = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
let ProtocolToMonacoConverter = class ProtocolToMonacoConverter {
    asRange(range) {
        if (range === undefined) {
            return undefined;
        }
        const start = this.asPosition(range.start);
        const end = this.asPosition(range.end);
        if (start instanceof monaco.Position && end instanceof monaco.Position) {
            return new monaco.Range(start.lineNumber, start.column, end.lineNumber, end.column);
        }
        const startLineNumber = !start || start.lineNumber === undefined ? undefined : start.lineNumber;
        const startColumn = !start || start.column === undefined ? undefined : start.column;
        const endLineNumber = !end || end.lineNumber === undefined ? undefined : end.lineNumber;
        const endColumn = !end || end.column === undefined ? undefined : end.column;
        return { startLineNumber, startColumn, endLineNumber, endColumn };
    }
    asPosition(position) {
        if (position === undefined) {
            return undefined;
        }
        const { line, character } = position;
        const lineNumber = line === undefined ? undefined : line + 1;
        const column = character === undefined ? undefined : character + 1;
        if (lineNumber !== undefined && column !== undefined) {
            return new monaco.Position(lineNumber, column);
        }
        return { lineNumber, column };
    }
    asLocation(item) {
        if (!item) {
            return undefined;
        }
        const uri = monaco.Uri.parse(item.uri);
        const range = this.asRange(item.range);
        return {
            uri, range
        };
    }
    asTextEdit(edit) {
        if (!edit) {
            return undefined;
        }
        const range = this.asRange(edit.range);
        return {
            range,
            text: edit.newText
        };
    }
    asTextEdits(items) {
        if (!items) {
            return undefined;
        }
        return items.map(item => this.asTextEdit(item));
    }
    asSeverity(severity) {
        if (severity === 1) {
            return monaco.MarkerSeverity.Error;
        }
        if (severity === 2) {
            return monaco.MarkerSeverity.Warning;
        }
        if (severity === 3) {
            return monaco.MarkerSeverity.Info;
        }
        return monaco.MarkerSeverity.Hint;
    }
    asDiagnostics(diagnostics) {
        if (!diagnostics) {
            return undefined;
        }
        return diagnostics.map(diagnostic => this.asDiagnostic(diagnostic));
    }
    asDiagnostic(diagnostic) {
        return {
            code: typeof diagnostic.code === 'number' ? diagnostic.code.toString() : diagnostic.code,
            severity: this.asSeverity(diagnostic.severity),
            message: diagnostic.message,
            source: diagnostic.source,
            startLineNumber: diagnostic.range.start.line + 1,
            startColumn: diagnostic.range.start.character + 1,
            endLineNumber: diagnostic.range.end.line + 1,
            endColumn: diagnostic.range.end.character + 1,
            relatedInformation: this.asRelatedInformations(diagnostic.relatedInformation),
            tags: diagnostic.tags
        };
    }
    asRelatedInformations(relatedInformation) {
        if (!relatedInformation) {
            return undefined;
        }
        return relatedInformation.map(item => this.asRelatedInformation(item));
    }
    asRelatedInformation(relatedInformation) {
        return {
            resource: monaco.Uri.parse(relatedInformation.location.uri),
            startLineNumber: relatedInformation.location.range.start.line + 1,
            startColumn: relatedInformation.location.range.start.character + 1,
            endLineNumber: relatedInformation.location.range.end.line + 1,
            endColumn: relatedInformation.location.range.end.character + 1,
            message: relatedInformation.message
        };
    }
};
ProtocolToMonacoConverter = __decorate([
    inversify_1.injectable()
], ProtocolToMonacoConverter);
exports.ProtocolToMonacoConverter = ProtocolToMonacoConverter;


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_monaco_lib_browser_monaco-text-model-service_js.bundle.js.map