"use strict";
(global["webpackChunkarduino_ide"] = global["webpackChunkarduino_ide"] || []).push([["vendors-node_modules_theia_messages_lib_browser_notifications-renderer_js"],{

/***/ "./node_modules/@theia/messages/lib/browser/notification-center-component.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@theia/messages/lib/browser/notification-center-component.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotificationCenterComponent = void 0;
const React = __webpack_require__(/*! @theia/core/shared/react */ "./node_modules/@theia/core/shared/react/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "./node_modules/@theia/core/lib/common/index.js");
const notification_component_1 = __webpack_require__(/*! ./notification-component */ "./node_modules/@theia/messages/lib/browser/notification-component.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "./node_modules/@theia/core/lib/common/nls.js");
const PerfectScrollbar = __webpack_require__(/*! react-perfect-scrollbar */ "./node_modules/react-perfect-scrollbar/lib/index.js");
class NotificationCenterComponent extends React.Component {
    constructor(props) {
        super(props);
        this.toDisposeOnUnmount = new core_1.DisposableCollection();
        this.onHide = () => {
            this.props.manager.hideCenter();
        };
        this.onClearAll = () => {
            this.props.manager.clearAll();
        };
        this.state = {
            notifications: [],
            visibilityState: 'hidden'
        };
    }
    async componentDidMount() {
        this.toDisposeOnUnmount.push(this.props.manager.onUpdated(({ notifications, visibilityState }) => {
            this.setState({
                notifications: notifications,
                visibilityState
            });
        }));
    }
    componentWillUnmount() {
        this.toDisposeOnUnmount.dispose();
    }
    render() {
        const empty = this.state.notifications.length === 0;
        const title = empty
            ? nls_1.nls.localizeByDefault('No New Notifications')
            : nls_1.nls.localizeByDefault('Notifications');
        return (React.createElement("div", { className: `theia-notifications-container theia-notification-center ${this.state.visibilityState === 'center' ? 'open' : 'closed'}` },
            React.createElement("div", { className: 'theia-notification-center-header' },
                React.createElement("div", { className: 'theia-notification-center-header-title' }, title),
                React.createElement("div", { className: 'theia-notification-center-header-actions' },
                    React.createElement("ul", { className: 'theia-notification-actions' },
                        React.createElement("li", { className: browser_1.codicon('clear-all', true), title: nls_1.nls.localizeByDefault('Clear All Notifications'), onClick: this.onClearAll }),
                        React.createElement("li", { className: browser_1.codicon('chevron-down', true), title: nls_1.nls.localizeByDefault('Hide Notifications'), onClick: this.onHide })))),
            React.createElement(PerfectScrollbar, { className: 'theia-notification-list-scroll-container' },
                React.createElement("div", { className: 'theia-notification-list' }, this.state.notifications.map(notification => React.createElement(notification_component_1.NotificationComponent, { key: notification.messageId, notification: notification, manager: this.props.manager }))))));
    }
}
exports.NotificationCenterComponent = NotificationCenterComponent;


/***/ }),

/***/ "./node_modules/@theia/messages/lib/browser/notification-component.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@theia/messages/lib/browser/notification-component.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotificationComponent = void 0;
const React = __webpack_require__(/*! @theia/core/shared/react */ "./node_modules/@theia/core/shared/react/index.js");
const DOMPurify = __webpack_require__(/*! @theia/core/shared/dompurify */ "./node_modules/@theia/core/shared/dompurify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "./node_modules/@theia/core/lib/common/nls.js");
class NotificationComponent extends React.Component {
    constructor(props) {
        super(props);
        this.onClear = (event) => {
            if (event.target instanceof HTMLElement) {
                const messageId = event.target.dataset.messageId;
                if (messageId) {
                    this.props.manager.clear(messageId);
                }
            }
        };
        this.onToggleExpansion = (event) => {
            if (event.target instanceof HTMLElement) {
                const messageId = event.target.dataset.messageId;
                if (messageId) {
                    this.props.manager.toggleExpansion(messageId);
                }
            }
        };
        this.onAction = (event) => {
            if (event.target instanceof HTMLElement) {
                const messageId = event.target.dataset.messageId;
                const action = event.target.dataset.action;
                if (messageId && action) {
                    this.props.manager.accept(messageId, action);
                }
            }
        };
        this.onMessageClick = (event) => {
            if (event.target instanceof HTMLAnchorElement) {
                event.stopPropagation();
                event.preventDefault();
                const link = event.target.href;
                this.props.manager.openLink(link);
            }
        };
        this.state = {};
    }
    render() {
        const { messageId, message, type, progress, collapsed, expandable, source, actions } = this.props.notification;
        const isProgress = typeof progress === 'number';
        return (React.createElement("div", { key: messageId, className: 'theia-notification-list-item' },
            React.createElement("div", { className: `theia-notification-list-item-content ${collapsed ? 'collapsed' : ''}` },
                React.createElement("div", { className: 'theia-notification-list-item-content-main' },
                    React.createElement("div", { className: `theia-notification-icon ${browser_1.codicon(type)} ${type}` }),
                    React.createElement("div", { className: 'theia-notification-message' },
                        React.createElement("span", { 
                            // eslint-disable-next-line react/no-danger
                            dangerouslySetInnerHTML: {
                                __html: DOMPurify.sanitize(message, {
                                    ALLOW_UNKNOWN_PROTOCOLS: true // DOMPurify usually strips non http(s) links from hrefs
                                })
                            }, onClick: this.onMessageClick })),
                    React.createElement("ul", { className: 'theia-notification-actions' },
                        expandable && (React.createElement("li", { className: browser_1.codicon('chevron-down', true) + (collapsed ? ' expand' : ' collapse'), title: collapsed ? 'Expand' : 'Collapse', "data-message-id": messageId, onClick: this.onToggleExpansion })),
                        !isProgress && (React.createElement("li", { className: browser_1.codicon('close', true), title: nls_1.nls.localizeByDefault('Clear'), "data-message-id": messageId, onClick: this.onClear })))),
                (source || !!actions.length) && (React.createElement("div", { className: 'theia-notification-list-item-content-bottom' },
                    React.createElement("div", { className: 'theia-notification-source' }, source && (React.createElement("span", null, source))),
                    React.createElement("div", { className: 'theia-notification-buttons' }, actions && actions.map((action, index) => (React.createElement("button", { key: messageId + `-action-${index}`, className: 'theia-button', "data-message-id": messageId, "data-action": action, onClick: this.onAction }, action))))))),
            isProgress && (React.createElement("div", { className: 'theia-notification-item-progress' },
                React.createElement("div", { className: 'theia-notification-item-progressbar', style: { width: `${progress}%` } })))));
    }
}
exports.NotificationComponent = NotificationComponent;


/***/ }),

/***/ "./node_modules/@theia/messages/lib/browser/notification-content-renderer.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@theia/messages/lib/browser/notification-content-renderer.js ***!
  \***********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotificationContentRenderer = void 0;
const markdownit = __webpack_require__(/*! @theia/core/shared/markdown-it */ "./node_modules/@theia/core/shared/markdown-it.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
let NotificationContentRenderer = class NotificationContentRenderer {
    constructor() {
        this.mdEngine = markdownit({ html: false });
    }
    renderMessage(content) {
        // in alignment with vscode, new lines aren't supported
        const contentWithoutNewlines = content.replace(/((\r)?\n)+/gm, ' ');
        return this.mdEngine.renderInline(contentWithoutNewlines);
    }
};
NotificationContentRenderer = __decorate([
    inversify_1.injectable()
], NotificationContentRenderer);
exports.NotificationContentRenderer = NotificationContentRenderer;


/***/ }),

/***/ "./node_modules/@theia/messages/lib/browser/notification-preferences.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@theia/messages/lib/browser/notification-preferences.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


/********************************************************************************
 * Copyright (C) 2018 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.bindNotificationPreferences = exports.createNotificationPreferences = exports.NotificationPreferences = exports.NotificationPreferenceContribution = exports.NotificationConfigSchema = void 0;
const preferences_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences */ "./node_modules/@theia/core/lib/browser/preferences/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "./node_modules/@theia/core/lib/common/nls.js");
exports.NotificationConfigSchema = {
    'type': 'object',
    'properties': {
        'notification.timeout': {
            'type': 'number',
            'description': nls_1.nls.localize('theia/messages/notificationTimeout', 'Informative notifications will be hidden after this timeout.'),
            'default': 30 * 1000 // `0` and negative values are treated as no timeout.
        }
    }
};
exports.NotificationPreferenceContribution = Symbol('NotificationPreferenceContribution');
exports.NotificationPreferences = Symbol('NotificationPreferences');
function createNotificationPreferences(preferences, schema = exports.NotificationConfigSchema) {
    return preferences_1.createPreferenceProxy(preferences, schema);
}
exports.createNotificationPreferences = createNotificationPreferences;
function bindNotificationPreferences(bind) {
    bind(exports.NotificationPreferences).toDynamicValue(ctx => {
        const preferences = ctx.container.get(preferences_1.PreferenceService);
        const contribution = ctx.container.get(exports.NotificationPreferenceContribution);
        return createNotificationPreferences(preferences, contribution.schema);
    }).inSingletonScope();
    bind(exports.NotificationPreferenceContribution).toConstantValue({ schema: exports.NotificationConfigSchema });
    bind(preferences_1.PreferenceContribution).toService(exports.NotificationPreferenceContribution);
}
exports.bindNotificationPreferences = bindNotificationPreferences;


/***/ }),

/***/ "./node_modules/@theia/messages/lib/browser/notification-toasts-component.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@theia/messages/lib/browser/notification-toasts-component.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotificationToastsComponent = void 0;
const React = __webpack_require__(/*! @theia/core/shared/react */ "./node_modules/@theia/core/shared/react/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "./node_modules/@theia/core/lib/common/index.js");
const notification_component_1 = __webpack_require__(/*! ./notification-component */ "./node_modules/@theia/messages/lib/browser/notification-component.js");
class NotificationToastsComponent extends React.Component {
    constructor(props) {
        super(props);
        this.toDisposeOnUnmount = new core_1.DisposableCollection();
        this.state = {
            toasts: [],
            visibilityState: 'hidden'
        };
    }
    async componentDidMount() {
        this.toDisposeOnUnmount.push(this.props.manager.onUpdated(({ toasts, visibilityState }) => {
            visibilityState = this.props.corePreferences['workbench.silentNotifications'] ? 'hidden' : visibilityState;
            this.setState({
                toasts: toasts.slice(-3),
                visibilityState
            });
        }));
    }
    componentWillUnmount() {
        this.toDisposeOnUnmount.dispose();
    }
    render() {
        return (React.createElement("div", { className: `theia-notifications-container theia-notification-toasts ${this.state.visibilityState === 'toasts' ? 'open' : 'closed'}` },
            React.createElement("div", { className: 'theia-notification-list' }, this.state.toasts.map(notification => React.createElement(notification_component_1.NotificationComponent, { key: notification.messageId, notification: notification, manager: this.props.manager })))));
    }
}
exports.NotificationToastsComponent = NotificationToastsComponent;


/***/ }),

/***/ "./node_modules/@theia/messages/lib/browser/notifications-manager.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@theia/messages/lib/browser/notifications-manager.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotificationManager = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "./node_modules/@theia/core/lib/common/index.js");
const objects_1 = __webpack_require__(/*! @theia/core/lib/common/objects */ "./node_modules/@theia/core/lib/common/objects.js");
const core_1 = __webpack_require__(/*! @theia/core */ "./node_modules/@theia/core/lib/common/index.js");
const promise_util_1 = __webpack_require__(/*! @theia/core/lib/common/promise-util */ "./node_modules/@theia/core/lib/common/promise-util.js");
const ts_md5_1 = __webpack_require__(/*! ts-md5 */ "./node_modules/ts-md5/dist/md5.js");
const throttle = __webpack_require__(/*! @theia/core/shared/lodash.throttle */ "./node_modules/@theia/core/shared/lodash.throttle/index.js");
const notification_preferences_1 = __webpack_require__(/*! ./notification-preferences */ "./node_modules/@theia/messages/lib/browser/notification-preferences.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "./node_modules/@theia/core/lib/browser/context-key-service.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "./node_modules/@theia/core/lib/common/uri.js");
const notification_content_renderer_1 = __webpack_require__(/*! ./notification-content-renderer */ "./node_modules/@theia/messages/lib/browser/notification-content-renderer.js");
let NotificationManager = class NotificationManager extends common_1.MessageClient {
    constructor() {
        super(...arguments);
        this.onUpdatedEmitter = new core_1.Emitter();
        this.onUpdated = this.onUpdatedEmitter.event;
        this.fireUpdatedEvent = throttle(() => {
            const notifications = objects_1.deepClone(Array.from(this.notifications.values()).filter((notification) => notification.message));
            const toasts = objects_1.deepClone(Array.from(this.toasts.values()).filter((toast) => toast.message));
            const visibilityState = this.visibilityState;
            this.onUpdatedEmitter.fire({ notifications, toasts, visibilityState });
        }, 250, { leading: true, trailing: true });
        this.deferredResults = new Map();
        this.notifications = new Map();
        this.toasts = new Map();
        this.visibilityState = 'hidden';
        this.hideTimeouts = new Map();
    }
    async init() {
        this.notificationToastsVisibleKey = this.contextKeyService.createKey('notificationToastsVisible', false);
        this.notificationCenterVisibleKey = this.contextKeyService.createKey('notificationCenterVisible', false);
    }
    updateContextKeys() {
        this.notificationToastsVisibleKey.set(this.toastsVisible);
        this.notificationCenterVisibleKey.set(this.centerVisible);
    }
    get toastsVisible() {
        return this.visibilityState === 'toasts';
    }
    get centerVisible() {
        return this.visibilityState === 'center';
    }
    setVisibilityState(newState) {
        const changed = this.visibilityState !== newState;
        this.visibilityState = newState;
        if (changed) {
            this.fireUpdatedEvent();
            this.updateContextKeys();
        }
    }
    hideCenter() {
        this.setVisibilityState('hidden');
    }
    showCenter() {
        this.setVisibilityState('center');
    }
    toggleCenter() {
        this.setVisibilityState(this.centerVisible ? 'hidden' : 'center');
    }
    accept(notification, action) {
        const messageId = this.getId(notification);
        if (!messageId) {
            return;
        }
        this.notifications.delete(messageId);
        this.toasts.delete(messageId);
        const result = this.deferredResults.get(messageId);
        if (!result) {
            return;
        }
        this.deferredResults.delete(messageId);
        if (this.centerVisible && this.notifications.size === 0) {
            this.visibilityState = 'hidden';
        }
        result.resolve(action);
        this.fireUpdatedEvent();
    }
    find(notification) {
        return typeof notification === 'string' ? this.notifications.get(notification) : notification;
    }
    getId(notification) {
        return typeof notification === 'string' ? notification : notification.messageId;
    }
    hide() {
        if (this.toastsVisible) {
            this.toasts.clear();
        }
        this.setVisibilityState('hidden');
    }
    clearAll() {
        this.setVisibilityState('hidden');
        Array.from(this.notifications.values()).forEach(n => this.clear(n));
    }
    clear(notification) {
        this.accept(notification, undefined);
    }
    toggleExpansion(notificationId) {
        const notification = this.find(notificationId);
        if (!notification) {
            return;
        }
        notification.collapsed = !notification.collapsed;
        this.fireUpdatedEvent();
    }
    showMessage(plainMessage) {
        const messageId = this.getMessageId(plainMessage);
        let notification = this.notifications.get(messageId);
        if (!notification) {
            const message = this.contentRenderer.renderMessage(plainMessage.text);
            const type = this.toNotificationType(plainMessage.type);
            const actions = Array.from(new Set(plainMessage.actions));
            const source = plainMessage.source;
            const expandable = this.isExpandable(message, source, actions);
            const collapsed = expandable;
            notification = { messageId, message, type, actions, expandable, collapsed };
            this.notifications.set(messageId, notification);
        }
        const result = this.deferredResults.get(messageId) || new promise_util_1.Deferred();
        this.deferredResults.set(messageId, result);
        if (!this.centerVisible) {
            this.toasts.delete(messageId);
            this.toasts.set(messageId, notification);
            this.startHideTimeout(messageId, this.getTimeout(plainMessage));
            this.setVisibilityState('toasts');
        }
        this.fireUpdatedEvent();
        return result.promise;
    }
    startHideTimeout(messageId, timeout) {
        if (timeout > 0) {
            this.hideTimeouts.set(messageId, window.setTimeout(() => {
                this.hideToast(messageId);
            }, timeout));
        }
    }
    hideToast(messageId) {
        this.toasts.delete(messageId);
        if (this.toastsVisible && !this.toasts.size) {
            this.setVisibilityState('hidden');
        }
        else {
            this.fireUpdatedEvent();
        }
    }
    getTimeout(plainMessage) {
        if (plainMessage.actions && plainMessage.actions.length > 0) {
            // Ignore the timeout if at least one action is set, and we wait for user interaction.
            return 0;
        }
        return plainMessage.options && plainMessage.options.timeout || this.preferences['notification.timeout'];
    }
    isExpandable(message, source, actions) {
        if (!actions.length && source) {
            return true;
        }
        return message.length > 500;
    }
    toNotificationType(type) {
        switch (type) {
            case common_1.MessageType.Error:
                return 'error';
            case common_1.MessageType.Warning:
                return 'warning';
            case common_1.MessageType.Progress:
                return 'progress';
            default:
                return 'info';
        }
    }
    getMessageId(m) {
        return String(ts_md5_1.Md5.hashStr(`[${m.type}] ${m.text} : ${(m.actions || []).join(' | ')};`));
    }
    async showProgress(messageId, plainMessage, cancellationToken) {
        let notification = this.notifications.get(messageId);
        if (!notification) {
            const message = this.contentRenderer.renderMessage(plainMessage.text);
            const type = this.toNotificationType(plainMessage.type);
            const actions = Array.from(new Set(plainMessage.actions));
            const source = plainMessage.source;
            const expandable = this.isExpandable(message, source, actions);
            const collapsed = expandable;
            notification = { messageId, message, type, actions, expandable, collapsed };
            this.notifications.set(messageId, notification);
            notification.progress = 0;
            cancellationToken.onCancellationRequested(() => {
                this.accept(messageId, common_1.ProgressMessage.Cancel);
            });
        }
        const result = this.deferredResults.get(messageId) || new promise_util_1.Deferred();
        this.deferredResults.set(messageId, result);
        if (!this.centerVisible) {
            this.toasts.set(messageId, notification);
            this.setVisibilityState('toasts');
        }
        this.fireUpdatedEvent();
        return result.promise;
    }
    async reportProgress(messageId, update, originalMessage, cancellationToken) {
        const notification = this.find(messageId);
        if (!notification) {
            return;
        }
        if (cancellationToken.isCancellationRequested) {
            this.clear(messageId);
        }
        else {
            const textMessage = originalMessage.text && update.message ? `${originalMessage.text}: ${update.message}` : originalMessage.text || (update === null || update === void 0 ? void 0 : update.message);
            if (textMessage) {
                notification.message = this.contentRenderer.renderMessage(textMessage);
            }
            notification.progress = this.toPlainProgress(update) || notification.progress;
        }
        this.fireUpdatedEvent();
    }
    toPlainProgress(update) {
        return update.work && Math.min(update.work.done / update.work.total * 100, 100);
    }
    async openLink(link) {
        const uri = new uri_1.default(link);
        const opener = await this.openerService.getOpener(uri);
        opener.open(uri);
    }
};
__decorate([
    inversify_1.inject(notification_preferences_1.NotificationPreferences),
    __metadata("design:type", Object)
], NotificationManager.prototype, "preferences", void 0);
__decorate([
    inversify_1.inject(context_key_service_1.ContextKeyService),
    __metadata("design:type", Object)
], NotificationManager.prototype, "contextKeyService", void 0);
__decorate([
    inversify_1.inject(browser_1.OpenerService),
    __metadata("design:type", Object)
], NotificationManager.prototype, "openerService", void 0);
__decorate([
    inversify_1.inject(notification_content_renderer_1.NotificationContentRenderer),
    __metadata("design:type", notification_content_renderer_1.NotificationContentRenderer)
], NotificationManager.prototype, "contentRenderer", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], NotificationManager.prototype, "init", null);
NotificationManager = __decorate([
    inversify_1.injectable()
], NotificationManager);
exports.NotificationManager = NotificationManager;


/***/ }),

/***/ "./node_modules/@theia/messages/lib/browser/notifications-renderer.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@theia/messages/lib/browser/notifications-renderer.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotificationsRenderer = void 0;
const ReactDOM = __webpack_require__(/*! @theia/core/shared/react-dom */ "./node_modules/@theia/core/shared/react-dom/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "./node_modules/@theia/core/shared/react/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const notifications_manager_1 = __webpack_require__(/*! ./notifications-manager */ "./node_modules/@theia/messages/lib/browser/notifications-manager.js");
const notification_center_component_1 = __webpack_require__(/*! ./notification-center-component */ "./node_modules/@theia/messages/lib/browser/notification-center-component.js");
const notification_toasts_component_1 = __webpack_require__(/*! ./notification-toasts-component */ "./node_modules/@theia/messages/lib/browser/notification-toasts-component.js");
let NotificationsRenderer = class NotificationsRenderer {
    init() {
        this.createOverlayContainer();
        this.render();
    }
    createOverlayContainer() {
        this.container = window.document.createElement('div');
        this.container.className = 'theia-notifications-overlay';
        if (window.document.body) {
            window.document.body.appendChild(this.container);
        }
    }
    render() {
        ReactDOM.render(React.createElement("div", null,
            React.createElement(notification_toasts_component_1.NotificationToastsComponent, { manager: this.manager, corePreferences: this.corePreferences }),
            React.createElement(notification_center_component_1.NotificationCenterComponent, { manager: this.manager })), this.container);
    }
};
__decorate([
    inversify_1.inject(browser_1.ApplicationShell),
    __metadata("design:type", browser_1.ApplicationShell)
], NotificationsRenderer.prototype, "shell", void 0);
__decorate([
    inversify_1.inject(notifications_manager_1.NotificationManager),
    __metadata("design:type", notifications_manager_1.NotificationManager)
], NotificationsRenderer.prototype, "manager", void 0);
__decorate([
    inversify_1.inject(browser_1.CorePreferences),
    __metadata("design:type", Object)
], NotificationsRenderer.prototype, "corePreferences", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], NotificationsRenderer.prototype, "init", null);
NotificationsRenderer = __decorate([
    inversify_1.injectable()
], NotificationsRenderer);
exports.NotificationsRenderer = NotificationsRenderer;


/***/ }),

/***/ "./node_modules/react-perfect-scrollbar/lib/index.js":
/*!***********************************************************!*\
  !*** ./node_modules/react-perfect-scrollbar/lib/index.js ***!
  \***********************************************************/
/***/ ((module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));

var _scrollbar = __webpack_require__(/*! ./scrollbar */ "./node_modules/react-perfect-scrollbar/lib/scrollbar.js");

var _scrollbar2 = _interopRequireDefault(_scrollbar);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports["default"] = _scrollbar2.default;
module.exports = exports['default'];

/***/ }),

/***/ "./node_modules/react-perfect-scrollbar/lib/scrollbar.js":
/*!***************************************************************!*\
  !*** ./node_modules/react-perfect-scrollbar/lib/scrollbar.js ***!
  \***************************************************************/
/***/ ((module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = __webpack_require__(/*! react */ "./node_modules/react/index.js");

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");

var _perfectScrollbar = __webpack_require__(/*! perfect-scrollbar */ "./node_modules/perfect-scrollbar/dist/perfect-scrollbar.esm.js");

var _perfectScrollbar2 = _interopRequireDefault(_perfectScrollbar);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var handlerNameByEvent = {
  'ps-scroll-y': 'onScrollY',
  'ps-scroll-x': 'onScrollX',
  'ps-scroll-up': 'onScrollUp',
  'ps-scroll-down': 'onScrollDown',
  'ps-scroll-left': 'onScrollLeft',
  'ps-scroll-right': 'onScrollRight',
  'ps-y-reach-start': 'onYReachStart',
  'ps-y-reach-end': 'onYReachEnd',
  'ps-x-reach-start': 'onXReachStart',
  'ps-x-reach-end': 'onXReachEnd'
};
Object.freeze(handlerNameByEvent);

var ScrollBar = function (_Component) {
  _inherits(ScrollBar, _Component);

  function ScrollBar(props) {
    _classCallCheck(this, ScrollBar);

    var _this = _possibleConstructorReturn(this, (ScrollBar.__proto__ || Object.getPrototypeOf(ScrollBar)).call(this, props));

    _this.handleRef = _this.handleRef.bind(_this);
    _this._handlerByEvent = {};
    return _this;
  }

  _createClass(ScrollBar, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      if (this.props.option) {
        console.warn('react-perfect-scrollbar: the "option" prop has been deprecated in favor of "options"');
      }

      this._ps = new _perfectScrollbar2.default(this._container, this.props.options || this.props.option);
      // hook up events
      this._updateEventHook();
      this._updateClassName();
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate(prevProps) {
      this._updateEventHook(prevProps);

      this.updateScroll();

      if (prevProps.className !== this.props.className) {
        this._updateClassName();
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      var _this2 = this;

      // unhook up evens
      Object.keys(this._handlerByEvent).forEach(function (key) {
        var value = _this2._handlerByEvent[key];

        if (value) {
          _this2._container.removeEventListener(key, value, false);
        }
      });
      this._handlerByEvent = {};
      this._ps.destroy();
      this._ps = null;
    }
  }, {
    key: '_updateEventHook',
    value: function _updateEventHook() {
      var _this3 = this;

      var prevProps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      // hook up events
      Object.keys(handlerNameByEvent).forEach(function (key) {
        var callback = _this3.props[handlerNameByEvent[key]];
        var prevCallback = prevProps[handlerNameByEvent[key]];
        if (callback !== prevCallback) {
          if (prevCallback) {
            var prevHandler = _this3._handlerByEvent[key];
            _this3._container.removeEventListener(key, prevHandler, false);
            _this3._handlerByEvent[key] = null;
          }
          if (callback) {
            var handler = function handler() {
              return callback(_this3._container);
            };
            _this3._container.addEventListener(key, handler, false);
            _this3._handlerByEvent[key] = handler;
          }
        }
      });
    }
  }, {
    key: '_updateClassName',
    value: function _updateClassName() {
      var className = this.props.className;


      var psClassNames = this._container.className.split(' ').filter(function (name) {
        return name.match(/^ps([-_].+|)$/);
      }).join(' ');

      if (this._container) {
        this._container.className = 'scrollbar-container' + (className ? ' ' + className : '') + (psClassNames ? ' ' + psClassNames : '');
      }
    }
  }, {
    key: 'updateScroll',
    value: function updateScroll() {
      this.props.onSync(this._ps);
    }
  }, {
    key: 'handleRef',
    value: function handleRef(ref) {
      this._container = ref;
      this.props.containerRef(ref);
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          className = _props.className,
          style = _props.style,
          option = _props.option,
          options = _props.options,
          containerRef = _props.containerRef,
          onScrollY = _props.onScrollY,
          onScrollX = _props.onScrollX,
          onScrollUp = _props.onScrollUp,
          onScrollDown = _props.onScrollDown,
          onScrollLeft = _props.onScrollLeft,
          onScrollRight = _props.onScrollRight,
          onYReachStart = _props.onYReachStart,
          onYReachEnd = _props.onYReachEnd,
          onXReachStart = _props.onXReachStart,
          onXReachEnd = _props.onXReachEnd,
          component = _props.component,
          onSync = _props.onSync,
          children = _props.children,
          remainProps = _objectWithoutProperties(_props, ['className', 'style', 'option', 'options', 'containerRef', 'onScrollY', 'onScrollX', 'onScrollUp', 'onScrollDown', 'onScrollLeft', 'onScrollRight', 'onYReachStart', 'onYReachEnd', 'onXReachStart', 'onXReachEnd', 'component', 'onSync', 'children']);

      var Comp = component;

      return _react2.default.createElement(
        Comp,
        _extends({ style: style, ref: this.handleRef }, remainProps),
        children
      );
    }
  }]);

  return ScrollBar;
}(_react.Component);

exports["default"] = ScrollBar;


ScrollBar.defaultProps = {
  className: '',
  style: undefined,
  option: undefined,
  options: undefined,
  containerRef: function containerRef() {},
  onScrollY: undefined,
  onScrollX: undefined,
  onScrollUp: undefined,
  onScrollDown: undefined,
  onScrollLeft: undefined,
  onScrollRight: undefined,
  onYReachStart: undefined,
  onYReachEnd: undefined,
  onXReachStart: undefined,
  onXReachEnd: undefined,
  onSync: function onSync(ps) {
    return ps.update();
  },
  component: 'div'
};

ScrollBar.propTypes = {
  children: _propTypes.PropTypes.node.isRequired,
  className: _propTypes.PropTypes.string,
  style: _propTypes.PropTypes.object,
  option: _propTypes.PropTypes.object,
  options: _propTypes.PropTypes.object,
  containerRef: _propTypes.PropTypes.func,
  onScrollY: _propTypes.PropTypes.func,
  onScrollX: _propTypes.PropTypes.func,
  onScrollUp: _propTypes.PropTypes.func,
  onScrollDown: _propTypes.PropTypes.func,
  onScrollLeft: _propTypes.PropTypes.func,
  onScrollRight: _propTypes.PropTypes.func,
  onYReachStart: _propTypes.PropTypes.func,
  onYReachEnd: _propTypes.PropTypes.func,
  onXReachStart: _propTypes.PropTypes.func,
  onXReachEnd: _propTypes.PropTypes.func,
  onSync: _propTypes.PropTypes.func,
  component: _propTypes.PropTypes.string
};
module.exports = exports['default'];

/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_messages_lib_browser_notifications-renderer_js.bundle.js.map