"use strict";
(global["webpackChunkarduino_ide"] = global["webpackChunkarduino_ide"] || []).push([["vendors-node_modules_theia_markers_lib_browser_problem_problem-manager_js"],{

/***/ "./node_modules/@theia/markers/lib/browser/marker-manager.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@theia/markers/lib/browser/marker-manager.js ***!
  \*******************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MarkerManager = exports.MarkerCollection = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "./node_modules/@theia/core/lib/common/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "./node_modules/@theia/core/lib/common/uri.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "./node_modules/@theia/filesystem/lib/browser/file-service.js");
class MarkerCollection {
    constructor(uri, kind) {
        this.uri = uri;
        this.kind = kind;
        this.owner2Markers = new Map();
    }
    get empty() {
        return !this.owner2Markers.size;
    }
    getOwners() {
        return Array.from(this.owner2Markers.keys());
    }
    getMarkers(owner) {
        return this.owner2Markers.get(owner) || [];
    }
    setMarkers(owner, markerData) {
        const before = this.owner2Markers.get(owner);
        if (markerData.length > 0) {
            this.owner2Markers.set(owner, markerData.map(data => this.createMarker(owner, data)));
        }
        else {
            this.owner2Markers.delete(owner);
        }
        return before || [];
    }
    createMarker(owner, data) {
        return Object.freeze({
            uri: this.uri.toString(),
            kind: this.kind,
            owner: owner,
            data
        });
    }
    findMarkers(filter) {
        if (filter.owner) {
            if (this.owner2Markers.has(filter.owner)) {
                return this.filterMarkers(filter, this.owner2Markers.get(filter.owner));
            }
            return [];
        }
        else {
            const result = [];
            for (const markers of this.owner2Markers.values()) {
                result.push(...this.filterMarkers(filter, markers));
            }
            return result;
        }
    }
    filterMarkers(filter, toFilter) {
        if (!toFilter) {
            return [];
        }
        if (filter.dataFilter) {
            return toFilter.filter(d => filter.dataFilter(d.data));
        }
        else {
            return toFilter;
        }
    }
}
exports.MarkerCollection = MarkerCollection;
let MarkerManager = class MarkerManager {
    constructor() {
        this.uri2MarkerCollection = new Map();
        this.onDidChangeMarkersEmitter = new common_1.Emitter();
    }
    init() {
        this.fileService.onDidFilesChange(event => {
            if (event.gotDeleted()) {
                this.cleanMarkers(event);
            }
        });
    }
    cleanMarkers(event) {
        for (const uriString of this.uri2MarkerCollection.keys()) {
            const uri = new uri_1.default(uriString);
            if (event.contains(uri, 2 /* DELETED */)) {
                this.cleanAllMarkers(uri);
            }
        }
    }
    get onDidChangeMarkers() {
        return this.onDidChangeMarkersEmitter.event;
    }
    fireOnDidChangeMarkers(uri) {
        this.onDidChangeMarkersEmitter.fire(uri);
    }
    /*
     * replaces the current markers for the given uri and owner with the given data.
     */
    setMarkers(uri, owner, data) {
        const uriString = uri.toString();
        const collection = this.uri2MarkerCollection.get(uriString) || new MarkerCollection(uri, this.getKind());
        const oldMarkers = collection.setMarkers(owner, data);
        if (collection.empty) {
            this.uri2MarkerCollection.delete(uri.toString());
        }
        else {
            this.uri2MarkerCollection.set(uriString, collection);
        }
        this.fireOnDidChangeMarkers(uri);
        return oldMarkers;
    }
    /*
     * returns all markers that satisfy the given filter.
     */
    findMarkers(filter = {}) {
        if (filter.uri) {
            const collection = this.uri2MarkerCollection.get(filter.uri.toString());
            return collection ? collection.findMarkers(filter) : [];
        }
        const result = [];
        for (const uri of this.getUris()) {
            result.push(...this.uri2MarkerCollection.get(uri).findMarkers(filter));
        }
        return result;
    }
    getUris() {
        return this.uri2MarkerCollection.keys();
    }
    cleanAllMarkers(uri) {
        if (uri) {
            this.doCleanAllMarkers(uri);
        }
        else {
            for (const uriString of this.getUris()) {
                this.doCleanAllMarkers(new uri_1.default(uriString));
            }
        }
    }
    doCleanAllMarkers(uri) {
        const uriString = uri.toString();
        const collection = this.uri2MarkerCollection.get(uriString);
        if (collection !== undefined) {
            this.uri2MarkerCollection.delete(uriString);
            this.fireOnDidChangeMarkers(uri);
        }
    }
};
__decorate([
    inversify_1.inject(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], MarkerManager.prototype, "fileService", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], MarkerManager.prototype, "init", null);
MarkerManager = __decorate([
    inversify_1.injectable()
], MarkerManager);
exports.MarkerManager = MarkerManager;


/***/ }),

/***/ "./node_modules/@theia/markers/lib/browser/problem/problem-manager.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@theia/markers/lib/browser/problem/problem-manager.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProblemManager = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const marker_manager_1 = __webpack_require__(/*! ../marker-manager */ "./node_modules/@theia/markers/lib/browser/marker-manager.js");
const problem_marker_1 = __webpack_require__(/*! ../../common/problem-marker */ "./node_modules/@theia/markers/lib/common/problem-marker.js");
let ProblemManager = class ProblemManager extends marker_manager_1.MarkerManager {
    getKind() {
        return problem_marker_1.PROBLEM_KIND;
    }
    getProblemStat() {
        let errors = 0;
        let warnings = 0;
        let infos = 0;
        for (const marker of this.findMarkers()) {
            if (marker.data.severity === 1) {
                errors++;
            }
            else if (marker.data.severity === 2) {
                warnings++;
            }
            else if (marker.data.severity === 3) {
                infos++;
            }
        }
        return { errors, warnings, infos };
    }
};
ProblemManager = __decorate([
    inversify_1.injectable()
], ProblemManager);
exports.ProblemManager = ProblemManager;


/***/ }),

/***/ "./node_modules/@theia/markers/lib/common/problem-marker.js":
/*!******************************************************************!*\
  !*** ./node_modules/@theia/markers/lib/common/problem-marker.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/********************************************************************************
 * Copyright (C) 2017 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProblemMarker = exports.PROBLEM_KIND = void 0;
exports.PROBLEM_KIND = 'problem';
var ProblemMarker;
(function (ProblemMarker) {
    function is(node) {
        return 'kind' in node && node.kind === exports.PROBLEM_KIND;
    }
    ProblemMarker.is = is;
})(ProblemMarker = exports.ProblemMarker || (exports.ProblemMarker = {}));


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_markers_lib_browser_problem_problem-manager_js.bundle.js.map