"use strict";
(global["webpackChunkarduino_ide"] = global["webpackChunkarduino_ide"] || []).push([["vendors-node_modules_theia_keymaps_lib_browser_keymaps-frontend-contribution_js"],{

/***/ "./node_modules/@theia/keymaps/lib/browser/keybindings-widget.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@theia/keymaps/lib/browser/keybindings-widget.js ***!
  \***********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2018 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var KeybindingWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.KeybindingWidget = void 0;
const React = __webpack_require__(/*! @theia/core/shared/react */ "./node_modules/@theia/core/shared/react/index.js");
const debounce = __webpack_require__(/*! @theia/core/shared/lodash.debounce */ "./node_modules/@theia/core/shared/lodash.debounce/index.js");
const fuzzy = __webpack_require__(/*! @theia/core/shared/fuzzy */ "./node_modules/@theia/core/shared/fuzzy/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "./node_modules/@theia/core/lib/common/event.js");
const command_1 = __webpack_require__(/*! @theia/core/lib/common/command */ "./node_modules/@theia/core/lib/common/command.js");
const react_widget_1 = __webpack_require__(/*! @theia/core/lib/browser/widgets/react-widget */ "./node_modules/@theia/core/lib/browser/widgets/react-widget.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const keymaps_service_1 = __webpack_require__(/*! ./keymaps-service */ "./node_modules/@theia/keymaps/lib/browser/keymaps-service.js");
const alert_message_1 = __webpack_require__(/*! @theia/core/lib/browser/widgets/alert-message */ "./node_modules/@theia/core/lib/browser/widgets/alert-message.js");
let KeybindingWidget = KeybindingWidget_1 = class KeybindingWidget extends react_widget_1.ReactWidget {
    constructor() {
        super(...arguments);
        /**
         * The list of all available keybindings.
         */
        this.items = [];
        /**
         * The current user search query.
         */
        this.query = '';
        /**
         * The regular expression used to extract values between fuzzy results.
         */
        this.regexp = /<match>(.*?)<\/match>/g;
        /**
         * The regular expression used to extract values between the keybinding separator.
         */
        this.keybindingSeparator = /<match>\+<\/match>/g;
        /**
         * The fuzzy search options.
         * The `pre` and `post` options are used to wrap fuzzy matches.
         */
        this.fuzzyOptions = {
            pre: '<match>',
            post: '</match>',
        };
        this.onDidUpdateEmitter = new event_1.Emitter();
        this.onDidUpdate = this.onDidUpdateEmitter.event;
        /**
         * Search keybindings.
         */
        this.searchKeybindings = debounce(() => this.doSearchKeybindings(), 50);
    }
    /**
     * Initialize the widget.
     */
    init() {
        this.id = KeybindingWidget_1.ID;
        this.title.label = KeybindingWidget_1.LABEL;
        this.title.caption = KeybindingWidget_1.LABEL;
        this.title.iconClass = browser_1.codicon('three-bars');
        this.title.closable = true;
        this.update();
        // Initialize the list of keybinding items.
        this.items = this.getItems();
        // Listen to changes made in the `keymaps.json` and update the view accordingly.
        if (this.keymapsService.onDidChangeKeymaps) {
            this.toDispose.push(this.keymapsService.onDidChangeKeymaps(() => {
                this.doSearchKeybindings();
                this.update();
            }));
        }
    }
    /**
     * Determine if there currently is a search term.
     * @returns `true` if a search term is present.
     */
    hasSearch() {
        return !!this.query.length;
    }
    /**
     * Clear the search and reset the view.
     */
    clearSearch() {
        const search = this.findSearchField();
        if (search) {
            search.value = '';
            this.query = '';
            this.doSearchKeybindings();
        }
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        this.focusInputField();
    }
    /**
     * Perform a search based on the user's search query.
     */
    doSearchKeybindings() {
        this.onDidUpdateEmitter.fire(undefined);
        this.items = [];
        const searchField = this.findSearchField();
        this.query = searchField ? searchField.value.trim().toLocaleLowerCase() : '';
        const items = this.getItems();
        items.forEach(item => {
            const keys = ['command', 'keybinding', 'context', 'source'];
            let matched = false;
            for (const key of keys) {
                const string = item.labels[key];
                if (string) {
                    const fuzzyMatch = fuzzy.match(this.query, string, this.fuzzyOptions);
                    if (fuzzyMatch) {
                        item.labels[key] = fuzzyMatch.rendered;
                        matched = true;
                    }
                    else {
                        // Match identical keybindings that have different orders.
                        if (key === 'keybinding') {
                            const queryItems = this.query.split('+');
                            // Handle key chords.
                            const tempItems = string.split(' ');
                            // Store positions of `space` in the keybinding string.
                            const spaceIndexArr = [0];
                            let bindingItems = [];
                            if (tempItems.length > 1) {
                                tempItems.forEach(tItem => {
                                    const tKeys = tItem.split('+');
                                    spaceIndexArr.push(tKeys.length + spaceIndexArr[-1]);
                                    bindingItems.push(...tKeys);
                                });
                            }
                            else {
                                bindingItems = string.split('+');
                            }
                            spaceIndexArr.shift();
                            const renderedResult = [...bindingItems];
                            let matchCounter = 0;
                            queryItems.forEach(queryItem => {
                                let keyFuzzyMatch = { rendered: '', score: 0 };
                                let keyIndex = -1;
                                if (string) {
                                    bindingItems.forEach((bindingItem) => {
                                        // Match every key in user query with every key in keybinding string.
                                        const tempFuzzyMatch = fuzzy.match(queryItem, bindingItem, this.fuzzyOptions);
                                        // Select the match with the highest matching score.
                                        if (tempFuzzyMatch && tempFuzzyMatch.score > keyFuzzyMatch.score) {
                                            keyFuzzyMatch = tempFuzzyMatch;
                                            // Get index in the keybinding array.
                                            keyIndex = renderedResult.indexOf(bindingItem);
                                        }
                                    });
                                    const keyRendered = keyFuzzyMatch.rendered;
                                    if (keyRendered) {
                                        if (keyIndex > -1) {
                                            renderedResult[keyIndex] = keyRendered;
                                        }
                                        // Remove key from keybinding items if it is matched.
                                        bindingItems.splice(keyIndex, 1, '');
                                        matchCounter += 1;
                                    }
                                }
                            });
                            if (matchCounter === queryItems.length) {
                                // Handle rendering of key chords.
                                if (spaceIndexArr.length > 0) {
                                    const chordRenderedResult = '';
                                    renderedResult.forEach((resultKey, index) => {
                                        if (index === 0) {
                                            chordRenderedResult.concat(resultKey);
                                        }
                                        else if (spaceIndexArr.indexOf(index) !== -1) {
                                            chordRenderedResult.concat(' ' + resultKey);
                                        }
                                        else {
                                            chordRenderedResult.concat('+' + resultKey);
                                        }
                                    });
                                    item.labels[key] = chordRenderedResult;
                                }
                                item.labels[key] = renderedResult.join('+');
                                matched = true;
                            }
                        }
                    }
                }
            }
            if (matched) {
                this.items.push(item);
            }
        });
        this.update();
    }
    /**
     * Get the search input if available.
     * @returns the search input if available.
     */
    findSearchField() {
        return document.getElementById('search-kb');
    }
    /**
     * Set the focus the search input field if available.
     */
    focusInputField() {
        const input = document.getElementById('search-kb');
        if (input) {
            input.focus();
            input.select();
        }
    }
    /**
     * Render the view.
     */
    render() {
        return React.createElement("div", { id: 'kb-main-container' },
            this.renderSearch(),
            (this.items.length > 0) ? this.renderTable() : this.renderMessage());
    }
    /**
     * Render the search container with the search input.
     */
    renderSearch() {
        return React.createElement("div", null,
            React.createElement("div", { className: 'search-kb-container' },
                React.createElement("input", { id: 'search-kb', className: `theia-input${(this.items.length > 0) ? '' : ' no-kb'}`, type: 'text', spellCheck: false, placeholder: 'Search keybindings', autoComplete: 'off', onKeyUp: this.searchKeybindings })));
    }
    /**
     * Render the warning message when no search results are found.
     */
    renderMessage() {
        return React.createElement(alert_message_1.AlertMessage, { type: 'WARNING', header: 'No results found!' });
    }
    /**
     * Render the keybindings table.
     */
    renderTable() {
        return React.createElement("div", { id: 'kb-table-container' },
            React.createElement("div", { className: 'kb' },
                React.createElement("table", null,
                    React.createElement("thead", null,
                        React.createElement("tr", null,
                            React.createElement("th", { className: 'th-action' }),
                            React.createElement("th", { className: 'th-label' }, "Command"),
                            React.createElement("th", { className: 'th-keybinding' }, "Keybinding"),
                            React.createElement("th", { className: 'th-context' }, "Context / When"),
                            React.createElement("th", { className: 'th-source' }, "Source"))),
                    React.createElement("tbody", null, this.renderRows()))));
    }
    /**
     * Render the table rows.
     */
    renderRows() {
        return React.createElement(React.Fragment, null, this.items.map((item, index) => this.renderRow(item, index)));
    }
    renderRow(item, index) {
        const { command, keybinding } = item;
        // TODO get rid of array functions in event handlers
        return React.createElement("tr", { className: 'kb-item-row', key: index, onDoubleClick: () => this.editKeybinding(item) },
            React.createElement("td", { className: 'kb-actions' }, this.renderActions(item)),
            React.createElement("td", { className: 'kb-label', title: this.getCommandLabel(command) }, this.renderMatchedData(item.labels.command)),
            React.createElement("td", { title: this.getKeybindingLabel(keybinding), className: 'kb-keybinding monaco-keybinding' }, this.renderKeybinding(item.labels.keybinding)),
            React.createElement("td", { className: 'kb-context', title: this.getContextLabel(keybinding) },
                React.createElement("code", null, this.renderMatchedData(item.labels.context))),
            React.createElement("td", { className: 'kb-source', title: this.getScopeLabel(keybinding) },
                React.createElement("code", { className: 'td-source' }, this.renderMatchedData(item.labels.source))));
    }
    /**
     * Render the actions container with action icons.
     * @param item the keybinding item for the row.
     */
    renderActions(item) {
        return React.createElement("span", { className: 'kb-actions-icons' },
            this.renderEdit(item),
            this.renderReset(item));
    }
    /**
     * Render the edit action used to update a keybinding.
     * @param item the keybinding item for the row.
     */
    renderEdit(item) {
        return React.createElement("a", { title: 'Edit Keybinding', href: '#', onClick: e => {
                e.preventDefault();
                this.editKeybinding(item);
            } },
            React.createElement("i", { className: `${browser_1.codicon('edit')} kb-action-item` }));
    }
    /**
     * Render the reset action to reset the custom keybinding.
     * Only visible if a keybinding has a `user` scope.
     * @param item the keybinding item for the row.
     */
    renderReset(item) {
        return (item.keybinding && item.keybinding.scope === browser_1.KeybindingScope.USER)
            ? React.createElement("a", { title: 'Reset Keybinding', href: '#', onClick: e => {
                    e.preventDefault();
                    this.resetKeybinding(item);
                } },
                React.createElement("i", { className: `${browser_1.codicon('discard')} kb-action-item` })) : '';
    }
    /**
     * Render the keybinding.
     * @param keybinding the keybinding value.
     */
    renderKeybinding(keybinding) {
        if (!keybinding.length) {
            return undefined;
        }
        const regex = new RegExp(this.keybindingSeparator);
        keybinding = keybinding.replace(regex, '+');
        const keys = keybinding.split('+');
        return React.createElement(React.Fragment, null, keys.map((key, index) => {
            if (index === 0) {
                return React.createElement("span", { key: index, className: 'monaco-keybinding-key' }, this.renderMatchedData(key));
            }
            else if (key.includes(' ')) {
                // Handle key chords, which have space as the separator
                // Example: `k Ctrl` in key chords `Ctrl+k Ctrl+p`
                let chordKeys = key.split('<match> </match>');
                if (chordKeys.length === 1) {
                    chordKeys = key.split(' ');
                }
                return React.createElement(React.Fragment, { key: index },
                    React.createElement("span", { className: 'monaco-keybinding-separator' }, "+"),
                    React.createElement("span", { className: 'monaco-keybinding-key' }, this.renderKeybinding(chordKeys[0])),
                    React.createElement("span", { className: 'monaco-keybinding-separator' }, "\u00A0\u00A0"),
                    React.createElement("span", { className: 'monaco-keybinding-key' }, this.renderKeybinding(chordKeys[1])));
            }
            else {
                return React.createElement(React.Fragment, { key: index },
                    React.createElement("span", { className: 'monaco-keybinding-separator' }, "+"),
                    React.createElement("span", { className: 'monaco-keybinding-key' }, this.renderKeybinding(key)));
            }
        }));
    }
    /**
     * Get the list of keybinding items.
     *
     * @returns the list of keybinding items.
     */
    getItems() {
        // Sort the commands alphabetically.
        const commands = this.commandRegistry.commands;
        const items = [];
        // Build the keybinding items.
        for (let i = 0; i < commands.length; i++) {
            const command = commands[i];
            // Skip internal commands prefixed by `_`.
            if (command.id.startsWith('_')) {
                continue;
            }
            const keybinding = this.keybindingRegistry.getKeybindingsForCommand(command.id)[0];
            items.push({
                command,
                keybinding,
                labels: {
                    id: command.id,
                    command: this.getCommandLabel(command),
                    keybinding: this.getKeybindingLabel(keybinding) || '',
                    context: this.getContextLabel(keybinding) || '',
                    source: this.getScopeLabel(keybinding) || ''
                }
            });
        }
        // Sort the keybinding item by label.
        const sorted = items.sort((a, b) => this.compareItem(a.command, b.command));
        // Get the list of keybinding item with keybindings (visually put them at the top of the table).
        const keyItems = sorted.filter(a => !!a.labels.keybinding);
        // Get the remaining keybinding items (without keybindings).
        const otherItems = sorted.filter(a => !a.labels.keybinding);
        // Return the list of keybinding items prioritizing those with a defined keybinding.
        return [...keyItems, ...otherItems];
    }
    /**
     * Get the human-readable label for a given command.
     * @param command the command.
     *
     * @returns a human-readable label for the given command.
     */
    getCommandLabel(command) {
        if (command.label) {
            // Prefix the command label with the category if it exists, else return the simple label.
            return command.category ? `${command.category}: ${command.label}` : command.label;
        }
        return command.id;
    }
    getKeybindingLabel(keybinding) {
        return keybinding && keybinding.keybinding;
    }
    getContextLabel(keybinding) {
        return keybinding ? keybinding.context || keybinding.when : undefined;
    }
    getScopeLabel(keybinding) {
        let scope = keybinding && keybinding.scope;
        if (scope !== undefined) {
            if (scope < browser_1.KeybindingScope.USER) {
                scope = browser_1.KeybindingScope.DEFAULT;
            }
            return browser_1.KeybindingScope[scope].toLocaleLowerCase();
        }
        return undefined;
    }
    /**
     * Compare two commands.
     * - Commands with a label should be prioritized and alphabetically sorted.
     * - Commands without a label (id) should be placed at the bottom.
     * @param a the first command.
     * @param b the second command.
     *
     * @returns an integer indicating whether `a` comes before, after or is equivalent to `b`.
     * - returns `-1` if `a` occurs before `b`.
     * - returns `1` if `a` occurs after `b`.
     * - returns `0` if they are equivalent.
     */
    compareItem(a, b) {
        const labelA = this.getCommandLabel(a);
        const labelB = this.getCommandLabel(b);
        if (labelA === a.id && labelB === b.id) {
            return labelA.toLowerCase().localeCompare(labelB.toLowerCase());
        }
        if (labelA === a.id) {
            return 1;
        }
        if (labelB === b.id) {
            return -1;
        }
        return labelA.toLowerCase().localeCompare(labelB.toLowerCase());
    }
    /**
     * Prompt users to update the keybinding for the given command.
     * @param item the keybinding item.
     */
    editKeybinding(item) {
        const command = item.command.id;
        const oldKeybinding = item.keybinding && item.keybinding.keybinding;
        const dialog = new EditKeybindingDialog({
            title: `Edit Keybinding for ${command}`,
            initialValue: oldKeybinding,
            validate: newKeybinding => this.validateKeybinding(command, oldKeybinding, newKeybinding),
        }, this.keymapsService, item);
        dialog.open().then(async (keybinding) => {
            if (keybinding) {
                await this.keymapsService.setKeybinding(Object.assign(Object.assign({}, item.keybinding), { command,
                    keybinding }), oldKeybinding);
            }
        });
    }
    /**
     * Prompt users for confirmation before resetting.
     * @param command the command label.
     *
     * @returns a Promise which resolves to `true` if a user accepts resetting.
     */
    async confirmResetKeybinding(item) {
        const dialog = new browser_1.ConfirmDialog({
            title: `Reset keybinding for '${this.getCommandLabel(item.command)}'`,
            msg: 'Do you really want to reset this keybinding to its default value?'
        });
        return !!await dialog.open();
    }
    /**
     * Reset the keybinding to its default value.
     * @param item the keybinding item.
     */
    async resetKeybinding(item) {
        const confirmed = await this.confirmResetKeybinding(item);
        if (confirmed) {
            this.keymapsService.removeKeybinding(item.command.id);
        }
    }
    /**
     * Validate the provided keybinding value against its previous value.
     * @param command the command label.
     * @param oldKeybinding the old keybinding value.
     * @param keybinding the new keybinding value.
     *
     * @returns the end user message to display.
     */
    validateKeybinding(command, oldKeybinding, keybinding) {
        if (!keybinding) {
            return 'keybinding value is required';
        }
        try {
            const binding = { command, keybinding };
            browser_1.KeySequence.parse(keybinding);
            if (oldKeybinding === keybinding) {
                return ' '; // if old and new keybindings match, quietly reject update
            }
            if (this.keybindingRegistry.containsKeybindingInScope(binding)) {
                return 'keybinding currently collides';
            }
            return '';
        }
        catch (error) {
            return error;
        }
    }
    /**
     * Build the cell data with highlights if applicable.
     * @param raw the raw cell value.
     *
     * @returns the list of cell data.
     */
    buildCellData(raw) {
        const data = [];
        if (this.query === '') {
            return data;
        }
        let following = raw;
        let leading;
        let result;
        const regexp = new RegExp(this.regexp);
        while (result = regexp.exec(raw)) {
            const splitLeftIndex = following.indexOf(result[0]);
            const splitRightIndex = splitLeftIndex + result[0].length;
            leading = following.slice(0, splitLeftIndex);
            following = following.slice(splitRightIndex);
            if (leading) {
                data.push({ value: leading, highlighted: false });
            }
            data.push({ value: result[1], highlighted: true });
        }
        if (following) {
            data.push({ value: following, highlighted: false });
        }
        return data;
    }
    /**
     * Render the fuzzy representation of a matched result.
     * @param property one of the `KeybindingItem` properties.
     */
    renderMatchedData(property) {
        if (this.query !== '') {
            const cellData = this.buildCellData(property);
            return React.createElement(React.Fragment, null, cellData.map((data, index) => (data.highlighted) ? React.createElement("span", { key: index, className: 'fuzzy-match' }, data.value) : React.createElement("span", { key: index }, data.value)));
        }
        else {
            return property;
        }
    }
};
KeybindingWidget.ID = 'keybindings.view.widget';
KeybindingWidget.LABEL = 'Keyboard Shortcuts';
__decorate([
    inversify_1.inject(command_1.CommandRegistry),
    __metadata("design:type", command_1.CommandRegistry)
], KeybindingWidget.prototype, "commandRegistry", void 0);
__decorate([
    inversify_1.inject(browser_1.KeybindingRegistry),
    __metadata("design:type", browser_1.KeybindingRegistry)
], KeybindingWidget.prototype, "keybindingRegistry", void 0);
__decorate([
    inversify_1.inject(keymaps_service_1.KeymapsService),
    __metadata("design:type", keymaps_service_1.KeymapsService)
], KeybindingWidget.prototype, "keymapsService", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], KeybindingWidget.prototype, "init", null);
KeybindingWidget = KeybindingWidget_1 = __decorate([
    inversify_1.injectable()
], KeybindingWidget);
exports.KeybindingWidget = KeybindingWidget;
/**
 * Dialog used to edit keybindings, and reset custom keybindings.
 */
let EditKeybindingDialog = class EditKeybindingDialog extends browser_1.SingleTextInputDialog {
    constructor(props, keymapsService, item) {
        super(props);
        this.props = props;
        this.keymapsService = keymapsService;
        this.item = item;
        // Add the `Reset` button if the command currently has a custom keybinding.
        if (this.item.keybinding && this.item.keybinding.scope === browser_1.KeybindingScope.USER) {
            this.appendResetButton();
        }
    }
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        if (this.resetButton) {
            this.addResetAction(this.resetButton, 'click');
        }
    }
    /**
     * Add `Reset` action used to reset a custom keybinding, and close the dialog.
     * @param element the HTML element in question.
     * @param additionalEventTypes additional event types.
     */
    addResetAction(element, ...additionalEventTypes) {
        this.addKeyListener(element, browser_1.Key.ENTER, () => {
            this.reset();
            this.close();
        }, ...additionalEventTypes);
    }
    /**
     * Create the `Reset` button, and append it to the dialog.
     *
     * @returns the `Reset` button.
     */
    appendResetButton() {
        // Create the `Reset` button.
        this.resetButton = this.createButton('Reset');
        // Add the `Reset` button to the dialog control panel, before the `Accept` button.
        this.controlPanel.insertBefore(this.resetButton, this.acceptButton);
        this.resetButton.title = 'Reset Keybinding';
        this.resetButton.classList.add('secondary');
        return this.resetButton;
    }
    /**
     * Perform keybinding reset.
     */
    reset() {
        this.keymapsService.removeKeybinding(this.item.command.id);
    }
};
EditKeybindingDialog = __decorate([
    __param(0, inversify_1.inject(browser_1.SingleTextInputDialogProps)),
    __param(1, inversify_1.inject(keymaps_service_1.KeymapsService)),
    __metadata("design:paramtypes", [browser_1.SingleTextInputDialogProps,
        keymaps_service_1.KeymapsService, Object])
], EditKeybindingDialog);


/***/ }),

/***/ "./node_modules/@theia/keymaps/lib/browser/keymaps-frontend-contribution.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@theia/keymaps/lib/browser/keymaps-frontend-contribution.js ***!
  \**********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.KeymapsFrontendContribution = exports.KeymapsCommands = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "./node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const common_frontend_contribution_1 = __webpack_require__(/*! @theia/core/lib/browser/common-frontend-contribution */ "./node_modules/@theia/core/lib/browser/common-frontend-contribution.js");
const keymaps_service_1 = __webpack_require__(/*! ./keymaps-service */ "./node_modules/@theia/keymaps/lib/browser/keymaps-service.js");
const keybindings_widget_1 = __webpack_require__(/*! ./keybindings-widget */ "./node_modules/@theia/keymaps/lib/browser/keybindings-widget.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "./node_modules/@theia/core/lib/common/nls.js");
var KeymapsCommands;
(function (KeymapsCommands) {
    KeymapsCommands.OPEN_KEYMAPS = common_1.Command.toDefaultLocalizedCommand({
        id: 'keymaps:open',
        category: common_frontend_contribution_1.CommonCommands.PREFERENCES_CATEGORY,
        label: 'Open Keyboard Shortcuts',
    });
    KeymapsCommands.OPEN_KEYMAPS_JSON = common_1.Command.toDefaultLocalizedCommand({
        id: 'keymaps:openJson',
        category: common_frontend_contribution_1.CommonCommands.PREFERENCES_CATEGORY,
        label: 'Open Keyboard Shortcuts (JSON)',
    });
    KeymapsCommands.OPEN_KEYMAPS_JSON_TOOLBAR = {
        id: 'keymaps:openJson.toolbar',
        iconClass: browser_1.codicon('json')
    };
    KeymapsCommands.CLEAR_KEYBINDINGS_SEARCH = {
        id: 'keymaps.clearSearch',
        iconClass: browser_1.codicon('clear-all')
    };
})(KeymapsCommands = exports.KeymapsCommands || (exports.KeymapsCommands = {}));
let KeymapsFrontendContribution = class KeymapsFrontendContribution extends browser_1.AbstractViewContribution {
    constructor() {
        super({
            widgetId: keybindings_widget_1.KeybindingWidget.ID,
            widgetName: keybindings_widget_1.KeybindingWidget.LABEL,
            defaultWidgetOptions: {
                area: 'main'
            },
        });
    }
    registerCommands(commands) {
        commands.registerCommand(KeymapsCommands.OPEN_KEYMAPS, {
            isEnabled: () => true,
            execute: () => this.openView({ activate: true })
        });
        commands.registerCommand(KeymapsCommands.OPEN_KEYMAPS_JSON, {
            isEnabled: () => true,
            execute: () => this.keymaps.open()
        });
        commands.registerCommand(KeymapsCommands.OPEN_KEYMAPS_JSON_TOOLBAR, {
            isEnabled: w => this.withWidget(w, () => true),
            isVisible: w => this.withWidget(w, () => true),
            execute: w => this.withWidget(w, widget => this.keymaps.open(widget)),
        });
        commands.registerCommand(KeymapsCommands.CLEAR_KEYBINDINGS_SEARCH, {
            isEnabled: w => this.withWidget(w, widget => widget.hasSearch()),
            isVisible: w => this.withWidget(w, () => true),
            execute: w => this.withWidget(w, widget => widget.clearSearch()),
        });
    }
    registerMenus(menus) {
        menus.registerMenuAction(common_frontend_contribution_1.CommonMenus.FILE_SETTINGS_SUBMENU_OPEN, {
            commandId: KeymapsCommands.OPEN_KEYMAPS.id,
            order: 'a20'
        });
        menus.registerMenuAction(common_frontend_contribution_1.CommonMenus.SETTINGS_OPEN, {
            commandId: KeymapsCommands.OPEN_KEYMAPS.id,
            order: 'a20'
        });
    }
    registerKeybindings(keybindings) {
        keybindings.registerKeybinding({
            command: KeymapsCommands.OPEN_KEYMAPS.id,
            keybinding: 'ctrl+alt+,'
        });
    }
    async registerToolbarItems(toolbar) {
        const widget = await this.widget;
        const onDidChange = widget.onDidUpdate;
        toolbar.registerItem({
            id: KeymapsCommands.OPEN_KEYMAPS_JSON_TOOLBAR.id,
            command: KeymapsCommands.OPEN_KEYMAPS_JSON_TOOLBAR.id,
            tooltip: nls_1.nls.localizeByDefault('Open Keyboard Shortcuts (JSON)'),
            priority: 0,
        });
        toolbar.registerItem({
            id: KeymapsCommands.CLEAR_KEYBINDINGS_SEARCH.id,
            command: KeymapsCommands.CLEAR_KEYBINDINGS_SEARCH.id,
            tooltip: nls_1.nls.localizeByDefault('Clear Keybindings Search Input'),
            priority: 1,
            onDidChange,
        });
    }
    /**
     * Determine if the current widget is the keybindings widget.
     */
    withWidget(widget = this.tryGetWidget(), fn) {
        if (widget instanceof keybindings_widget_1.KeybindingWidget && widget.id === keybindings_widget_1.KeybindingWidget.ID) {
            return fn(widget);
        }
        return false;
    }
};
__decorate([
    inversify_1.inject(keymaps_service_1.KeymapsService),
    __metadata("design:type", keymaps_service_1.KeymapsService)
], KeymapsFrontendContribution.prototype, "keymaps", void 0);
KeymapsFrontendContribution = __decorate([
    inversify_1.injectable(),
    __metadata("design:paramtypes", [])
], KeymapsFrontendContribution);
exports.KeymapsFrontendContribution = KeymapsFrontendContribution;


/***/ }),

/***/ "./node_modules/@theia/keymaps/lib/browser/keymaps-service.js":
/*!********************************************************************!*\
  !*** ./node_modules/@theia/keymaps/lib/browser/keymaps-service.js ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2017 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.KeymapsService = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const keybinding_1 = __webpack_require__(/*! @theia/core/lib/browser/keybinding */ "./node_modules/@theia/core/lib/browser/keybinding.js");
const keybinding_2 = __webpack_require__(/*! @theia/core/lib/common/keybinding */ "./node_modules/@theia/core/lib/common/keybinding.js");
const browser_2 = __webpack_require__(/*! @theia/userstorage/lib/browser */ "./node_modules/@theia/userstorage/lib/browser/index.js");
const jsoncparser = __webpack_require__(/*! jsonc-parser */ "./node_modules/jsonc-parser/lib/esm/main.js");
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "./node_modules/@theia/core/lib/common/event.js");
const monaco_text_model_service_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-text-model-service */ "./node_modules/@theia/monaco/lib/browser/monaco-text-model-service.js");
const promise_util_1 = __webpack_require__(/*! @theia/core/lib/common/promise-util */ "./node_modules/@theia/core/lib/common/promise-util.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "./node_modules/@theia/core/lib/common/uri.js");
const monaco_workspace_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-workspace */ "./node_modules/@theia/monaco/lib/browser/monaco-workspace.js");
const message_service_1 = __webpack_require__(/*! @theia/core/lib/common/message-service */ "./node_modules/@theia/core/lib/common/message-service.js");
let KeymapsService = class KeymapsService {
    constructor() {
        this.changeKeymapEmitter = new event_1.Emitter();
        this.onDidChangeKeymaps = this.changeKeymapEmitter.event;
        this.deferredModel = new promise_util_1.Deferred();
    }
    /**
     * Initialize the keybinding service.
     */
    async init() {
        const reference = await this.textModelService.createModelReference(browser_2.UserStorageUri.resolve('keymaps.json'));
        this.model = reference.object;
        this.deferredModel.resolve(this.model);
        this.reconcile();
        this.model.onDidChangeContent(() => this.reconcile());
        this.model.onDirtyChanged(() => this.reconcile());
        this.model.onDidChangeValid(() => this.reconcile());
        this.keybindingRegistry.onKeybindingsChanged(() => this.changeKeymapEmitter.fire(undefined));
    }
    /**
     * Reconcile all the keybindings, registering them to the registry.
     */
    reconcile() {
        const model = this.model;
        if (!model || model.dirty) {
            return;
        }
        try {
            const keybindings = [];
            if (model.valid) {
                const content = model.getText();
                const json = jsoncparser.parse(content, undefined, { disallowComments: false });
                if (Array.isArray(json)) {
                    for (const value of json) {
                        if (keybinding_2.Keybinding.is(value)) {
                            keybindings.push(value);
                        }
                        else if (keybinding_2.RawKeybinding.is(value)) {
                            keybindings.push(keybinding_2.Keybinding.apiObjectify(value));
                        }
                    }
                }
            }
            this.keybindingRegistry.setKeymap(keybinding_1.KeybindingScope.USER, keybindings);
        }
        catch (e) {
            console.error(`Failed to load keymaps from '${model.uri}'.`, e);
        }
    }
    /**
     * Open the keybindings widget.
     * @param ref the optional reference for opening the widget.
     */
    async open(ref) {
        const model = await this.deferredModel.promise;
        const options = {
            widgetOptions: ref ? { area: 'main', mode: 'split-right', ref } : { area: 'main' },
            mode: 'activate'
        };
        if (!model.valid) {
            await model.save();
        }
        await browser_1.open(this.opener, new uri_1.default(model.uri), options);
    }
    /**
     * Set the keybinding in the JSON.
     * @param newKeybinding the JSON keybindings.
     */
    async setKeybinding(newKeybinding, oldKeybinding) {
        return this.updateKeymap(() => {
            let newAdded = false;
            let oldRemoved = false;
            const keybindings = [];
            for (let keybinding of this.keybindingRegistry.getKeybindingsByScope(keybinding_1.KeybindingScope.USER)) {
                if (keybinding_2.Keybinding.equals(keybinding, newKeybinding, true, true)) {
                    newAdded = true;
                    keybinding = Object.assign(Object.assign({}, keybinding), { keybinding: newKeybinding.keybinding });
                }
                if (oldKeybinding && keybinding_2.Keybinding.equals(keybinding, Object.assign(Object.assign({}, newKeybinding), { keybinding: oldKeybinding, command: '-' + newKeybinding.command }), false, true)) {
                    oldRemoved = true;
                }
                keybindings.push(keybinding);
            }
            if (!newAdded) {
                keybindings.push({
                    command: newKeybinding.command,
                    keybinding: newKeybinding.keybinding,
                    context: newKeybinding.context,
                    when: newKeybinding.when,
                    args: newKeybinding.args
                });
                newAdded = true;
            }
            if (!oldRemoved && oldKeybinding) {
                const disabledBinding = {
                    command: '-' + newKeybinding.command,
                    // TODO key: oldKeybinding, see https://github.com/eclipse-theia/theia/issues/6879
                    keybinding: oldKeybinding,
                    context: newKeybinding.context,
                    when: newKeybinding.when,
                    args: newKeybinding.args
                };
                // Add disablement of the old keybinding if it isn't already disabled in the list to avoid duplicate disabled entries
                if (!keybindings.some(binding => keybinding_2.Keybinding.equals(binding, disabledBinding, true, true))) {
                    keybindings.push(disabledBinding);
                }
                oldRemoved = true;
            }
            if (newAdded || oldRemoved) {
                return keybindings;
            }
        });
    }
    /**
     * Remove the given keybinding with the given command id from the JSON.
     * @param commandId the keybinding command id.
     */
    removeKeybinding(commandId) {
        return this.updateKeymap(() => {
            const keybindings = this.keybindingRegistry.getKeybindingsByScope(keybinding_1.KeybindingScope.USER);
            const removedCommand = '-' + commandId;
            const filtered = keybindings.filter(a => a.command !== commandId && a.command !== removedCommand);
            if (filtered.length !== keybindings.length) {
                return filtered;
            }
        });
    }
    async updateKeymap(op) {
        const model = await this.deferredModel.promise;
        try {
            const keybindings = op();
            if (keybindings) {
                const content = model.getText().trim();
                const textModel = model.textEditorModel;
                const { insertSpaces, tabSize, defaultEOL } = textModel.getOptions();
                const editOperations = [];
                for (const edit of jsoncparser.modify(content, [], keybindings.map(binding => keybinding_2.Keybinding.apiObjectify(binding)), {
                    formattingOptions: {
                        insertSpaces,
                        tabSize,
                        eol: defaultEOL === monaco.editor.DefaultEndOfLine.LF ? '\n' : '\r\n'
                    }
                })) {
                    const start = textModel.getPositionAt(edit.offset);
                    const end = textModel.getPositionAt(edit.offset + edit.length);
                    editOperations.push({
                        range: monaco.Range.fromPositions(start, end),
                        text: edit.content,
                        forceMoveMarkers: false
                    });
                }
                await this.workspace.applyBackgroundEdit(model, editOperations);
            }
        }
        catch (e) {
            const message = `Failed to update a keymap in '${model.uri}'.`;
            this.messageService.error(`${message} Please check if it is corrupted.`);
            console.error(`${message}`, e);
        }
    }
};
__decorate([
    inversify_1.inject(monaco_workspace_1.MonacoWorkspace),
    __metadata("design:type", monaco_workspace_1.MonacoWorkspace)
], KeymapsService.prototype, "workspace", void 0);
__decorate([
    inversify_1.inject(monaco_text_model_service_1.MonacoTextModelService),
    __metadata("design:type", monaco_text_model_service_1.MonacoTextModelService)
], KeymapsService.prototype, "textModelService", void 0);
__decorate([
    inversify_1.inject(keybinding_1.KeybindingRegistry),
    __metadata("design:type", keybinding_1.KeybindingRegistry)
], KeymapsService.prototype, "keybindingRegistry", void 0);
__decorate([
    inversify_1.inject(browser_1.OpenerService),
    __metadata("design:type", Object)
], KeymapsService.prototype, "opener", void 0);
__decorate([
    inversify_1.inject(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], KeymapsService.prototype, "messageService", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], KeymapsService.prototype, "init", null);
KeymapsService = __decorate([
    inversify_1.injectable()
], KeymapsService);
exports.KeymapsService = KeymapsService;


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_keymaps_lib_browser_keymaps-frontend-contribution_js.bundle.js.map