"use strict";
(global["webpackChunkarduino_ide"] = global["webpackChunkarduino_ide"] || []).push([["vendors-node_modules_theia_git_lib_electron-browser_prompt_electron-git-prompt-module_js"],{

/***/ "./node_modules/@theia/git/lib/browser/prompt/git-prompt-module.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@theia/git/lib/browser/prompt/git-prompt-module.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.bindPromptServer = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const ws_connection_provider_1 = __webpack_require__(/*! @theia/core/lib/browser/messaging/ws-connection-provider */ "./node_modules/@theia/core/lib/browser/messaging/ws-connection-provider.js");
const git_prompt_1 = __webpack_require__(/*! ../../common/git-prompt */ "./node_modules/@theia/git/lib/common/git-prompt.js");
exports["default"] = new inversify_1.ContainerModule(bind => {
    bind(git_prompt_1.GitPrompt).toSelf();
    bindPromptServer(bind);
});
function bindPromptServer(bind) {
    bind(git_prompt_1.GitPromptServer).to(git_prompt_1.GitPromptServerImpl).inSingletonScope();
    bind(git_prompt_1.GitPromptServerProxy).toDynamicValue(context => ws_connection_provider_1.WebSocketConnectionProvider.createProxy(context.container, git_prompt_1.GitPrompt.WS_PATH)).inSingletonScope();
}
exports.bindPromptServer = bindPromptServer;


/***/ }),

/***/ "./node_modules/@theia/git/lib/common/git-prompt.js":
/*!**********************************************************!*\
  !*** ./node_modules/@theia/git/lib/common/git-prompt.js ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var GitPrompt_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GitPromptServerImpl = exports.GitPromptClient = exports.GitPrompt = exports.GitPromptServerProxy = exports.GitPromptServer = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const disposable_1 = __webpack_require__(/*! @theia/core/lib/common/disposable */ "./node_modules/@theia/core/lib/common/disposable.js");
exports.GitPromptServer = Symbol('GitPromptServer');
exports.GitPromptServerProxy = Symbol('GitPromptServerProxy');
let GitPrompt = GitPrompt_1 = class GitPrompt {
    constructor() {
        this.toDispose = new disposable_1.DisposableCollection();
    }
    init() {
        this.server.setClient(this);
    }
    dispose() {
        this.toDispose.dispose();
    }
    async ask(question) {
        return GitPrompt_1.Failure.create('Interactive Git prompt is not supported in the browser.');
    }
};
__decorate([
    inversify_1.inject(exports.GitPromptServer),
    __metadata("design:type", Object)
], GitPrompt.prototype, "server", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], GitPrompt.prototype, "init", null);
GitPrompt = GitPrompt_1 = __decorate([
    inversify_1.injectable()
], GitPrompt);
exports.GitPrompt = GitPrompt;
(function (GitPrompt) {
    /**
     * Unique WS endpoint path for the Git prompt service.
     */
    GitPrompt.WS_PATH = 'services/git-prompt';
    let Success;
    (function (Success) {
        function is(answer) {
            return answer.type === Answer.Type.SUCCESS
                && 'result' in answer
                && ((typeof answer.result) === 'string' || (typeof answer.result) === 'boolean');
        }
        Success.is = is;
        function create(result) {
            return {
                type: Answer.Type.SUCCESS,
                result
            };
        }
        Success.create = create;
    })(Success = GitPrompt.Success || (GitPrompt.Success = {}));
    let Cancel;
    (function (Cancel) {
        function is(answer) {
            return answer.type === Answer.Type.CANCEL;
        }
        Cancel.is = is;
        function create() {
            return {
                type: Answer.Type.CANCEL
            };
        }
        Cancel.create = create;
    })(Cancel = GitPrompt.Cancel || (GitPrompt.Cancel = {}));
    let Failure;
    (function (Failure) {
        function is(answer) {
            return answer.type === Answer.Type.FAILURE
                && 'error' in answer
                && ((typeof answer.error) === 'string' || answer.error instanceof Error);
        }
        Failure.is = is;
        function create(error) {
            return {
                type: Answer.Type.FAILURE,
                error
            };
        }
        Failure.create = create;
    })(Failure = GitPrompt.Failure || (GitPrompt.Failure = {}));
    let Answer;
    (function (Answer) {
        let Type;
        (function (Type) {
            Type[Type["SUCCESS"] = 0] = "SUCCESS";
            Type[Type["CANCEL"] = 1] = "CANCEL";
            Type[Type["FAILURE"] = 2] = "FAILURE";
        })(Type = Answer.Type || (Answer.Type = {}));
    })(Answer = GitPrompt.Answer || (GitPrompt.Answer = {}));
})(GitPrompt = exports.GitPrompt || (exports.GitPrompt = {}));
exports.GitPrompt = GitPrompt;
exports.GitPromptClient = Symbol('GitPromptClient');
/**
 * Note: This implementation is not reconnecting.
 * Git prompting is not supported in the browser. In electron, there's no need to reconnect.
 */
let GitPromptServerImpl = class GitPromptServerImpl {
    setClient(client) {
        this.proxy.setClient(client);
    }
    dispose() {
        this.proxy.dispose();
    }
};
__decorate([
    inversify_1.inject(exports.GitPromptServerProxy),
    __metadata("design:type", Object)
], GitPromptServerImpl.prototype, "proxy", void 0);
GitPromptServerImpl = __decorate([
    inversify_1.injectable()
], GitPromptServerImpl);
exports.GitPromptServerImpl = GitPromptServerImpl;


/***/ }),

/***/ "./node_modules/@theia/git/lib/electron-browser/prompt/electron-git-prompt-module.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@theia/git/lib/electron-browser/prompt/electron-git-prompt-module.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const git_prompt_1 = __webpack_require__(/*! ../../common/git-prompt */ "./node_modules/@theia/git/lib/common/git-prompt.js");
const git_prompt_module_1 = __webpack_require__(/*! ../../browser/prompt/git-prompt-module */ "./node_modules/@theia/git/lib/browser/prompt/git-prompt-module.js");
const git_quick_open_prompt_1 = __webpack_require__(/*! ./git-quick-open-prompt */ "./node_modules/@theia/git/lib/electron-browser/prompt/git-quick-open-prompt.js");
exports["default"] = new inversify_1.ContainerModule(bind => {
    bind(git_quick_open_prompt_1.GitQuickOpenPrompt).toSelf().inSingletonScope();
    bind(git_prompt_1.GitPrompt).toService(git_quick_open_prompt_1.GitQuickOpenPrompt);
    git_prompt_module_1.bindPromptServer(bind);
});


/***/ }),

/***/ "./node_modules/@theia/git/lib/electron-browser/prompt/git-quick-open-prompt.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@theia/git/lib/electron-browser/prompt/git-quick-open-prompt.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GitQuickOpenPrompt = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const PQueue = __webpack_require__(/*! p-queue */ "./node_modules/p-queue/index.js");
const git_prompt_1 = __webpack_require__(/*! ../../common/git-prompt */ "./node_modules/@theia/git/lib/common/git-prompt.js");
let GitQuickOpenPrompt = class GitQuickOpenPrompt extends git_prompt_1.GitPrompt {
    constructor() {
        super(...arguments);
        this.queue = new PQueue({ autoStart: true, concurrency: 1 });
    }
    async ask(question) {
        return this.queue.add(() => {
            const { details, text, password } = question;
            return new Promise(async (resolve) => {
                var _a;
                const result = await ((_a = this.quickInputService) === null || _a === void 0 ? void 0 : _a.input({
                    placeHolder: text,
                    prompt: details,
                    password,
                }));
                resolve(git_prompt_1.GitPrompt.Success.create(result));
            });
        });
    }
    dispose() {
        if (!this.queue.isPaused) {
            this.queue.pause();
        }
        this.queue.clear();
    }
};
__decorate([
    inversify_1.inject(browser_1.QuickInputService),
    inversify_1.optional(),
    __metadata("design:type", Object)
], GitQuickOpenPrompt.prototype, "quickInputService", void 0);
GitQuickOpenPrompt = __decorate([
    inversify_1.injectable()
], GitQuickOpenPrompt);
exports.GitQuickOpenPrompt = GitQuickOpenPrompt;


/***/ }),

/***/ "./node_modules/p-queue/index.js":
/*!***************************************!*\
  !*** ./node_modules/p-queue/index.js ***!
  \***************************************/
/***/ ((module) => {



// Port of lower_bound from http://en.cppreference.com/w/cpp/algorithm/lower_bound
// Used to compute insertion index to keep queue sorted after insertion
function lowerBound(array, value, comp) {
	let first = 0;
	let count = array.length;

	while (count > 0) {
		const step = (count / 2) | 0;
		let it = first + step;

		if (comp(array[it], value) <= 0) {
			first = ++it;
			count -= step + 1;
		} else {
			count = step;
		}
	}

	return first;
}

class PriorityQueue {
	constructor() {
		this._queue = [];
	}

	enqueue(run, opts) {
		opts = Object.assign({
			priority: 0
		}, opts);

		const element = {priority: opts.priority, run};

		if (this.size && this._queue[this.size - 1].priority >= opts.priority) {
			this._queue.push(element);
			return;
		}

		const index = lowerBound(this._queue, element, (a, b) => b.priority - a.priority);
		this._queue.splice(index, 0, element);
	}

	dequeue() {
		return this._queue.shift().run;
	}

	get size() {
		return this._queue.length;
	}
}

class PQueue {
	constructor(opts) {
		opts = Object.assign({
			concurrency: Infinity,
			autoStart: true,
			queueClass: PriorityQueue
		}, opts);

		if (!(typeof opts.concurrency === 'number' && opts.concurrency >= 1)) {
			throw new TypeError(`Expected \`concurrency\` to be a number from 1 and up, got \`${opts.concurrency}\` (${typeof opts.concurrency})`);
		}

		this.queue = new opts.queueClass(); // eslint-disable-line new-cap
		this._queueClass = opts.queueClass;
		this._pendingCount = 0;
		this._concurrency = opts.concurrency;
		this._isPaused = opts.autoStart === false;
		this._resolveEmpty = () => {};
		this._resolveIdle = () => {};
	}

	_next() {
		this._pendingCount--;

		if (this.queue.size > 0) {
			if (!this._isPaused) {
				this.queue.dequeue()();
			}
		} else {
			this._resolveEmpty();
			this._resolveEmpty = () => {};

			if (this._pendingCount === 0) {
				this._resolveIdle();
				this._resolveIdle = () => {};
			}
		}
	}

	add(fn, opts) {
		return new Promise((resolve, reject) => {
			const run = () => {
				this._pendingCount++;

				try {
					Promise.resolve(fn()).then(
						val => {
							resolve(val);
							this._next();
						},
						err => {
							reject(err);
							this._next();
						}
					);
				} catch (err) {
					reject(err);
					this._next();
				}
			};

			if (!this._isPaused && this._pendingCount < this._concurrency) {
				run();
			} else {
				this.queue.enqueue(run, opts);
			}
		});
	}

	addAll(fns, opts) {
		return Promise.all(fns.map(fn => this.add(fn, opts)));
	}

	start() {
		if (!this._isPaused) {
			return;
		}

		this._isPaused = false;
		while (this.queue.size > 0 && this._pendingCount < this._concurrency) {
			this.queue.dequeue()();
		}
	}

	pause() {
		this._isPaused = true;
	}

	clear() {
		this.queue = new this._queueClass(); // eslint-disable-line new-cap
	}

	onEmpty() {
		// Instantly resolve if the queue is empty
		if (this.queue.size === 0) {
			return Promise.resolve();
		}

		return new Promise(resolve => {
			const existingResolve = this._resolveEmpty;
			this._resolveEmpty = () => {
				existingResolve();
				resolve();
			};
		});
	}

	onIdle() {
		// Instantly resolve if none pending
		if (this._pendingCount === 0) {
			return Promise.resolve();
		}

		return new Promise(resolve => {
			const existingResolve = this._resolveIdle;
			this._resolveIdle = () => {
				existingResolve();
				resolve();
			};
		});
	}

	get size() {
		return this.queue.size;
	}

	get pending() {
		return this._pendingCount;
	}

	get isPaused() {
		return this._isPaused;
	}
}

module.exports = PQueue;


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_git_lib_electron-browser_prompt_electron-git-prompt-module_js.bundle.js.map