"use strict";
(global["webpackChunkarduino_ide"] = global["webpackChunkarduino_ide"] || []).push([["vendors-node_modules_theia_filesystem_lib_electron-browser_file-dialog_electron-file-dialog-m-56a414"],{

/***/ "./node_modules/@theia/core/lib/node/file-uri.js":
/*!*******************************************************!*\
  !*** ./node_modules/@theia/core/lib/node/file-uri.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileUri = void 0;
const vscode_uri_1 = __webpack_require__(/*! vscode-uri */ "./node_modules/vscode-uri/lib/esm/index.js");
const uri_1 = __webpack_require__(/*! ../common/uri */ "./node_modules/@theia/core/lib/common/uri.js");
const os_1 = __webpack_require__(/*! ../common/os */ "./node_modules/@theia/core/lib/common/os.js");
var FileUri;
(function (FileUri) {
    const windowsDriveRegex = /^([^:/?#]+?):$/;
    /**
     * Creates a new file URI from the filesystem path argument.
     * @param fsPath the filesystem path.
     */
    function create(fsPath_) {
        return new uri_1.default(vscode_uri_1.URI.file(fsPath_));
    }
    FileUri.create = create;
    /**
     * Returns with the platform specific FS path that is represented by the URI argument.
     *
     * @param uri the file URI that has to be resolved to a platform specific FS path.
     */
    function fsPath(uri) {
        if (typeof uri === 'string') {
            return fsPath(new uri_1.default(uri));
        }
        else {
            /*
             * A uri for the root of a Windows drive, eg file:\\\c%3A, is converted to c:
             * by the Uri class.  However file:\\\c%3A is unambiguously a uri to the root of
             * the drive and c: is interpreted as the default directory for the c drive
             * (by, for example, the readdir function in the fs-extra module).
             * A backslash must be appended to the drive, eg c:\, to ensure the correct path.
             */
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            const fsPathFromVsCodeUri = uri.codeUri.fsPath;
            if (os_1.isWindows) {
                const isWindowsDriveRoot = windowsDriveRegex.exec(fsPathFromVsCodeUri);
                if (isWindowsDriveRoot) {
                    return fsPathFromVsCodeUri + '\\';
                }
            }
            return fsPathFromVsCodeUri;
        }
    }
    FileUri.fsPath = fsPath;
})(FileUri = exports.FileUri || (exports.FileUri = {}));


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/electron-browser/file-dialog/electron-file-dialog-module.js":
/*!********************************************************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/electron-browser/file-dialog/electron-file-dialog-module.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const file_dialog_service_1 = __webpack_require__(/*! ../../browser/file-dialog/file-dialog-service */ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-service.js");
const electron_file_dialog_service_1 = __webpack_require__(/*! ./electron-file-dialog-service */ "./node_modules/@theia/filesystem/lib/electron-browser/file-dialog/electron-file-dialog-service.js");
exports["default"] = new inversify_1.ContainerModule(bind => {
    bind(electron_file_dialog_service_1.ElectronFileDialogService).toSelf().inSingletonScope();
    bind(file_dialog_service_1.FileDialogService).toService(electron_file_dialog_service_1.ElectronFileDialogService);
});


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/electron-browser/file-dialog/electron-file-dialog-service.js":
/*!*********************************************************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/electron-browser/file-dialog/electron-file-dialog-service.js ***!
  \*********************************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.electron = exports.ElectronFileDialogService = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const electronRemote = __webpack_require__(/*! @theia/core/electron-shared/@electron/remote */ "./node_modules/@theia/core/electron-shared/@electron/remote/index.js");
const os_1 = __webpack_require__(/*! @theia/core/lib/common/os */ "./node_modules/@theia/core/lib/common/os.js");
const message_service_1 = __webpack_require__(/*! @theia/core/lib/common/message-service */ "./node_modules/@theia/core/lib/common/message-service.js");
const filesystem_1 = __webpack_require__(/*! ../../common/filesystem */ "./node_modules/@theia/filesystem/lib/common/filesystem.js");
const file_dialog_1 = __webpack_require__(/*! ../../browser/file-dialog */ "./node_modules/@theia/filesystem/lib/browser/file-dialog/index.js");
//
// We are OK to use this here because the electron backend and frontend are on the same host.
// If required, we can move this single service (and its module) to a dedicated Theia extension,
// and at packaging time, clients can decide whether they need the native or the browser-based
// solution.
//
// eslint-disable-next-line @theia/runtime-import-check
const file_uri_1 = __webpack_require__(/*! @theia/core/lib/node/file-uri */ "./node_modules/@theia/core/lib/node/file-uri.js");
let ElectronFileDialogService = class ElectronFileDialogService extends file_dialog_1.DefaultFileDialogService {
    async showOpenDialog(props, folder) {
        const rootNode = await this.getRootNode(folder);
        if (rootNode) {
            const { filePaths } = await electronRemote.dialog.showOpenDialog(this.toOpenDialogOptions(rootNode.uri, props));
            if (filePaths.length === 0) {
                return undefined;
            }
            const uris = filePaths.map(path => file_uri_1.FileUri.create(path));
            const canAccess = await this.canRead(uris);
            const result = canAccess ? uris.length === 1 ? uris[0] : uris : undefined;
            return result;
        }
        return undefined;
    }
    async showSaveDialog(props, folder) {
        const rootNode = await this.getRootNode(folder);
        if (rootNode) {
            const { filePath } = await electronRemote.dialog.showSaveDialog(this.toSaveDialogOptions(rootNode.uri, props));
            if (!filePath) {
                return undefined;
            }
            const uri = file_uri_1.FileUri.create(filePath);
            const exists = await this.fileService.exists(uri);
            if (!exists) {
                return uri;
            }
            const canWrite = await this.canReadWrite(uri);
            return canWrite ? uri : undefined;
        }
        return undefined;
    }
    async canReadWrite(uris) {
        for (const uri of Array.isArray(uris) ? uris : [uris]) {
            if (!(await this.fileService.access(uri, filesystem_1.FileAccess.Constants.R_OK | filesystem_1.FileAccess.Constants.W_OK))) {
                this.messageService.error(`Cannot access resource at ${uri.path}.`);
                return false;
            }
        }
        return true;
    }
    async canRead(uris) {
        const resources = Array.isArray(uris) ? uris : [uris];
        const unreadableResourcePaths = [];
        await Promise.all(resources.map(async (resource) => {
            if (!await this.fileService.access(resource, filesystem_1.FileAccess.Constants.R_OK)) {
                unreadableResourcePaths.push(resource.path.toString());
            }
        }));
        if (unreadableResourcePaths.length > 0) {
            this.messageService.error(`Cannot read ${unreadableResourcePaths.length} resource(s): ${unreadableResourcePaths.join(', ')}`);
        }
        return unreadableResourcePaths.length === 0;
    }
    toDialogOptions(uri, props, dialogTitle) {
        const electronProps = {
            title: props.title || dialogTitle,
            defaultPath: file_uri_1.FileUri.fsPath(uri),
        };
        const { canSelectFiles = true, canSelectFolders = false, } = props;
        if (!os_1.isOSX && canSelectFiles && canSelectFolders) {
            console.warn('canSelectFiles === true && canSelectFolders === true is only supported on OSX!');
        }
        if ((os_1.isOSX && canSelectFiles) || !canSelectFolders) {
            electronProps.filters = props.filters ? Object.entries(props.filters).map(([name, extensions]) => ({ name, extensions })) : [];
            electronProps.filters.push({ name: 'All Files', extensions: ['*'] });
        }
        return electronProps;
    }
    toOpenDialogOptions(uri, props) {
        const properties = electron.dialog.toDialogProperties(props);
        const buttonLabel = props.openLabel;
        return Object.assign(Object.assign({}, this.toDialogOptions(uri, props, 'Open')), { properties, buttonLabel });
    }
    toSaveDialogOptions(uri, props) {
        const buttonLabel = props.saveLabel;
        if (props.inputValue) {
            uri = uri.resolve(props.inputValue);
        }
        const defaultPath = file_uri_1.FileUri.fsPath(uri);
        return Object.assign(Object.assign({}, this.toDialogOptions(uri, props, 'Save')), { buttonLabel, defaultPath });
    }
};
__decorate([
    inversify_1.inject(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], ElectronFileDialogService.prototype, "messageService", void 0);
ElectronFileDialogService = __decorate([
    inversify_1.injectable()
], ElectronFileDialogService);
exports.ElectronFileDialogService = ElectronFileDialogService;
var electron;
(function (electron) {
    let dialog;
    (function (dialog) {
        /**
         * Converts the Theia specific `OpenFileDialogProps` into an electron specific array.
         *
         * Note: On Windows and Linux an open dialog can not be both a file selector and a directory selector,
         * so if you set properties to ['openFile', 'openDirectory'] on these platforms, a directory selector will be shown.
         *
         * See: https://github.com/electron/electron/issues/10252#issuecomment-322012159
         */
        function toDialogProperties(props) {
            if (!os_1.isOSX && props.canSelectFiles !== false && props.canSelectFolders === true) {
                console.warn(`Cannot have 'canSelectFiles' and 'canSelectFolders' at the same time. Fallback to 'folder' dialog. \nProps was: ${JSON.stringify(props)}.`);
                // Given that both props are set, fallback to using a `folder` dialog.
                props.canSelectFiles = false;
                props.canSelectFolders = true;
            }
            const properties = [];
            if (!os_1.isOSX) {
                if (props.canSelectFiles !== false && props.canSelectFolders !== true) {
                    properties.push('openFile');
                }
                if (props.canSelectFolders === true && props.canSelectFiles === false) {
                    properties.push('openDirectory');
                }
            }
            else {
                if (props.canSelectFiles !== false) {
                    properties.push('openFile');
                }
                if (props.canSelectFolders === true) {
                    properties.push('openDirectory');
                    properties.push('createDirectory');
                }
            }
            if (props.canSelectMany === true) {
                properties.push('multiSelections');
            }
            return properties;
        }
        dialog.toDialogProperties = toDialogProperties;
    })(dialog = electron.dialog || (electron.dialog = {}));
})(electron = exports.electron || (exports.electron = {}));


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_filesystem_lib_electron-browser_file-dialog_electron-file-dialog-m-56a414.bundle.js.map