"use strict";
(global["webpackChunkarduino_ide"] = global["webpackChunkarduino_ide"] || []).push([["vendors-node_modules_theia_filesystem_lib_browser_index_js"],{

/***/ "./node_modules/@theia/filesystem/lib/browser/file-resource.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/browser/file-resource.js ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileResourceResolver = exports.FileResource = exports.FileResourceVersion = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const resource_1 = __webpack_require__(/*! @theia/core/lib/common/resource */ "./node_modules/@theia/core/lib/common/resource.js");
const disposable_1 = __webpack_require__(/*! @theia/core/lib/common/disposable */ "./node_modules/@theia/core/lib/common/disposable.js");
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "./node_modules/@theia/core/lib/common/event.js");
const files_1 = __webpack_require__(/*! ../common/files */ "./node_modules/@theia/filesystem/lib/common/files.js");
const file_service_1 = __webpack_require__(/*! ./file-service */ "./node_modules/@theia/filesystem/lib/browser/file-service.js");
const dialogs_1 = __webpack_require__(/*! @theia/core/lib/browser/dialogs */ "./node_modules/@theia/core/lib/browser/dialogs.js");
const label_provider_1 = __webpack_require__(/*! @theia/core/lib/browser/label-provider */ "./node_modules/@theia/core/lib/browser/label-provider.js");
const filesystem_preferences_1 = __webpack_require__(/*! ./filesystem-preferences */ "./node_modules/@theia/filesystem/lib/browser/filesystem-preferences.js");
var FileResourceVersion;
(function (FileResourceVersion) {
    function is(version) {
        return !!version && 'encoding' in version && 'mtime' in version && 'etag' in version;
    }
    FileResourceVersion.is = is;
})(FileResourceVersion = exports.FileResourceVersion || (exports.FileResourceVersion = {}));
class FileResource {
    constructor(uri, fileService, options) {
        this.uri = uri;
        this.fileService = fileService;
        this.options = options;
        this.acceptTextOnly = true;
        this.toDispose = new disposable_1.DisposableCollection();
        this.onDidChangeContentsEmitter = new event_1.Emitter();
        this.onDidChangeContents = this.onDidChangeContentsEmitter.event;
        this.doSaveContentChanges = async (changes, options) => {
            const version = (options === null || options === void 0 ? void 0 : options.version) || this._version;
            const current = FileResourceVersion.is(version) ? version : undefined;
            if (!current) {
                throw resource_1.ResourceError.NotFound({ message: 'has not been read yet', data: { uri: this.uri } });
            }
            const etag = current === null || current === void 0 ? void 0 : current.etag;
            try {
                const stat = await this.fileService.update(this.uri, changes, {
                    readEncoding: current.encoding,
                    encoding: options === null || options === void 0 ? void 0 : options.encoding,
                    overwriteEncoding: options === null || options === void 0 ? void 0 : options.overwriteEncoding,
                    etag,
                    mtime: current === null || current === void 0 ? void 0 : current.mtime
                });
                this._version = {
                    etag: stat.etag,
                    mtime: stat.mtime,
                    encoding: stat.encoding
                };
            }
            catch (e) {
                if (e instanceof files_1.FileOperationError && e.fileOperationResult === 1 /* FILE_NOT_FOUND */) {
                    const { message, stack } = e;
                    throw resource_1.ResourceError.NotFound({ message, stack, data: { uri: this.uri } });
                }
                if (e instanceof files_1.FileOperationError && e.fileOperationResult === 3 /* FILE_MODIFIED_SINCE */) {
                    const { message, stack } = e;
                    throw resource_1.ResourceError.OutOfSync({ message, stack, data: { uri: this.uri } });
                }
                throw e;
            }
        };
        this.toDispose.push(this.onDidChangeContentsEmitter);
        this.toDispose.push(this.fileService.onDidFilesChange(event => {
            if (event.contains(this.uri)) {
                this.sync();
            }
        }));
        this.toDispose.push(this.fileService.onDidRunOperation(e => {
            if ((e.isOperation(1 /* DELETE */) || e.isOperation(2 /* MOVE */)) && e.resource.isEqualOrParent(this.uri)) {
                this.sync();
            }
        }));
        try {
            this.toDispose.push(this.fileService.watch(this.uri));
        }
        catch (e) {
            console.error(e);
        }
        this.updateSavingContentChanges();
        this.toDispose.push(this.fileService.onDidChangeFileSystemProviderCapabilities(e => {
            if (e.scheme === this.uri.scheme) {
                this.updateSavingContentChanges();
            }
        }));
    }
    get version() {
        return this._version;
    }
    get encoding() {
        var _a;
        return (_a = this._version) === null || _a === void 0 ? void 0 : _a.encoding;
    }
    dispose() {
        this.toDispose.dispose();
    }
    async readContents(options) {
        var _a, _b;
        try {
            const encoding = (options === null || options === void 0 ? void 0 : options.encoding) || ((_a = this.version) === null || _a === void 0 ? void 0 : _a.encoding);
            const stat = await this.fileService.read(this.uri, {
                encoding,
                etag: files_1.ETAG_DISABLED,
                acceptTextOnly: this.acceptTextOnly,
                limits: this.limits
            });
            this._version = {
                encoding: stat.encoding,
                etag: stat.etag,
                mtime: stat.mtime
            };
            return stat.value;
        }
        catch (e) {
            if (e instanceof file_service_1.TextFileOperationError && e.textFileOperationResult === 0 /* FILE_IS_BINARY */) {
                if (await this.shouldOpenAsText('The file is either binary or uses an unsupported text encoding.')) {
                    this.acceptTextOnly = false;
                    return this.readContents(options);
                }
            }
            else if (e instanceof files_1.FileOperationError && e.fileOperationResult === 7 /* FILE_TOO_LARGE */) {
                const stat = await this.fileService.resolve(this.uri, { resolveMetadata: true });
                const maxFileSize = filesystem_preferences_1.GENERAL_MAX_FILE_SIZE_MB * 1024 * 1024;
                if (((_b = this.limits) === null || _b === void 0 ? void 0 : _b.size) !== maxFileSize && await this.shouldOpenAsText(`The file is too large (${files_1.BinarySize.formatSize(stat.size)}).`)) {
                    this.limits = {
                        size: maxFileSize
                    };
                    return this.readContents(options);
                }
            }
            else if (e instanceof files_1.FileOperationError && e.fileOperationResult === 1 /* FILE_NOT_FOUND */) {
                this._version = undefined;
                const { message, stack } = e;
                throw resource_1.ResourceError.NotFound({
                    message, stack,
                    data: {
                        uri: this.uri
                    }
                });
            }
            throw e;
        }
    }
    async readStream(options) {
        var _a, _b;
        try {
            const encoding = (options === null || options === void 0 ? void 0 : options.encoding) || ((_a = this.version) === null || _a === void 0 ? void 0 : _a.encoding);
            const stat = await this.fileService.readStream(this.uri, {
                encoding,
                etag: files_1.ETAG_DISABLED,
                acceptTextOnly: this.acceptTextOnly,
                limits: this.limits
            });
            this._version = {
                encoding: stat.encoding,
                etag: stat.etag,
                mtime: stat.mtime
            };
            return stat.value;
        }
        catch (e) {
            if (e instanceof file_service_1.TextFileOperationError && e.textFileOperationResult === 0 /* FILE_IS_BINARY */) {
                if (await this.shouldOpenAsText('The file is either binary or uses an unsupported text encoding.')) {
                    this.acceptTextOnly = false;
                    return this.readStream(options);
                }
            }
            else if (e instanceof files_1.FileOperationError && e.fileOperationResult === 7 /* FILE_TOO_LARGE */) {
                const stat = await this.fileService.resolve(this.uri, { resolveMetadata: true });
                const maxFileSize = filesystem_preferences_1.GENERAL_MAX_FILE_SIZE_MB * 1024 * 1024;
                if (((_b = this.limits) === null || _b === void 0 ? void 0 : _b.size) !== maxFileSize && await this.shouldOpenAsText(`The file is too large (${files_1.BinarySize.formatSize(stat.size)}).`)) {
                    this.limits = {
                        size: maxFileSize
                    };
                    return this.readStream(options);
                }
            }
            else if (e instanceof files_1.FileOperationError && e.fileOperationResult === 1 /* FILE_NOT_FOUND */) {
                this._version = undefined;
                const { message, stack } = e;
                throw resource_1.ResourceError.NotFound({
                    message, stack,
                    data: {
                        uri: this.uri
                    }
                });
            }
            throw e;
        }
    }
    saveContents(content, options) {
        return this.doWrite(content, options);
    }
    saveStream(content, options) {
        return this.doWrite(content, options);
    }
    async doWrite(content, options) {
        const version = (options === null || options === void 0 ? void 0 : options.version) || this._version;
        const current = FileResourceVersion.is(version) ? version : undefined;
        const etag = current === null || current === void 0 ? void 0 : current.etag;
        try {
            const stat = await this.fileService.write(this.uri, content, {
                encoding: options === null || options === void 0 ? void 0 : options.encoding,
                overwriteEncoding: options === null || options === void 0 ? void 0 : options.overwriteEncoding,
                etag,
                mtime: current === null || current === void 0 ? void 0 : current.mtime
            });
            this._version = {
                etag: stat.etag,
                mtime: stat.mtime,
                encoding: stat.encoding
            };
        }
        catch (e) {
            if (e instanceof files_1.FileOperationError && e.fileOperationResult === 3 /* FILE_MODIFIED_SINCE */) {
                if (etag !== files_1.ETAG_DISABLED && await this.shouldOverwrite()) {
                    return this.doWrite(content, Object.assign(Object.assign({}, options), { version: { stat: Object.assign(Object.assign({}, current), { etag: files_1.ETAG_DISABLED }) } }));
                }
                const { message, stack } = e;
                throw resource_1.ResourceError.OutOfSync({ message, stack, data: { uri: this.uri } });
            }
            throw e;
        }
    }
    updateSavingContentChanges() {
        if (this.fileService.hasCapability(this.uri, 33554432 /* Update */)) {
            this.saveContentChanges = this.doSaveContentChanges;
        }
        else {
            delete this.saveContentChanges;
        }
    }
    async guessEncoding() {
        // TODO limit size
        const content = await this.fileService.read(this.uri, { autoGuessEncoding: true });
        return content.encoding;
    }
    async sync() {
        if (await this.isInSync()) {
            return;
        }
        this.onDidChangeContentsEmitter.fire(undefined);
    }
    async isInSync() {
        try {
            const stat = await this.fileService.resolve(this.uri, { resolveMetadata: true });
            return !!this.version && this.version.mtime >= stat.mtime;
        }
        catch (_a) {
            return !this.version;
        }
    }
    async shouldOverwrite() {
        return this.options.shouldOverwrite();
    }
    async shouldOpenAsText(error) {
        return this.options.shouldOpenAsText(error);
    }
}
exports.FileResource = FileResource;
let FileResourceResolver = class FileResourceResolver {
    async resolve(uri) {
        let stat;
        try {
            stat = await this.fileService.resolve(uri);
        }
        catch (e) {
            if (!(e instanceof files_1.FileOperationError && e.fileOperationResult === 1 /* FILE_NOT_FOUND */)) {
                throw e;
            }
        }
        if (stat && stat.isDirectory) {
            throw new Error('The given uri is a directory: ' + this.labelProvider.getLongName(uri));
        }
        return new FileResource(uri, this.fileService, {
            shouldOverwrite: () => this.shouldOverwrite(uri),
            shouldOpenAsText: error => this.shouldOpenAsText(uri, error)
        });
    }
    async shouldOverwrite(uri) {
        const dialog = new dialogs_1.ConfirmDialog({
            title: `The file '${this.labelProvider.getName(uri)}' has been changed on the file system.`,
            msg: `Do you want to overwrite the changes made to '${this.labelProvider.getLongName(uri)}' on the file system?`,
            ok: 'Yes',
            cancel: 'No'
        });
        return !!await dialog.open();
    }
    async shouldOpenAsText(uri, error) {
        const dialog = new dialogs_1.ConfirmDialog({
            title: error,
            msg: `Opening it might take some time and might make the IDE unresponsive. Do you want to open '${this.labelProvider.getLongName(uri)}' anyway?`,
            ok: 'Yes',
            cancel: 'No'
        });
        return !!await dialog.open();
    }
};
__decorate([
    inversify_1.inject(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], FileResourceResolver.prototype, "fileService", void 0);
__decorate([
    inversify_1.inject(label_provider_1.LabelProvider),
    __metadata("design:type", label_provider_1.LabelProvider)
], FileResourceResolver.prototype, "labelProvider", void 0);
FileResourceResolver = __decorate([
    inversify_1.injectable()
], FileResourceResolver);
exports.FileResourceResolver = FileResourceResolver;


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/browser/filesystem-watcher.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/browser/filesystem-watcher.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileSystemWatcher = exports.FileOperationEmitter = exports.FileMoveEvent = exports.FileChangeEvent = exports.FileChange = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const disposable_1 = __webpack_require__(/*! @theia/core/lib/common/disposable */ "./node_modules/@theia/core/lib/common/disposable.js");
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "./node_modules/@theia/core/lib/common/event.js");
const file_service_1 = __webpack_require__(/*! ./file-service */ "./node_modules/@theia/filesystem/lib/browser/file-service.js");
var FileChange;
(function (FileChange) {
    function isUpdated(change, uri) {
        return change.type === 0 /* UPDATED */ && uri.toString() === change.uri.toString();
    }
    FileChange.isUpdated = isUpdated;
    function isAdded(change, uri) {
        return change.type === 1 /* ADDED */ && uri.toString() === change.uri.toString();
    }
    FileChange.isAdded = isAdded;
    function isDeleted(change, uri) {
        return change.type === 2 /* DELETED */ && change.uri.isEqualOrParent(uri);
    }
    FileChange.isDeleted = isDeleted;
    function isAffected(change, uri) {
        return isDeleted(change, uri) || uri.toString() === change.uri.toString();
    }
    FileChange.isAffected = isAffected;
    function isChanged(change, uri) {
        return !isDeleted(change, uri) && uri.toString() === change.uri.toString();
    }
    FileChange.isChanged = isChanged;
})(FileChange = exports.FileChange || (exports.FileChange = {}));
var FileChangeEvent;
(function (FileChangeEvent) {
    function isUpdated(event, uri) {
        return event.some(change => FileChange.isUpdated(change, uri));
    }
    FileChangeEvent.isUpdated = isUpdated;
    function isAdded(event, uri) {
        return event.some(change => FileChange.isAdded(change, uri));
    }
    FileChangeEvent.isAdded = isAdded;
    function isDeleted(event, uri) {
        return event.some(change => FileChange.isDeleted(change, uri));
    }
    FileChangeEvent.isDeleted = isDeleted;
    function isAffected(event, uri) {
        return event.some(change => FileChange.isAffected(change, uri));
    }
    FileChangeEvent.isAffected = isAffected;
    function isChanged(event, uri) {
        return !isDeleted(event, uri) && event.some(change => FileChange.isChanged(change, uri));
    }
    FileChangeEvent.isChanged = isChanged;
})(FileChangeEvent = exports.FileChangeEvent || (exports.FileChangeEvent = {}));
var FileMoveEvent;
(function (FileMoveEvent) {
    function isRename({ sourceUri, targetUri }) {
        return sourceUri.parent.toString() === targetUri.parent.toString();
    }
    FileMoveEvent.isRename = isRename;
})(FileMoveEvent = exports.FileMoveEvent || (exports.FileMoveEvent = {}));
class FileOperationEmitter {
    constructor() {
        this.onWillEmitter = new event_1.Emitter();
        this.onWill = this.onWillEmitter.event;
        this.onDidFailEmitter = new event_1.Emitter();
        this.onDidFail = this.onDidFailEmitter.event;
        this.onDidEmitter = new event_1.Emitter();
        this.onDid = this.onDidEmitter.event;
        this.toDispose = new disposable_1.DisposableCollection(this.onWillEmitter, this.onDidFailEmitter, this.onDidEmitter);
    }
    dispose() {
        this.toDispose.dispose();
    }
    async fireWill(event) {
        await event_1.WaitUntilEvent.fire(this.onWillEmitter, event);
    }
    async fireDid(failed, event) {
        const onDidEmitter = failed ? this.onDidFailEmitter : this.onDidEmitter;
        await event_1.WaitUntilEvent.fire(onDidEmitter, event);
    }
}
exports.FileOperationEmitter = FileOperationEmitter;
/**
 * React to file system events, including calls originating from the
 * application or event coming from the system's filesystem directly
 * (actual file watching).
 *
 * `on(will|did)(create|rename|delete)` events solely come from application
 * usage, not from actual filesystem.
 *
 * @deprecated since 1.4.0 - in order to support VS Code FS API (https://github.com/eclipse-theia/theia/pull/7908), use `FileService.watch` instead
 */
let FileSystemWatcher = class FileSystemWatcher {
    constructor() {
        this.toDispose = new disposable_1.DisposableCollection();
        this.toRestartAll = new disposable_1.DisposableCollection();
        this.onFileChangedEmitter = new event_1.Emitter();
        /**
         * @deprecated since 1.4.0 - in order to support VS Code FS API (https://github.com/eclipse-theia/theia/pull/7908), use `FileService.onDidFilesChange` instead
         */
        this.onFilesChanged = this.onFileChangedEmitter.event;
        this.fileCreateEmitter = new FileOperationEmitter();
        /**
         * @deprecated since 1.4.0 - in order to support VS Code FS API (https://github.com/eclipse-theia/theia/pull/7908), use `FileService.onWillRunUserOperation` instead
         */
        this.onWillCreate = this.fileCreateEmitter.onWill;
        /**
         * @deprecated since 1.4.0 - in order to support VS Code FS API (https://github.com/eclipse-theia/theia/pull/7908), use `FileService.onDidFailUserOperation` instead
         */
        this.onDidFailCreate = this.fileCreateEmitter.onDidFail;
        /**
         * @deprecated since 1.4.0 - in order to support VS Code FS API (https://github.com/eclipse-theia/theia/pull/7908),
         * instead use `FileService.onDidRunUserOperation` for events triggered by user gestures
         * or `FileService.onDidRunOperation` triggered by user gestures and programmatically
         */
        this.onDidCreate = this.fileCreateEmitter.onDid;
        this.fileDeleteEmitter = new FileOperationEmitter();
        /**
         * @deprecated since 1.4.0 - in order to support VS Code FS API (https://github.com/eclipse-theia/theia/pull/7908), use `FileService.onWillRunUserOperation` instead
         */
        this.onWillDelete = this.fileDeleteEmitter.onWill;
        /**
         * @deprecated since 1.4.0 - in order to support VS Code FS API (https://github.com/eclipse-theia/theia/pull/7908), use `FileService.onDidFailUserOperation` instead
         */
        this.onDidFailDelete = this.fileDeleteEmitter.onDidFail;
        /**
         * @deprecated since 1.4.0 - in order to support VS Code FS API (https://github.com/eclipse-theia/theia/pull/7908),
         * instead use `FileService.onDidRunUserOperation` for events triggered by user gestures
         * or `FileService.onDidRunOperation` triggered by user gestures and programmatically
         */
        this.onDidDelete = this.fileDeleteEmitter.onDid;
        this.fileMoveEmitter = new FileOperationEmitter();
        /**
         * @deprecated since 1.4.0 - in order to support VS Code FS API (https://github.com/eclipse-theia/theia/pull/7908), use `FileService.onWillRunUserOperation` instead
         */
        this.onWillMove = this.fileMoveEmitter.onWill;
        /**
         * @deprecated since 1.4.0 - in order to support VS Code FS API (https://github.com/eclipse-theia/theia/pull/7908), use `FileService.onDidFailUserOperation` instead
         */
        this.onDidFailMove = this.fileMoveEmitter.onDidFail;
        /**
         * @deprecated since 1.4.0 - in order to support VS Code FS API (https://github.com/eclipse-theia/theia/pull/7908),
         * instead use `FileService.onDidRunUserOperation` for events triggered by user gestures
         * or `FileService.onDidRunOperation` triggered by user gestures and programmatically
         */
        this.onDidMove = this.fileMoveEmitter.onDid;
    }
    init() {
        this.toDispose.push(this.onFileChangedEmitter);
        this.toDispose.push(this.fileDeleteEmitter);
        this.toDispose.push(this.fileMoveEmitter);
        this.toDispose.push(this.fileService.onWillRunUserOperation(event => {
            if (event.operation === 0 /* CREATE */) {
                this.fileCreateEmitter.fireWill({ uri: event.target });
            }
            else if (event.operation === 1 /* DELETE */) {
                this.fileDeleteEmitter.fireWill({ uri: event.target });
            }
            else if (event.operation === 2 /* MOVE */ && event.source) {
                this.fileMoveEmitter.fireWill({ sourceUri: event.source, targetUri: event.target });
            }
        }));
        this.toDispose.push(this.fileService.onDidFailUserOperation(event => {
            if (event.operation === 0 /* CREATE */) {
                this.fileCreateEmitter.fireDid(true, { uri: event.target });
            }
            else if (event.operation === 1 /* DELETE */) {
                this.fileDeleteEmitter.fireDid(true, { uri: event.target });
            }
            else if (event.operation === 2 /* MOVE */ && event.source) {
                this.fileMoveEmitter.fireDid(true, { sourceUri: event.source, targetUri: event.target });
            }
        }));
        this.toDispose.push(this.fileService.onDidRunUserOperation(event => {
            if (event.operation === 0 /* CREATE */) {
                this.fileCreateEmitter.fireDid(false, { uri: event.target });
            }
            else if (event.operation === 1 /* DELETE */) {
                this.fileDeleteEmitter.fireDid(false, { uri: event.target });
            }
            else if (event.operation === 2 /* MOVE */ && event.source) {
                this.fileMoveEmitter.fireDid(false, { sourceUri: event.source, targetUri: event.target });
            }
        }));
    }
    /**
     * Stop watching.
     */
    dispose() {
        this.toDispose.dispose();
    }
    /**
     * Start file watching under the given uri.
     *
     * Resolve when watching is started.
     * Return a disposable to stop file watching under the given uri.
     */
    async watchFileChanges(uri) {
        return this.fileService.watch(uri);
    }
};
__decorate([
    inversify_1.inject(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], FileSystemWatcher.prototype, "fileService", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], FileSystemWatcher.prototype, "init", null);
FileSystemWatcher = __decorate([
    inversify_1.injectable()
], FileSystemWatcher);
exports.FileSystemWatcher = FileSystemWatcher;


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/browser/index.js":
/*!*************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/browser/index.js ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./location */ "./node_modules/@theia/filesystem/lib/browser/location/index.js"), exports);
__exportStar(__webpack_require__(/*! ./file-tree */ "./node_modules/@theia/filesystem/lib/browser/file-tree/index.js"), exports);
__exportStar(__webpack_require__(/*! ./file-dialog */ "./node_modules/@theia/filesystem/lib/browser/file-dialog/index.js"), exports);
__exportStar(__webpack_require__(/*! ./filesystem-preferences */ "./node_modules/@theia/filesystem/lib/browser/filesystem-preferences.js"), exports);
__exportStar(__webpack_require__(/*! ./filesystem-watcher */ "./node_modules/@theia/filesystem/lib/browser/filesystem-watcher.js"), exports);
__exportStar(__webpack_require__(/*! ./file-resource */ "./node_modules/@theia/filesystem/lib/browser/file-resource.js"), exports);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_filesystem_lib_browser_index_js.bundle.js.map